/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.SchedulerSpaceInterface;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedMethodResolver;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedPropertyAccessor;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.utils.RestrictedTypeLocator;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ModelValidatorContext {
    private final StandardEvaluationContext spelContext;
    private final Scheduler scheduler;
    private final SchedulerSpaceInterface space;
    private String variableName;
    private SpELVariables spELVariables;

    public ModelValidatorContext(StandardEvaluationContext context, Scheduler scheduler, SchedulerSpaceInterface space) {
        this.spelContext = context;
        this.scheduler = scheduler;
        this.space = space;
    }

    public ModelValidatorContext(Map<String, Serializable> variablesValues, Scheduler scheduler, SchedulerSpaceInterface space) {
        this.spELVariables = new SpELVariables(variablesValues);
        this.spelContext = new StandardEvaluationContext((Object)this.spELVariables);
        this.spelContext.setTypeLocator((TypeLocator)new RestrictedTypeLocator());
        this.spelContext.setMethodResolvers(Collections.singletonList(new RestrictedMethodResolver()));
        this.spelContext.addPropertyAccessor((PropertyAccessor)new RestrictedPropertyAccessor());
        this.scheduler = scheduler;
        this.space = space;
    }

    public ModelValidatorContext(Task task, Scheduler scheduler, SchedulerSpaceInterface space) {
        this(task.getVariables().values().stream().collect(HashMap::new, (m, v) -> {
            Serializable cfr_ignored_0 = (Serializable)((Object)m.put(v.getName(), v.getValue()));
        }, HashMap::putAll), scheduler, space);
    }

    public ModelValidatorContext(TaskFlowJob job, Scheduler scheduler, SchedulerSpaceInterface space) {
        this(job.getVariables().values().stream().collect(HashMap::new, (m, v) -> {
            Serializable cfr_ignored_0 = (Serializable)((Object)m.put(v.getName(), v.getValue()));
        }, HashMap::putAll), scheduler, space);
    }

    public ModelValidatorContext(StandardEvaluationContext context) {
        this(context, null, null);
    }

    public ModelValidatorContext(Map<String, Serializable> variablesValues) {
        this(variablesValues, null, null);
    }

    public ModelValidatorContext(Task task) {
        this(task, null, null);
    }

    public ModelValidatorContext(TaskFlowJob job) {
        this(job, null, null);
    }

    public StandardEvaluationContext getSpELContext() {
        return this.spelContext;
    }

    public SpELVariables getSpELVariables() {
        return this.spELVariables;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SchedulerSpaceInterface getSpace() {
        return this.space;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void updateJobWithContext(TaskFlowJob job) {
        for (JobVariable jobVariable : job.getVariables().values()) {
            jobVariable.setValue(this.spELVariables.getVariables().get(jobVariable.getName()).toString());
        }
    }

    public void updateTaskWithContext(Task task) {
        for (TaskVariable taskVariable : task.getVariables().values()) {
            taskVariable.setValue(this.spELVariables.getVariables().get(taskVariable.getName()).toString());
        }
    }

    public class SpELVariables {
        private Map<String, Serializable> variables;

        public SpELVariables(Map<String, Serializable> variables) {
            this.variables = variables;
        }

        public Map<String, Serializable> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Serializable> variables) {
            this.variables = variables;
        }
    }
}

