/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.volume3d;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TimeDist;
import net.alomax.graphics3d.Vect3D;
import net.alomax.volume3d.TauPSlownessModel;

public class SphericalTauPSlownessModel
extends TauPSlownessModel {
    protected static final double D_DISTANCE = 0.001;
    protected static final double TOLERANCE = 0.001;

    public SphericalTauPSlownessModel() throws Exception {
        this(DEFAULT_MODEL, DEFAULT_PHASE_LIST);
    }

    public SphericalTauPSlownessModel(String string) throws Exception {
        this(null, string);
    }

    public SphericalTauPSlownessModel(String string, String string2) throws Exception {
        super(string, string2);
    }

    public SphericalTauPSlownessModel(String string, String string2, boolean bl) throws Exception {
        super(string, string2, bl);
    }

    public final double getAngleOfIncidence(Arrival arrival, double d, String string) {
        double d2 = arrival.getRayParam();
        double d3 = this.getSlowness(new Vect3D(0.0, 0.0, d), string);
        double d4 = 6371.0 - d;
        double d5 = Math.asin(d2 / (d3 * d4));
        return d5;
    }

    public final Arrival getArrivalIgnoreCase(double d, double d2, String string) {
        Arrival arrival = this.getArrival(d, d2, string);
        if (arrival == null) {
            arrival = this.getArrival(d, d2, string.toUpperCase());
        }
        if (arrival == null) {
            arrival = this.getArrival(d, d2, string.toLowerCase());
        }
        return arrival;
    }

    public final double getDRayParamDDelta(double d, double d2, String string) {
        double d3 = d - 5.0E-4;
        double d4 = d + 5.0E-4;
        Arrival arrival = this.getArrivalIgnoreCase(d3, d2, string);
        Arrival arrival2 = this.getArrivalIgnoreCase(d4, d2, string);
        return (arrival2.getRayParam() - arrival.getRayParam()) / 1.7453292519943296E-5;
    }

    public final double getGeometricalSpreadingFactor(double d, double d2, String string) {
        Arrival arrival;
        if ((d = Math.abs(d)) < 0.001) {
            d = 0.001;
        }
        if ((arrival = this.getArrivalIgnoreCase(d, d2, string)) == null) {
            return -1.0;
        }
        double d3 = arrival.getRayParam();
        double d4 = Math.abs(this.getDRayParamDDelta(d, d2, string));
        double d5 = this.getSlowness(d2, string);
        double d6 = 6371.0 - d2;
        double d7 = 6371.0;
        double d8 = this.getAngleOfIncidence(arrival, d2, string);
        double d9 = this.getAngleOfIncidence(arrival, 0.0, string);
        double d10 = d * Math.PI / 180.0;
        double d11 = d5 * d6 * d7 * Math.sqrt(Math.sin(d10) * Math.cos(d8) * Math.cos(d9) / (d3 * d4));
        return d11;
    }

    public final double getTStar(double d, double d2, String string, boolean bl) {
        if ((d = Math.abs(d)) < 0.001) {
            d = 0.001;
        }
        Arrival arrival = this.getArrivalPath(d, d2, string);
        Arrival arrival2 = this.getArrivalPath(d, d2, string.toUpperCase());
        Arrival arrival3 = null;
        arrival3 = arrival != null && arrival2 != null ? (arrival.getTime() <= arrival2.getTime() ? arrival : arrival2) : (arrival != null ? arrival : arrival2);
        Arrival arrival4 = this.getArrivalPath(d, d2, string.toLowerCase());
        if (arrival3 != null && arrival4 != null) {
            arrival3 = arrival3.getTime() <= arrival4.getTime() ? arrival3 : arrival4;
        } else if (arrival4 != null) {
            arrival3 = arrival4;
        }
        if (arrival3 == null) {
            return -1.0;
        }
        TimeDist[] timeDistArray = arrival3.getPath();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = timeDistArray[0].dist * 57.29577951308232 * 111.11111111111111;
        double d6 = 6371.0 - timeDistArray[0].depth;
        for (int i = 1; i < timeDistArray.length; ++i) {
            double d7 = timeDistArray[i].dist * 57.29577951308232 * 111.11111111111111;
            double d8 = d7 - d5;
            double d9 = timeDistArray[i].depth;
            double d10 = 6371.0 - d9;
            double d11 = d10 - d6;
            double d12 = Math.sqrt((d8 *= (d10 + d6) / 12742.0) * d8 + d11 * d11);
            double d13 = this.getQuality(timeDistArray[i].depth, string);
            d3 += d12;
            d4 += d12 * this.getSlowness(d9, string) / this.getQuality(d9, string);
            d5 = d7;
            d6 = d10;
        }
        if (bl) {
            System.out.println("getTStar wavetype=" + string + "  rayLength(km)=" + d3 + "  rayLength(deg)=" + d3 * 0.009);
        }
        return d4;
    }

    public final double getRayLength(double d, double d2, String string) {
        Arrival arrival;
        if ((d = Math.abs(d)) < 0.001) {
            d = 0.001;
        }
        if ((arrival = this.getArrivalPath(d, d2, string)) == null) {
            return -1.0;
        }
        TimeDist[] timeDistArray = arrival.getPath();
        double d3 = 0.0;
        double d4 = timeDistArray[0].dist * 57.29577951308232 * 111.11111111111111;
        double d5 = 6371.0 - timeDistArray[0].depth;
        for (int i = 1; i < timeDistArray.length; ++i) {
            double d6 = timeDistArray[i].dist * 57.29577951308232 * 111.11111111111111;
            double d7 = d6 - d4;
            double d8 = timeDistArray[i].depth;
            double d9 = 6371.0 - d8;
            double d10 = d9 - d5;
            double d11 = Math.sqrt((d7 *= (d9 + d5) / 12742.0) * d7 + d10 * d10);
            d3 += d11;
            d4 = d6;
            d5 = d9;
        }
        return d3;
    }

    public final double getDepthMax(double d, double d2, String string) {
        Arrival arrival;
        if ((d = Math.abs(d)) < 0.001) {
            d = 0.001;
        }
        if ((arrival = this.getArrivalPath(d, d2, string)) == null) {
            return -1.0;
        }
        TimeDist[] timeDistArray = arrival.getPath();
        double d3 = timeDistArray[0].depth;
        for (int i = 1; i < timeDistArray.length; ++i) {
            double d4 = timeDistArray[i].depth;
            if (!(d4 > d3)) continue;
            d3 = d4;
        }
        return d3;
    }

    public final double getSlowness(double d, String string) {
        return this.getSlowness(new Vect3D(0.0, 0.0, d), string);
    }

    public final double getQuality(double d, String string) {
        return this.getQuality(new Vect3D(0.0, 0.0, d), string);
    }

    public static void main(String[] stringArray) {
        SphericalTauPSlownessModel sphericalTauPSlownessModel = null;
        try {
            sphericalTauPSlownessModel = new SphericalTauPSlownessModel("prem.taup", "P,p");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d = 33.0;
        for (double d2 = 0.0; d2 < 90.0; d2 += 2.0) {
            double d3 = d2 * 111.111;
            double d4 = sphericalTauPSlownessModel.getGeometricalSpreadingFactor(d2, d, "P");
            double d5 = sphericalTauPSlownessModel.getTStar(d2, d, "P", true);
            double d6 = sphericalTauPSlownessModel.getTStar(d2, d, "S", true);
            double d7 = Math.sqrt(d3 * d3 + d * d);
            System.out.println("dist=" + (float)d2 + " gs=" + (float)d4 + " r=" + (float)d7 + " ratio=" + (float)(d4 / d7) + " TStarP=" + (float)d5 + " TStarS=" + (float)d6);
        }
    }
}

