/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.volume3d;

public class GradientHalfSpaceModelAlgorithms {
    protected static final double TOLERANCE = 1.0E-6;
    protected double refVelLayer;
    protected double gradLayer;
    protected double velHalfSpace;
    protected double topOfHalfSpaceDepth;
    protected double refDepth;
    protected double sourceDepth;
    protected double receiverDepth;
    protected double offset;
    protected double p_global;
    protected double t_global;
    protected double dtdz;
    protected double dtdx;
    protected double dtdt;
    protected double hemi;
    protected double aoi;
    protected final double MIN_GRADIENT = 1.0E-4;

    public GradientHalfSpaceModelAlgorithms(double d, double d2, double d3, double d4, double d5) {
        if (d2 < 1.0E-4) {
            d2 = 1.0E-4;
            System.err.println(this.getClass().getName() + ": WARNING: layer gradient too small: reset to:" + 1.0E-4);
        }
        this.refDepth = d5;
        this.refVelLayer = d;
        this.gradLayer = d2;
        this.velHalfSpace = d3;
        this.topOfHalfSpaceDepth = d4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("refDepth: " + this.refDepth);
        stringBuffer.append(", topOfHalfSpaceDepth: " + this.topOfHalfSpaceDepth);
        stringBuffer.append(", refVelLayer: " + this.refVelLayer);
        stringBuffer.append(", gradLayer: " + this.gradLayer);
        stringBuffer.append(", velHalfSpace: " + this.velHalfSpace);
        return stringBuffer.toString();
    }

    public double getVelocity(double d) {
        if (d >= this.topOfHalfSpaceDepth) {
            return this.velHalfSpace;
        }
        return this.refVelLayer + (d - this.refDepth) * this.gradLayer;
    }

    public double getTravelTime(double d, double d2, double d3) {
        this.calculate(d, d2, d3);
        if (Double.isNaN(this.t_global)) {
            System.err.println(this.getClass().getName() + ": ERROR: NaN value in getTravelTime().");
        }
        return this.t_global;
    }

    public double getAngleOfIncidence(double d, double d2, double d3) {
        this.calculate(d, d2, d3);
        if (Double.isNaN(this.aoi)) {
            System.err.println(this.getClass().getName() + ": ERROR: NaN value in getAngleOfIncidence().");
        }
        return this.aoi;
    }

    public double[] getPartialDerivatives(double d, double d2, double d3) {
        this.calculate(d, d2, d3);
        if (Double.isNaN(this.dtdx) || Double.isNaN(this.dtdz)) {
            System.err.println(this.getClass().getName() + ": ERROR: NaN value in getPartialDerivatives().");
        }
        double[] dArray = new double[]{this.dtdx, this.dtdz};
        return dArray;
    }

    protected double calculate(double d, double d2, double d3) {
        if (!this.identicalParameters(d, d2, d3)) {
            double d4 = 0.001;
            this.ptdcal(this.refVelLayer, this.gradLayer, this.velHalfSpace, this.topOfHalfSpaceDepth - this.refDepth, d2 - this.refDepth, d - this.refDepth, d4, d3);
            this.sourceDepth = d;
            this.receiverDepth = d2;
            this.offset = d3;
        }
        return this.t_global;
    }

    protected boolean identicalParameters(double d, double d2, double d3) {
        return d == this.sourceDepth && d2 == this.receiverDepth && d3 == this.offset;
    }

    protected void ptdcal(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.ptcalc(d, d2, d3, d4, d5, d6, d7, d8);
        this.dtdx = this.p_global;
        this.dtdt = 1.0;
    }

    protected void ptcalc(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 45.0 / Math.atan(1.0);
        this.dtdz = 0.0;
        int n = -1;
        int n2 = 1;
        if (d6 > d4) {
            this.p_global = this.calc_pcalc(d, d2, d3, d4, d5, d6, d8, d7, d9, d10, d11, n);
            this.t_global = this.calc_tcalc(d, d2, d3, d4, d5, d6, this.p_global, d9, d10, d11, d14, d8, n);
            this.hemi = -1.0;
            d15 = this.p_global * d3;
            this.aoi = d15 < 1.0 ? d17 * Math.asin(d15) : 90.0;
            d11 = 1.0 / d3;
            d16 = Math.pow(d11, 2.0) - Math.pow(this.p_global, 2.0);
            this.dtdz = d16 > 0.0 ? Math.sqrt(d16) : 0.0;
            return;
        }
        d9 = 1.0 / (d + d2 * d6);
        d10 = 1.0 / (d + d2 * d4);
        d11 = 1.0 / d3;
        d12 = this.calc_xcalc(d, d2, d3, d4, d5, d6, d9, d9, d10, d11, n);
        d13 = this.calc_xcalc(d, d2, d3, d4, d5, d6, d10, d9, d10, d11, n2);
        d14 = this.calc_xcalc(d, d2, d3, d4, d5, d6, d11, d9, d10, d11, n2);
        if (d8 <= d12) {
            this.p_global = this.calc_pcalc(d, d2, d3, d4, d5, d6, d8, d7, d9, d10, d11, n);
            this.t_global = this.calc_tcalc(d, d2, d3, d4, d5, d6, this.p_global, d9, d10, d11, d14, d8, n);
            this.hemi = -1.0;
            d15 = this.p_global * (d + d2 * d6);
            this.aoi = d15 < 1.0 ? d17 * Math.asin(d15) : 90.0;
            d16 = Math.pow(d9, 2.0) - Math.pow(this.p_global, 2.0);
            this.dtdz = d16 > 0.0 ? Math.sqrt(d16) : 0.0;
        } else if (d8 <= d13) {
            this.p_global = this.calc_pcalc(d, d2, d3, d4, d5, d6, d8, d7, d9, d10, d11, n2);
            this.t_global = this.calc_tcalc(d, d2, d3, d4, d5, d6, this.p_global, d9, d10, d11, d14, d8, n2);
            this.hemi = 1.0;
            d15 = this.p_global * (d + d2 * d6);
            this.aoi = d15 < 1.0 ? d17 * Math.asin(d15) : 90.0;
            d16 = Math.pow(d9, 2.0) - Math.pow(this.p_global, 2.0);
            this.dtdz = d16 > 0.0 ? -1.0 * Math.sqrt(d16) : 0.0;
            if (d8 < d14) {
                return;
            }
            double d18 = this.calc_tcalc(d, d2, d3, d4, d5, d6, d11, d9, d10, d11, d14, d8, n2);
            if (d18 > this.t_global) {
                return;
            }
            this.p_global = d11;
            this.t_global = d18;
            d15 = this.p_global * (d + d2 * d6);
            this.aoi = d15 < 1.0 ? d17 * Math.asin(d15) : 90.0;
            d16 = Math.pow(d9, 2.0) - Math.pow(this.p_global, 2.0);
            this.dtdz = d16 > 0.0 ? -1.0 * Math.sqrt(d16) : 0.0;
        } else {
            this.p_global = d11;
            this.t_global = this.calc_tcalc(d, d2, d3, d4, d5, d6, d11, d9, d10, d11, d14, d8, n2);
            this.hemi = 1.0;
            d15 = this.p_global * (d + d2 * d6);
            this.aoi = d15 < 1.0 ? d17 * Math.asin(d15) : 90.0;
            d16 = Math.pow(d9, 2.0) - Math.pow(this.p_global, 2.0);
            this.dtdz = d16 > 0.0 ? -1.0 * Math.sqrt(d16) : 0.0;
        }
    }

    protected final double calc_xcalc(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, int n) {
        double d11 = -1.0 / (d2 * d7);
        double d12 = n == 1 ? (d7 >= d8 ? d11 * (this.calc_r5(d, d2, d7, d6) - this.calc_r5(d, d2, d7, d5)) : (d7 >= d9 ? -1.0 * d11 * (this.calc_r5(d, d2, d7, d5) + this.calc_r5(d, d2, d7, d6)) : (d7 >= d10 ? d11 * (2.0 * this.calc_r5(d, d2, d7, d4) - this.calc_r5(d, d2, d7, d5) - this.calc_r5(d, d2, d7, d6)) : d11 * (this.calc_r5(d, d2, d7, d4) - this.calc_r5(d, d2, d7, d5)) + d7 * d3 * (d6 - d4) / Math.sqrt(1.0 - Math.pow(d7 * d3, 2.0))))) : (d6 > d4 ? d11 * (this.calc_r5(d, d2, d7, d4) - this.calc_r5(d, d2, d7, d5)) + d7 * d3 * (d6 - d4) / Math.sqrt(1.0 - Math.pow(d7 * d3, 2.0)) : d11 * (this.calc_r5(d, d2, d7, d6) - this.calc_r5(d, d2, d7, d5)));
        return d12;
    }

    protected final double calc_r5(double d, double d2, double d3, double d4) {
        double d5 = 1.0 - Math.pow(d3 * (d + d2 * d4), 2.0);
        double d6 = d5 <= 0.0 ? 0.0 : Math.sqrt(d5);
        return d6;
    }

    protected final double calc_tcalc(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, int n) {
        double d13;
        double d14 = -1.0 / d2;
        double d15 = 1.0 / (d5 + d / d2);
        double d16 = 1.0 / (d6 + d / d2);
        double d17 = 1.0 / (d4 + d / d2);
        if (n == 1) {
            if (d7 >= d8) {
                d13 = d14 * (this.calc_r4(d2, d7, d16) - this.calc_r4(d2, d7, d15));
            } else if (d7 >= d9) {
                double d18 = d2 * d7;
                d13 = d14 * (2.0 * this.calc_r4(d2, d7, d18) - this.calc_r4(d2, d7, d15) - this.calc_r4(d2, d7, d16));
            } else {
                d13 = d7 > d10 ? d14 * (2.0 * this.calc_r4(d2, d7, d17) - this.calc_r4(d2, d7, d15) - this.calc_r4(d2, d7, d16)) : (d7 == d10 ? d14 * (2.0 * this.calc_r4(d2, d7, d17) - this.calc_r4(d2, d7, d15) - this.calc_r4(d2, d7, d16)) + (d12 - d11) / d3 : d14 * (this.calc_r4(d2, d7, d17) - this.calc_r4(d2, d7, d15) - this.calc_r4(d2, d7, d16)) + 1.0 / d3 * (d6 - d4) / Math.sqrt(1.0 - Math.pow(d7 * d3, 2.0)));
            }
        } else {
            d13 = d6 > d4 ? d14 * (this.calc_r4(d2, d7, d17) - this.calc_r4(d2, d7, d15)) + 1.0 / d3 * (d6 - d4) / Math.sqrt(1.0 - Math.pow(d7 * d3, 2.0)) : d14 * (this.calc_r4(d2, d7, d16) - this.calc_r4(d2, d7, d15));
        }
        return d13;
    }

    protected final double calc_r4(double d, double d2, double d3) {
        double d4 = Math.pow(d3, 2.0) - Math.pow(d * d2, 2.0);
        double d5 = d4 <= 0.0 ? 0.0 : Math.sqrt(d4);
        double d6 = Math.log(2.0 * (d5 + d3));
        return d6;
    }

    protected final double calc_pcalc(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, int n) {
        double d12;
        if (d6 <= d4) {
            d12 = d7 == 0.0 ? 0.0 : 2.0 * d7 * d2 / Math.sqrt(Math.pow(Math.pow(d7 * d2, 2.0) + Math.pow(d + d2 * d6, 2.0) + Math.pow(d + d2 * d5, 2.0), 2.0) - 4.0 * Math.pow(d + d2 * d6, 2.0) * Math.pow(d + d2 * d5, 2.0));
        } else if (d7 == 0.0) {
            d12 = 0.0;
        } else {
            double d13 = d7 / (Math.sqrt(Math.pow(d7, 2.0) + Math.pow(d6 - d4, 2.0)) * d3);
            double d14 = this.calc_xcalc(d, d2, d3, d4, d5, d6, d13, d9, d10, d11, n);
            double d15 = d13;
            double d16 = d7 - d14;
            int n2 = 0;
            do {
                double d17 = this.calc_dpdxc(d, d2, d3, d4, d5, d6, d15, d9, d10, d11, n);
                double d18 = this.calc_xcalc(d, d2, d3, d4, d5, d6, d15 += d17 * d16, d9, d10, d11, n);
                d16 = d7 - d18;
                ++n2;
            } while (Math.abs(d16) > d8);
            d12 = d15;
        }
        return d12;
    }

    protected final double calc_dpdxc(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, int n) {
        double d11;
        if (d6 > d4) {
            double d12 = this.calc_r1(d, d2, d7, d4) - this.calc_r1(d, d2, d7, d5) + this.calc_r2(d, d2, d7, d4) - this.calc_r2(d, d2, d7, d5) + this.calc_r3(d3, d7, d6) - this.calc_r3(d3, d7, d4) + this.calc_r6(d3, d7, d6) - this.calc_r6(d3, d7, d4);
            d11 = 1.0 / d12;
        } else if (n == -1) {
            double d13 = this.calc_r1(d, d2, d7, d6) - this.calc_r1(d, d2, d7, d5) + this.calc_r2(d, d2, d7, d6) - this.calc_r2(d, d2, d7, d5);
            d11 = 1.0 / d13;
        } else if (d7 < d8) {
            if (d7 >= d9) {
                double d14 = (1.0 - d * d7) / (d2 * d7);
                double d15 = 2.0 * (this.calc_r1(d, d2, d7, d14) + this.calc_r2(d, d2, d7, d14)) - this.calc_r1(d, d2, d7, d5) - this.calc_r1(d, d2, d7, d6) - this.calc_r2(d, d2, d7, d5) - this.calc_r2(d, d2, d7, d6);
                d11 = 1.0 / d15;
            } else if (d7 > d10) {
                double d16 = 2.0 * (this.calc_r1(d, d2, d7, d4) + this.calc_r2(d, d2, d7, d4)) - this.calc_r1(d, d2, d7, d5) - this.calc_r1(d, d2, d7, d6) - this.calc_r2(d, d2, d7, d5) - this.calc_r2(d, d2, d7, d6);
                d11 = 1.0 / d16;
            } else if (d7 < d10) {
                double d17 = this.calc_r1(d, d2, d7, d4) - this.calc_r1(d, d2, d7, d5) + this.calc_r2(d, d2, d7, d4) - this.calc_r2(d, d2, d7, d5) + this.calc_r3(d3, d7, d6) - this.calc_r3(d3, d7, d4) + this.calc_r6(d3, d7, d6) - this.calc_r6(d3, d7, d4);
                d11 = 1.0 / d17;
            } else {
                d11 = 0.0;
            }
        } else {
            double d18 = this.calc_r1(d, d2, d7, d6) - this.calc_r1(d, d2, d7, d5) + this.calc_r2(d, d2, d7, d6) - this.calc_r2(d, d2, d7, d5);
            d11 = 1.0 / d18;
        }
        return d11;
    }

    protected final double calc_r1(double d, double d2, double d3, double d4) {
        double d5 = 1.0 - Math.pow(d3 * (d + d2 * d4), 2.0);
        double d6 = d5 <= 0.0 ? 0.0 : Math.sqrt(d5) / (d2 * d3 * d3);
        return d6;
    }

    protected final double calc_r2(double d, double d2, double d3, double d4) {
        double d5 = 1.0 - Math.pow(d3 * (d + d2 * d4), 2.0);
        double d6 = d5 <= 1.0E-6 ? 0.0 : Math.pow(d + d2 * d4, 2.0) / (d2 * Math.sqrt(d5));
        return d6;
    }

    protected final double calc_r3(double d, double d2, double d3) {
        double d4 = 1.0 - Math.pow(d2 * d, 2.0);
        double d5 = d * d3 / Math.sqrt(d4);
        return d5;
    }

    protected final double calc_r6(double d, double d2, double d3) {
        double d4 = Math.sqrt(1.0 - Math.pow(d2 * d, 2.0));
        double d5 = d * d3 * Math.pow(d * d2, 2.0) / Math.pow(d4, 3.0);
        return d5;
    }
}

