/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.util;

public class PhysicalUnits {
    public static final String UNKNOWN = "?";
    public static final String MILLIGRAMS = "mg";
    public static final String GRAMS = "g";
    public static final String KILOGRAMS = "kg";
    public static final String SECONDS = "sec";
    public static final String SECONDS_SHORT = "s";
    protected static final String TIME_INTEGRAL_EXT = "*s";
    protected static final String TIME_DERIVATIVE_EXT = "/s";
    protected static final String VEL_EXT = "/s";
    protected static final String ACC_EXT = "/s/s";
    protected static final String SQUARED = "**2";
    public static final String DEGREES = "deg";
    public static final String NANOMETERS = "nm";
    public static final String MICROMETERS = "micron";
    public static final String MILLIMETERS = "mm";
    public static final String CENTIMETERS = "cm";
    public static final String DECIMETERS = "dm";
    public static final String METERS = "m";
    public static final String KILOMETERS = "km";
    public static final String VOLTS = "volts";
    public static final String AMPS = "amps";
    public static final String MILLIGALS = "mG";
    public static final String COUNTS = "counts";
    public static final String NO_UNITS = "counts";
    public static String defaultLengthUnits = "nm";
    public static final double D2R = Math.PI / 180;
    public static final double R2D = 57.29577951308232;
    public static final double RPD = Math.PI / 180;
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;

    public static String getDefaultLengthUnits() {
        return defaultLengthUnits;
    }

    public static void setDefaultLengthUnits(String string) {
        defaultLengthUnits = string;
    }

    public static double scaleFactor(String string, String string2) {
        double d = PhysicalUnits.scaleToLengthUnit(string);
        double d2 = PhysicalUnits.scaleToLengthUnit(string2);
        if (d > 0.0 && d2 > 0.0) {
            return d / d2;
        }
        d = PhysicalUnits.scaleToMassUnit(string);
        d2 = PhysicalUnits.scaleToMassUnit(string);
        if (d > 0.0 && d2 > 0.0) {
            return d / d2;
        }
        return -1.0;
    }

    public static double scaleToLengthUnit(String string) {
        if (string.equalsIgnoreCase(NANOMETERS)) {
            return 1.0E-9;
        }
        if (string.equalsIgnoreCase(MICROMETERS)) {
            return 1.0E-6;
        }
        if (string.equalsIgnoreCase(MICROMETERS)) {
            return 1.0E-6;
        }
        if (string.equalsIgnoreCase(MILLIMETERS)) {
            return 0.001;
        }
        if (string.equalsIgnoreCase(CENTIMETERS)) {
            return 0.01;
        }
        if (string.equalsIgnoreCase(DECIMETERS)) {
            return 0.1;
        }
        if (string.equalsIgnoreCase(METERS)) {
            return 1.0;
        }
        if (string.equalsIgnoreCase(KILOMETERS)) {
            return 1000.0;
        }
        return -1.0;
    }

    public static double scaleToMassUnit(String string) {
        if (string.equalsIgnoreCase(MILLIGRAMS)) {
            return 0.001;
        }
        if (string.equalsIgnoreCase(GRAMS)) {
            return 1.0;
        }
        if (string.equalsIgnoreCase(KILOGRAMS)) {
            return 1000.0;
        }
        return -1.0;
    }

    public static String timeIntegral(String string) {
        if (string.endsWith("/s")) {
            return string.substring(0, string.lastIndexOf("/s"));
        }
        return string + TIME_INTEGRAL_EXT;
    }

    public static String timeDerivative(String string) {
        if (string.endsWith(TIME_INTEGRAL_EXT)) {
            return string.substring(0, string.lastIndexOf(TIME_INTEGRAL_EXT));
        }
        return string + "/s";
    }

    public static String square(String string) {
        return "(" + string + ")" + SQUARED;
    }

    public static void main(String[] stringArray) {
        String string = "counts";
        System.out.println("original " + string);
        string = METERS;
        System.out.println("METERS " + string);
        string = PhysicalUnits.timeIntegral(string);
        System.out.println("timeIntegral " + string);
        string = PhysicalUnits.timeIntegral(string);
        System.out.println("timeIntegral " + string);
        string = PhysicalUnits.timeDerivative(string);
        System.out.println("timeDerivative " + string);
        string = PhysicalUnits.timeDerivative(string);
        System.out.println("timeDerivative " + string);
        string = PhysicalUnits.timeDerivative(string);
        System.out.println("timeDerivative " + string);
        string = PhysicalUnits.timeDerivative(string);
        System.out.println("timeDerivative " + string);
        string = NANOMETERS;
        System.out.println("NANOMETERS " + string);
        string = PhysicalUnits.timeDerivative(string);
        System.out.println("timeDerivative " + string);
        string = PhysicalUnits.timeDerivative(string);
        System.out.println("timeDerivative " + string);
        string = PhysicalUnits.timeIntegral(string);
        System.out.println("timeIntegral " + string);
        string = PhysicalUnits.timeIntegral(string);
        System.out.println("timeIntegral " + string);
    }
}

