/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.BasicPicker;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainText;

public class ShortLongTermAve
extends BasicPicker {
    public double shortTermWindow = 1.0;
    public double longTermWindow = 10.0;
    public double triggerRatio = 2.0;
    public String errorMessage;
    private static final double WINDOW_MIN = Double.MIN_VALUE;
    private static final double WINDOW_MAX = Double.MAX_VALUE;
    private static final double RATIO_MIN = -1.7976931348623157E308;
    private static final double RATIO_MAX = Double.MAX_VALUE;

    public ShortLongTermAve(String string, double d, double d2, double d3, int n) {
        super(string, n);
        this.shortTermWindow = d;
        this.longTermWindow = d2;
        this.triggerRatio = d3;
    }

    public void setShortTermWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_short_term_window_value + ": " + d);
        }
        this.shortTermWindow = d;
    }

    public void setShortTermWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_short_term_window_value + ": " + string);
        }
        this.setShortTermWindow(d);
    }

    public void setLongTermWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + d);
        }
        this.longTermWindow = d;
    }

    public void setLongTermWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + string);
        }
        this.setLongTermWindow(d);
    }

    public void setRatio(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_ratio_value + ": " + d);
        }
        this.triggerRatio = d;
    }

    public void setRatio(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_ratio_value + ": " + string);
        }
        this.setRatio(d);
    }

    public void checkSettings() throws TimeDomainException {
        super.checkSettings();
        String string = "";
        int n = 0;
        if (this.shortTermWindow < Double.MIN_VALUE || this.shortTermWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_short_term_window_value;
            ++n;
        }
        if (this.longTermWindow < Double.MIN_VALUE || this.longTermWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_long_term_window_value;
            ++n;
        }
        if (this.triggerRatio < -1.7976931348623157E308 || this.triggerRatio > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_ratio_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        float f = (float)(1.0 - d / this.shortTermWindow);
        float f2 = 1.0f - f;
        float f3 = (float)(1.0 - d / this.longTermWindow);
        float f4 = 1.0f - f3;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = fArray[0];
        float f8 = 0.0f;
        int n = 1 + (int)(this.longTermWindow / d);
        boolean bl = this.direction == -1;
        int n2 = -1;
        double d2 = 1.0;
        double d3 = f5;
        double d4 = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            boolean bl2;
            int n3 = bl ? fArray.length - i - 1 : i;
            f7 = 0.0f;
            f5 = f5 * f + Math.abs(fArray[n3] - f7) * f2;
            if (i > n) {
                f6 = f6 * f3 + Math.abs(fArray[n3] - f7) * f4;
                f8 = f5 / f6;
            } else {
                f6 = f5;
            }
            boolean bl3 = bl2 = i > n && (double)f8 > this.triggerRatio;
            if (this.resultType == 2) {
                fArray[n3] = bl2 ? 1.0f : 0.0f;
            } else if (this.resultType == 1) {
                fArray[n3] = f8;
            } else {
                if (bl2) {
                    double[] dArray = new double[2];
                    dArray[0] = (double)n3 - ((double)f8 - 1.0) / ((double)f8 - d3);
                    if (dArray[0] < d4) {
                        dArray[0] = d4;
                    }
                    if (dArray[0] < (double)n2) {
                        dArray[0] = n2;
                    }
                    dArray[1] = n3;
                    PickData pickData = new PickData(dArray[0], dArray[1], 0, f8, "_CF");
                    this.triggerPickData.add(pickData);
                    d4 = dArray[1];
                }
                if (n2 < 0 && i > n && (double)f8 > d2) {
                    n2 = n3;
                } else if (i > n && (double)f8 < d2) {
                    n2 = -1;
                }
            }
            if (this.triggerRatio != 0.0 && (double)f8 > Math.abs(this.triggerRatio)) {
                f6 = f5;
            }
            d3 = f8;
        }
        return fArray;
    }

    public void updateFields(TimeSeries timeSeries) {
        super.updateFields(timeSeries);
    }
}

