/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class BufferedJPanel
extends JPanel {
    protected Image backBuffer = null;
    protected Dimension backSize;
    protected Graphics backBufferGraphics = null;

    public BufferedJPanel() {
    }

    public BufferedJPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = this.getBufferedGraphics(graphics);
        super.paint(graphics2);
        if (this.backBuffer != null) {
            graphics.drawImage(this.backBuffer, 0, 0, null);
        }
    }

    public Graphics getBufferedGraphics(Graphics graphics) {
        Graphics graphics2 = null;
        if (this.backBuffer == null || !this.backSize.equals(this.getSize())) {
            this.newBackBuffer(this);
        }
        if (this.backBuffer != null) {
            graphics2 = this.backBufferGraphics != null ? this.backBufferGraphics : this.backBuffer.getGraphics();
        } else {
            this.disposeOfBackBuffer();
            graphics2 = graphics;
        }
        return graphics2;
    }

    public void showBackBuffer(Graphics graphics) {
        if (this.backBuffer != null) {
            graphics.drawImage(this.backBuffer, 0, 0, null);
        }
    }

    public void newBackBuffer(JPanel jPanel) {
        this.backBuffer = jPanel.createImage(jPanel.getSize().width, jPanel.getSize().height);
        this.backSize = jPanel.getSize();
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
        }
        this.backBufferGraphics = this.backBuffer.getGraphics();
    }

    public void disposeOfBackBuffer() {
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
        }
        this.backBufferGraphics = null;
        this.backBuffer = null;
    }
}

