/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.multicomp.MultiCompException;
import net.alomax.multicomp.PolarisationAnalysis;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;

public class PolarisationAnalysisToolManager
extends JToolManager {
    protected String[] typeNames = new String[]{"COVARIANCE", "COHERENCY"};
    protected SeisGram2KFrame seisFrame = null;
    protected PolarisationAnalysis polarisationAnalysis;
    protected AJLJButton buttonApply;
    protected JTextField textFieldWindowWidth;
    protected JComboBox choiceType;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public PolarisationAnalysisToolManager(SeisGram2KFrame seisGram2KFrame) {
        String string;
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        int n = 10;
        this.polarisationAnalysis = new PolarisationAnalysis(SeisGramText.getLocaleString(), PolarisationAnalysis.COVARIANCE, n);
        try {
            string = null;
            string = seisGram2KFrame.getParameter("multicomp.polarisation.type");
            if (string != null) {
                this.polarisationAnalysis.setType(string);
            }
        }
        catch (MultiCompException multiCompException) {
            seisGram2KFrame.writeMessage("ERROR: " + multiCompException.toString());
        }
        try {
            string = null;
            string = seisGram2KFrame.getParameter("multicomp.polarisation.width");
            if (string != null) {
                this.polarisationAnalysis.setWindowWidth(string);
            }
        }
        catch (MultiCompException multiCompException) {
            seisGram2KFrame.writeMessage("ERROR: " + multiCompException.toString());
        }
        this.commandNames = new String[]{"polarisation"};
        this.commandNamesShort = new String[]{"pol"};
    }

    public void updateLabel() {
        this.label = SeisGramText.POLARISATION;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApply = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApply);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.WINDOW_WIDTH + ":", 4));
        this.textFieldWindowWidth = SwingExt.newJTextField(this, this, String.valueOf(this.polarisationAnalysis.windowWidth), 5);
        jToolBar.add(this.textFieldWindowWidth);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.TYPE + ":", 4));
        this.choiceType = SwingExt.newChoice(this, this.typeNames);
        this.choiceType.setSelectedIndex(this.polarisationAnalysis.getType());
        jToolBar.add(this.choiceType);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApply)) {
            boolean bl = false;
            try {
                this.polarisationAnalysis.setWindowWidth(this.textFieldWindowWidth.getText());
            }
            catch (MultiCompException multiCompException) {
                this.seisFrame.writeMessage("ERROR: " + multiCompException.toString());
                bl = true;
            }
            this.textFieldWindowWidth.setText(String.valueOf(this.polarisationAnalysis.windowWidth));
            try {
                this.polarisationAnalysis.setType(this.choiceType.getSelectedIndex());
            }
            catch (MultiCompException multiCompException) {
                this.seisFrame.writeMessage("ERROR: " + multiCompException.toString());
                bl = true;
            }
            if (bl) {
                return;
            }
            try {
                this.polarisationAnalysis.checkSettings();
            }
            catch (MultiCompException multiCompException) {
                this.seisFrame.writeMessage("ERROR: " + multiCompException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (MultiCompException multiCompException) {
                this.seisFrame.writeMessage("ERROR: " + multiCompException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldWindowWidth)) {
            try {
                this.polarisationAnalysis.setWindowWidth(this.textFieldWindowWidth.getText());
            }
            catch (MultiCompException multiCompException) {
                this.seisFrame.writeMessage("ERROR: " + multiCompException.toString());
            }
            this.textFieldWindowWidth.setText(String.valueOf(this.polarisationAnalysis.windowWidth));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldWindowWidth)) {
            try {
                this.polarisationAnalysis.setType(this.choiceType.getSelectedIndex());
            }
            catch (MultiCompException multiCompException) {
                this.seisFrame.writeMessage("ERROR: " + multiCompException.toString());
            }
        } else {
            return;
        }
    }

    protected void apply() throws MultiCompException {
        this.polarisationAnalysis.checkSettings();
        this.seisFrame.applyMultiCompProcess(this.polarisationAnalysis, this.getCommandString(), null);
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        block8: {
            if (!this.isCommandHandler(string)) {
                throw new JToolManagerException("Not command handler: " + string);
            }
            String string2 = " ";
            this.argumentString = string;
            StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
            try {
                stringTokenizer.nextToken();
                if (this.variant < 0) break block8;
                block3: while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("ty")) {
                        string2 = stringTokenizer.nextToken();
                        for (int i = 0; i < this.typeNames.length; ++i) {
                            if (!string2.equalsIgnoreCase(this.typeNames[i])) continue;
                            this.polarisationAnalysis.setType(i);
                            continue block3;
                        }
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("wi")) {
                        this.polarisationAnalysis.setWindowWidth(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new JToolManagerException("Parsing or applying command", string, string2);
            }
            catch (MultiCompException multiCompException) {
                throw new JToolManagerException("Parsing or applying command: ERROR: " + multiCompException.toString(), string, string2);
            }
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " type " + this.typeNames[this.polarisationAnalysis.type];
        string = string + " width " + this.polarisationAnalysis.windowWidth;
        return string;
    }
}

