/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.BlocketteFactory;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.exception.SeedException;
import edu.iris.Fissures.seed.util.Utility;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import net.alomax.io.GeneralInputStream;
import net.alomax.seis.SEEDControlHeader;
import net.alomax.seis.SeisException;
import net.alomax.seis.VolumeParser;

public class SEEDVolumeParser
extends VolumeParser {
    public static final int B0999_Blockette_type = 1;
    public static final int B0999_Data_Source_Identifier = 2;
    public static final int B0999_Data_Arrival_Time_Stamp = 3;
    public static final int B0999_Station_identifier_code = 4;
    public static final int B0999_Location_identifier = 5;
    public static final int B0999_Channel_identifier = 6;
    public static final int B0999_Network_Code = 7;
    public static final int B0999_Record_start_time = 8;
    public static final int B0999_Number_of_samples = 9;
    public static final int B0999_Sample_rate_factor = 10;
    public static final int B0999_Sample_rate_multiplier = 11;
    public static final int B0999_Activity_flags = 12;
    public static final int B0999_I_O_and_clock_flags = 13;
    public static final int B0999_Data_quality_flags = 14;
    public static final int B0999_No_of_blockettes_that_follow = 15;
    public static final int B0999_Time_correction = 16;
    public static final int B0999_Beginning_of_data = 17;
    public static final int B0999_First_blockette = 18;
    public static final int B1000_Blockette_type = 1;
    public static final int B1000_Next_blockettes_byte_number = 2;
    public static final int B1000_Encoding_format = 3;
    public static final int B1000_Word_order = 4;
    public static final int B1000_Data_Record_Length = 5;
    public static final int B1000_Reserved = 6;
    public static final int B0010_Blockette_type = 1;
    public static final int B0010_Length_of_blockette = 2;
    public static final int B0010_Version_of_format = 3;
    public static final int B0010_Logical_record_length = 4;
    public static final int B0010_Beginning_time = 5;
    public static final int B0010_End_time = 6;
    public static final int B0010_Volume_Time = 7;
    public static final int B0010_Originating_Organization = 8;
    public static final int B0010_Label = 9;
    public static final int B0050_Blockette_type = 1;
    public static final int B0050_Length_of_blockette = 2;
    public static final int B0050_Station_call_letters = 3;
    public static final int B0050_Latitude = 4;
    public static final int B0050_Longitude = 5;
    public static final int B0050_Elevation = 6;
    public static final int B0050_Number_of_channels = 7;
    public static final int B0050_Number_of_station_comments = 8;
    public static final int B0050_Site_name = 9;
    public static final int B0050_Network_identifier_code = 10;
    public static final int B0050_32_bit_word_order = 11;
    public static final int B0050_16_bit_word_order = 12;
    public static final int B0050_Start_effective_date = 13;
    public static final int B0050_End_effective_date = 14;
    public static final int B0050_Update_flag = 15;
    public static final int B0050_Network_Code = 16;
    public static final int B0052_Blockette_type = 1;
    public static final int B0052_Length_of_blockette = 2;
    public static final int B0052_Location_identifier = 3;
    public static final int B0052_Channel_identifier = 4;
    public static final int B0052_Subchannel_identifier = 5;
    public static final int B0052_Instrument_identifier = 6;
    public static final int B0052_Optional_comment = 7;
    public static final int B0052_Units_of_signal_response = 8;
    public static final int B0052_Units_of_calibration_input = 9;
    public static final int B0052_Latitude = 10;
    public static final int B0052_Longitude = 11;
    public static final int B0052_Elevation = 12;
    public static final int B0052_Local_depth = 13;
    public static final int B0052_Azimuth = 14;
    public static final int B0052_Dip = 15;
    public static final int B0052_Data_format_identifier_code = 16;
    public static final int B0052_Data_record_length = 17;
    public static final int B0052_Sample_rate = 18;
    public static final int B0052_Max_clock_drift = 19;
    public static final int B0052_Number_of_comments = 20;
    public static final int B0052_Channel_flags = 21;
    public static final int B0052_Start_date = 22;
    public static final int B0052_End_date = 23;
    public static final int B0052_Update_flag = 24;
    public static final int B0074_Blockette_type = 1;
    public static final int B0074_Length_of_blockette = 2;
    public static final int B0074_Station_identifier = 3;
    public static final int B0074_Location_identifier = 4;
    public static final int B0074_Channel_identifier = 5;
    public static final int B0074_Series_start_time = 6;
    public static final int B0074_Sequence_number_of_first_data = 7;
    public static final int B0074_Sub_sequence_number_of_first_data = 8;
    public static final int B0074_Series_end_time = 9;
    public static final int B0074_Sequence_number_of_last_record = 10;
    public static final int B0074_Sub_sequence_number_of_last_record = 11;
    public static final int B0074_Number_of_accelerator_repeats = 12;
    public static final int B0074_Record_start_time = 13;
    public static final int B0074_Sequence_number_of_record = 14;
    public static final int B0074_Sub_sequence_number_of_record = 15;
    public static final int B0074_Network_Code = 16;
    public static final int B0100_Blockette_type = 1;
    public static final int B0100_Next_blockettes_byte_number = 2;
    public static final int B0100_ctual_Sample_Rate = 3;
    public static final int B0100_Flags = 4;
    public static final int B0100_Reserved_byte = 5;
    protected URL documentBase = null;
    protected String URLName = null;
    protected boolean useCaches = true;
    protected DataInputStream bis = null;
    protected int recordPosition = 0;
    protected long filePosition = 0L;
    protected SEEDControlHeader currentControlHeader = null;
    protected float versionOfFormat = -1.0f;
    protected int logicalRecordLength = Integer.MAX_VALUE;
    protected byte[] identifierBlock = null;
    protected Vector controlHeaders = new Vector();
    protected boolean swapBytes = false;
    protected long markFilePosition = -1L;
    protected int markRecordPosition = -1;
    protected int nextBlocketteByteNumber = 0;

    public SEEDVolumeParser(URL uRL, String string, boolean bl) throws Exception {
        this.documentBase = uRL;
        this.URLName = string;
        this.useCaches = bl;
        this.openDataInputStream();
        SEEDControlHeader sEEDControlHeader = this.readControlHeaderIdentifier();
        if (sEEDControlHeader.typeCode != 86) {
            throw new SeisException("ERROR: reading SEED volume identifier block: control header type code not \"V\": not SEED Volume:: bytes read= \"" + new String(this.getIdentifierBlock()) + "\"");
        }
    }

    protected void openDataInputStream() throws Exception {
        try {
            this.bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bis = new DataInputStream(GeneralInputStream.openStream(this.documentBase, this.URLName, this.useCaches));
        this.recordPosition = 0;
        this.filePosition = 0L;
    }

    public SEEDVolumeParser(DataInputStream dataInputStream) throws Exception {
        this(dataInputStream, false);
    }

    public SEEDVolumeParser(DataInputStream dataInputStream, boolean bl) throws Exception {
        this.bis = dataInputStream;
        SEEDControlHeader sEEDControlHeader = this.readControlHeaderIdentifier();
        if (!bl && sEEDControlHeader.typeCode != 86) {
            throw new SeisException("ERROR: reading SEED volume identifier block: control header type code not \"V\": not SEED Volume:: bytes read= \"" + new String(this.getIdentifierBlock()) + "\"");
        }
    }

    public SEEDControlHeader readControlHeaderIdentifier() throws Exception {
        SEEDControlHeader sEEDControlHeader;
        this.recordPosition = 0;
        long l = this.getFilePosition();
        this.identifierBlock = new byte[8];
        this.bis.readFully(this.identifierBlock);
        this.filePosition += (long)this.identifierBlock.length;
        this.recordPosition += this.identifierBlock.length;
        if (new String("VASTDRQ ").indexOf(this.identifierBlock[6]) < 0) {
            throw new SeisException("ERROR: reading SEED control header: control header type code not \"V\", \"A\", \"S\", \"T\", \"D\", \"R\", \"Q\" or \" \": not valid SEED control header: starting at byte= " + this.getFilePosition() + ": bytes read= \"" + new String(this.identifierBlock) + "\"");
        }
        if (new String("* ").indexOf(this.identifierBlock[7]) < 0) {
            throw new SeisException("ERROR: reading SEED control header: control header continuation code not \" \" or \"*\": not SEED Volume: starting at byte= " + this.getFilePosition() + ": bytes read= \"" + new String(this.identifierBlock) + "\"");
        }
        int n = 0;
        try {
            n = new Integer(new String(this.identifierBlock, 0, 6));
        }
        catch (Exception exception) {
            String string = "WARNING: reading SEED volume: Control Header Sequence Number is not an integer: " + exception;
            System.out.println(this.getClass().getName() + ": " + string);
        }
        byte by = this.identifierBlock[6];
        byte by2 = this.identifierBlock[7];
        this.currentControlHeader = sEEDControlHeader = new SEEDControlHeader(l, n, by, by2);
        return sEEDControlHeader;
    }

    public void readHeaders(boolean bl, boolean bl2) throws Exception {
        block5: while (true) {
            if (this.recordPosition == 0) {
                try {
                    this.readControlHeaderIdentifier();
                }
                catch (EOFException eOFException) {
                    return;
                }
            }
            if (bl2) {
                System.out.println("ControlHeader:  type = " + (char)this.currentControlHeader.getTypeCode() + ", sequence no. = \"" + this.currentControlHeader.getSequenceNumber() + "\"" + ", starting at byte = " + this.currentControlHeader.getStartingByte());
            }
            if (this.currentControlHeader.getTypeCode() == 68 || this.currentControlHeader.getTypeCode() == 82 || this.currentControlHeader.getTypeCode() == 81) {
                if (!bl) break;
                this.skipToEndOfRecord();
                continue;
            }
            this.controlHeaders.addElement(this.currentControlHeader);
            while (true) {
                int n;
                int n2;
                long l = this.getFilePosition();
                int n3 = this.getControlHeaderSequenceNumber();
                Blockette blockette = this.readBlockette(false, bl2);
                if (blockette == null) {
                    this.skipToEndOfRecord();
                    continue block5;
                }
                this.currentControlHeader.add(blockette);
                int n4 = blockette.getType();
                switch (n4) {
                    case 10: {
                        this.versionOfFormat = Float.valueOf(blockette.getFieldVal(3).toString()).floatValue();
                        n2 = Integer.parseInt(blockette.getFieldVal(4).toString());
                        this.logicalRecordLength = 1;
                        for (n = 0; n < n2; ++n) {
                            this.logicalRecordLength *= 2;
                        }
                        this.setLogicalRecordLength(this.logicalRecordLength);
                    }
                }
                if (this.getNextBlocketteByteNumber() <= 0) {
                    this.skipToEndOfRecord();
                    continue block5;
                }
                n2 = (int)(this.getFilePosition() - l);
                if (this.getControlHeaderSequenceNumber() != n3) {
                    n2 -= 8 * (this.getControlHeaderSequenceNumber() - n3);
                }
                n = this.getNextBlocketteByteNumber() - n2;
                this.skipBytesCheckHeaders(n);
            }
            break;
        }
    }

    public synchronized void mark(int n) {
        this.bis.mark(n);
        this.markFilePosition = this.getFilePosition();
        this.markRecordPosition = this.recordPosition;
    }

    public synchronized void reset() throws IOException {
        this.bis.reset();
        this.filePosition = this.markFilePosition;
        this.recordPosition = this.markRecordPosition;
        this.markFilePosition = -1L;
    }

    public void skipBytes(int n) throws Exception {
        this.bis.skipBytes(n);
        this.filePosition += (long)n;
    }

    public void skipBytesCheckHeaders(int n) throws Exception {
        byte[] byArray = new byte[n];
        this.read(byArray);
    }

    public void skipToEndOfRecord() throws Exception {
        int n = this.logicalRecordLength - this.recordPosition;
        if (n <= 0 || n >= this.logicalRecordLength) {
            return;
        }
        byte[] byArray = new byte[n];
        this.read(byArray);
    }

    public void positionAtRecord(int n) throws Exception {
        int n2;
        long l = (long)n * (long)this.logicalRecordLength;
        if (l < this.getFilePosition()) {
            this.openDataInputStream();
        }
        if ((n2 = (int)(l - this.getFilePosition())) <= 0) {
            return;
        }
        this.skipBytes(n2);
    }

    public void read(byte[] byArray, int n, int n2) throws Exception {
        byte[] byArray2 = new byte[n2];
        this.read(byArray2);
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public void read(byte[] byArray) throws Exception {
        this.read(byArray, false);
    }

    public void read(byte[] byArray, boolean bl) throws Exception {
        byte[] byArray2 = new byte[]{};
        if (this.recordPosition != 0) {
            if (this.recordPosition + byArray.length <= this.logicalRecordLength) {
                this.bis.readFully(byArray);
                this.filePosition += (long)byArray.length;
                this.recordPosition += byArray.length;
                this.recordPosition %= this.logicalRecordLength;
                return;
            }
            if (bl) {
                byArray = new byte[]{32};
                return;
            }
            byArray2 = new byte[this.logicalRecordLength - this.recordPosition];
            this.bis.readFully(byArray2);
            this.filePosition += (long)byArray2.length;
            this.recordPosition += byArray2.length;
            this.recordPosition = 0;
        }
        SEEDControlHeader sEEDControlHeader = this.readControlHeaderIdentifier();
        if (sEEDControlHeader.continuationCode == 42 && sEEDControlHeader.typeCode != this.getControlHeaderTypeCode()) {
            throw new SeisException("ERROR: reading SEED control header: continuation control header has new type code: bytes read= \"" + new String(this.getIdentifierBlock()) + "\"");
        }
        byte[] byArray3 = new byte[byArray.length - byArray2.length];
        this.read(byArray3);
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    public long getFilePosition() {
        return this.filePosition;
    }

    public byte getControlHeaderTypeCode() {
        if (this.currentControlHeader == null) {
            return 0;
        }
        return this.currentControlHeader.typeCode;
    }

    public int getControlHeaderSequenceNumber() {
        if (this.currentControlHeader == null) {
            return -1;
        }
        return this.currentControlHeader.sequenceNumber;
    }

    public byte getControlHeaderContinuationCode() {
        if (this.currentControlHeader == null) {
            return 0;
        }
        return this.currentControlHeader.continuationCode;
    }

    public byte[] getIdentifierBlock() {
        return this.identifierBlock;
    }

    public int getLogicalRecordLength() {
        return this.logicalRecordLength;
    }

    public void setLogicalRecordLength(int n) {
        this.logicalRecordLength = n;
    }

    public Vector getControlHeaders() {
        return this.controlHeaders;
    }

    public int getNextBlocketteByteNumber() {
        return this.nextBlocketteByteNumber;
    }

    public Blockette readBlockette(boolean bl, boolean bl2) throws Exception {
        int n;
        long l = this.getFilePosition();
        int n2 = 3;
        if (bl) {
            n2 = 2;
        }
        byte[] byArray = new byte[n2];
        this.read(byArray, true);
        for (n = 0; n < byArray.length && (byArray[n] == 32 || byArray[n] == 0); ++n) {
        }
        if (n == byArray.length) {
            if (bl2) {
                System.out.println("INFO: found only blank characters reading SEED blockette (may be in record padding): from byte= " + l + " to byte=" + this.getFilePosition());
            }
            return null;
        }
        int n3 = -1;
        n3 = bl ? Utility.uBytesToInt(byArray[0], byArray[1], this.swapBytes) : new Integer(new String(byArray).trim());
        int n4 = 4;
        if (bl) {
            n4 = 2;
        }
        byte[] byArray2 = new byte[n4];
        this.read(byArray2);
        this.nextBlocketteByteNumber = bl ? Utility.uBytesToInt(byArray2[0], byArray2[1], this.swapBytes) : new Integer(new String(byArray2).trim());
        int n5 = 0;
        int n6 = 0;
        switch (n3) {
            case 1001: {
                n5 = 8;
                n6 = n5 - n2 - n4;
                break;
            }
            case 1000: {
                n5 = 8;
                n6 = n5 - n2 - n4;
                break;
            }
            case 100: {
                n5 = 10;
                n6 = n5 - n2 - n4;
                break;
            }
            default: {
                n5 = this.nextBlocketteByteNumber;
                n6 = this.nextBlocketteByteNumber - n2 - n4;
            }
        }
        byte[] byArray3 = new byte[n6];
        this.read(byArray3);
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        try {
            Blockette blockette = null;
            try {
                blockette = BlocketteFactory.createBlockette(byArray4, this.swapBytes, bl);
            }
            catch (Exception exception) {
                blockette = BlocketteFactory.createBlockette(byArray4, !this.swapBytes, bl);
            }
            if (bl2) {
                System.out.println("Blockette:  type = " + blockette.getType() + ", name = \"" + blockette.getName() + "\"" + ", starting at byte = " + l);
                for (int i = 2; i < blockette.getNumFields() + 1; ++i) {
                    if (blockette.getFieldRepeat(i) > 0) {
                        System.out.print("   " + blockette.getFieldName(i) + " = " + "REPEATING");
                    } else {
                        System.out.print("   " + blockette.getFieldName(i) + " = " + blockette.toString(i));
                        try {
                            String string = blockette.translate(i);
                            if (string.indexOf("Value Undefined") < 0) {
                                System.out.print(" [" + string + "]");
                            }
                        }
                        catch (Exception exception) {
                            System.out.print(exception);
                        }
                    }
                    System.out.println("");
                }
            }
            return blockette;
        }
        catch (SeedException seedException) {
            String string = "WARNING: reading SEED blockette: " + seedException;
            System.out.println(this.getClass().getName() + ": " + string);
            return null;
        }
    }

    protected Waveform readDataRecord(int n, String string, Blockette blockette) throws Exception {
        int n2 = n - this.getRecordPosition();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        do {
            this.read(byArray, n3, n2 - n3);
        } while ((n3 += n2 - n3) < n2);
        if (n3 != byArray.length) {
            throw new SeisException("ERROR: reading SEED data record block:num bytes read [" + n3 + " ]" + " not equal to nominal data record length [" + n2 + "]" + " currently at byte: " + this.getFilePosition() + n3);
        }
        int n4 = (Integer)blockette.getFieldVal(9);
        Waveform waveform = new Waveform(byArray, 0, n4, string, this.swapBytes);
        return waveform;
    }

    public String getStringValue(Blockette blockette, int n) throws Exception {
        return (String)blockette.getFieldVal(n);
    }

    public double getDoubleValue(Blockette blockette, int n) throws Exception {
        return (Double)blockette.getFieldVal(n);
    }

    public int getIntValue(Blockette blockette, int n) throws Exception {
        return (Integer)blockette.getFieldVal(n);
    }

    public int getByteValue(int n, String string, int n2) throws Exception {
        return new Byte((String)this.getValue(n, string, n2)).byteValue();
    }

    public int getIntValue(int n, String string, int n2) throws Exception {
        return (Integer)this.getValue(n, string, n2);
    }

    public Object getValue(int n, String string, int n2) throws Exception {
        int n3 = 0;
        for (int i = 0; i < this.controlHeaders.size(); ++i) {
            SEEDControlHeader sEEDControlHeader = (SEEDControlHeader)this.controlHeaders.elementAt(i);
            Vector vector = sEEDControlHeader.getBlockettes();
            for (int j = 0; j < vector.size(); ++j) {
                Blockette blockette = (Blockette)vector.elementAt(j);
                if (blockette.getType() != n || ++n3 < n2) continue;
                int n4 = BlocketteFactory.getNumFields(n, this.versionOfFormat);
                for (int k = 1; k < n4 + 1; ++k) {
                    if (!BlocketteFactory.getFieldName(n, k).equals(string)) continue;
                    return blockette.getFieldVal(k);
                }
            }
        }
        return null;
    }

    public Blockette[] getBlockettes(int n) throws Exception {
        Vector<Blockette> vector = new Vector<Blockette>();
        for (int i = 0; i < this.controlHeaders.size(); ++i) {
            SEEDControlHeader sEEDControlHeader = (SEEDControlHeader)this.controlHeaders.elementAt(i);
            Vector vector2 = sEEDControlHeader.getBlockettes();
            for (int j = 0; j < vector2.size(); ++j) {
                Blockette blockette = (Blockette)vector2.elementAt(j);
                if (blockette.getType() != n) continue;
                vector.addElement(blockette);
            }
        }
        Object[] objectArray = new Blockette[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Blockette getStationIdentifierBlockette(String string) throws Exception {
        for (int i = 0; i < this.controlHeaders.size(); ++i) {
            SEEDControlHeader sEEDControlHeader = (SEEDControlHeader)this.controlHeaders.elementAt(i);
            Vector vector = sEEDControlHeader.getBlockettes();
            for (int j = 0; j < vector.size(); ++j) {
                Blockette blockette = (Blockette)vector.elementAt(j);
                if (blockette.getType() != 50 || !this.getStringValue(blockette, 3).equals(string)) continue;
                return blockette;
            }
        }
        return null;
    }

    public Blockette getChannelIdentifierBlockette(Blockette blockette, String string) throws Exception {
        for (int i = 0; i < this.controlHeaders.size(); ++i) {
            SEEDControlHeader sEEDControlHeader = (SEEDControlHeader)this.controlHeaders.elementAt(i);
            Vector vector = sEEDControlHeader.getBlockettes();
            int n = vector.indexOf(blockette);
            if (n < 0) continue;
            for (int j = n + 1; j < vector.size(); ++j) {
                Blockette blockette2 = (Blockette)vector.elementAt(j);
                if (blockette2.getType() != 52 || !this.getStringValue(blockette2, 4).equals(string)) continue;
                return blockette2;
            }
        }
        return null;
    }

    protected Blockette getFixedSectionDataHeader() throws Exception {
        if (new String("DRQ").indexOf(this.getControlHeaderTypeCode()) < 0) {
            throw new SeisException("ERROR: reading SEED volume identifier block: control header type code not \"D\": not SEED Data Record:: bytes read= \"" + new String(this.getIdentifierBlock()) + "\"");
        }
        byte[] byArray = new byte[40];
        this.read(byArray);
        byte[] byArray2 = new byte[10];
        System.arraycopy(byArray, 12, byArray2, 0, 10);
        Btime btime = new Btime(byArray2);
        this.swapBytes = btime.getSwapFlag();
        byte[] byArray3 = new byte[60];
        int n = 0;
        byte[] byArray4 = new byte[2];
        if (this.swapBytes) {
            byArray4[0] = -25;
            byArray4[1] = 3;
        } else {
            byArray4[0] = 3;
            byArray4[1] = -25;
        }
        byArray3[n++] = byArray4[0];
        byArray3[n++] = byArray4[1];
        byte[] byArray5 = new byte[8];
        for (int i = 0; i < byArray5.length; ++i) {
            byArray5[0] = 32;
        }
        byArray5[0] = this.getControlHeaderTypeCode();
        System.arraycopy(byArray5, 0, byArray3, n, byArray5.length);
        n += byArray5.length;
        byArray5 = new Btime().getByteTime();
        System.arraycopy(byArray5, 0, byArray3, n, byArray5.length);
        System.arraycopy(byArray, 0, byArray3, n += byArray5.length, byArray.length);
        n += byArray.length;
        Blockette blockette = BlocketteFactory.createBlockette(byArray3, this.swapBytes, true);
        return blockette;
    }

    public Vector getTimeSeries(Vector vector, Blockette blockette, boolean bl) throws Exception {
        Vector<Blockette> vector2 = new Vector<Blockette>();
        boolean bl2 = true;
        int n = this.getIntValue(blockette, 7);
        int n2 = this.getIntValue(blockette, 10);
        for (int i = n; i <= n2; ++i) {
            char c;
            this.positionAtRecord(i - 1);
            this.readControlHeaderIdentifier();
            int n3 = 0;
            Blockette blockette2 = this.getFixedSectionDataHeader();
            if (bl2) {
                vector2.addElement(blockette2);
            }
            boolean bl3 = ((c = ((String)blockette2.getFieldVal(13)).charAt(0)) & 8) != 0;
            boolean bl4 = (c & 0x10) != 0;
            long l = ((Integer)blockette2.getFieldVal(17)).intValue();
            l += (long)(this.getRecordPosition() - 48);
            if (bl) {
                System.out.println("beginningOfData: " + l);
                System.out.println("this.getRecordPosition(): " + this.getRecordPosition());
            }
            String string = null;
            int n4 = 0;
            boolean bl5 = false;
            while ((long)this.getRecordPosition() < l) {
                long l2 = this.getFilePosition();
                Blockette blockette3 = this.readBlockette(true, bl);
                if (blockette3 == null) {
                    if (bl5) {
                        if (bl) {
                            System.out.println("beginningOfData: " + l);
                            System.out.println("this.getRecordPosition(): " + this.getRecordPosition());
                        }
                        try {
                            this.skipBytes((int)(l - (long)this.getRecordPosition()));
                            this.recordPosition = (int)((long)this.recordPosition + (l - (long)this.getRecordPosition()));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (!bl) continue;
                        System.out.println("beginningOfData: " + l);
                        System.out.println("this.getRecordPosition(): " + this.getRecordPosition());
                        continue;
                    }
                    throw new SeisException("ERROR: unexpected blank characters reading SEED blockette: starting at byte= " + l2);
                }
                if (bl2) {
                    vector2.addElement(blockette3);
                }
                ++n3;
                int n5 = blockette3.getType();
                block1 : switch (n5) {
                    case 1000: {
                        int n6;
                        int n7 = Integer.valueOf((String)blockette3.getFieldVal(5));
                        n4 = 1;
                        for (n6 = 0; n6 < n7; ++n6) {
                            n4 *= 2;
                        }
                        if (bl) {
                            System.out.println("Data Only SEED Blockette: dataRecordLength: " + n4);
                        }
                        n6 = new Byte((String)blockette3.getFieldVal(3)).byteValue();
                        switch (n6) {
                            case 10: {
                                string = "Steim1";
                                break block1;
                            }
                            case 11: {
                                string = "Steim2";
                                break block1;
                            }
                        }
                        string = "UNKNOWN";
                        break;
                    }
                }
                long l3 = this.getNextBlocketteByteNumber();
                long l4 = l3 > 0L ? l3 - (long)this.getRecordPosition() : l - (long)this.getRecordPosition();
                this.skipBytesCheckHeaders((int)l4);
            }
            if (bl) {
                System.out.println("dataRecordLength: " + n4);
            }
            Waveform waveform = this.readDataRecord(n4, string, blockette2);
            vector.addElement(waveform);
            bl2 = false;
        }
        return vector2;
    }

    public String getControlHeadersString() {
        Vector vector = this.getControlHeaders();
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(4096);
        for (int i = 0; i < vector.size(); ++i) {
            SEEDControlHeader sEEDControlHeader = (SEEDControlHeader)vector.elementAt(i);
            stringBuffer.append("<controlHeader type=" + (char)sEEDControlHeader.getTypeCode() + ">" + string);
            Vector vector2 = sEEDControlHeader.getBlockettes();
            for (int j = 0; j < vector2.size(); ++j) {
                Blockette blockette = (Blockette)vector2.elementAt(j);
                stringBuffer.append("<blockette type=" + blockette.getType() + ">" + string + "   " + blockette.toString() + string + "</blockette>" + string);
            }
            stringBuffer.append("</controlHeader>" + string);
        }
        return stringBuffer.toString();
    }
}

