/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.Serializable;
import net.alomax.geog.Position;
import net.alomax.seis.BasicItem;
import net.alomax.util.StringExt;
import net.alomax.util.TimeInstant;

public class BasicHypocenter
extends BasicItem
implements Serializable {
    public static final double UNDEF_MAG = -9.9;
    public static final TimeInstant UNDEF_OTIME = new TimeInstant(9999, 1, 1);
    public Position position = new Position();
    public TimeInstant otime = UNDEF_OTIME;
    public double ms = -9.9;
    public double mb = -9.9;
    public double mw = -9.9;
    public double ml = -9.9;
    public double md = -9.9;
    public double mo = -9.9;
    public double mag = -9.9;

    public static BasicHypocenter create(String string, String string2) throws Exception {
        BasicHypocenter basicHypocenter = new BasicHypocenter();
        basicHypocenter.otime = TimeInstant.create(string, string2);
        String[] stringArray = StringExt.parse(string, string2);
        basicHypocenter.position = new Position();
        basicHypocenter.position.latitude = Double.parseDouble(stringArray[6]);
        basicHypocenter.position.longitude = Double.parseDouble(stringArray[7]);
        basicHypocenter.position.depth = Double.parseDouble(stringArray[8]);
        return basicHypocenter;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "otime = " + this.otime + string;
        string2 = string2 + this.position.toString();
        string2 = string2 + "ms = " + this.ms + string + "mb = " + this.mb + string + "mw = " + this.mw + string + "ml = " + this.ml + string + "md = " + this.md + string + "mo = " + this.mo + string + "mag = " + this.mo + string;
        return string2;
    }

    public String toStringOtimeHypo() {
        String string = this.otime + "," + (float)this.position.latitude + "," + (float)this.position.longitude + "," + (float)this.position.depth;
        return string;
    }

    public String toStringPretty(boolean bl) {
        String string = null;
        string = bl ? this.otime.toString(1, 2, true) : this.otime.toString(0, 2, true);
        String string2 = "Date-Time: " + string + " " + this.otime.getTimeZoneID() + "  Location: " + this.position.toStringGeog(2);
        return string2;
    }
}

