/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.message;

import java.net.URL;
import java.util.Date;
import net.alomax.message.FileMessagePusher;
import net.alomax.message.HeartbeatFilePusherListener;

public class HeartbeatFilePusher
extends Thread {
    protected boolean stopRunning = false;
    protected HeartbeatFilePusherListener listener;
    protected URL documentBase;
    protected String messageFileName;
    protected long waitMilliSec;
    protected String heartbeatMessage = null;
    protected int heartbeatCount = -1;
    protected FileMessagePusher fileMessagePusher = null;
    private static final int EXCEPTION_COUNT_LIMIT = 20;
    private int exceptCount = 20;

    public HeartbeatFilePusher(HeartbeatFilePusherListener heartbeatFilePusherListener, URL uRL, String string, long l, String string2) {
        this.listener = heartbeatFilePusherListener;
        this.documentBase = uRL;
        this.messageFileName = string;
        this.waitMilliSec = l;
        this.heartbeatMessage = string2;
    }

    public void stopRunning() {
        this.stopRunning = true;
    }

    public int getCount() {
        return this.heartbeatCount;
    }

    private boolean checkForStop() {
        return this.stopRunning;
    }

    public void run() {
        long l = this.waitMilliSec;
        this.fileMessagePusher = new FileMessagePusher(this.documentBase, this.messageFileName);
        do {
            if (this.checkForStop()) {
                return;
            }
            try {
                HeartbeatFilePusher.sleep(l);
                if (this.checkForStop()) {
                    return;
                }
                String[] stringArray = new String[]{"<heartbeat message=\"" + this.heartbeatMessage + "\" " + "count=\"" + ++this.heartbeatCount + "\" " + "time=\"" + new Date().toGMTString() + "\"" + "/>"};
                this.fileMessagePusher.write(stringArray);
                this.listener.heartbeatSent(this, stringArray[0]);
                if (this.checkForStop()) {
                    return;
                }
                this.exceptCount = 20;
            }
            catch (Exception exception) {
                if (this.exceptCount++ < 20) continue;
                System.out.println("HeartbeatFilePusher: (" + new Date().toString() + ") caught and ignoring an exception:");
                System.out.println(exception.getMessage());
                this.exceptCount = 0;
            }
            catch (Throwable throwable) {
                if (this.exceptCount++ < 20) continue;
                System.out.println("HeartbeatFilePusher: (" + new Date().toString() + ") caught and ignoring a throwable:");
                System.out.println(throwable.getMessage());
                this.exceptCount = 0;
            }
        } while (!this.checkForStop());
    }
}

