/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.earthworm;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Locale;
import net.alomax.earthworm.WaveserverException;
import net.alomax.util.StringExt;

public class WSSiteChanNet {
    public int pin = -1;
    public String site = null;
    public String channel = null;
    public String network = null;
    public double starttime = -1.0;
    public double endtime = -1.0;
    public String datatype = null;
    public String flag = null;
    public int numBytesData = -1;
    public double sampleRate = -1.0;
    protected static DecimalFormat timeformat = new DecimalFormat("#0.######", new DecimalFormatSymbols(Locale.US));

    public WSSiteChanNet(String string, String string2, String string3) {
        this.site = string;
        this.channel = string2;
        this.network = string3;
    }

    public WSSiteChanNet(WSSiteChanNet wSSiteChanNet, double d, double d2) {
        this.pin = wSSiteChanNet.pin;
        this.site = wSSiteChanNet.site;
        this.channel = wSSiteChanNet.channel;
        this.network = wSSiteChanNet.network;
        this.starttime = d;
        this.endtime = d2;
        this.datatype = wSSiteChanNet.datatype;
    }

    public WSSiteChanNet(int n, String string, String string2, String string3, double d, double d2, String string4) {
        this.pin = n;
        this.site = string;
        this.channel = string2;
        this.network = string3;
        this.starttime = d;
        this.endtime = d2;
        this.datatype = string4;
    }

    public WSSiteChanNet(int n, String string, String string2, String string3, String string4, String string5, double d, double d2, int n2) {
        this.pin = n;
        this.site = string;
        this.channel = string2;
        this.network = string3;
        this.flag = string4;
        this.datatype = string5;
        this.starttime = d;
        this.endtime = d2;
        this.numBytesData = n2;
    }

    public WSSiteChanNet(int n, String string, String string2, String string3, String string4, String string5, double d, double d2, double d3) {
        this.pin = n;
        this.site = string;
        this.channel = string2;
        this.network = string3;
        this.flag = string4;
        this.datatype = string5;
        this.starttime = d;
        this.endtime = d2;
        this.sampleRate = d3;
    }

    public WSSiteChanNet(WSSiteChanNet wSSiteChanNet) {
        this.pin = wSSiteChanNet.pin;
        this.site = wSSiteChanNet.site;
        this.channel = wSSiteChanNet.channel;
        this.network = wSSiteChanNet.network;
        this.flag = wSSiteChanNet.flag;
        this.datatype = wSSiteChanNet.datatype;
        this.starttime = wSSiteChanNet.starttime;
        this.endtime = wSSiteChanNet.endtime;
        this.sampleRate = wSSiteChanNet.sampleRate;
        this.numBytesData = wSSiteChanNet.numBytesData;
    }

    public static WSSiteChanNet createFromSCN(String string) throws WaveserverException {
        String[] stringArray = StringExt.parse(string, ". _:");
        if (stringArray == null || stringArray.length < 3) {
            throw new WaveserverException("failed to parse SCN selector: " + string);
        }
        return new WSSiteChanNet(stringArray[0], stringArray[1], stringArray[2]);
    }

    public static WSSiteChanNet createFromResponseToMENU(String[] stringArray) throws WaveserverException {
        if (stringArray == null || stringArray.length != 7) {
            throw new WaveserverException("failed to parse MENU response string");
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            double d = Double.parseDouble(stringArray[4].replace(',', '.'));
            double d2 = Double.parseDouble(stringArray[5].replace(',', '.'));
            return new WSSiteChanNet(n, stringArray[1], stringArray[2], stringArray[3], d, d2, stringArray[6]);
        }
        catch (Exception exception) {
            throw new WaveserverException("failed to parse MENU response string:" + exception);
        }
    }

    public static WSSiteChanNet createFromResponseToGETSCNRAW(String[] stringArray) throws WaveserverException {
        if (stringArray == null || stringArray.length < 6) {
            throw new WaveserverException("failed to parse GETSCNRAW response string");
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            String string = stringArray[4];
            String string2 = stringArray[5];
            double d = -1.0;
            double d2 = -1.0;
            int n2 = -1;
            if (string.equals("F")) {
                d = Double.parseDouble(stringArray[6]);
                d2 = Double.parseDouble(stringArray[7]);
                n2 = Integer.parseInt(stringArray[8]);
                System.out.println("numBytesData=" + n2);
            } else if (string.equals("FL")) {
                d = Double.parseDouble(stringArray[6]);
            } else if (string.equals("FR")) {
                d2 = Double.parseDouble(stringArray[6]);
            }
            return new WSSiteChanNet(n, stringArray[1], stringArray[2], stringArray[3], string, string2, d, d2, n2);
        }
        catch (Exception exception) {
            throw new WaveserverException("failed to parse GETSCNRAW response string:" + exception);
        }
    }

    public static WSSiteChanNet createFromResponseToGETSCN(String[] stringArray) throws WaveserverException {
        if (stringArray == null || stringArray.length < 8) {
            throw new WaveserverException("failed to parse GETSCN response string");
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            String string = stringArray[4];
            String string2 = stringArray[5];
            double d = -1.0;
            double d2 = -1.0;
            double d3 = -1.0;
            if (string.equals("F")) {
                d = Double.parseDouble(stringArray[6]);
                d3 = Double.parseDouble(stringArray[7]);
            } else if (string.equals("FL")) {
                d = Double.parseDouble(stringArray[6]);
            } else if (string.equals("FR")) {
                d2 = Double.parseDouble(stringArray[6]);
            }
            return new WSSiteChanNet(n, stringArray[1], stringArray[2], stringArray[3], string, string2, d, d2, d3);
        }
        catch (Exception exception) {
            throw new WaveserverException("failed to parse GETSCN response string:" + exception);
        }
    }

    public String toSCNString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.site).append(' ').append(this.channel).append(' ').append(this.network);
        return stringBuffer.toString();
    }

    public String toSCNStartStopString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.site).append(' ').append(this.channel).append(' ').append(this.network);
        stringBuffer.append(' ').append(timeformat.format(this.starttime)).append(' ').append(timeformat.format(this.endtime));
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pin);
        stringBuffer.append(' ').append(this.site).append(' ').append(this.channel).append(' ').append(this.network);
        stringBuffer.append(' ').append(this.starttime).append(' ').append(this.endtime).append(' ').append(this.datatype);
        return stringBuffer.toString();
    }

    public String toStringPretty() {
        String string = new Date((long)(this.starttime * 1000.0)).toGMTString();
        String string2 = new Date((long)(this.endtime * 1000.0)).toGMTString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pin);
        stringBuffer.append("  ").append(this.site).append(' ').append(this.channel).append(' ').append(this.network);
        stringBuffer.append("  ").append(string).append("  ").append(string2).append("  ").append(this.datatype);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        try {
            WSSiteChanNet wSSiteChanNet = (WSSiteChanNet)object;
            return this.site.equals(wSSiteChanNet.site) && this.channel.equals(wSSiteChanNet.channel) && this.network.equals(wSSiteChanNet.network);
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

