/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.fields.Field;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.PolynomialBasis;
import JSci.maths.polynomials.RealPolynomial;
import JSci.maths.polynomials.RealPolynomialRing;

public class RealLagrangeBasis
implements PolynomialBasis {
    protected double[] _samplingsX;
    protected int _dim;
    private RealPolynomial[] _basis;
    private Field.Member[] _samplings;

    public RealLagrangeBasis(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException();
        }
        this._dim = memberArray.length;
        this._samplings = memberArray;
        this._samplingsX = RealPolynomialRing.toDouble(this._samplings);
        this.buildBasis();
    }

    public RealLagrangeBasis(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException();
        }
        this._dim = dArray.length;
        this._samplingsX = dArray;
        this.buildBasis();
    }

    protected RealLagrangeBasis() {
    }

    public Polynomial getBasisVector(int n) {
        return this._basis[n];
    }

    public int dimension() {
        return this._dim;
    }

    public Field.Member[] getSamplingPoints() {
        if (this._samplings == null) {
            this._samplings = RealPolynomialRing.toMathDouble(this._samplingsX);
        }
        return this._samplings;
    }

    public Polynomial superposition(Field.Member[] memberArray) {
        if (memberArray == null) {
            throw new NullPointerException();
        }
        if (memberArray.length != this._dim) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        double[] dArray = RealPolynomialRing.toDouble(memberArray);
        return this.superposition(dArray);
    }

    public RealPolynomial superposition(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException();
        }
        if (dArray.length != this._dim) {
            throw new IllegalArgumentException("Dimension of basis is " + this._dim + ". Got " + dArray.length + " coefficients");
        }
        RealPolynomial realPolynomial = (RealPolynomial)RealPolynomialRing.getInstance().zero();
        for (int i = 0; i < this._dim; ++i) {
            RealPolynomial realPolynomial2 = (RealPolynomial)this.getBasisVector(i);
            RealPolynomial realPolynomial3 = realPolynomial2.scalarMultiply(dArray[i]);
            realPolynomial = (RealPolynomial)realPolynomial.add(realPolynomial3);
        }
        return realPolynomial;
    }

    protected void buildBasis() {
        this._basis = new RealPolynomial[this._dim];
        for (int i = 0; i < this._dim; ++i) {
            this._basis[i] = (RealPolynomial)RealPolynomialRing.getInstance().one();
            double d = 1.0;
            for (int j = 0; j < this._dim; ++j) {
                if (j == i) continue;
                RealPolynomial realPolynomial = new RealPolynomial(new double[]{-this._samplingsX[j], 1.0});
                this._basis[i] = (RealPolynomial)this._basis[i].multiply(realPolynomial);
                d *= this._samplingsX[i] - this._samplingsX[j];
            }
            this._basis[i] = this._basis[i].scalarDivide(d);
        }
    }
}

