'''OpenGL extension ARB.debug_label

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.debug_label to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines a mechanism for OpenGL applications to label their 
	objects (textures, buffers, shaders, etc.) with a descriptive string. 
	
	When profiling or debugging an OpenGL application within an external or 
	built-in (debut output API) debugger or profiler it is difficult to 
	identify objects from their object names. 
	
	Even when the object itself is viewed it can be problematic to 
	differentiate between similar objects. Attaching a label to an object         
	helps obviate this difficulty.
	
	The intended purpose of this is purely to improve the user experience 
	within OpenGL development tools and application built-in profilers and 
	debuggers.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/debug_label.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.debug_label import *
### END AUTOGENERATED SECTION