
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class DocumentListType(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext is not None and apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		else:
			apiContext = ApiContext(dataViewMode = dataViewMode);
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def createDocumentListType(self,list, responseFields = None):
		""" Creates a new documentListType
		
		Args:
			| list(list) - Properties for the document list type. Document lists contain documents with an associated document type, such as web pages.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DocumentListType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlistTypes/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(list).execute();
		return self.client.result();

	
		
	def updateDocumentListType(self,list, documentListTypeFQN, responseFields = None):
		""" Updates a DocumentListType
		
		Args:
			| list(list) - Properties for the document list type. Document lists contain documents with an associated document type, such as web pages.
			| documentListTypeFQN (string) - 
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DocumentListType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlistTypes/{documentListTypeFQN}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("documentListTypeFQN", documentListTypeFQN);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(list).execute();
		return self.client.result();

	
	
	