
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Application(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def thirdPartyGetApplication(self,responseFields = None):
		""" Retrieve the settings of a third-party application.
		
		Args:
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Application 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/applications/?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def thirdPartyUpdateApplication(self,application, responseFields = None):
		""" Initializes an application with the necessary configured settings.
		
		Args:
			| application(application) - Properties of an application installed in a tenant.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Application 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/settings/applications/?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(application).execute();
		return self.client.result();

	
	
	