
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class MasterCatalog(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getMasterCatalogs(self,responseFields = None):
		""" Retrieve the details of all master catalog associated with a tenant.
		
		Args:
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| MasterCatalogCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/mastercatalogs/?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getMasterCatalog(self,masterCatalogId, responseFields = None):
		""" Retrieve the details of the master catalog specified in the request.
		
		Args:
			| masterCatalogId (int) - The unique identifier of the master catalog associated with the entity.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| MasterCatalog 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/mastercatalogs/{masterCatalogId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("masterCatalogId", masterCatalogId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def updateMasterCatalog(self,masterCatalog, masterCatalogId, responseFields = None):
		""" Updates the product publishing mode for the master catalog specified in the request.
		
		Args:
			| masterCatalog(masterCatalog) - Properties of a master product catalog defined for a tenant. All catalogs and sites associated with a master catalog share product definitions.
			| masterCatalogId (int) - 
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| MasterCatalog 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/mastercatalogs/{masterCatalogId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("masterCatalogId", masterCatalogId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(masterCatalog).execute();
		return self.client.result();

	
	
	