
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Cart(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getCart(self,cartId, responseFields = None):
		""" Retrieves the cart specified in the request.
		
		Args:
			| cartId (string) - Identifier of the cart to delete.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Cart 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/{cartId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("cartId", cartId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getOrCreateCart(self,responseFields = None):
		""" Retrieves a cart's contents for the current shopper. If the shopper does not have an active cart on the site, the service creates one.
		
		Args:
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Cart 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getCartSummary(self,responseFields = None):
		""" Retrieves summary information associated with the cart of the current shopper, including the number of items, the current total, and whether the cart has expired. All anonymous idle carts that do not proceed to checkout expire after 14 days.
		
		Args:
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CartSummary 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/summary?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getUserCartSummary(self,userId, responseFields = None):
		""" Retrieves summary information associated with the cart of user specified in the request, including the number of items in the cart, the current total, and whether the cart has expired. All anonymous idle carts that do not proceed to checkout expire after 14 days.
		
		Args:
			| userId (string) - Unique identifier of the user whose tenant scopes you want to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CartSummary 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/user/{userId}/summary?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("userId", userId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getUserCart(self,userId, responseFields = None):
		""" Retrieves the cart of the user specified in the request.
		
		Args:
			| userId (string) - Unique identifier of the user whose tenant scopes you want to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Cart 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/user/{userId}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("userId", userId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def updateCart(self,cart, responseFields = None):
		""" Update the current shopper's cart.
		
		Args:
			| cart(cart) - Properties of a shopping cart.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Cart 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(cart).execute();
		return self.client.result();

	
		
	def deleteCart(self,cartId):
		""" Deletes the cart specified in the request.
		
		Args:
			| cartId (string) - Identifier of the cart to delete.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/{cartId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("cartId", cartId);
		self.client.withResourceUrl(url).execute();

	
		
	def deleteCurrentCart(self,):
		""" Deletes the cart of the currently active shopper.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current", "DELETE", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).execute();

	
	
	