# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, Optional, TypeVar

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._event_routes_operations import build_add_request, build_delete_request, build_get_by_id_request, build_list_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class EventRoutesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.digitaltwins.core.aio.AzureDigitalTwinsAPI`'s
        :attr:`event_routes` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        args = list(args)
        self._client = args.pop(0) if args else kwargs.pop("client")
        self._config = args.pop(0) if args else kwargs.pop("config")
        self._serialize = args.pop(0) if args else kwargs.pop("serializer")
        self._deserialize = args.pop(0) if args else kwargs.pop("deserializer")


    @distributed_trace
    def list(
        self,
        event_routes_list_options: Optional["_models.EventRoutesListOptions"] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.EventRouteCollection"]:
        """Retrieves all event routes.
        Status codes:


        * 200 OK.

        :param event_routes_list_options: Parameter group. Default value is None.
        :type event_routes_list_options: ~azure.digitaltwins.core.models.EventRoutesListOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either EventRouteCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.digitaltwins.core.models.EventRouteCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2021-06-30-preview")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.EventRouteCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                _traceparent = None
                _tracestate = None
                _max_items_per_page = None
                if event_routes_list_options is not None:
                    _traceparent = event_routes_list_options.traceparent
                    _tracestate = event_routes_list_options.tracestate
                    _max_items_per_page = event_routes_list_options.max_items_per_page
                
                request = build_list_request(
                    api_version=api_version,
                    traceparent=_traceparent,
                    tracestate=_tracestate,
                    max_items_per_page=_max_items_per_page,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                _traceparent = None
                _tracestate = None
                _max_items_per_page = None
                if event_routes_list_options is not None:
                    _traceparent = event_routes_list_options.traceparent
                    _tracestate = event_routes_list_options.tracestate
                    _max_items_per_page = event_routes_list_options.max_items_per_page
                
                request = build_list_request(
                    api_version=api_version,
                    traceparent=_traceparent,
                    tracestate=_tracestate,
                    max_items_per_page=_max_items_per_page,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("EventRouteCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/eventroutes"}  # type: ignore

    @distributed_trace_async
    async def get_by_id(
        self,
        id: str,
        event_routes_get_by_id_options: Optional["_models.EventRoutesGetByIdOptions"] = None,
        **kwargs: Any
    ) -> "_models.DigitalTwinsEventRoute":
        """Retrieves an event route.
        Status codes:


        * 200 OK
        * 404 Not Found

          * EventRouteNotFound - The event route was not found.

        :param id: The id for an event route. The id is unique within event routes and case sensitive.
        :type id: str
        :param event_routes_get_by_id_options: Parameter group. Default value is None.
        :type event_routes_get_by_id_options: ~azure.digitaltwins.core.models.EventRoutesGetByIdOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DigitalTwinsEventRoute, or the result of cls(response)
        :rtype: ~azure.digitaltwins.core.models.DigitalTwinsEventRoute
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DigitalTwinsEventRoute"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-06-30-preview")  # type: str

        _traceparent = None
        _tracestate = None
        if event_routes_get_by_id_options is not None:
            _traceparent = event_routes_get_by_id_options.traceparent
            _tracestate = event_routes_get_by_id_options.tracestate

        request = build_get_by_id_request(
            id=id,
            api_version=api_version,
            traceparent=_traceparent,
            tracestate=_tracestate,
            template_url=self.get_by_id.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('DigitalTwinsEventRoute', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_by_id.metadata = {'url': "/eventroutes/{id}"}  # type: ignore


    @distributed_trace_async
    async def add(  # pylint: disable=inconsistent-return-statements
        self,
        id: str,
        event_route: Optional["_models.DigitalTwinsEventRoute"] = None,
        event_routes_add_options: Optional["_models.EventRoutesAddOptions"] = None,
        **kwargs: Any
    ) -> None:
        """Adds or replaces an event route.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * EventRouteEndpointInvalid - The endpoint provided does not exist or is not active.
          * EventRouteFilterInvalid - The event route filter is invalid.
          * EventRouteIdInvalid - The event route id is invalid.
          * LimitExceeded - The maximum number of event routes allowed has been reached.

        :param id: The id for an event route. The id is unique within event routes and case sensitive.
        :type id: str
        :param event_route: The event route data. Default value is None.
        :type event_route: ~azure.digitaltwins.core.models.DigitalTwinsEventRoute
        :param event_routes_add_options: Parameter group. Default value is None.
        :type event_routes_add_options: ~azure.digitaltwins.core.models.EventRoutesAddOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-06-30-preview")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _traceparent = None
        _tracestate = None
        if event_routes_add_options is not None:
            _traceparent = event_routes_add_options.traceparent
            _tracestate = event_routes_add_options.tracestate
        if event_route is not None:
            _json = self._serialize.body(event_route, 'DigitalTwinsEventRoute')
        else:
            _json = None

        request = build_add_request(
            id=id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            traceparent=_traceparent,
            tracestate=_tracestate,
            template_url=self.add.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    add.metadata = {'url': "/eventroutes/{id}"}  # type: ignore


    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        id: str,
        event_routes_delete_options: Optional["_models.EventRoutesDeleteOptions"] = None,
        **kwargs: Any
    ) -> None:
        """Deletes an event route.
        Status codes:


        * 204 No Content
        * 404 Not Found

          * EventRouteNotFound - The event route was not found.

        :param id: The id for an event route. The id is unique within event routes and case sensitive.
        :type id: str
        :param event_routes_delete_options: Parameter group. Default value is None.
        :type event_routes_delete_options: ~azure.digitaltwins.core.models.EventRoutesDeleteOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-06-30-preview")  # type: str

        _traceparent = None
        _tracestate = None
        if event_routes_delete_options is not None:
            _traceparent = event_routes_delete_options.traceparent
            _tracestate = event_routes_delete_options.tracestate

        request = build_delete_request(
            id=id,
            api_version=api_version,
            traceparent=_traceparent,
            tracestate=_tracestate,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': "/eventroutes/{id}"}  # type: ignore

