# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from msrest import Deserializer, Serializer

from azure.core import AsyncPipelineClient
from azure.core.rest import AsyncHttpResponse, HttpRequest

from .. import models
from ._configuration import AzureDigitalTwinsAPIConfiguration
from .operations import DigitalTwinModelsOperations, DigitalTwinsOperations, EventRoutesOperations, QueryOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

class AzureDigitalTwinsAPI:
    """A service for managing and querying digital twins and digital twin models.

    :ivar digital_twin_models: DigitalTwinModelsOperations operations
    :vartype digital_twin_models:
     azure.digitaltwins.core.aio.operations.DigitalTwinModelsOperations
    :ivar query: QueryOperations operations
    :vartype query: azure.digitaltwins.core.aio.operations.QueryOperations
    :ivar digital_twins: DigitalTwinsOperations operations
    :vartype digital_twins: azure.digitaltwins.core.aio.operations.DigitalTwinsOperations
    :ivar event_routes: EventRoutesOperations operations
    :vartype event_routes: azure.digitaltwins.core.aio.operations.EventRoutesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param base_url: Service URL. Default value is "https://digitaltwins-hostname".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2021-06-30-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        base_url: str = "https://digitaltwins-hostname",
        **kwargs: Any
    ) -> None:
        self._config = AzureDigitalTwinsAPIConfiguration(credential=credential, **kwargs)
        self._client = AsyncPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.digital_twin_models = DigitalTwinModelsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.query = QueryOperations(self._client, self._config, self._serialize, self._deserialize)
        self.digital_twins = DigitalTwinsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.event_routes = EventRoutesOperations(self._client, self._config, self._serialize, self._deserialize)


    def _send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "AzureDigitalTwinsAPI":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
