/** vim: et:ts=4:sw=4:sts=4
 * @license RequireJS 2.1.11 Copyright (c) 2010-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/requirejs for details
 */

// Patterns
//
// Author: Rok Garbas
// Contact: rok@garbas.si
// Version: 1.0
// Depends: jquery.js
//
// Description:
//
// License:
//
// Copyright (C) 2010 Plone Foundation
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 51
// Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

/**
 * @license
 * Lo-Dash 2.4.1 (Custom Build) <http://lodash.com/>
 * Build: `lodash underscore exports="amd,commonjs,global,node" -o ./dist/lodash.underscore.js`
 * Copyright 2012-2013 The Dojo Foundation <http://dojofoundation.org/>
 * Based on Underscore.js 1.5.2 <http://underscorejs.org/LICENSE>
 * Copyright 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 * Available under MIT license <http://lodash.com/license>
 */

/* Backdrop pattern.
 *
 * Options:
 *    zIndex(integer): z-index of backdrop element. (null)
 *    opacity(float): opacity level of backdrop element. (0.8)
 *    className(string): class name of backdrop element. ('backdrop')
 *    classActiveName(string): class name when backdrop is active. ('backdrop-active')
 *    closeOnEsc(boolean): should backdrop close when ESC key is pressed. (true)
 *    closeOnClick(boolean): should backdrop close when clicked on it. (true)
 *
 * Documentation:
 *    # TODO: we need example or this is not pattern :)
 *
 * Example: example-1
 *
 * License:
 *    Copyright (C) 2010 Plone Foundation
 *
 *    This program is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU General Public License as published by the
 *    Free Software Foundation; either version 2 of the License.
 *
 *    This program is distributed in the hope that it will be useful, but
 *    WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *    Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

//     (c) 2010-2011 Jeremy Ashkenas, DocumentCloud Inc.
//     (c) 2011-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Backbone may be freely distributed under the MIT license.
//     For all details and documentation:
//     http://backbonejs.org

// pattern router.
//
// Author: Ryan Foster
// Contact: ryan@rynamic.com
// Version: 1.0
// Depends: jquery.js
//
// Description:
//
// License:
//
// Copyright (C) 2010 Plone Foundation
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 51
// Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

// utils.
//
// Author: Nathan Van Gheem
// Contact: nathan@vangheem.us
// Version: 1.0
// Depends: jquery.js
//
// Description:
//
// License:
//
// Copyright (C) 2010 Plone Foundation
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 51
// Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

/*!
 * jQuery Form Plugin
 * version: 3.46.0-2013.11.21
 * Requires jQuery v1.5 or later
 * Copyright (c) 2013 M. Alsup
 * Examples and documentation at: http://malsup.com/jquery/form/
 * Project repository: https://github.com/malsup/form
 * Dual licensed under the MIT and GPL licenses.
 * https://github.com/malsup/form#copyright-and-license
 */

/* Modal pattern.
 *
 * Options:
 *    height(string): Set the height of the modal, for example: 250px ('')
 *    width(string): Set the width of the modal, for example: 80% or 500px. ('')
 *    margin(function or integer): A function, Integer or String which will be used to set the margin of the modal in pixels. If a function is passed it must return an Integer. (20)
 *    position(string): Position the modal relative to the window with the format: "<horizontal> <vertical>" -- allowed values: top, bottom, left, right, center, middle. ('center middle')
 *    triggers(array): Add event listeners to elements on the page which will open the modal when triggered. Pass an Array of strings with the format ["&lt;event&gt; &lt;selector&gt;"] or ["&lt;event&gt;"]. For example, ["click .someButton"]. If you pass in only an event such as, ["change"], the event listener will be added to the element on which the modal was initiated, usually a link or button. ([])
 *    title(string): A string to place in the modal header. If title is provided, titleSelector is not used. (null)
 *    titleSelector(string): Selector for an element to extract from the content provided to the modal and place in the modal header. ('h1:first')
 *    content(string): Selector for an element within the content provided to the modal to use as the modal body. ('#content')
 *    prependContent(string): Selector for elements within the content provided to the modal which will be collected and inserted, by default above, the modal content. This is useful for extracting things like alerts or status messages on forms and displaying them to the user after an AJAX response. ('.portalMessage')
 *    backdrop(string): Selector for the element upon which the Backdrop pattern should be initiated. The Backdrop is a full width mask that will be apply above the content behind the modal which is useful for highlighting the modal dialog to the user. ('body')
 *    backdropOptions(object): Look at options at backdrop pattern. ({ zIndex: "1040", opacity: "0.8", className: "backdrop", classActiveName: "backdrop-active", closeOnEsc: true, closeOnClick: true })
 *    buttons(string): Selector for matching elements, usually buttons, inputs or links, from the modal content to place in the modal footer. The original elements in the content will be hidden. ('.formControls > input[type="submit"]')
 *    automaticallyAddButtonActions(boolean): Automatically create actions for elements matched with the buttons selector. They will use the options provided in actionOptions. (true)
 *    loadLinksWithinModal(boolean): Automatically load links inside of the modal using AJAX. (true)
 *    actions(object): A hash of selector to options. Where options can include any of the defaults from actionOptions. Allows for the binding of events to elements in the content and provides options for handling ajax requests and displaying them in the modal. ({})
 *
 *
 * Documentation:
 *    # Example
 *
 *    {{ example-basic }}
 *
 *    {{ example-long }}
 *
 *    {{ example-tinymce }}
 *
 *
 * Example: example-basic
 *    <a href="#modal1" class="btn btn-large btn-primary pat-modal"
 *                      data-pat-modal="width: 400">Modal basic</a>
 *    <div id="modal1" style="display: none">
 *      <h1>Basic modal!</h1>
 *      <p>Indeed. Whoa whoa whoa whoa. Wait.</p>
 *    </div>
 *
 * Example: example-long
 *    <a href="#modal2" class="btn btn-large btn-primary pat-modal"
 *                      data-pat-modal="width: 500">Modal long scrolling</a>
 *    <div id="modal2" style="display: none">
 *      <h1>Basic with scrolling</h1>
 *      <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>
 *      <br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />
 *      <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>
 *      <br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />
 *      <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>
 *      <br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />
 *      <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>
 *      <br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />
 *      <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>
 *      <br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />
 *      <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua</p>
 *    </div>
 *
 *
 * Example: example-tinymce
 *    <a href="#modaltinymce" class="btn btn-large btn-primary pat-modal"
 *       data-pat-modal="height: 600px;
 *                       width: 80%">
 *       Modal with TinyMCE</a>
 *    <div id="modaltinymce" style="display:none">
 *      <textarea class="pat-tinymce"></textarea>
 *    </div>
 *
 *
 * License:
 *    Copyright (C) 2010 Plone Foundation
 *
 *    This program is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU General Public License as published by the
 *    Free Software Foundation; either version 2 of the License.
 *
 *    This program is distributed in the hope that it will be useful, but
 *    WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *    Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

// Author: Ryan Foster
// Contact: ryan@rynamic.com
// Version: 1.0
//
// Description:
//
// License:
//
// Copyright (C) 2010 Plone Foundation
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 51
// Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

/* ========================================================================
 * Bootstrap: tooltip.js v3.1.0
 * http://getbootstrap.com/javascript/#tooltip
 * Inspired by the original jQuery.tipsy by Jason Frame
 * ========================================================================
 * Copyright 2011-2014 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

// Author: Nathan Van Gheem
// Contact: nathan@vangheem.us
// Version: 1.0
//
// Description:
//
// License:
//
// Copyright (C) 2010 Plone Foundation
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 51
// Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

/**
 * @license RequireJS text 2.0.10 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/requirejs/text for details
 */

/* ========================================================================
 * Bootstrap: dropdown.js v3.1.0
 * http://getbootstrap.com/javascript/#dropdowns
 * ========================================================================
 * Copyright 2011-2014 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * ======================================================================== */

/*! 
 * jquery.event.drag - v 2.2
 * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
 * Open Source MIT License - http://threedubmedia.com/code/license
 */

/*! 
 * jquery.event.drop - v 2.2
 * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
 * Open Source MIT License - http://threedubmedia.com/code/license
 */

/* Sortable pattern.
 *
 * Options:
 *    selector(string): Selector to use to draggable items in pattern ('li')
 *    dragClass(string): Class to apply to original item that is being dragged. ('item-dragging')
 *    cloneClass(string): Class to apply to cloned item that is dragged. ('dragging')
 *    drop(function): callback function for when item is dropped (null)
 *
 * Documentation:
 *    # Default
 *
 *    {{ example-1 }}
 *
 *    # Table
 *
 *    {{ example-2 }}
 *
 * Example: example-1
 *    <ul class="pat-sortable">
 *      <li>One</li>
 *      <li>Two</li>
 *      <li>Three</li>
 *    </ul>
 *
 * Example: example-2
 *    <table class="table table-stripped pat-sortable"
 *           data-pat-sortable="selector:tr;">
 *      <tbody>
 *        <tr>
 *          <td>One One</td>
 *          <td>One Two</td>
 *        </tr>
 *        <tr>
 *          <td>Two One</td>
 *          <td>Two Two</td>
 *        </tr>
 *        <tr>
 *          <td>Three One</td>
 *          <td>Three Two</td>
 *        </tr>
 *      </tbody>
 *    </table>
 *
 * License:
 *    Copyright (C) 2010 Plone Foundation
 *
 *    This program is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU General Public License as published by the
 *    Free Software Foundation; either version 2 of the License.
 *
 *    This program is distributed in the hope that it will be useful, but
 *    WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *    Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

//! moment.js
//! version : 2.5.0
//! authors : Tim Wood, Iskren Chernev, Moment.js contributors
//! license : MIT
//! momentjs.com

/* Moment pattern.
 *
 * Options:
 *    selector(string): selector to use to look for dates to format (null)
 *    format(string): Format to use to render date. Also available is "relative" and "calendar" formats. (MMMM Do YYYY, h:mm:ss a)
 *
 * Documentation:
 *    # Defaults
 *
 *    {{ example-1 }}
 *
 *    # Relative format
 *
 *    {{ example-2 }}
 *
 *    # Calendar format
 *
 *    {{ example-3 }}
 *
 *    # Custom format
 *
 *    {{ example-4 }}
 *
 *    # Setting date by attribute
 *
 *    {{ example-5 }}
 *
 * Example: example-1
 *    <ul class="pat-moment" data-pat-moment="selector:li">
 *      <li>2013-10-01T10:00:00-05:00</li>
 *      <li>2013-01-01T22:10:00-05:00</li>
 *      <li>2013-01-05T04:34:00-05:00</li>
 *      <li>2013-02-14T16:55:00-05:00</li>
 *    </ul>
 *
 * Example: example-2
 *    <ul class="pat-moment"
 *        data-pat-moment="selector:li;format:relative;">
 *      <li>2013-10-01T10:00:00-05:00</li>
 *      <li>2013-01-01T22:10:00-05:00</li>
 *      <li>2013-01-05T04:34:00-05:00</li>
 *      <li>2013-02-14T16:55:00-05:00</li>
 *    </ul>
 *
 * Example: example-3
 *    <ul class="pat-moment"
 *        data-pat-moment="selector:li;format:calendar;">
 *      <li>2013-10-01T10:00:00-05:00</li>
 *      <li>2013-10-02T22:10:00-05:00</li>
 *      <li>2013-10-05T04:34:00-05:00</li>
 *      <li>2013-10-03T16:55:00-05:00</li>
 *    </ul>
 *
 * Example: example-4
 *    <ul class="pat-moment"
 *        data-pat-moment="selector:li;format:MMM Do, YYYY h:m a;">
 *      <li>2013-10-01T10:00:00-05:00</li>
 *      <li>2013-01-01T22:10:00-05:00</li>
 *      <li>2013-01-05T04:34:00-05:00</li>
 *      <li>2013-02-14T16:55:00-05:00</li>
 *    </ul>
 *
 * Example: example-5
 *    <ul class="pat-moment"
 *        data-pat-moment="selector:li;format:MMM Do, YYYY h:m a;">
 *      <li data-date="2013-10-01T10:00:00-05:00"></li>
 *      <li data-date="2013-01-01T22:10:00-05:00"></li>
 *      <li data-date="2013-01-05T04:34:00-05:00"></li>
 *      <li data-date="2013-02-14T16:55:00-05:00"></li>
 *    </ul>
 *
 * License:
 *    Copyright (C) 2010 Plone Foundation
 *
 *    This program is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU General Public License as published by the
 *    Free Software Foundation; either version 2 of the License.
 *
 *    This program is distributed in the hope that it will be useful, but
 *    WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *    Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*
Copyright 2012 Igor Vaynberg

Version: 3.4.5 Timestamp: Mon Nov  4 08:22:42 PST 2013

This software is licensed under the Apache License, Version 2.0 (the "Apache License") or the GNU
General Public License version 2 (the "GPL License"). You may choose either license to govern your
use of this software only upon the condition that you accept all of the terms of either the Apache
License or the GPL License.

You may obtain a copy of the Apache License and the GPL License at:

    http://www.apache.org/licenses/LICENSE-2.0
    http://www.gnu.org/licenses/gpl-2.0.html

Unless required by applicable law or agreed to in writing, software distributed under the
Apache License or the GPL Licesnse is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
CONDITIONS OF ANY KIND, either express or implied. See the Apache License and the GPL License for
the specific language governing permissions and limitations under the Apache License and the GPL License.
*/

/* Select2 pattern.
 *
 * Options:
 *    separator(string): Analagous to the separator constructor parameter from Select2. Defines a custom separator used to distinguish the tag values. Ex: a value of ";" will allow tags and initialValues to have values separated by ";" instead of the default ",". (',')
 *    initialValues(string): This can be a json encoded string, or a list of id:text values. Ex: Red:The Color Red,Orange:The Color Orange  This is used inside the initSelection method, if AJAX options are NOT set. (null)
 *    vocabularyUrl(string): This is a URL to a JSON-formatted file used to populate the list (null)
 *    OTHER OPTIONS(): For more options on select2 go to http://ivaynberg.github.io/select2/#documentation ()
 *
 * Documentation:
 *    # Autocomplete with search (single select)
 *
 *    {{ example-1 }}
 *
 *    # Tagging
 *
 *    {{ example-2 }}
 *
 *    # Orderable tags
 *
 *    {{ example-3 }}
 *
 *    # AJAX tags
 *
 *    {{ example-4 }}
 *
 * Example: example-1
 *    <select class="pat-select2" data-pat-select2="width:20em">
 *      <option value="Acholi">Acholi</option>
 *      <option value="Afrikaans">Afrikaans</option>
 *      <option value="Akan">Akan</option>
 *      <option value="Albanian">Albanian</option>
 *      <option value="Amharic">Amharic</option>
 *      <option value="Arabic">Arabic</option>
 *      <option value="Ashante">Ashante</option>
 *      <option value="Asl">Asl</option>
 *      <option value="Assyrian">Assyrian</option>
 *      <option value="Azerbaijani">Azerbaijani</option>
 *      <option value="Azeri">Azeri</option>
 *    </select>
 *
 * Example: example-2
 *    <input type="text" class="pat-select2"
 *           data-pat-select2="separator:,;
 *                             tags:Red,Yellow,Green,Orange,Purple;
 *                             width:20em;
 *                             initialValues:Red:The Color Red,Orange:The Color Orange"
 *           value="Red,Orange"/>
 *
 * Example: example-3
 *    <input type="text" class="pat-select2"
 *           data-pat-select2="orderable:true;
 *                             tags:Red,Yellow,Green;
 *                             width:20em" />
 * Example: example-4
 *    <input type="hidden" class="pat-select2"
 *           data-pat-select2="placeholder:Search for a Value;
 *                             vocabularyUrl:select2-test.json;
 *                             width:20em" />
 *
 * License:
 *    Copyright (C) 2010 Plone Foundation
 *
 *    This program is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU General Public License as published by the
 *    Free Software Foundation; either version 2 of the License.
 *
 *    This program is distributed in the hope that it will be useful, but
 *    WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *    Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*!
 * pickadate.js v3.3.2, 2013/12/28
 * By Amsul, http://amsul.ca
 * Hosted on http://amsul.github.io/pickadate.js
 * Licensed under MIT
 */

/*!
 * Date picker for pickadate.js v3.3.2
 * http://amsul.github.io/pickadate.js/date.htm
 */

/*!
 * Time picker for pickadate.js v3.3.2
 * http://amsul.github.io/pickadate.js/time.htm
 */

/* PickADate pattern.
 *
 * Options:
 *    date(object): Date widget options described here. If false is selected date picker wont be shown. ({{selectYears: true, selectMonths: true })
 *    time(object): Time widget options described here. If false is selected time picker wont be shown. ({})
 *    separator(string): Separator between date and time if both are enabled.
 *    (' ')
 *    classClearName(string): Class name of element that is generated by pattern. ('pattern-pickadate-clear')
 *    classDateName(string): Class applied to date input. ('pattern-pickadate-date')
 *    classDateWrapperName(string): Class applied to extra wrapper div around date input. ('pattern-pickadate-date-wrapper')
 *    classSeparatorName(string): Class applied to separator. ('pattern-pickadate-separator')
 *    classTimeName(string): Class applied to time input. ('pattern-pickadate-time')
 *    classTimeWrapperName(string): Class applied to wrapper div around time input. ('pattern-pickadate-time-wrapper')
 *    classWrapperName(string): Class name of element that is generated by pattern. ('pattern-pickadate-wrapper')
 *
 * Documentation:
 *    # Date and Time
 *
 *    {{ example-1 }}
 *
 *    # Date and Time with initial data
 *
 *    {{ example-2 }}
 *
 *    # Date
 *
 *    {{ example-3 }}
 *
 *    # Date with initial date
 *
 *    {{ example-4 }}
 *
 *    # Time
 *
 *    {{ example-5 }}
 *
 *    # Time with initial time
 *
 *    {{ example-6 }}
 *
 * Example: example-1
 *    <input class="pat-pickadate"/>
 *
 * Example: example-2
 *    <input class="pat-pickadate" value="2010-12-31 00:45" />
 *
 * Example: example-3
 *    <input class="pat-pickadate" data-pat-pickadate="time:false"/>
 *
 * Example: example-4
 *    <input class="pat-pickadate" value="2010-12-31" data-pat-pickadate="time:false"/>
 *
 * Example: example-5
 *    <input class="pat-pickadate" data-pat-pickadate="date:false"/>
 *
 * Example: example-6
 *    <input class="pat-pickadate" value="00:00" data-pat-pickadate="date:false"/>
 *
 * License:
 *    Copyright (C) 2010 Plone Foundation
 *
 *    This program is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU General Public License as published by the
 *    Free Software Foundation; either version 2 of the License.
 *
 *    This program is distributed in the hope that it will be useful, but
 *    WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *    Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

// Author: Nathan Van Gheem Contact: nathan@vangheem.us Version: 1.0
//
// Description:
//
// License:
//
// Copyright (C) 2010 Plone Foundation
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 51
// Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

/* Querystring pattern.
 *
 * Options:
 *    criteria(object): options to pass into criteria ({})
 *    indexOptionsUrl(string): URL to grab index option data from. Must contain "sortable_indexes" and "indexes" data in JSON object. (null)
 *    previewURL(string): URL used to pass in a plone.app.querystring-formatted HTTP querystring and get an HTML list of results ('portal_factory/@@querybuilder_html_results')
 *    previewCountURL(string): URL used to pass in a plone.app.querystring-formatted HTTP querystring and get an HTML string of the total number of records found with the query ('portal_factory/@@querybuildernumberofresults')
 *    sorttxt(string): Text to use to label the sort dropdown ('Sort On')
 *    reversetxt(string): Text to use to label the sort order checkbox ('Reversed Order')
 *    previewTitle(string): Title for the preview area ('Preview')
 *    previewDescription(string): Description for the preview area ('Preview of at most 10 items')
 *    classWrapperName(string): CSS class to apply to the wrapper element ('querystring-wrapper')
 *    classSortLabelName(string): CSS class to apply to the sort on label ('querystring-sort-label')
 *    classSortReverseName(string): CSS class to apply to the sort order label and checkbox container ('querystring-sortreverse')
 *    classSortReverseLabelName(string): CSS class to apply to the sort order label ('querystring-sortreverse-label')
 *    classPreviewCountWrapperName(string): TODO ('querystring-previewcount-wrapper')
 *    classPreviewResultsWrapperName(string): CSS class to apply to the results wrapper ('querystring-previewresults-wrapper')
 *    classPreviewWrapperName(string): CSS class to apply to the preview wrapper ('querystring-preview-wrapper')
 *    classPreviewName(string): CSS class to apply to the preview pane ('querystring-preview')
 *    classPreviewTitleName(string): CSS class to apply to the preview title ('querystring-preview-title')
 *    classPreviewDescriptionName(string): CSS class to apply to the preview description ('querystring-preview-description')
 *    classSortWrapperName(string): CSS class to apply to the sort order and sort on wrapper ('querystring-sort-wrapper')
 *    showPreviews(boolean): Should previews be shown? (true)
 *
 * Documentation:
 *    # Default
 *
 *    {{ example-1 }}
 *
 *    # Without Previews
 *
 *    {{ example-2 }}
 *
 * Example: example-1
 *    <input class="pat-querystring"
 *           data-pat-querystring="indexOptionsUrl: /tests/json/queryStringCriteria.json" />
 *
 * Example: example-2
 *    <input class="pat-querystring"
 *           data-pat-querystring="indexOptionsUrl: /tests/json/queryStringCriteria.json;
 *                                 showPreviews: false;" />
 *
 * License:
 *    Copyright (C) 2010 Plone Foundation
 *
 *    This program is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU General Public License as published by the
 *    Free Software Foundation; either version 2 of the License.
 *
 *    This program is distributed in the hope that it will be useful, but
 *    WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *    Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*
#
# More info at [www.dropzonejs.com](http://www.dropzonejs.com)
# 
# Copyright (c) 2012, Matias Meno  
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
*/

/* Dropzone pattern.
 *
 * Options:
 *    url(string): If not used with a form, this option must provide the URL to submit to (null)
 *    clickable(boolean): If you can click on container to also upload (false)
 *    className(string): value for class attribute in the form element ('dropzone')
 *    paramName(string): value for name attribute in the file input element ('file')
 *    uploadMultiple(boolean): condition value for multiple attribute in the file input element. If the value is 'true' and paramName is file, 'multiple=multiple' and 'name=file[]' will be added in the file input. (false)
 *    wrap(boolean): true or false for wrapping this element using the value of wrapperTemplate. If the value is 'inner', this element will wrap the wrapperTemplate value. (false)
 *    wrapperTemplate(string): HTML template for wrapping around with this element. ('<div class='dropzone-container"/>')
 *    resultTemplate(string): HTML template for the element that will contain file information. ('<div class="dz-notice"><p>Drop files here...</p></div><div class="dropzone-previews"/>')
 *    autoCleanResults(boolean): condition value for the file preview in div element to fadeout after file upload is completed. (false)
 *    previewsContainer(selector): JavaScript selector for file preview in div element. (.dropzone-previews)
 *
 * Documentation:
 *    # On a form element
 *
 *    {{ example-1 }}
 *
 *    # On a div element
 *
 *    {{ example-2 }}
 *
 *    # With custom style
 *
 *    {{ example-3 }}
 *
 * Example: example-1
 *    <form method="post" action="/upload" enctype="multipart/form-data"
 *          class="pat-dropzone" data-pat-dropzone="clickable:true">
 *    </form>
 *
 * Example: example-2
 *    <div class="pat-dropzone" data-pat-dropzone="url: /upload">
 *      <div>
 *        <p>Something here that is useful</p>
 *        <p>Something else here that is useful</p>
 *        <p>Another thing here that is useful</p>
 *      </div>
 *    </div>
 *
 * Example: example-3
 *    <style>
 *      .mydropzone{
 *        width: 400px;
 *        height: 100px;
 *        background-color: gray;
 *      }
 *      .mydropzone.dz-drag-hover{
 *        background-color: red;
 *      }
 *    </style>
 *    <div class="pat-dropzone"
 *         data-pat-dropzone="url: /upload; className: mydropzone">
 *      Drop here...
 *    </div>
 *
 * License:
 *    Copyright (C) 2010 Plone Foundation
 *
 *    This program is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU General Public License as published by the
 *    Free Software Foundation; either version 2 of the License.
 *
 *    This program is distributed in the hope that it will be useful, but
 *    WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *    Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*!
 * jQuery Cookie Plugin v1.4.0
 * https://github.com/carhartl/jquery-cookie
 *
 * Copyright 2013 Klaus Hartl
 * Released under the MIT license
 */

/* Structure pattern.
 *
 * Options:
 *    vocabularyUrl(string): Url to return query results (null)
 *    tagsVocabularyUrl(string): Url to return tags query results (null)
 *    usersVocabularyUrl(string): Url to query users (null)
 *    indexOptionsUrl(string): Url to configure querystring widget with (null)
 *    uploadUrl(string): For setting up dropzone (null)
 *    moveUrl(string): For supporting drag drop reordering (null)
 *    contextInfoUrl(string): For supporting add menu (null)
 *
 * Documentation:
 *    # Example
 *
 *    {{ example-1 }}
 *
 * Example: example-1
 *    <div class="pat-structure"
 *         data-pat-structure="vocabularyUrl:/relateditems-test.json;
 *                             uploadUrl:/upload;
 *                             moveUrl:/moveitem;
 *                             tagsVocabularyUrl:/select2-test.json;
 *                             usersVocabularyUrl:/tests/json/users.json;
 *                             indexOptionsUrl:/tests/json/queryStringCriteria.json;
 *                             contextInfoUrl:{path}/context-info;"></div>
 *
 * License:
 *    Copyright (C) 2010 Plone Foundation
 *
 *    This program is free software; you can redistribute it and/or modify it
 *    under the terms of the GNU General Public License as published by the
 *    Free Software Foundation; either version 2 of the License.
 *
 *    This program is distributed in the hope that it will be useful, but
 *    WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *    Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

// Author: Nathan Van Gheem
// Contact: nathan@vangheem.us
// Version: 1.0
//
// License:
//
// Copyright (C) 2010 Plone Foundation
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 51
// Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//

var requirejs,require,define;(function(global){function isFunction(e){return ostring.call(e)==="[object Function]"}function isArray(e){return ostring.call(e)==="[object Array]"}function each(e,t){if(e){var n;for(n=0;n<e.length;n+=1)if(e[n]&&t(e[n],n,e))break}}function eachReverse(e,t){if(e){var n;for(n=e.length-1;n>-1;n-=1)if(e[n]&&t(e[n],n,e))break}}function hasProp(e,t){return hasOwn.call(e,t)}function getOwn(e,t){return hasProp(e,t)&&e[t]}function eachProp(e,t){var n;for(n in e)if(hasProp(e,n)&&t(e[n],n))break}function mixin(e,t,n,r){return t&&eachProp(t,function(t,i){if(n||!hasProp(e,i))r&&typeof t=="object"&&t&&!isArray(t)&&!isFunction(t)&&!(t instanceof RegExp)?(e[i]||(e[i]={}),mixin(e[i],t,n,r)):e[i]=t}),e}function bind(e,t){return function(){return t.apply(e,arguments)}}function scripts(){return document.getElementsByTagName("script")}function defaultOnError(e){throw e}function getGlobal(e){if(!e)return e;var t=global;return each(e.split("."),function(e){t=t[e]}),t}function makeError(e,t,n,r){var i=new Error(t+"\nhttp://requirejs.org/docs/errors.html#"+e);return i.requireType=e,i.requireModules=r,n&&(i.originalError=n),i}function newContext(e){function m(e){var t,n,r=e.length;for(t=0;t<r;t++){n=e[t];if(n===".")e.splice(t,1),t-=1;else if(n===".."){if(t===1&&(e[2]===".."||e[0]===".."))break;t>0&&(e.splice(t-1,2),t-=2)}}}function g(e,t,n){var r,i,s,u,a,f,l,c,h,p,d,v=t&&t.split("/"),g=v,y=o.map,b=y&&y["*"];e&&e.charAt(0)==="."&&(t?(g=v.slice(0,v.length-1),e=e.split("/"),l=e.length-1,o.nodeIdCompat&&jsSuffixRegExp.test(e[l])&&(e[l]=e[l].replace(jsSuffixRegExp,"")),e=g.concat(e),m(e),e=e.join("/")):e.indexOf("./")===0&&(e=e.substring(2)));if(n&&y&&(v||b)){s=e.split("/");e:for(u=s.length;u>0;u-=1){f=s.slice(0,u).join("/");if(v)for(a=v.length;a>0;a-=1){i=getOwn(y,v.slice(0,a).join("/"));if(i){i=getOwn(i,f);if(i){c=i,h=u;break e}}}!p&&b&&getOwn(b,f)&&(p=getOwn(b,f),d=u)}!c&&p&&(c=p,h=d),c&&(s.splice(0,h,c),e=s.join("/"))}return r=getOwn(o.pkgs,e),r?r:e}function y(e){isBrowser&&each(scripts(),function(t){if(t.getAttribute("data-requiremodule")===e&&t.getAttribute("data-requirecontext")===r.contextName)return t.parentNode.removeChild(t),!0})}function b(e){var t=getOwn(o.paths,e);if(t&&isArray(t)&&t.length>1)return t.shift(),r.require.undef(e),r.require([e]),!0}function w(e){var t,n=e?e.indexOf("!"):-1;return n>-1&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function E(e,t,n,i){var s,o,u,a,f=null,l=t?t.name:null,h=e,p=!0,m="";return e||(p=!1,e="_@r"+(d+=1)),a=w(e),f=a[0],e=a[1],f&&(f=g(f,l,i),o=getOwn(c,f)),e&&(f?o&&o.normalize?m=o.normalize(e,function(e){return g(e,l,i)}):m=g(e,l,i):(m=g(e,l,i),a=w(m),f=a[0],m=a[1],n=!0,s=r.nameToUrl(m))),u=f&&!o&&!n?"_unnormalized"+(v+=1):"",{prefix:f,name:m,parentMap:t,unnormalized:!!u,url:s,originalName:h,isDefine:p,id:(f?f+"!"+m:m)+u}}function S(e){var t=e.id,n=getOwn(u,t);return n||(n=u[t]=new r.Module(e)),n}function x(e,t,n){var r=e.id,i=getOwn(u,r);hasProp(c,r)&&(!i||i.defineEmitComplete)?t==="defined"&&n(c[r]):(i=S(e),i.error&&t==="error"?n(i.error):i.on(t,n))}function T(e,t){var n=e.requireModules,r=!1;t?t(e):(each(n,function(t){var n=getOwn(u,t);n&&(n.error=e,n.events.error&&(r=!0,n.emit("error",e)))}),r||req.onError(e))}function N(){globalDefQueue.length&&(apsp.apply(l,[l.length,0].concat(globalDefQueue)),globalDefQueue=[])}function C(e){delete u[e],delete a[e]}function k(e,t,n){var r=e.map.id;e.error?e.emit("error",e.error):(t[r]=!0,each(e.depMaps,function(r,i){var s=r.id,o=getOwn(u,s);o&&!e.depMatched[i]&&!n[s]&&(getOwn(t,s)?(e.defineDep(i,c[s]),e.check()):k(o,t,n))}),n[r]=!0)}function L(){var e,n,i=o.waitSeconds*1e3,u=i&&r.startTime+i<(new Date).getTime(),f=[],l=[],c=!1,h=!0;if(t)return;t=!0,eachProp(a,function(e){var t=e.map,r=t.id;if(!e.enabled)return;t.isDefine||l.push(e);if(!e.error)if(!e.inited&&u)b(r)?(n=!0,c=!0):(f.push(r),y(r));else if(!e.inited&&e.fetched&&t.isDefine){c=!0;if(!t.prefix)return h=!1}});if(u&&f.length)return e=makeError("timeout","Load timeout for modules: "+f,null,f),e.contextName=r.contextName,T(e);h&&each(l,function(e){k(e,{},{})}),(!u||n)&&c&&(isBrowser||isWebWorker)&&!s&&(s=setTimeout(function(){s=0,L()},50)),t=!1}function A(e){hasProp(c,e[0])||S(E(e[0],null,!0)).init(e[1],e[2])}function O(e,t,n,r){e.detachEvent&&!isOpera?r&&e.detachEvent(r,t):e.removeEventListener(n,t,!1)}function M(e){var t=e.currentTarget||e.srcElement;return O(t,r.onScriptLoad,"load","onreadystatechange"),O(t,r.onScriptError,"error"),{node:t,id:t&&t.getAttribute("data-requiremodule")}}function _(){var e;N();while(l.length){e=l.shift();if(e[0]===null)return T(makeError("mismatch","Mismatched anonymous define() module: "+e[e.length-1]));A(e)}}var t,n,r,i,s,o={waitSeconds:7,baseUrl:"./",paths:{},bundles:{},pkgs:{},shim:{},config:{}},u={},a={},f={},l=[],c={},h={},p={},d=1,v=1;return i={require:function(e){return e.require?e.require:e.require=r.makeRequire(e.map)},exports:function(e){e.usingExports=!0;if(e.map.isDefine)return e.exports?c[e.map.id]=e.exports:e.exports=c[e.map.id]={}},module:function(e){return e.module?e.module:e.module={id:e.map.id,uri:e.map.url,config:function(){return getOwn(o.config,e.map.id)||{}},exports:e.exports||(e.exports={})}}},n=function(e){this.events=getOwn(f,e.id)||{},this.map=e,this.shim=getOwn(o.shim,e.id),this.depExports=[],this.depMaps=[],this.depMatched=[],this.pluginMaps={},this.depCount=0},n.prototype={init:function(e,t,n,r){r=r||{};if(this.inited)return;this.factory=t,n?this.on("error",n):this.events.error&&(n=bind(this,function(e){this.emit("error",e)})),this.depMaps=e&&e.slice(0),this.errback=n,this.inited=!0,this.ignore=r.ignore,r.enabled||this.enabled?this.enable():this.check()},defineDep:function(e,t){this.depMatched[e]||(this.depMatched[e]=!0,this.depCount-=1,this.depExports[e]=t)},fetch:function(){if(this.fetched)return;this.fetched=!0,r.startTime=(new Date).getTime();var e=this.map;if(!this.shim)return e.prefix?this.callPlugin():this.load();r.makeRequire(this.map,{enableBuildCallback:!0})(this.shim.deps||[],bind(this,function(){return e.prefix?this.callPlugin():this.load()}))},load:function(){var e=this.map.url;h[e]||(h[e]=!0,r.load(this.map.id,e))},check:function(){if(!this.enabled||this.enabling)return;var e,t,n=this.map.id,i=this.depExports,s=this.exports,o=this.factory;if(!this.inited)this.fetch();else if(this.error)this.emit("error",this.error);else if(!this.defining){this.defining=!0;if(this.depCount<1&&!this.defined){if(isFunction(o)){if(this.events.error&&this.map.isDefine||req.onError!==defaultOnError)try{s=r.execCb(n,o,i,s)}catch(u){e=u}else s=r.execCb(n,o,i,s);this.map.isDefine&&s===undefined&&(t=this.module,t?s=t.exports:this.usingExports&&(s=this.exports));if(e)return e.requireMap=this.map,e.requireModules=this.map.isDefine?[this.map.id]:null,e.requireType=this.map.isDefine?"define":"require",T(this.error=e)}else s=o;this.exports=s,this.map.isDefine&&!this.ignore&&(c[n]=s,req.onResourceLoad&&req.onResourceLoad(r,this.map,this.depMaps)),C(n),this.defined=!0}this.defining=!1,this.defined&&!this.defineEmitted&&(this.defineEmitted=!0,this.emit("defined",this.exports),this.defineEmitComplete=!0)}},callPlugin:function(){var e=this.map,t=e.id,n=E(e.prefix);this.depMaps.push(n),x(n,"defined",bind(this,function(n){var i,s,a,f=getOwn(p,this.map.id),l=this.map.name,c=this.map.parentMap?this.map.parentMap.name:null,h=r.makeRequire(e.parentMap,{enableBuildCallback:!0});if(this.map.unnormalized){n.normalize&&(l=n.normalize(l,function(e){return g(e,c,!0)})||""),s=E(e.prefix+"!"+l,this.map.parentMap),x(s,"defined",bind(this,function(e){this.init([],function(){return e},null,{enabled:!0,ignore:!0})})),a=getOwn(u,s.id),a&&(this.depMaps.push(s),this.events.error&&a.on("error",bind(this,function(e){this.emit("error",e)})),a.enable());return}if(f){this.map.url=r.nameToUrl(f),this.load();return}i=bind(this,function(e){this.init([],function(){return e},null,{enabled:!0})}),i.error=bind(this,function(e){this.inited=!0,this.error=e,e.requireModules=[t],eachProp(u,function(e){e.map.id.indexOf(t+"_unnormalized")===0&&C(e.map.id)}),T(e)}),i.fromText=bind(this,function(n,s){var u=e.name,a=E(u),f=useInteractive;s&&(n=s),f&&(useInteractive=!1),S(a),hasProp(o.config,t)&&(o.config[u]=o.config[t]);try{req.exec(n)}catch(l){return T(makeError("fromtexteval","fromText eval for "+t+" failed: "+l,l,[t]))}f&&(useInteractive=!0),this.depMaps.push(a),r.completeLoad(u),h([u],i)}),n.load(e.name,h,i,o)})),r.enable(n,this),this.pluginMaps[n.id]=n},enable:function(){a[this.map.id]=this,this.enabled=!0,this.enabling=!0,each(this.depMaps,bind(this,function(e,t){var n,s,o;if(typeof e=="string"){e=E(e,this.map.isDefine?this.map:this.map.parentMap,!1,!this.skipMap),this.depMaps[t]=e,o=getOwn(i,e.id);if(o){this.depExports[t]=o(this);return}this.depCount+=1,x(e,"defined",bind(this,function(e){this.defineDep(t,e),this.check()})),this.errback&&x(e,"error",bind(this,this.errback))}n=e.id,s=u[n],!hasProp(i,n)&&s&&!s.enabled&&r.enable(e,this)})),eachProp(this.pluginMaps,bind(this,function(e){var t=getOwn(u,e.id);t&&!t.enabled&&r.enable(e,this)})),this.enabling=!1,this.check()},on:function(e,t){var n=this.events[e];n||(n=this.events[e]=[]),n.push(t)},emit:function(e,t){each(this.events[e],function(e){e(t)}),e==="error"&&delete this.events[e]}},r={config:o,contextName:e,registry:u,defined:c,urlFetched:h,defQueue:l,Module:n,makeModuleMap:E,nextTick:req.nextTick,onError:T,configure:function(e){e.baseUrl&&e.baseUrl.charAt(e.baseUrl.length-1)!=="/"&&(e.baseUrl+="/");var t=o.shim,n={paths:!0,bundles:!0,config:!0,map:!0};eachProp(e,function(e,t){n[t]?(o[t]||(o[t]={}),mixin(o[t],e,!0,!0)):o[t]=e}),e.bundles&&eachProp(e.bundles,function(e,t){each(e,function(e){e!==t&&(p[e]=t)})}),e.shim&&(eachProp(e.shim,function(e,n){isArray(e)&&(e={deps:e}),(e.exports||e.init)&&!e.exportsFn&&(e.exportsFn=r.makeShimExports(e)),t[n]=e}),o.shim=t),e.packages&&each(e.packages,function(e){var t,n;e=typeof e=="string"?{name:e}:e,n=e.name,t=e.location,t&&(o.paths[n]=e.location),o.pkgs[n]=e.name+"/"+(e.main||"main").replace(currDirRegExp,"").replace(jsSuffixRegExp,"")}),eachProp(u,function(e,t){!e.inited&&!e.map.unnormalized&&(e.map=E(t))}),(e.deps||e.callback)&&r.require(e.deps||[],e.callback)},makeShimExports:function(e){function t(){var t;return e.init&&(t=e.init.apply(global,arguments)),t||e.exports&&getGlobal(e.exports)}return t},makeRequire:function(t,n){function s(o,a,f){var l,h,p;return n.enableBuildCallback&&a&&isFunction(a)&&(a.__requireJsBuild=!0),typeof o=="string"?isFunction(a)?T(makeError("requireargs","Invalid require call"),f):t&&hasProp(i,o)?i[o](u[t.id]):req.get?req.get(r,o,t,s):(h=E(o,t,!1,!0),l=h.id,hasProp(c,l)?c[l]:T(makeError("notloaded",'Module name "'+l+'" has not been loaded yet for context: '+e+(t?"":". Use require([])")))):(_(),r.nextTick(function(){_(),p=S(E(null,t)),p.skipMap=n.skipMap,p.init(o,a,f,{enabled:!0}),L()}),s)}return n=n||{},mixin(s,{isBrowser:isBrowser,toUrl:function(e){var n,i=e.lastIndexOf("."),s=e.split("/")[0],o=s==="."||s==="..";return i!==-1&&(!o||i>1)&&(n=e.substring(i,e.length),e=e.substring(0,i)),r.nameToUrl(g(e,t&&t.id,!0),n,!0)},defined:function(e){return hasProp(c,E(e,t,!1,!0).id)},specified:function(e){return e=E(e,t,!1,!0).id,hasProp(c,e)||hasProp(u,e)}}),t||(s.undef=function(e){N();var n=E(e,t,!0),r=getOwn(u,e);y(e),delete c[e],delete h[n.url],delete f[e],eachReverse(l,function(t,n){t[0]===e&&l.splice(n,1)}),r&&(r.events.defined&&(f[e]=r.events),C(e))}),s},enable:function(e){var t=getOwn(u,e.id);t&&S(e).enable()},completeLoad:function(e){var t,n,r,i=getOwn(o.shim,e)||{},s=i.exports;N();while(l.length){n=l.shift();if(n[0]===null){n[0]=e;if(t)break;t=!0}else n[0]===e&&(t=!0);A(n)}r=getOwn(u,e);if(!t&&!hasProp(c,e)&&r&&!r.inited){if(o.enforceDefine&&(!s||!getGlobal(s))){if(b(e))return;return T(makeError("nodefine","No define call for "+e,null,[e]))}A([e,i.deps||[],i.exportsFn])}L()},nameToUrl:function(e,t,n){var i,s,u,a,f,l,c,h=getOwn(o.pkgs,e);h&&(e=h),c=getOwn(p,e);if(c)return r.nameToUrl(c,t,n);if(req.jsExtRegExp.test(e))f=e+(t||"");else{i=o.paths,s=e.split("/");for(u=s.length;u>0;u-=1){a=s.slice(0,u).join("/"),l=getOwn(i,a);if(l){isArray(l)&&(l=l[0]),s.splice(0,u,l);break}}f=s.join("/"),f+=t||(/^data\:|\?/.test(f)||n?"":".js"),f=(f.charAt(0)==="/"||f.match(/^[\w\+\.\-]+:/)?"":o.baseUrl)+f}return o.urlArgs?f+((f.indexOf("?")===-1?"?":"&")+o.urlArgs):f},load:function(e,t){req.load(r,e,t)},execCb:function(e,t,n,r){return t.apply(r,n)},onScriptLoad:function(e){if(e.type==="load"||readyRegExp.test((e.currentTarget||e.srcElement).readyState)){interactiveScript=null;var t=M(e);r.completeLoad(t.id)}},onScriptError:function(e){var t=M(e);if(!b(t.id))return T(makeError("scripterror","Script error for: "+t.id,e,[t.id]))}},r.require=r.makeRequire(),r}function getInteractiveScript(){return interactiveScript&&interactiveScript.readyState==="interactive"?interactiveScript:(eachReverse(scripts(),function(e){if(e.readyState==="interactive")return interactiveScript=e}),interactiveScript)}var req,s,head,baseElement,dataMain,src,interactiveScript,currentlyAddingScript,mainScript,subPath,version="2.1.11",commentRegExp=/(\/\*([\s\S]*?)\*\/|([^:]|^)\/\/(.*)$)/mg,cjsRequireRegExp=/[^.]\s*require\s*\(\s*["']([^'"\s]+)["']\s*\)/g,jsSuffixRegExp=/\.js$/,currDirRegExp=/^\.\//,op=Object.prototype,ostring=op.toString,hasOwn=op.hasOwnProperty,ap=Array.prototype,apsp=ap.splice,isBrowser=typeof window!="undefined"&&typeof navigator!="undefined"&&!!window.document,isWebWorker=!isBrowser&&typeof importScripts!="undefined",readyRegExp=isBrowser&&navigator.platform==="PLAYSTATION 3"?/^complete$/:/^(complete|loaded)$/,defContextName="_",isOpera=typeof opera!="undefined"&&opera.toString()==="[object Opera]",contexts={},cfg={},globalDefQueue=[],useInteractive=!1;if(typeof define!="undefined")return;if(typeof requirejs!="undefined"){if(isFunction(requirejs))return;cfg=requirejs,requirejs=undefined}typeof require!="undefined"&&!isFunction(require)&&(cfg=require,require=undefined),req=requirejs=function(e,t,n,r){var i,s,o=defContextName;return!isArray(e)&&typeof e!="string"&&(s=e,isArray(t)?(e=t,t=n,n=r):e=[]),s&&s.context&&(o=s.context),i=getOwn(contexts,o),i||(i=contexts[o]=req.s.newContext(o)),s&&i.configure(s),i.require(e,t,n)},req.config=function(e){return req(e)},req.nextTick=typeof setTimeout!="undefined"?function(e){setTimeout(e,4)}:function(e){e()},require||(require=req),req.version=version,req.jsExtRegExp=/^\/|:|\?|\.js$/,req.isBrowser=isBrowser,s=req.s={contexts:contexts,newContext:newContext},req({}),each(["toUrl","undef","defined","specified"],function(e){req[e]=function(){var t=contexts[defContextName];return t.require[e].apply(t,arguments)}}),isBrowser&&(head=s.head=document.getElementsByTagName("head")[0],baseElement=document.getElementsByTagName("base")[0],baseElement&&(head=s.head=baseElement.parentNode)),req.onError=defaultOnError,req.createNode=function(e,t,n){var r=e.xhtml?document.createElementNS("http://www.w3.org/1999/xhtml","html:script"):document.createElement("script");return r.type=e.scriptType||"text/javascript",r.charset="utf-8",r.async=!0,r},req.load=function(e,t,n){var r=e&&e.config||{},i;if(isBrowser)return i=req.createNode(r,t,n),i.setAttribute("data-requirecontext",e.contextName),i.setAttribute("data-requiremodule",t),i.attachEvent&&!(i.attachEvent.toString&&i.attachEvent.toString().indexOf("[native code")<0)&&!isOpera?(useInteractive=!0,i.attachEvent("onreadystatechange",e.onScriptLoad)):(i.addEventListener("load",e.onScriptLoad,!1),i.addEventListener("error",e.onScriptError,!1)),i.src=n,currentlyAddingScript=i,baseElement?head.insertBefore(i,baseElement):head.appendChild(i),currentlyAddingScript=null,i;if(isWebWorker)try{importScripts(n),e.completeLoad(t)}catch(s){e.onError(makeError("importscripts","importScripts failed for "+t+" at "+n,s,[t]))}},isBrowser&&!cfg.skipDataMain&&eachReverse(scripts(),function(e){head||(head=e.parentNode),dataMain=e.getAttribute("data-main");if(dataMain)return mainScript=dataMain,cfg.baseUrl||(src=mainScript.split("/"),mainScript=src.pop(),subPath=src.length?src.join("/")+"/":"./",cfg.baseUrl=subPath),mainScript=mainScript.replace(jsSuffixRegExp,""),req.jsExtRegExp.test(mainScript)&&(mainScript=dataMain),cfg.deps=cfg.deps?cfg.deps.concat(mainScript):[mainScript],!0}),define=function(e,t,n){var r,i;typeof e!="string"&&(n=t,t=e,e=null),isArray(t)||(n=t,t=null),!t&&isFunction(n)&&(t=[],n.length&&(n.toString().replace(commentRegExp,"").replace(cjsRequireRegExp,function(e,n){t.push(n)}),t=(n.length===1?["require"]:["require","exports","module"]).concat(t))),useInteractive&&(r=currentlyAddingScript||getInteractiveScript(),r&&(e||(e=r.getAttribute("data-requiremodule")),i=contexts[r.getAttribute("data-requirecontext")])),(i?i.defQueue:globalDefQueue).push([e,t,n])},define.amd={jQuery:!0},req.exec=function(text){return eval(text)},req(cfg)})(this),define("node_modules/requirejs/require.js",function(){}),define("mockup-registry",["jquery"],function(e,t){var n={patterns:{},warn:function(e){window.DEBUG&&window.console&&console.warn(e)},getOptions:function(t,r,i){i=i||{},t.length!==0&&!e.nodeName(t[0],"body")&&(i=n.getOptions(t.parent(),r,i));var s={};if(t.length!==0){s=t.data("pat-"+r);if(s&&typeof s=="string"){var o={};e.each(s.split(";"),function(e,t){t=t.split(":"),t.reverse();var n=t.pop();n=n.replace(/^\s+|\s+$/g,""),t.reverse();var r=t.join(":");r=r.replace(/^\s+|\s+$/g,""),o[n]=r}),s=o}}return e.extend(!0,{},i,s)},init:function(e,r,i){var s=e.data("pattern-"+r);if(s===t&&n.patterns[r]){if(window.DEBUG)s=new n.patterns[r](e,n.getOptions(e,r,i));else try{s=new n.patterns[r](e,n.getOptions(e,r,i))}catch(o){n.warn('Failed while initializing "'+r+'" pattern.')}e.data("pattern-"+r,s)}return s},scan:function(t){var r=e(t),i=[];i=e.merge(i,r.filter('[class*="pat-"]')),i=e.merge(i,e('[class*="pat-"]',r)),e.each(i,function(t,r){r=e(r),e.each(r.attr("class").split(" "),function(e,t){t.indexOf("pat-")===0&&n.init(r,t.substr(4))})})},register:function(r){if(!r.prototype.name)return n.warn("Pattern didn't specified a name."),!1;r.prototype.jqueryPlugin===t&&(r.prototype.jqueryPlugin="pattern"+r.prototype.name.charAt(0).toUpperCase()+r.prototype.name.slice(1)),e.fn[r.prototype.jqueryPlugin]=function(i,s){return e(this).each(function(){typeof i=="object"&&(s=i,i=t);var o=e(this),u=n.init(o,r.prototype.name,s);if(i){if(u[i]===t)return n.warn('Method "'+i+'" does not exists.'),!1;if(i.charAt(0)==="_")return n.warn('Method "'+i+'" is private.'),!1;u[i].apply(u,[s])}}),this},n.patterns[r.prototype.name]=r}};return n}),define("mockup-patterns-base",["jquery","mockup-registry"],function(e,t){var n=function(t,n){this.$el=t,this.options=e.extend(!0,{},this.defaults||{},n||{}),this.init(),this.trigger("init")};return n.prototype={constructor:n,on:function(e,t){this.$el.on(e+"."+this.name+".patterns",t)},trigger:function(e,t){t===undefined&&(t=[]),this.$el.trigger(e+"."+this.name+".patterns",t)}},n.extend=function(n){var r=this,i;n&&n.hasOwnProperty("constructor")?i=n.constructor:i=function(){r.apply(this,arguments)};var s=function(){this.constructor=i};return s.prototype=r.prototype,i.prototype=new s,i.extend=r.extend,e.extend(!0,i.prototype,n),i.__super__=r.prototype,t.register(i),i},n}),function(){function x(e,t,n){var r=(n||0)-1,i=e?e.length:0;while(++r<i)if(e[r]===t)return r;return-1}function T(e,t){var n=e.criteria,r=t.criteria,i=-1,s=n.length;while(++i<s){var o=n[i],u=r[i];if(o!==u){if(o>u||typeof o=="undefined")return 1;if(o<u||typeof u=="undefined")return-1}}return e.index-t.index}function N(e){return"\\"+g[e]}function C(e,t,n){t||(t=0),typeof n=="undefined"&&(n=e?e.length:0);var r=-1,i=n-t||0,s=Array(i<0?0:i);while(++r<i)s[r]=e[t+r];return s}function X(e){return e instanceof X?e:new V(e)}function V(e,t){this.__chain__=!!t,this.__wrapped__=e}function J(e){function i(){if(n){var e=C(n);H.apply(e,arguments)}if(this instanceof i){var s=K(t.prototype),o=t.apply(s,e||arguments);return _t(o)?o:s}return t.apply(r,e||arguments)}var t=e[0],n=e[2],r=e[4];return i}function K(e,t){return _t(e)?j(e):{}}function Q(e,t,n){if(typeof e!="function")return Vn;if(typeof t!="undefined"&&"prototype"in e){switch(n){case 1:return function(n){return e.call(t,n)};case 2:return function(n,r){return e.call(t,n,r)};case 3:return function(n,r,i){return e.call(t,n,r,i)};case 4:return function(n,r,i,s){return e.call(t,n,r,i,s)}}return Dn(e,t)}return e}function G(e){function h(){var e=u?s:this;if(r){var p=C(r);H.apply(p,arguments)}if(i||f){p||(p=C(arguments)),i&&H.apply(p,i);if(f&&p.length<o)return n|=16,G([t,l?n:n&-4,p,null,s,o])}p||(p=arguments),a&&(t=e[c]);if(this instanceof h){e=K(t.prototype);var d=t.apply(e,p);return _t(d)?d:e}return t.apply(e,p)}var t=e[0],n=e[1],r=e[2],i=e[3],s=e[4],o=e[5],u=n&1,a=n&2,f=n&4,l=n&8,c=t;return h}function Y(e,t){var n=-1,r=ot(),i=e?e.length:0,s=[];while(++n<i){var o=e[n];r(t,o)<0&&s.push(o)}return s}function Z(e,t,n,r){var i=(r||0)-1,s=e?e.length:0,o=[];while(++i<s){var u=e[i];if(u&&typeof u=="object"&&typeof u.length=="number"&&(lt(u)||ft(u))){t||(u=Z(u,t,n));var a=-1,f=u.length,l=o.length;o.length+=f;while(++a<f)o[l++]=u[a]}else n||o.push(u)}return o}function et(e,t,r,i){if(e===t)return e!==0||1/e==1/t;var s=typeof e,o=typeof t;if(e===e&&(!e||!m[s])&&(!t||!m[o]))return!1;if(e==null||t==null)return e===t;var u=O.call(e),c=O.call(t);if(u!=c)return!1;switch(u){case f:case l:return+e==+t;case h:return e!=+e?t!=+t:e==0?1/e==1/t:e==+t;case d:case v:return e==String(t)}var g=u==a;if(!g){var y=e instanceof X,b=t instanceof X;if(y||b)return et(y?e.__wrapped__:e,b?t.__wrapped__:t,r,i);if(u!=p)return!1;var w=e.constructor,E=t.constructor;if(w!=E&&!(Mt(w)&&w instanceof w&&Mt(E)&&E instanceof E)&&"constructor"in e&&"constructor"in t)return!1}r||(r=[]),i||(i=[]);var S=r.length;while(S--)if(r[S]==e)return i[S]==t;var x=!0,T=0;r.push(e),i.push(t);if(g){T=t.length,x=T==e.length;if(x)while(T--)if(!(x=et(e[T],t[T],r,i)))break}else wt(t,function(t,s,o){if(P.call(o,s))return T++,!(x=P.call(e,s)&&et(e[s],t,r,i))&&n}),x&&wt(e,function(e,t,r){if(P.call(r,t))return!(x=--T>-1)&&n});return r.pop(),i.pop(),x}function tt(e,t){return e+D(W()*(t-e+1))}function nt(e,t,n){var r=-1,i=ot(),s=e?e.length:0,o=[],u=n?[]:o;while(++r<s){var a=e[r],f=n?n(a,r,e):a;if(t?!r||u[u.length-1]!==f:i(u,f)<0)n&&u.push(f),o.push(a)}return o}function rt(e){return function(t,n,r){var i={};n=Wn(n,r,3);var s=-1,o=t?t.length:0;if(typeof o=="number")while(++s<o){var u=t[s];e(i,u,n(u,s,t),t)}else Et(t,function(t,r,s){e(i,t,n(t,r,s),s)});return i}}function it(e,t,n,r,i,s){var o=t&1,u=t&2,a=t&4,f=t&8,l=t&16,c=t&32;if(!u&&!Mt(e))throw new TypeError;l&&!n.length&&(t&=-17,l=n=!1),c&&!r.length&&(t&=-33,c=r=!1);var h=t==1||t===17?J:G;return h([e,t,n,r,i,s])}function st(e){return pt[e]}function ot(){var e=(e=X.indexOf)===bn?x:e;return e}function ut(e){return typeof e=="function"&&M.test(e)}function at(e){return dt[e]}function ft(e){return e&&typeof e=="object"&&typeof e.length=="number"&&O.call(e)==u||!1}function gt(e){if(!e)return e;for(var t=1,n=arguments.length;t<n;t++){var r=arguments[t];if(r)for(var i in r)e[i]=r[i]}return e}function yt(e){return _t(e)?lt(e)?C(e):gt({},e):e}function bt(e){if(!e)return e;for(var t=1,n=arguments.length;t<n;t++){var r=arguments[t];if(r)for(var i in r)typeof e[i]=="undefined"&&(e[i]=r[i])}return e}function St(e){var t=[];return wt(e,function(e,n){Mt(e)&&t.push(n)}),t.sort()}function xt(e,t){return e?P.call(e,t):!1}function Tt(e){var t=-1,n=ht(e),r=n.length,i={};while(++t<r){var s=n[t];i[e[s]]=s}return i}function Nt(e){return e===!0||e===!1||e&&typeof e=="object"&&O.call(e)==f||!1}function Ct(e){return e&&typeof e=="object"&&O.call(e)==l||!1}function kt(e){return e&&e.nodeType===1||!1}function Lt(e){if(!e)return!0;if(lt(e)||jt(e))return!e.length;for(var t in e)if(P.call(e,t))return!1;return!0}function At(e,t){return et(e,t)}function Ot(e){return I(e)&&!q(parseFloat(e))}function Mt(e){return typeof e=="function"}function _t(e){return!!e&&!!m[typeof e]}function Dt(e){return Ht(e)&&e!=+e}function Pt(e){return e===null}function Ht(e){return typeof e=="number"||e&&typeof e=="object"&&O.call(e)==h||!1}function Bt(e){return e&&m[typeof e]&&O.call(e)==d||!1}function jt(e){return typeof e=="string"||e&&typeof e=="object"&&O.call(e)==v||!1}function Ft(e){return typeof e=="undefined"}function It(e){var t=[];wt(e,function(e,n){t.push(n)}),t=Y(t,Z(arguments,!0,!1,1));var n=-1,r=t.length,i={};while(++n<r){var s=t[n];i[s]=e[s]}return i}function qt(e){var t=-1,n=ht(e),r=n.length,i=Array(r);while(++t<r){var s=n[t];i[t]=[s,e[s]]}return i}function Rt(e){var t=-1,n=Z(arguments,!0,!1,1),r=n.length,i={};while(++t<r){var s=n[t];s in e&&(i[s]=e[s])}return i}function Ut(e){var t=-1,n=ht(e),r=n.length,i=Array(r);while(++t<r)i[t]=e[n[t]];return i}function zt(e,t){var r=ot(),i=e?e.length:0,s=!1;return i&&typeof i=="number"?s=r(e,t)>-1:Et(e,function(e){return(s=e===t)&&n}),s}function Xt(e,t,r){var i=!0;t=Wn(t,r,3);var s=-1,o=e?e.length:0;if(typeof o=="number"){while(++s<o)if(!(i=!!t(e[s],s,e)))break}else Et(e,function(e,r,s){return!(i=!!t(e,r,s))&&n});return i}function Vt(e,t,n){var r=[];t=Wn(t,n,3);var i=-1,s=e?e.length:0;if(typeof s=="number")while(++i<s){var o=e[i];t(o,i,e)&&r.push(o)}else Et(e,function(e,n,i){t(e,n,i)&&r.push(e)});return r}function $t(e,t,r){t=Wn(t,r,3);var i=-1,s=e?e.length:0;if(typeof s!="number"){var u;return Et(e,function(e,r,i){if(t(e,r,i))return u=e,n}),u}while(++i<s){var o=e[i];if(t(o,i,e))return o}}function Jt(e,t){return dn(e,t,!0)}function Kt(e,t,r){var i=-1,s=e?e.length:0;t=t&&typeof r=="undefined"?t:Q(t,r,3);if(typeof s=="number"){while(++i<s)if(t(e[i],i,e)===n)break}else Et(e,t)}function Qt(e,t){var r=e?e.length:0;if(typeof r=="number"){while(r--)if(t(e[r],r,e)===!1)break}else{var i=ht(e);r=i.length,Et(e,function(e,s,o){return s=i?i[--r]:--r,t(o[s],s,o)===!1&&n})}}function Zt(e,t){var n=C(arguments,2),r=-1,i=typeof t=="function",s=e?e.length:0,o=Array(typeof s=="number"?s:0);return Kt(e,function(e){o[++r]=(i?t:e[t]).apply(e,n)}),o}function en(e,t,n){var r=-1,i=e?e.length:0;t=Wn(t,n,3);if(typeof i=="number"){var s=Array(i);while(++r<i)s[r]=t(e[r],r,e)}else s=[],Et(e,function(e,n,i){s[++r]=t(e,n,i)});return s}function tn(e,t,n){var r=-Infinity,i=r;typeof t!="function"&&n&&n[t]===e&&(t=null);var s=-1,o=e?e.length:0;if(t==null&&typeof o=="number")while(++s<o){var u=e[s];u>i&&(i=u)}else t=Wn(t,n,3),Kt(e,function(e,n,s){var o=t(e,n,s);o>r&&(r=o,i=e)});return i}function nn(e,t,n){var r=Infinity,i=r;typeof t!="function"&&n&&n[t]===e&&(t=null);var s=-1,o=e?e.length:0;if(t==null&&typeof o=="number")while(++s<o){var u=e[s];u<i&&(i=u)}else t=Wn(t,n,3),Kt(e,function(e,n,s){var o=t(e,n,s);o<r&&(r=o,i=e)});return i}function sn(e,t,n,r){if(!e)return n;var i=arguments.length<3;t=Wn(t,r,4);var s=-1,o=e.length;if(typeof o=="number"){i&&(n=e[++s]);while(++s<o)n=t(n,e[s],s,e)}else Et(e,function(e,r,s){n=i?(i=!1,e):t(n,e,r,s)});return n}function on(e,t,n,r){var i=arguments.length<3;return t=Wn(t,r,4),Qt(e,function(e,r,s){n=i?(i=!1,e):t(n,e,r,s)}),n}function un(e,t,n){return t=Wn(t,n,3),Vt(e,function(e,n,r){return!t(e,n,r)})}function an(t,n,r){t&&typeof t.length!="number"&&(t=Ut(t));if(n==null||r)return t?t[tt(0,t.length-1)]:e;var i=fn(t);return i.length=z(U(0,n),i.length),i}function fn(e){var t=-1,n=e?e.length:0,r=Array(typeof n=="number"?n:0);return Kt(e,function(e){var n=tt(0,++t);r[t]=r[n],r[n]=e}),r}function ln(e){var t=e?e.length:0;return typeof t=="number"?t:ht(e).length}function cn(e,t,r){var i;t=Wn(t,r,3);var s=-1,o=e?e.length:0;if(typeof o=="number"){while(++s<o)if(i=t(e[s],s,e))break}else Et(e,function(e,r,s){return(i=t(e,r,s))&&n});return!!i}function hn(e,t,n){var r=-1,i=e?e.length:0,s=Array(typeof i=="number"?i:0);t=Wn(t,n,3),Kt(e,function(e,n,i){s[++r]={criteria:[t(e,n,i)],index:r,value:e}}),i=s.length,s.sort(T);while(i--)s[i]=s[i].value;return s}function pn(e){return lt(e)?C(e):e&&typeof e.length=="number"?en(e):Ut(e)}function dn(t,n,r){return r&&Lt(n)?e:(r?$t:Vt)(t,n)}function vn(e){var t=-1,n=e?e.length:0,r=[];while(++t<n){var i=e[t];i&&r.push(i)}return r}function mn(e){return Y(e,Z(arguments,!0,!0,1))}function gn(t,n,r){var i=0,s=t?t.length:0;if(typeof n!="number"&&n!=null){var o=-1;n=Wn(n,r,3);while(++o<s&&n(t[o],o,t))i++}else{i=n;if(i==null||r)return t?t[0]:e}return C(t,0,z(U(0,i),s))}function yn(e,t){return Z(e,t)}function bn(e,t,n){if(typeof n=="number"){var r=e?e.length:0;n=n<0?U(0,r+n):n||0}else if(n){var i=Cn(e,t);return e[i]===t?i:-1}return x(e,t,n)}function wn(e,t,n){var r=0,i=e?e.length:0;if(typeof t!="number"&&t!=null){var s=i;t=Wn(t,n,3);while(s--&&t(e[s],s,e))r++}else r=t==null||n?1:t||r;return C(e,0,z(U(0,i-r),i))}function En(){var e=[],t=-1,n=arguments.length;while(++t<n){var r=arguments[t];(lt(r)||ft(r))&&e.push(r)}var i=e[0],s=-1,o=ot(),u=i?i.length:0,a=[];e:while(++s<u){r=i[s];if(o(a,r)<0){var t=n;while(--t)if(o(e[t],r)<0)continue e;a.push(r)}}return a}function Sn(t,n,r){var i=0,s=t?t.length:0;if(typeof n!="number"&&n!=null){var o=s;n=Wn(n,r,3);while(o--&&n(t[o],o,t))i++}else{i=n;if(i==null||r)return t?t[s-1]:e}return C(t,U(0,s-i))}function xn(e,t,n){var r=e?e.length:0;typeof n=="number"&&(r=(n<0?U(0,r+n):z(n,r-1))+1);while(r--)if(e[r]===t)return r;return-1}function Tn(e,t,n){e=+e||0,n=+n||1,t==null&&(t=e,e=0);var r=-1,i=U(0,_((t-e)/n)),s=Array(i);while(++r<i)s[r]=e,e+=n;return s}function Nn(e,t,n){if(typeof t!="number"&&t!=null){var r=0,i=-1,s=e?e.length:0;t=Wn(t,n,3);while(++i<s&&t(e[i],i,e))r++}else r=t==null||n?1:U(0,t);return C(e,r)}function Cn(e,t,n,r){var i=0,s=e?e.length:i;n=n?Wn(n,r,1):Vn,t=n(t);while(i<s){var o=i+s>>>1;n(e[o])<t?i=o+1:s=o}return i}function kn(){return nt(Z(arguments,!0,!0))}function Ln(e,t,n,r){return typeof t!="boolean"&&t!=null&&(r=n,n=typeof t!="function"&&r&&r[t]===e?null:t,t=!1),n!=null&&(n=Wn(n,r,3)),nt(e,t,n)}function An(e){return Y(e,C(arguments,1))}function On(){var e=-1,t=tn(rn(arguments,"length")),n=Array(t<0?0:t);while(++e<t)n[e]=rn(arguments,e);return n}function Mn(e,t){var n=-1,r=e?e.length:0,i={};!t&&r&&!lt(e[0])&&(t=[]);while(++n<r){var s=e[n];t?i[s]=t[n]:s&&(i[s[0]]=s[1])}return i}function _n(e,t){if(!Mt(t))throw new TypeError;return function(){if(--e<1)return t.apply(this,arguments)}}function Dn(e,t){return arguments.length>2?it(e,17,C(arguments,2),null,t):it(e,1,null,null,t)}function Pn(e){var t=arguments.length>1?Z(arguments,!0,!1,1):St(e),n=-1,r=t.length;while(++n<r){var i=t[n];e[i]=it(e[i],1,null,null,e)}return e}function Hn(){var e=arguments,t=e.length;while(t--)if(!Mt(e[t]))throw new TypeError;return function(){var t=arguments,n=e.length;while(n--)t=[e[n].apply(this,t)];return t[0]}}function Bn(t,n,r){var i,s,o,u,a,f,l,c=0,h=!1,p=!0;if(!Mt(t))throw new TypeError;n=U(0,n)||0;if(r===!0){var d=!0;p=!1}else _t(r)&&(d=r.leading,h="maxWait"in r&&(U(n,r.maxWait)||0),p="trailing"in r?r.trailing:p);var v=function(){var r=n-(Qn()-u);if(r<=0){s&&clearTimeout(s);var h=l;s=f=l=e,h&&(c=Qn(),o=t.apply(a,i),!f&&!s&&(i=a=null))}else f=setTimeout(v,r)},m=function(){f&&clearTimeout(f),s=f=l=e;if(p||h!==n)c=Qn(),o=t.apply(a,i),!f&&!s&&(i=a=null)};return function(){i=arguments,u=Qn(),a=this,l=p&&(f||!d);if(h===!1)var e=d&&!f;else{!s&&!d&&(c=u);var r=h-(u-c),g=r<=0;g?(s&&(s=clearTimeout(s)),c=u,o=t.apply(a,i)):s||(s=setTimeout(m,r))}return g&&f?f=clearTimeout(f):!f&&n!==h&&(f=setTimeout(v,n)),e&&(g=!0,o=t.apply(a,i)),g&&!f&&!s&&(i=a=null),o}}function jn(t){if(!Mt(t))throw new TypeError;var n=C(arguments,1);return setTimeout(function(){t.apply(e,n)},1)}function Fn(t,n){if(!Mt(t))throw new TypeError;var r=C(arguments,2);return setTimeout(function(){t.apply(e,r)},n)}function In(e,t){var n={};return function(){var i=t?t.apply(this,arguments):r+arguments[0];return P.call(n,i)?n[i]:n[i]=e.apply(this,arguments)}}function qn(e){var t,n;if(!Mt(e))throw new TypeError;return function(){return t?n:(t=!0,n=e.apply(this,arguments),e=null,n)}}function Rn(e){return it(e,16,C(arguments,1))}function Un(e,t,n){var r=!0,i=!0;if(!Mt(e))throw new TypeError;return n===!1?r=!1:_t(n)&&(r="leading"in n?n.leading:r,i="trailing"in n?n.trailing:i),n={},n.leading=r,n.maxWait=t,n.trailing=i,Bn(e,t,n)}function zn(e,t){return it(t,16,[e])}function Wn(e,t,n){var r=typeof e;if(e==null||r=="function")return Q(e,t,n);if(r!="object")return Gn(e);var i=ht(e);return function(t){var n=i.length,r=!1;while(n--)if(!(r=t[i[n]]===e[i[n]]))break;return r}}function Xn(e){return e==null?"":String(e).replace(mt,st)}function Vn(e){return e}function $n(e){Kt(St(e),function(t){var n=X[t]=e[t];X.prototype[t]=function(){var e=[this.__wrapped__];H.apply(e,arguments);var t=n.apply(X,e);return this.__chain__?new V(t,!0):t}})}function Jn(){return y._=A,this}function Kn(){}function Gn(e){return function(t){return t[e]}}function Yn(e,t){return e==null&&t==null&&(t=1),e=+e||0,t==null?(t=e,e=0):t=+t||0,e+D(W()*(t-e+1))}function Zn(e,t){if(e){var n=e[t];return Mt(n)?e[t]():n}}function er(e,t,n){var r=X,i=r.templateSettings;e=String(e||""),n=bt({},n,i);var u=0,a="__p += '",f=n.variable,l=RegExp((n.escape||s).source+"|"+(n.interpolate||s).source+"|"+(n.evaluate||s).source+"|$","g");e.replace(l,function(t,n,r,i,s){return a+=e.slice(u,s).replace(o,N),n&&(a+="' +\n_.escape("+n+") +\n'"),i&&(a+="';\n"+i+";\n__p += '"),r&&(a+="' +\n((__t = ("+r+")) == null ? '' : __t) +\n'"),u=s+t.length,t}),a+="';\n",f||(f="obj",a="with ("+f+" || {}) {\n"+a+"\n}\n"),a="function("+f+") {\n"+"var __t, __p = '', __j = Array.prototype.join;\n"+"function print() { __p += __j.call(arguments, '') }\n"+a+"return __p\n}";try{var c=Function("_","return "+a)(r)}catch(h){throw h.source=a,h}return t?c(t):(c.source=a,c)}function tr(e,t,n){e=(e=+e)>-1?e:0;var r=-1,i=Array(e);t=Q(t,n,1);while(++r<e)i[r]=t(r);return i}function nr(e){return e==null?"":String(e).replace(vt,at)}function rr(e){var n=++t+"";return e?e+n:n}function ir(e){return e=new V(e),e.__chain__=!0,e}function sr(e,t){return t(e),e}function or(){return this.__chain__=!0,this}function ur(){return this.__wrapped__}var e,t=0,n={},r=+(new Date)+"",i=/<%=([\s\S]+?)%>/g,s=/($^)/,o=/['\n\r\t\u2028\u2029\\]/g,u="[object Arguments]",a="[object Array]",f="[object Boolean]",l="[object Date]",c="[object Function]",h="[object Number]",p="[object Object]",d="[object RegExp]",v="[object String]",m={"boolean":!1,"function":!0,object:!0,number:!1,string:!1,"undefined":!1},g={"\\":"\\","'":"'","\n":"n","\r":"r","	":"t","\u2028":"u2028","\u2029":"u2029"},y=m[typeof window]&&window||this,b=m[typeof exports]&&exports&&!exports.nodeType&&exports,w=m[typeof module]&&module&&!module.nodeType&&module,E=w&&w.exports===b&&b,S=m[typeof global]&&global;S&&(S.global===S||S.window===S)&&(y=S);var k=[],L=Object.prototype,A=y._,O=L.toString,M=RegExp("^"+String(O).replace(/[.*+?^${}()|[\]\\]/g,"\\$&").replace(/toString| for [^\]]+/g,".*?")+"$"),_=Math.ceil,D=Math.floor,P=L.hasOwnProperty,H=k.push,B=L.propertyIsEnumerable,j=ut(j=Object.create)&&j,F=ut(F=Array.isArray)&&F,I=y.isFinite,q=y.isNaN,R=ut(R=Object.keys)&&R,U=Math.max,z=Math.min,W=Math.random;V.prototype=X.prototype;var $={};(function(){var e={0:1,length:1};$.spliceObjects=(k.splice.call(e,0,1),!e[0])})(1),X.templateSettings={escape:/<%-([\s\S]+?)%>/g,evaluate:/<%([\s\S]+?)%>/g,interpolate:i,variable:""},j||(K=function(){function e(){}return function(t){if(_t(t)){e.prototype=t;var n=new e;e.prototype=null}return n||y.Object()}}()),ft(arguments)||(ft=function(e){return e&&typeof e=="object"&&typeof e.length=="number"&&P.call(e,"callee")&&!B.call(e,"callee")||!1});var lt=F||function(e){return e&&typeof e=="object"&&typeof e.length=="number"&&O.call(e)==a||!1},ct=function(e){var t,n=e,r=[];if(!n)return r;if(!m[typeof e])return r;for(t in n)P.call(n,t)&&r.push(t);return r},ht=R?function(e){return _t(e)?R(e):[]}:ct,pt={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;"},dt=Tt(pt),vt=RegExp("("+ht(dt).join("|")+")","g"),mt=RegExp("["+ht(pt).join("")+"]","g"),wt=function(e,t){var r,i=e,s=i;if(!i)return s;if(!m[typeof i])return s;for(r in i)if(t(i[r],r,e)===n)return s;return s},Et=function(e,t){var r,i=e,s=i;if(!i)return s;if(!m[typeof i])return s;for(r in i)if(P.call(i,r)&&t(i[r],r,e)===n)return s;return s};Mt(/x/)&&(Mt=function(e){return typeof e=="function"&&O.call(e)==c});var Wt=rt(function(e,t,n){P.call(e,n)?e[n]++:e[n]=1}),Gt=rt(function(e,t,n){(P.call(e,n)?e[n]:e[n]=[]).push(t)}),Yt=rt(function(e,t,n){e[n]=t}),rn=en,Qn=ut(Qn=Date.now)&&Qn||function(){return(new Date).getTime()};X.after=_n,X.bind=Dn,X.bindAll=Pn,X.chain=ir,X.compact=vn,X.compose=Hn,X.countBy=Wt,X.debounce=Bn,X.defaults=bt,X.defer=jn,X.delay=Fn,X.difference=mn,X.filter=Vt,X.flatten=yn,X.forEach=Kt,X.functions=St,X.groupBy=Gt,X.indexBy=Yt,X.initial=wn,X.intersection=En,X.invert=Tt,X.invoke=Zt,X.keys=ht,X.map=en,X.max=tn,X.memoize=In,X.min=nn,X.omit=It,X.once=qn,X.pairs=qt,X.partial=Rn,X.pick=Rt,X.pluck=rn,X.range=Tn,X.reject=un,X.rest=Nn,X.shuffle=fn,X.sortBy=hn,X.tap=sr,X.throttle=Un,X.times=tr,X.toArray=pn,X.union=kn,X.uniq=Ln,X.values=Ut,X.where=dn,X.without=An,X.wrap=zn,X.zip=On,X.collect=en,X.drop=Nn,X.each=Kt,X.extend=gt,X.methods=St,X.object=Mn,X.select=Vt,X.tail=Nn,X.unique=Ln,X.clone=yt,X.contains=zt,X.escape=Xn,X.every=Xt,X.find=$t,X.has=xt,X.identity=Vn,X.indexOf=bn,X.isArguments=ft,X.isArray=lt,X.isBoolean=Nt,X.isDate=Ct,X.isElement=kt,X.isEmpty=Lt,X.isEqual=At,X.isFinite=Ot,X.isFunction=Mt,X.isNaN=Dt,X.isNull=Pt,X.isNumber=Ht,X.isObject=_t,X.isRegExp=Bt,X.isString=jt,X.isUndefined=Ft,X.lastIndexOf=xn,X.mixin=$n,X.noConflict=Jn,X.random=Yn,X.reduce=sn,X.reduceRight=on,X.result=Zn,X.size=ln,X.some=cn,X.sortedIndex=Cn,X.template=er,X.unescape=nr,X.uniqueId=rr,X.all=Xt,X.any=cn,X.detect=$t,X.findWhere=Jt,X.foldl=sn,X.foldr=on,X.include=zt,X.inject=sn,X.first=gn,X.last=Sn,X.sample=an,X.take=gn,X.head=gn,$n(X),X.VERSION="2.4.1",X.prototype.chain=or,X.prototype.value=ur,Kt(["pop","push","reverse","shift","sort","splice","unshift"],function(e){var t=k[e];X.prototype[e]=function(){var e=this.__wrapped__;return t.apply(e,arguments),!$.spliceObjects&&e.length===0&&delete e[0],this}}),Kt(["concat","join","slice"],function(e){var t=k[e];X.prototype[e]=function(){var e=this.__wrapped__,n=t.apply(e,arguments);return this.__chain__&&(n=new V(n),n.__chain__=!0),n}}),typeof define=="function"&&typeof define.amd=="object"&&define.amd?(y._=X,define("underscore",[],function(){return X})):b&&w?E?(w.exports=X)._=X:b._=X:y._=X}.call(this),define("mockup-patterns-backdrop",["jquery","mockup-patterns-base"],function(e,t){var n=t.extend({name:"backdrop",defaults:{zIndex:null,opacity:.8,className:"backdrop",classActiveName:"backdrop-active",closeOnEsc:!0,closeOnClick:!0},init:function(){var t=this;t.$backdrop=e("> ."+t.options.className,t.$el),t.$backdrop.size()===0&&(t.$backdrop=e("<div/>").hide().appendTo(t.$el).addClass(t.options.className),t.options.zIndex!==null&&t.$backdrop.css("z-index",t.options.zIndex)),t.options.closeOnEsc===!0&&e(document).on("keydown",function(e,n){t.$el.is("."+t.options.classActiveName)&&e.keyCode===27&&t.hide()}),t.options.closeOnClick===!0&&t.$backdrop.on("click",function(){t.$el.is("."+t.options.classActiveName)&&t.hide()})},show:function(){var e=this;e.$el.hasClass(e.options.classActiveName)||(e.trigger("show"),e.$backdrop.css("opacity","0").show(),e.$el.addClass(e.options.classActiveName),e.$backdrop.animate({opacity:e.options.opacity},500),e.trigger("shown"))},hide:function(){var e=this;e.$el.hasClass(e.options.classActiveName)&&(e.trigger("hide"),e.$backdrop.animate({opacity:"0"},500).hide(),e.$el.removeClass(e.options.classActiveName),e.trigger("hidden"))}});return n}),function(){var e=this,t=e.Backbone,n=[],r=n.push,i=n.slice,s=n.splice,o;typeof exports!="undefined"?o=exports:o=e.Backbone={},o.VERSION="1.1.0";var u=e._;!u&&typeof require!="undefined"&&(u=require("underscore")),o.$=e.jQuery||e.Zepto||e.ender||e.$,o.noConflict=function(){return e.Backbone=t,this},o.emulateHTTP=!1,o.emulateJSON=!1;var a=o.Events={on:function(e,t,n){if(!l(this,"on",e,[t,n])||!t)return this;this._events||(this._events={});var r=this._events[e]||(this._events[e]=[]);return r.push({callback:t,context:n,ctx:n||this}),this},once:function(e,t,n){if(!l(this,"once",e,[t,n])||!t)return this;var r=this,i=u.once(function(){r.off(e,i),t.apply(this,arguments)});return i._callback=t,this.on(e,i,n)},off:function(e,t,n){var r,i,s,o,a,f,c,h;if(!this._events||!l(this,"off",e,[t,n]))return this;if(!e&&!t&&!n)return this._events={},this;o=e?[e]:u.keys(this._events);for(a=0,f=o.length;a<f;a++){e=o[a];if(s=this._events[e]){this._events[e]=r=[];if(t||n)for(c=0,h=s.length;c<h;c++)i=s[c],(t&&t!==i.callback&&t!==i.callback._callback||n&&n!==i.context)&&r.push(i);r.length||delete this._events[e]}}return this},trigger:function(e){if(!this._events)return this;var t=i.call(arguments,1);if(!l(this,"trigger",e,t))return this;var n=this._events[e],r=this._events.all;return n&&c(n,t),r&&c(r,arguments),this},stopListening:function(e,t,n){var r=this._listeningTo;if(!r)return this;var i=!t&&!n;!n&&typeof t=="object"&&(n=this),e&&((r={})[e._listenId]=e);for(var s in r)e=r[s],e.off(t,n,this),(i||u.isEmpty(e._events))&&delete this._listeningTo[s];return this}},f=/\s+/,l=function(e,t,n,r){if(!n)return!0;if(typeof n=="object"){for(var i in n)e[t].apply(e,[i,n[i]].concat(r));return!1}if(f.test(n)){var s=n.split(f);for(var o=0,u=s.length;o<u;o++)e[t].apply(e,[s[o]].concat(r));return!1}return!0},c=function(e,t){var n,r=-1,i=e.length,s=t[0],o=t[1],u=t[2];switch(t.length){case 0:while(++r<i)(n=e[r]).callback.call(n.ctx);return;case 1:while(++r<i)(n=e[r]).callback.call(n.ctx,s);return;case 2:while(++r<i)(n=e[r]).callback.call(n.ctx,s,o);return;case 3:while(++r<i)(n=e[r]).callback.call(n.ctx,s,o,u);return;default:while(++r<i)(n=e[r]).callback.apply(n.ctx,t)}},h={listenTo:"on",listenToOnce:"once"};u.each(h,function(e,t){a[t]=function(t,n,r){var i=this._listeningTo||(this._listeningTo={}),s=t._listenId||(t._listenId=u.uniqueId("l"));return i[s]=t,!r&&typeof n=="object"&&(r=this),t[e](n,r,this),this}}),a.bind=a.on,a.unbind=a.off,u.extend(o,a);var p=o.Model=function(e,t){var n=e||{};t||(t={}),this.cid=u.uniqueId("c"),this.attributes={},t.collection&&(this.collection=t.collection),t.parse&&(n=this.parse(n,t)||{}),n=u.defaults({},n,u.result(this,"defaults")),this.set(n,t),this.changed={},this.initialize.apply(this,arguments)};u.extend(p.prototype,a,{changed:null,validationError:null,idAttribute:"id",initialize:function(){},toJSON:function(e){return u.clone(this.attributes)},sync:function(){return o.sync.apply(this,arguments)},get:function(e){return this.attributes[e]},escape:function(e){return u.escape(this.get(e))},has:function(e){return this.get(e)!=null},set:function(e,t,n){var r,i,s,o,a,f,l,c;if(e==null)return this;typeof e=="object"?(i=e,n=t):(i={})[e]=t,n||(n={});if(!this._validate(i,n))return!1;s=n.unset,a=n.silent,o=[],f=this._changing,this._changing=!0,f||(this._previousAttributes=u.clone(this.attributes),this.changed={}),c=this.attributes,l=this._previousAttributes,this.idAttribute in i&&(this.id=i[this.idAttribute]);for(r in i)t=i[r],u.isEqual(c[r],t)||o.push(r),u.isEqual(l[r],t)?delete this.changed[r]:this.changed[r]=t,s?delete c[r]:c[r]=t;if(!a){o.length&&(this._pending=!0);for(var h=0,p=o.length;h<p;h++)this.trigger("change:"+o[h],this,c[o[h]],n)}if(f)return this;if(!a)while(this._pending)this._pending=!1,this.trigger("change",this,n);return this._pending=!1,this._changing=!1,this},unset:function(e,t){return this.set(e,void 0,u.extend({},t,{unset:!0}))},clear:function(e){var t={};for(var n in this.attributes)t[n]=void 0;return this.set(t,u.extend({},e,{unset:!0}))},hasChanged:function(e){return e==null?!u.isEmpty(this.changed):u.has(this.changed,e)},changedAttributes:function(e){if(!e)return this.hasChanged()?u.clone(this.changed):!1;var t,n=!1,r=this._changing?this._previousAttributes:this.attributes;for(var i in e){if(u.isEqual(r[i],t=e[i]))continue;(n||(n={}))[i]=t}return n},previous:function(e){return e==null||!this._previousAttributes?null:this._previousAttributes[e]},previousAttributes:function(){return u.clone(this._previousAttributes)},fetch:function(e){e=e?u.clone(e):{},e.parse===void 0&&(e.parse=!0);var t=this,n=e.success;return e.success=function(r){if(!t.set(t.parse(r,e),e))return!1;n&&n(t,r,e),t.trigger("sync",t,r,e)},F(this,e),this.sync("read",this,e)},save:function(e,t,n){var r,i,s,o=this.attributes;e==null||typeof e=="object"?(r=e,n=t):(r={})[e]=t,n=u.extend({validate:!0},n);if(r&&!n.wait){if(!this.set(r,n))return!1}else if(!this._validate(r,n))return!1;r&&n.wait&&(this.attributes=u.extend({},o,r)),n.parse===void 0&&(n.parse=!0);var a=this,f=n.success;return n.success=function(e){a.attributes=o;var t=a.parse(e,n);n.wait&&(t=u.extend(r||{},t));if(u.isObject(t)&&!a.set(t,n))return!1;f&&f(a,e,n),a.trigger("sync",a,e,n)},F(this,n),i=this.isNew()?"create":n.patch?"patch":"update",i==="patch"&&(n.attrs=r),s=this.sync(i,this,n),r&&n.wait&&(this.attributes=o),s},destroy:function(e){e=e?u.clone(e):{};var t=this,n=e.success,r=function(){t.trigger("destroy",t,t.collection,e)};e.success=function(i){(e.wait||t.isNew())&&r(),n&&n(t,i,e),t.isNew()||t.trigger("sync",t,i,e)};if(this.isNew())return e.success(),!1;F(this,e);var i=this.sync("delete",this,e);return e.wait||r(),i},url:function(){var e=u.result(this,"urlRoot")||u.result(this.collection,"url")||j();return this.isNew()?e:e+(e.charAt(e.length-1)==="/"?"":"/")+encodeURIComponent(this.id)},parse:function(e,t){return e},clone:function(){return new this.constructor(this.attributes)},isNew:function(){return this.id==null},isValid:function(e){return this._validate({},u.extend(e||{},{validate:!0}))},_validate:function(e,t){if(!t.validate||!this.validate)return!0;e=u.extend({},this.attributes,e);var n=this.validationError=this.validate(e,t)||null;return n?(this.trigger("invalid",this,n,u.extend(t,{validationError:n})),!1):!0}});var d=["keys","values","pairs","invert","pick","omit"];u.each(d,function(e){p.prototype[e]=function(){var t=i.call(arguments);return t.unshift(this.attributes),u[e].apply(u,t)}});var v=o.Collection=function(e,t){t||(t={}),t.model&&(this.model=t.model),t.comparator!==void 0&&(this.comparator=t.comparator),this._reset(),this.initialize.apply(this,arguments),e&&this.reset(e,u.extend({silent:!0},t))},m={add:!0,remove:!0,merge:!0},g={add:!0,remove:!1};u.extend(v.prototype,a,{model:p,initialize:function(){},toJSON:function(e){return this.map(function(t){return t.toJSON(e)})},sync:function(){return o.sync.apply(this,arguments)},add:function(e,t){return this.set(e,u.extend({merge:!1},t,g))},remove:function(e,t){var n=!u.isArray(e);e=n?[e]:u.clone(e),t||(t={});var r,i,s,o;for(r=0,i=e.length;r<i;r++){o=e[r]=this.get(e[r]);if(!o)continue;delete this._byId[o.id],delete this._byId[o.cid],s=this.indexOf(o),this.models.splice(s,1),this.length--,t.silent||(t.index=s,o.trigger("remove",o,this,t)),this._removeReference(o)}return n?e[0]:e},set:function(e,t){t=u.defaults({},t,m),t.parse&&(e=this.parse(e,t));var n=!u.isArray(e);e=n?e?[e]:[]:u.clone(e);var r,i,s,o,a,f,l,c=t.at,h=this.model,d=this.comparator&&c==null&&t.sort!==!1,v=u.isString(this.comparator)?this.comparator:null,g=[],y=[],b={},w=t.add,E=t.merge,S=t.remove,x=!d&&w&&S?[]:!1;for(r=0,i=e.length;r<i;r++){a=e[r],a instanceof p?s=o=a:s=a[h.prototype.idAttribute];if(f=this.get(s))S&&(b[f.cid]=!0),E&&(a=a===o?o.attributes:a,t.parse&&(a=f.parse(a,t)),f.set(a,t),d&&!l&&f.hasChanged(v)&&(l=!0)),e[r]=f;else if(w){o=e[r]=this._prepareModel(a,t);if(!o)continue;g.push(o),o.on("all",this._onModelEvent,this),this._byId[o.cid]=o,o.id!=null&&(this._byId[o.id]=o)}x&&x.push(f||o)}if(S){for(r=0,i=this.length;r<i;++r)b[(o=this.models[r]).cid]||y.push(o);y.length&&this.remove(y,t)}if(g.length||x&&x.length){d&&(l=!0),this.length+=g.length;if(c!=null)for(r=0,i=g.length;r<i;r++)this.models.splice(c+r,0,g[r]);else{x&&(this.models.length=0);var T=x||g;for(r=0,i=T.length;r<i;r++)this.models.push(T[r])}}l&&this.sort({silent:!0});if(!t.silent){for(r=0,i=g.length;r<i;r++)(o=g[r]).trigger("add",o,this,t);(l||x&&x.length)&&this.trigger("sort",this,t)}return n?e[0]:e},reset:function(e,t){t||(t={});for(var n=0,r=this.models.length;n<r;n++)this._removeReference(this.models[n]);return t.previousModels=this.models,this._reset(),e=this.add(e,u.extend({silent:!0},t)),t.silent||this.trigger("reset",this,t),e},push:function(e,t){return this.add(e,u.extend({at:this.length},t))},pop:function(e){var t=this.at(this.length-1);return this.remove(t,e),t},unshift:function(e,t){return this.add(e,u.extend({at:0},t))},shift:function(e){var t=this.at(0);return this.remove(t,e),t},slice:function(){return i.apply(this.models,arguments)},get:function(e){return e==null?void 0:this._byId[e.id]||this._byId[e.cid]||this._byId[e]},at:function(e){return this.models[e]},where:function(e,t){return u.isEmpty(e)?t?void 0:[]:this[t?"find":"filter"](function(t){for(var n in e)if(e[n]!==t.get(n))return!1;return!0})},findWhere:function(e){return this.where(e,!0)},sort:function(e){if(!this.comparator)throw new Error("Cannot sort a set without a comparator");return e||(e={}),u.isString(this.comparator)||this.comparator.length===1?this.models=this.sortBy(this.comparator,this):this.models.sort(u.bind(this.comparator,this)),e.silent||this.trigger("sort",this,e),this},pluck:function(e){return u.invoke(this.models,"get",e)},fetch:function(e){e=e?u.clone(e):{},e.parse===void 0&&(e.parse=!0);var t=e.success,n=this;return e.success=function(r){var i=e.reset?"reset":"set";n[i](r,e),t&&t(n,r,e),n.trigger("sync",n,r,e)},F(this,e),this.sync("read",this,e)},create:function(e,t){t=t?u.clone(t):{};if(!(e=this._prepareModel(e,t)))return!1;t.wait||this.add(e,t);var n=this,r=t.success;return t.success=function(e,t,i){i.wait&&n.add(e,i),r&&r(e,t,i)},e.save(null,t),e},parse:function(e,t){return e},clone:function(){return new this.constructor(this.models)},_reset:function(){this.length=0,this.models=[],this._byId={}},_prepareModel:function(e,t){if(e instanceof p)return e.collection||(e.collection=this),e;t=t?u.clone(t):{},t.collection=this;var n=new this.model(e,t);return n.validationError?(this.trigger("invalid",this,n.validationError,t),!1):n},_removeReference:function(e){this===e.collection&&delete e.collection,e.off("all",this._onModelEvent,this)},_onModelEvent:function(e,t,n,r){if((e==="add"||e==="remove")&&n!==this)return;e==="destroy"&&this.remove(t,r),t&&e==="change:"+t.idAttribute&&(delete this._byId[t.previous(t.idAttribute)],t.id!=null&&(this._byId[t.id]=t)),this.trigger.apply(this,arguments)}});var y=["forEach","each","map","collect","reduce","foldl","inject","reduceRight","foldr","find","detect","filter","select","reject","every","all","some","any","include","contains","invoke","max","min","toArray","size","first","head","take","initial","rest","tail","drop","last","without","difference","indexOf","shuffle","lastIndexOf","isEmpty","chain"];u.each(y,function(e){v.prototype[e]=function(){var t=i.call(arguments);return t.unshift(this.models),u[e].apply(u,t)}});var b=["groupBy","countBy","sortBy"];u.each(b,function(e){v.prototype[e]=function(t,n){var r=u.isFunction(t)?t:function(e){return e.get(t)};return u[e](this.models,r,n)}});var w=o.View=function(e){this.cid=u.uniqueId("view"),e||(e={}),u.extend(this,u.pick(e,S)),this._ensureElement(),this.initialize.apply(this,arguments),this.delegateEvents()},E=/^(\S+)\s*(.*)$/,S=["model","collection","el","id","attributes","className","tagName","events"];u.extend(w.prototype,a,{tagName:"div",$:function(e){return this.$el.find(e)},initialize:function(){},render:function(){return this},remove:function(){return this.$el.remove(),this.stopListening(),this},setElement:function(e,t){return this.$el&&this.undelegateEvents(),this.$el=e instanceof o.$?e:o.$(e),this.el=this.$el[0],t!==!1&&this.delegateEvents(),this},delegateEvents:function(e){if(!e&&!(e=u.result(this,"events")))return this;this.undelegateEvents();for(var t in e){var n=e[t];u.isFunction(n)||(n=this[e[t]]);if(!n)continue;var r=t.match(E),i=r[1],s=r[2];n=u.bind(n,this),i+=".delegateEvents"+this.cid,s===""?this.$el.on(i,n):this.$el.on(i,s,n)}return this},undelegateEvents:function(){return this.$el.off(".delegateEvents"+this.cid),this},_ensureElement:function(){if(!this.el){var e=u.extend({},u.result(this,"attributes"));this.id&&(e.id=u.result(this,"id")),this.className&&(e["class"]=u.result(this,"className"));var t=o.$("<"+u.result(this,"tagName")+">").attr(e);this.setElement(t,!1)}else this.setElement(u.result(this,"el"),!1)}}),o.sync=function(e,t,n){var r=T[e];u.defaults(n||(n={}),{emulateHTTP:o.emulateHTTP,emulateJSON:o.emulateJSON});var i={type:r,dataType:"json"};n.url||(i.url=u.result(t,"url")||j()),n.data==null&&t&&(e==="create"||e==="update"||e==="patch")&&(i.contentType="application/json",i.data=JSON.stringify(n.attrs||t.toJSON(n))),n.emulateJSON&&(i.contentType="application/x-www-form-urlencoded",i.data=i.data?{model:i.data}:{});if(n.emulateHTTP&&(r==="PUT"||r==="DELETE"||r==="PATCH")){i.type="POST",n.emulateJSON&&(i.data._method=r);var s=n.beforeSend;n.beforeSend=function(e){e.setRequestHeader("X-HTTP-Method-Override",r);if(s)return s.apply(this,arguments)}}i.type!=="GET"&&!n.emulateJSON&&(i.processData=!1),i.type==="PATCH"&&x&&(i.xhr=function(){return new ActiveXObject("Microsoft.XMLHTTP")});var a=n.xhr=o.ajax(u.extend(i,n));return t.trigger("request",t,a,n),a};var x=typeof window!="undefined"&&!!window.ActiveXObject&&(!window.XMLHttpRequest||!(new XMLHttpRequest).dispatchEvent),T={create:"POST",update:"PUT",patch:"PATCH","delete":"DELETE",read:"GET"};o.ajax=function(){return o.$.ajax.apply(o.$,arguments)};var N=o.Router=function(e){e||(e={}),e.routes&&(this.routes=e.routes),this._bindRoutes(),this.initialize.apply(this,arguments)},C=/\((.*?)\)/g,k=/(\(\?)?:\w+/g,L=/\*\w+/g,A=/[\-{}\[\]+?.,\\\^$|#\s]/g;u.extend(N.prototype,a,{initialize:function(){},route:function(e,t,n){u.isRegExp(e)||(e=this._routeToRegExp(e)),u.isFunction(t)&&(n=t,t=""),n||(n=this[t]);var r=this;return o.history.route(e,function(i){var s=r._extractParameters(e,i);n&&n.apply(r,s),r.trigger.apply(r,["route:"+t].concat(s)),r.trigger("route",t,s),o.history.trigger("route",r,t,s)}),this},navigate:function(e,t){return o.history.navigate(e,t),this},_bindRoutes:function(){if(!this.routes)return;this.routes=u.result(this,"routes");var e,t=u.keys(this.routes);while((e=t.pop())!=null)this.route(e,this.routes[e])},_routeToRegExp:function(e){return e=e.replace(A,"\\$&").replace(C,"(?:$1)?").replace(k,function(e,t){return t?e:"([^/]+)"}).replace(L,"(.*?)"),new RegExp("^"+e+"$")},_extractParameters:function(e,t){var n=e.exec(t).slice(1);return u.map(n,function(e){return e?decodeURIComponent(e):null})}});var O=o.History=function(){this.handlers=[],u.bindAll(this,"checkUrl"),typeof window!="undefined"&&(this.location=window.location,this.history=window.history)},M=/^[#\/]|\s+$/g,_=/^\/+|\/+$/g,D=/msie [\w.]+/,P=/\/$/,H=/[?#].*$/;O.started=!1,u.extend(O.prototype,a,{interval:50,getHash:function(e){var t=(e||this).location.href.match(/#(.*)$/);return t?t[1]:""},getFragment:function(e,t){if(e==null)if(this._hasPushState||!this._wantsHashChange||t){e=this.location.pathname;var n=this.root.replace(P,"");e.indexOf(n)||(e=e.slice(n.length))}else e=this.getHash();return e.replace(M,"")},start:function(e){if(O.started)throw new Error("Backbone.history has already been started");O.started=!0,this.options=u.extend({root:"/"},this.options,e),this.root=this.options.root,this._wantsHashChange=this.options.hashChange!==!1,this._wantsPushState=!!this.options.pushState,this._hasPushState=!!(this.options.pushState&&this.history&&this.history.pushState);var t=this.getFragment(),n=document.documentMode,r=D.exec(navigator.userAgent.toLowerCase())&&(!n||n<=7);this.root=("/"+this.root+"/").replace(_,"/"),r&&this._wantsHashChange&&(this.iframe=o.$('<iframe src="javascript:0" tabindex="-1" />').hide().appendTo("body")[0].contentWindow,this.navigate(t)),this._hasPushState?o.$(window).on("popstate",this.checkUrl):this._wantsHashChange&&"onhashchange"in window&&!r?o.$(window).on("hashchange",this.checkUrl):this._wantsHashChange&&(this._checkUrlInterval=setInterval(this.checkUrl,this.interval)),this.fragment=t;var i=this.location,s=i.pathname.replace(/[^\/]$/,"$&/")===this.root;if(this._wantsHashChange&&this._wantsPushState){if(!this._hasPushState&&!s)return this.fragment=this.getFragment(null,!0),this.location.replace(this.root+this.location.search+"#"+this.fragment),!0;this._hasPushState&&s&&i.hash&&(this.fragment=this.getHash().replace(M,""),this.history.replaceState({},document.title,this.root+this.fragment+i.search))}if(!this.options.silent)return this.loadUrl()},stop:function(){o.$(window).off("popstate",this.checkUrl).off("hashchange",this.checkUrl),clearInterval(this._checkUrlInterval),O.started=!1},route:function(e,t){this.handlers.unshift({route:e,callback:t})},checkUrl:function(e){var t=this.getFragment();t===this.fragment&&this.iframe&&(t=this.getFragment(this.getHash(this.iframe)));if(t===this.fragment)return!1;this.iframe&&this.navigate(t),this.loadUrl()},loadUrl:function(e){return e=this.fragment=this.getFragment(e),u.any(this.handlers,function(t){if(t.route.test(e))return t.callback(e),!0})},navigate:function(e,t){if(!O.started)return!1;if(!t||t===!0)t={trigger:!!t};var n=this.root+(e=this.getFragment(e||""));e=e.replace(H,"");if(this.fragment===e)return;this.fragment=e,e===""&&n!=="/"&&(n=n.slice(0,-1));if(this._hasPushState)this.history[t.replace?"replaceState":"pushState"]({},document.title,n);else{if(!this._wantsHashChange)return this.location.assign(n);this._updateHash(this.location,e,t.replace),this.iframe&&e!==this.getFragment(this.getHash(this.iframe))&&(t.replace||this.iframe.document.open().close(),this._updateHash(this.iframe.location,e,t.replace))}if(t.trigger)return this.loadUrl(e)},_updateHash:function(e,t,n){if(n){var r=e.href.replace(/(javascript:|#).*$/,"");e.replace(r+"#"+t)}else e.hash="#"+t}}),o.history=new O;var B=function(e,t){var n=this,r;e&&u.has(e,"constructor")?r=e.constructor:r=function(){return n.apply(this,arguments)},u.extend(r,n,t);var i=function(){this.constructor=r};return i.prototype=n.prototype,r.prototype=new i,e&&u.extend(r.prototype,e),r.__super__=n.prototype,r};p.extend=v.extend=N.extend=w.extend=O.extend=B;var j=function(){throw new Error('A "url" property or function must be specified')},F=function(e,t){var n=t.error;t.error=function(r){n&&n(e,r,t),e.trigger("error",e,r,t)}}}.call(this),define("backbone",["underscore","jquery"],function(e){return function(){var t,n;return t||e.window.Backbone}}(this)),define("mockup-router",["jquery","underscore","backbone"],function(e,t,n){var r=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")},i=n.Router.extend({actions:[],redirects:{},addRoute:function(e,n,i,s,o,u){t.findWhere(this.patterns,{patternName:e,id:n})===undefined&&this.actions.push({patternName:e,id:n,callback:i,context:s,pathExp:o,expReplace:u});var a=new RegExp("("+r(e)+":"+r(n)+")");this.route(a,"handleRoute")},addRedirect:function(e,t){this.redirects[e]=t},handleRoute:function(e){var n=e.split(":"),r=n[0],i=n[1],s=t.findWhere(this.actions,{patternName:r,id:i});s&&s.callback.call(s.context)},redirect:function(){var e=window.parent.location.pathname,n,r,i;t.some(this.actions,function(t){if(t.pathExp){r=new RegExp(t.pathExp);if(e.match(r)){i="!/"+t.patternName+":"+t.id;var s="";return t.expReplace&&(s=t.expReplace),n=e.replace(r,s),!0}}},this);if(i===undefined)for(var s in this.redirects){r=new RegExp(s);if(e.match(r)){i="!/"+this.redirects[s],n=e.replace(r,"");break}}i!==undefined&&this._changeLocation.apply(this,[n,i])},_changeLocation:function(e,t){window.parent.location.hash=t,window.parent.location.pathname=e},start:function(){n.history.start()},reset:function(){this.actions=[]}});return new i}),define("mockup-utils",["jquery"],function(e){var t=function(t){var n=this,r={pattern:null,vocabularyUrl:null,searchParam:"SearchableText",attributes:["UID","Title","Description","getURL","Type"],batchSize:10,baseCriteria:[],pathDepth:1};n.options=e.extend({},r,t),n.pattern=n.options.pattern;if(n.pattern===undefined||n.pattern===null)n.pattern={browsing:!1,basePath:"/"};return n.options.url&&!n.options.vocabularyUrl?n.options.vocabularyUrl=n.options.url:n.pattern.vocabularyUrl&&(n.options.vocabularyUrl=n.pattern.vocabularyUrl),n.options.vocabularyUrl!==undefined&&n.options.vocabularyUrl!==null?n.valid=!0:n.valid=!1,n.getCurrentPath=function(){var e=n.pattern,t;n.currentPath?t=n.currentPath:t=e.currentPath,typeof t=="function"&&(t=t());var r=t;return r||(e.basePath?r=e.basePath:e.options.basePath?r=e.options.basePath:r="/"),r},n.getCriterias=function(t,r){r===undefined&&(r={}),r=e.extend({},{useBaseCriteria:!0,additionalCriterias:[]},r);var i=[];return r.useBaseCriteria&&(i=n.options.baseCriteria.slice(0)),t&&(t+="*",i.push({i:n.options.searchParam,o:"plone.app.querystring.operation.string.contains",v:t})),n.pattern.browsing&&i.push({i:"path",o:"plone.app.querystring.operation.string.path",v:n.getCurrentPath()+"::"+n.options.pathDepth}),i=i.concat(r.additionalCriterias),i},n.getBatch=function(e){return e||(e=1),{page:e,size:n.options.batchSize}},n.selectAjax=function(){return{url:n.options.vocabularyUrl,dataType:"JSON",quietMillis:100,data:function(e,t){return n.getQueryData(e,t)},results:function(e,t){var n=t*10<e.total;return{results:e.results,more:n}}}},n.getUrl=function(){var t=n.options.vocabularyUrl;return t.indexOf("?")===-1?t+="?":t+="&",t+e.param(n.getQueryData())},n.getQueryData=function(e,t){var r={query:JSON.stringify({criteria:n.getCriterias(e)}),attributes:JSON.stringify(n.options.attributes)};return t&&(r.batch=JSON.stringify(n.getBatch(t))),r},n.search=function(t,r,i,s,o){o===undefined&&(o=!0);var u=[];o&&(u=n.options.baseCriteria.slice(0)),u.push({i:t,o:r,v:i});var a={query:JSON.stringify({criteria:u}),attributes:JSON.stringify(n.options.attributes)};e.ajax({url:n.options.vocabularyUrl,dataType:"JSON",data:a,success:s})},n},n=function(t){var n=this,r={className:"progress-indicator",container:null,backdrop:null,wrapper:null,zIndex:10005};return t||(t={}),n.options=e.extend({},r,t),n.options.container===null&&(n.options.container=e("body")),n.$loading=e("> ."+n.options.className,n.options.container),n.$loading.size()===0&&(n.$loading=e("<div/>").hide().addClass(n.options.className).appendTo(n.options.container)),n.$wrapper=n.options.wrapper,n.$wrapper===null&&(n.$wrapper=n.options.container),n.show=function(e){e===undefined&&(e=!0),n.options.backdrop&&(n.options.backdrop.closeOnClick=e,n.options.backdrop.closeOnEsc=e,n.options.backdrop.init()),n.$wrapper.parent().css("overflow","hidden"),n.$wrapper.show(),n.options.backdrop&&n.options.backdrop.show(),n.$loading.show(),n.position()},n.position=function(){n.$loading.css({"margin-left":n.$wrapper.width()/2-n.$loading.width()/2,"margin-top":n.$wrapper.height()/2-n.$loading.height()/2,position:"absolute",bottom:"0",left:"0",right:"0",top:"0"});var e=n.options.zIndex;typeof e=="function"&&(e=e()),n.$loading.css("zIndex",e)},n.hide=function(){n.$loading.hide(),n.$wrapper.parent().css("overflow","")},n};return{parseBodyTag:function(t){return e(/<body[^>]*>((.|[\n\r])*)<\/body>/im.exec(t)[0].replace("<body","<div").replace("</body>","</div>")).eq(0).html()},setId:function(e,t){t===undefined&&(t="id");var n=e.attr("id");return n===undefined?n=t+Math.floor((1+Math.random())*65536).toString(16).substring(1):n=n.replace(/\./g,"-"),e.attr("id",n),n},bool:function(t){return typeof t=="string"&&(t=e.trim(t).toLowerCase()),["true",!0,1].indexOf(t)!==-1},QueryHelper:t,ProgressIndicator:n}}),function(e){typeof define=="function"&&define.amd?define("jquery.form",["jquery"],e):e(typeof jQuery!="undefined"?jQuery:window.Zepto)}(function(e){function r(t){var n=t.data;t.isDefaultPrevented()||(t.preventDefault(),e(t.target).ajaxSubmit(n))}function i(t){var n=t.target,r=e(n);if(!r.is("[type=submit],[type=image]")){var i=r.closest("[type=submit]");if(i.length===0)return;n=i[0]}var s=this;s.clk=n;if(n.type=="image")if(t.offsetX!==undefined)s.clk_x=t.offsetX,s.clk_y=t.offsetY;else if(typeof e.fn.offset=="function"){var o=r.offset();s.clk_x=t.pageX-o.left,s.clk_y=t.pageY-o.top}else s.clk_x=t.pageX-n.offsetLeft,s.clk_y=t.pageY-n.offsetTop;setTimeout(function(){s.clk=s.clk_x=s.clk_y=null},100)}function s(){if(!e.fn.ajaxSubmit.debug)return;var t="[jquery.form] "+Array.prototype.join.call(arguments,"");window.console&&window.console.log?window.console.log(t):window.opera&&window.opera.postError&&window.opera.postError(t)}var t={};t.fileapi=e("<input type='file'/>").get(0).files!==undefined,t.formdata=window.FormData!==undefined;var n=!!e.fn.prop;e.fn.attr2=function(){if(!n)return this.attr.apply(this,arguments);var e=this.prop.apply(this,arguments);return e&&e.jquery||typeof e=="string"?e:this.attr.apply(this,arguments)},e.fn.ajaxSubmit=function(r){function k(t){var n=e.param(t,r.traditional).split("&"),i=n.length,s=[],o,u;for(o=0;o<i;o++)n[o]=n[o].replace(/\+/g," "),u=n[o].split("="),s.push([decodeURIComponent(u[0]),decodeURIComponent(u[1])]);return s}function L(t){var n=new FormData;for(var s=0;s<t.length;s++)n.append(t[s].name,t[s].value);if(r.extraData){var o=k(r.extraData);for(s=0;s<o.length;s++)o[s]&&n.append(o[s][0],o[s][1])}r.data=null;var u=e.extend(!0,{},e.ajaxSettings,r,{contentType:!1,processData:!1,cache:!1,type:i||"POST"});r.uploadProgress&&(u.xhr=function(){var t=e.ajaxSettings.xhr();return t.upload&&t.upload.addEventListener("progress",function(e){var t=0,n=e.loaded||e.position,i=e.total;e.lengthComputable&&(t=Math.ceil(n/i*100)),r.uploadProgress(e,n,i,t)},!1),t}),u.data=null;var a=u.beforeSend;return u.beforeSend=function(e,t){r.formData?t.data=r.formData:t.data=n,a&&a.call(this,e,t)},e.ajax(u)}function A(t){function T(e){var t=null;try{e.contentWindow&&(t=e.contentWindow.document)}catch(n){s("cannot get iframe.contentWindow document: "+n)}if(t)return t;try{t=e.contentDocument?e.contentDocument:e.document}catch(n){s("cannot get iframe.contentDocument: "+n),t=e.document}return t}function k(){function r(){try{var e=T(v).readyState;s("state = "+e),e&&e.toLowerCase()=="uninitialized"&&setTimeout(r,50)}catch(t){s("Server abort: ",t," (",t.name,")"),_(x),w&&clearTimeout(w),w=undefined}}var t=a.attr2("target"),n=a.attr2("action");o.setAttribute("target",p),(!i||/post/i.test(i))&&o.setAttribute("method","POST"),n!=l.url&&o.setAttribute("action",l.url),!l.skipEncodingOverride&&(!i||/post/i.test(i))&&a.attr({encoding:"multipart/form-data",enctype:"multipart/form-data"}),l.timeout&&(w=setTimeout(function(){b=!0,_(S)},l.timeout));var u=[];try{if(l.extraData)for(var f in l.extraData)l.extraData.hasOwnProperty(f)&&(e.isPlainObject(l.extraData[f])&&l.extraData[f].hasOwnProperty("name")&&l.extraData[f].hasOwnProperty("value")?u.push(e('<input type="hidden" name="'+l.extraData[f].name+'">').val(l.extraData[f].value).appendTo(o)[0]):u.push(e('<input type="hidden" name="'+f+'">').val(l.extraData[f]).appendTo(o)[0]));l.iframeTarget||d.appendTo("body"),v.attachEvent?v.attachEvent("onload",_):v.addEventListener("load",_,!1),setTimeout(r,15);try{o.submit()}catch(c){var h=document.createElement("form").submit;h.apply(o)}}finally{o.setAttribute("action",n),t?o.setAttribute("target",t):a.removeAttr("target"),e(u).remove()}}function _(t){if(m.aborted||M)return;A=T(v),A||(s("cannot access response document"),t=x);if(t===S&&m){m.abort("timeout"),E.reject(m,"timeout");return}if(t==x&&m){m.abort("server abort"),E.reject(m,"error","server abort");return}if(!A||A.location.href==l.iframeSrc)if(!b)return;v.detachEvent?v.detachEvent("onload",_):v.removeEventListener("load",_,!1);var n="success",r;try{if(b)throw"timeout";var i=l.dataType=="xml"||A.XMLDocument||e.isXMLDoc(A);s("isXml="+i);if(!i&&window.opera&&(A.body===null||!A.body.innerHTML)&&--O){s("requeing onLoad callback, DOM not available"),setTimeout(_,250);return}var o=A.body?A.body:A.documentElement;m.responseText=o?o.innerHTML:null,m.responseXML=A.XMLDocument?A.XMLDocument:A,i&&(l.dataType="xml"),m.getResponseHeader=function(e){var t={"content-type":l.dataType};return t[e.toLowerCase()]},o&&(m.status=Number(o.getAttribute("status"))||m.status,m.statusText=o.getAttribute("statusText")||m.statusText);var u=(l.dataType||"").toLowerCase(),a=/(json|script|text)/.test(u);if(a||l.textarea){var f=A.getElementsByTagName("textarea")[0];if(f)m.responseText=f.value,m.status=Number(f.getAttribute("status"))||m.status,m.statusText=f.getAttribute("statusText")||m.statusText;else if(a){var c=A.getElementsByTagName("pre")[0],p=A.getElementsByTagName("body")[0];c?m.responseText=c.textContent?c.textContent:c.innerText:p&&(m.responseText=p.textContent?p.textContent:p.innerText)}}else u=="xml"&&!m.responseXML&&m.responseText&&(m.responseXML=D(m.responseText));try{L=H(m,u,l)}catch(g){n="parsererror",m.error=r=g||n}}catch(g){s("error caught: ",g),n="error",m.error=r=g||n}m.aborted&&(s("upload aborted"),n=null),m.status&&(n=m.status>=200&&m.status<300||m.status===304?"success":"error"),n==="success"?(l.success&&l.success.call(l.context,L,"success",m),E.resolve(m.responseText,"success",m),h&&e.event.trigger("ajaxSuccess",[m,l])):n&&(r===undefined&&(r=m.statusText),l.error&&l.error.call(l.context,m,n,r),E.reject(m,"error",r),h&&e.event.trigger("ajaxError",[m,l,r])),h&&e.event.trigger("ajaxComplete",[m,l]),h&&!--e.active&&e.event.trigger("ajaxStop"),l.complete&&l.complete.call(l.context,m,n),M=!0,l.timeout&&clearTimeout(w),setTimeout(function(){l.iframeTarget?d.attr("src",l.iframeSrc):d.remove(),m.responseXML=null},100)}var o=a[0],u,f,l,h,p,d,v,m,g,y,b,w,E=e.Deferred();E.abort=function(e){m.abort(e)};if(t)for(f=0;f<c.length;f++)u=e(c[f]),n?u.prop("disabled",!1):u.removeAttr("disabled");l=e.extend(!0,{},e.ajaxSettings,r),l.context=l.context||l,p="jqFormIO"+(new Date).getTime(),l.iframeTarget?(d=e(l.iframeTarget),y=d.attr2("name"),y?p=y:d.attr2("name",p)):(d=e('<iframe name="'+p+'" src="'+l.iframeSrc+'" />'),d.css({position:"absolute",top:"-1000px",left:"-1000px"})),v=d[0],m={aborted:0,responseText:null,responseXML:null,status:0,statusText:"n/a",getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){},abort:function(t){var n=t==="timeout"?"timeout":"aborted";s("aborting upload... "+n),this.aborted=1;try{v.contentWindow.document.execCommand&&v.contentWindow.document.execCommand("Stop")}catch(r){}d.attr("src",l.iframeSrc),m.error=n,l.error&&l.error.call(l.context,m,n,t),h&&e.event.trigger("ajaxError",[m,l,n]),l.complete&&l.complete.call(l.context,m,n)}},h=l.global,h&&0===e.active++&&e.event.trigger("ajaxStart"),h&&e.event.trigger("ajaxSend",[m,l]);if(l.beforeSend&&l.beforeSend.call(l.context,m,l)===!1)return l.global&&e.active--,E.reject(),E;if(m.aborted)return E.reject(),E;g=o.clk,g&&(y=g.name,y&&!g.disabled&&(l.extraData=l.extraData||{},l.extraData[y]=g.value,g.type=="image"&&(l.extraData[y+".x"]=o.clk_x,l.extraData[y+".y"]=o.clk_y)));var S=1,x=2,N=e("meta[name=csrf-token]").attr("content"),C=e("meta[name=csrf-param]").attr("content");C&&N&&(l.extraData=l.extraData||{},l.extraData[C]=N),l.forceSync?k():setTimeout(k,10);var L,A,O=50,M,D=e.parseXML||function(e,t){return window.ActiveXObject?(t=new ActiveXObject("Microsoft.XMLDOM"),t.async="false",t.loadXML(e)):t=(new DOMParser).parseFromString(e,"text/xml"),t&&t.documentElement&&t.documentElement.nodeName!="parsererror"?t:null},P=e.parseJSON||function(e){return window.eval("("+e+")")},H=function(t,n,r){var i=t.getResponseHeader("content-type")||"",s=n==="xml"||!n&&i.indexOf("xml")>=0,o=s?t.responseXML:t.responseText;return s&&o.documentElement.nodeName==="parsererror"&&e.error&&e.error("parsererror"),r&&r.dataFilter&&(o=r.dataFilter(o,n)),typeof o=="string"&&(n==="json"||!n&&i.indexOf("json")>=0?o=P(o):(n==="script"||!n&&i.indexOf("javascript")>=0)&&e.globalEval(o)),o};return E}if(!this.length)return s("ajaxSubmit: skipping submit process - no element selected"),this;var i,o,u,a=this;typeof r=="function"?r={success:r}:r===undefined&&(r={}),i=r.type||this.attr2("method"),o=r.url||this.attr2("action"),u=typeof o=="string"?e.trim(o):"",u=u||window.location.href||"",u&&(u=(u.match(/^([^#]+)/)||[])[1]),r=e.extend(!0,{url:u,success:e.ajaxSettings.success,type:i||e.ajaxSettings.type,iframeSrc:/^https/i.test(window.location.href||"")?"javascript:false":"about:blank"},r);var f={};this.trigger("form-pre-serialize",[this,r,f]);if(f.veto)return s("ajaxSubmit: submit vetoed via form-pre-serialize trigger"),this;if(r.beforeSerialize&&r.beforeSerialize(this,r)===!1)return s("ajaxSubmit: submit aborted via beforeSerialize callback"),this;var l=r.traditional;l===undefined&&(l=e.ajaxSettings.traditional);var c=[],h,p=this.formToArray(r.semantic,c);r.data&&(r.extraData=r.data,h=e.param(r.data,l));if(r.beforeSubmit&&r.beforeSubmit(p,this,r)===!1)return s("ajaxSubmit: submit aborted via beforeSubmit callback"),this;this.trigger("form-submit-validate",[p,this,r,f]);if(f.veto)return s("ajaxSubmit: submit vetoed via form-submit-validate trigger"),this;var d=e.param(p,l);h&&(d=d?d+"&"+h:h),r.type.toUpperCase()=="GET"?(r.url+=(r.url.indexOf("?")>=0?"&":"?")+d,r.data=null):r.data=d;var v=[];r.resetForm&&v.push(function(){a.resetForm()}),r.clearForm&&v.push(function(){a.clearForm(r.includeHidden)});if(!r.dataType&&r.target){var m=r.success||function(){};v.push(function(t){var n=r.replaceTarget?"replaceWith":"html";e(r.target)[n](t).each(m,arguments)})}else r.success&&v.push(r.success);r.success=function(e,t,n){var i=r.context||this;for(var s=0,o=v.length;s<o;s++)v[s].apply(i,[e,t,n||a,a])};if(r.error){var g=r.error;r.error=function(e,t,n){var i=r.context||this;g.apply(i,[e,t,n,a])}}if(r.complete){var y=r.complete;r.complete=function(e,t){var n=r.context||this;y.apply(n,[e,t,a])}}var b=e("input[type=file]:enabled",this).filter(function(){return e(this).val()!==""}),w=b.length>0,E="multipart/form-data",S=a.attr("enctype")==E||a.attr("encoding")==E,x=t.fileapi&&t.formdata;s("fileAPI :"+x);var T=(w||S)&&!x,N;r.iframe!==!1&&(r.iframe||T)?r.closeKeepAlive?e.get(r.closeKeepAlive,function(){N=A(p)}):N=A(p):(w||S)&&x?N=L(p):N=e.ajax(r),a.removeData("jqxhr").data("jqxhr",N);for(var C=0;C<c.length;C++)c[C]=null;return this.trigger("form-submit-notify",[this,r]),this},e.fn.ajaxForm=function(t){t=t||{},t.delegation=t.delegation&&e.isFunction(e.fn.on);if(!t.delegation&&this.length===0){var n={s:this.selector,c:this.context};return!e.isReady&&n.s?(s("DOM not ready, queuing ajaxForm"),e(function(){e(n.s,n.c).ajaxForm(t)}),this):(s("terminating; zero elements found by selector"+(e.isReady?"":" (DOM not ready)")),this)}return t.delegation?(e(document).off("submit.form-plugin",this.selector,r).off("click.form-plugin",this.selector,i).on("submit.form-plugin",this.selector,t,r).on("click.form-plugin",this.selector,t,i),this):this.ajaxFormUnbind().bind("submit.form-plugin",t,r).bind("click.form-plugin",t,i)},e.fn.ajaxFormUnbind=function(){return this.unbind("submit.form-plugin click.form-plugin")},e.fn.formToArray=function(n,r){var i=[];if(this.length===0)return i;var s=this[0],o=n?s.getElementsByTagName("*"):s.elements;if(!o)return i;var u,a,f,l,c,h,p;for(u=0,h=o.length;u<h;u++){c=o[u],f=c.name;if(!f||c.disabled)continue;if(n&&s.clk&&c.type=="image"){s.clk==c&&(i.push({name:f,value:e(c).val(),type:c.type}),i.push({name:f+".x",value:s.clk_x},{name:f+".y",value:s.clk_y}));continue}l=e.fieldValue(c,!0);if(l&&l.constructor==Array){r&&r.push(c);for(a=0,p=l.length;a<p;a++)i.push({name:f,value:l[a]})}else if(t.fileapi&&c.type=="file"){r&&r.push(c);var d=c.files;if(d.length)for(a=0;a<d.length;a++)i.push({name:f,value:d[a],type:c.type});else i.push({name:f,value:"",type:c.type})}else l!==null&&typeof l!="undefined"&&(r&&r.push(c),i.push({name:f,value:l,type:c.type,required:c.required}))}if(!n&&s.clk){var v=e(s.clk),m=v[0];f=m.name,f&&!m.disabled&&m.type=="image"&&(i.push({name:f,value:v.val()}),i.push({name:f+".x",value:s.clk_x},{name:f+".y",value:s.clk_y}))}return i},e.fn.formSerialize=function(t){return e.param(this.formToArray(t))},e.fn.fieldSerialize=function(t){var n=[];return this.each(function(){var r=this.name;if(!r)return;var i=e.fieldValue(this,t);if(i&&i.constructor==Array)for(var s=0,o=i.length;s<o;s++)n.push({name:r,value:i[s]});else i!==null&&typeof i!="undefined"&&n.push({name:this.name,value:i})}),e.param(n)},e.fn.fieldValue=function(t){for(var n=[],r=0,i=this.length;r<i;r++){var s=this[r],o=e.fieldValue(s,t);if(o===null||typeof o=="undefined"||o.constructor==Array&&!o.length)continue;o.constructor==Array?e.merge(n,o):n.push(o)}return n},e.fieldValue=function(t,n){var r=t.name,i=t.type,s=t.tagName.toLowerCase();n===undefined&&(n=!0);if(n&&(!r||t.disabled||i=="reset"||i=="button"||(i=="checkbox"||i=="radio")&&!t.checked||(i=="submit"||i=="image")&&t.form&&t.form.clk!=t||s=="select"&&t.selectedIndex==-1))return null;if(s=="select"){var o=t.selectedIndex;if(o<0)return null;var u=[],a=t.options,f=i=="select-one",l=f?o+1:a.length;for(var c=f?o:0;c<l;c++){var h=a[c];if(h.selected){var p=h.value;p||(p=h.attributes&&h.attributes.value&&!h.attributes.value.specified?h.text:h.value);if(f)return p;u.push(p)}}return u}return e(t).val()},e.fn.clearForm=function(t){return this.each(function(){e("input,select,textarea",this).clearFields(t)})},e.fn.clearFields=e.fn.clearInputs=function(t){var n=/^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;return this.each(function(){var r=this.type,i=this.tagName.toLowerCase();n.test(r)||i=="textarea"?this.value="":r=="checkbox"||r=="radio"?this.checked=!1:i=="select"?this.selectedIndex=-1:r=="file"?/MSIE/.test(navigator.userAgent)?e(this).replaceWith(e(this).clone(!0)):e(this).val(""):t&&(t===!0&&/hidden/.test(r)||typeof t=="string"&&e(this).is(t))&&(this.value="")})},e.fn.resetForm=function(){return this.each(function(){(typeof this.reset=="function"||typeof this.reset=="object"&&!this.reset.nodeType)&&this.reset()})},e.fn.enable=function(e){return e===undefined&&(e=!0),this.each(function(){this.disabled=!e})},e.fn.selected=function(t){return t===undefined&&(t=!0),this.each(function(){var n=this.type;if(n=="checkbox"||n=="radio")this.checked=t;else if(this.tagName.toLowerCase()=="option"){var r=e(this).parent("select");t&&r[0]&&r[0].type=="select-one"&&r.find("option").selected(!1),this.selected=t}})},e.fn.ajaxSubmit.debug=!1}),define("mockup-patterns-modal",["jquery","underscore","mockup-patterns-base","mockup-patterns-backdrop","mockup-registry","mockup-router","mockup-utils","jquery.form"],function(e,t,n,r,i,s,o){var u=n.extend({name:"modal",createModal:null,$model:null,defaults:{width:"",height:"",margin:20,position:"center middle",triggers:[],backdrop:"body",backdropOptions:{zIndex:"1040",opacity:"0.8",className:"backdrop",classActiveName:"backdrop-active",closeOnEsc:!0,closeOnClick:!0},title:null,titleSelector:"h1:first",buttons:'.formControls > input[type="submit"]',content:"#content",automaticallyAddButtonActions:!0,loadLinksWithinModal:!0,prependContent:".portalMessage",templateOptions:{className:"modal fade",classDialog:"modal-dialog",classModal:"modal-content",classHeaderName:"modal-header",classBodyName:"modal-body",classFooterName:"modal-footer",classWrapperName:"modal-wrapper",classWrapperInnerName:"modal-wrapper-inner",classActiveName:"in",classPrependName:"",classContentName:"",template:'<div class="<%= options.className %>">  <div class="<%= options.classDialog %>">    <div class="<%= options.classModal %>">      <div class="<%= options.classHeaderName %>">        <a class="close">&times;</a>        <% if (title) { %><h3><%= title %></h3><% } %>      </div>      <div class="<%= options.classBodyName %>">        <div class="<%= options.classPrependName %>"><%= prepend %></div>         <div class="<%= options.classContentName %>"><%= content %></div>      </div>      <div class="<%= options.classFooterName %>">         <%= buttons %>         <a class="close hiddenStructure">&times;</a>      </div>    </div>  </div></div>'},actions:{},actionOptions:{eventType:"click",target:null,ajaxUrl:null,modalFunction:null,isForm:!1,timeout:5e3,displayInModal:!0,reloadWindowOnClose:!0,error:".portalMessage.error",formFieldError:".field.error",onSuccess:null,onError:null,onFormError:null,onTimeout:null,redirectOnResponse:!1,redirectToUrl:function(t,n,r){var i=e(/<base.*?(\/>|<\/base>)/im.exec(n)[0]);return i.attr("href")}},routerOptions:{id:null,pathExp:null},form:function(n){var r=this,i=r.$modal;r.options.automaticallyAddButtonActions&&(n[r.options.buttons]={}),r.options.loadLinksWithinModal&&(n.a={}),e.each(n,function(n,s){var o=t.union(t.keys(r.options.actionOptions),["templateOptions"]),u=e.extend(!0,{},r.options.actionOptions,t.pick(s,o));s.templateOptions=e.extend(!0,s.templateOptions,r.options.templateOptions);var a=t.union(t.keys(r.options.actionOptions),["actions","actionOptions"]),f=e.extend(!0,t.omit(s,a),r.options);e(n,e("."+s.templateOptions.classBodyName,i)).each(function(t){var n=e(this);n.on(u.eventType,function(t){t.stopPropagation(),t.preventDefault(),r.loading.show(!1),u.modalFunction!==null?r[u.modalFunction]():e.nodeName(n[0],"input")||e.nodeName(n[0],"button")||s.isForm===!0?r.options.handleFormAction.apply(r,[n,u,f]):(s.ajaxUrl!==null||e.nodeName(n[0],"a"))&&r.options.handleLinkAction.apply(r,[n,u,f])})})})},handleFormAction:function(t,n,r){var i=this,s={};s[t.attr("name")]=t.attr("value");var o;e.nodeName(t[0],"form")?o=t:o=t.parents("form:not(.disableAutoSubmit)");var u;n.ajaxUrl!==null?typeof n.ajaxUrl=="function"?u=n.ajaxUrl.apply(i,[t,n]):u=n.ajaxUrl:u=t.parents("form").attr("action"),o.on("submit",function(e){e.preventDefault()}),o.trigger("submit"),i.loading.show(!1),o.ajaxSubmit({timeout:n.timeout,data:s,url:u,error:function(e,t,r){i.loading.hide(),t==="timeout"&&n.onTimeout?n.onTimeout.apply(i,e,r):n.onError?n.onError(e,t,r):console.log("error happened do something"),i.trigger("formActionError",[e,t,r])},success:function(s,o,u,a){i.loading.hide();if(e(n.error,s).size()!==0||e(n.formFieldError,s).size()!==0){n.onFormError?n.onFormError(i,s,o,u,a):i.redraw(s,r);return}if(n.redirectOnResponse===!0){typeof n.redirectToUrl=="function"?window.parent.location.href=n.redirectToUrl.apply(i,[t,s,n]):window.parent.location.href=n.redirectToUrl;return}n.onSuccess&&n.onSuccess(i,s,o,u,a),n.displayInModal===!0?i.redraw(s,r):(t.trigger("destroy.modal.patterns"),n.reloadWindowOnClose&&i.reloadWindow()),i.trigger("formActionSuccess",[s,o,u,a])}})},handleLinkAction:function(t,n,r){var i=this,s;n.ajaxUrl?typeof n.ajaxUrl=="function"?s=n.ajaxUrl.apply(i,[t,n]):s=n.ajaxUrl:s=t.attr("href");if(n.displayInModal===!1){window.parent.location.href=s;return}e.ajax({url:s,error:function(e,t,r){t==="timeout"&&n.onTimeout?n.onTimeout(i.$modal,e,r):n.onError?n.onError(e,t,r):console.log("error happened do something"),i.loading.hide(),i.trigger("linkActionError",[e,t,r])},success:function(e,t,s){i.redraw(e,r),n.onSuccess&&n.onSuccess(i,e,t,s),i.loading.hide(),i.trigger("linkActionSuccess",[e,t,s])}})},render:function(n){var r=this;r.trigger("before-render");if(!r.$raw)return;var i=r.$raw.clone();e("input:checked",i).each(function(){this.setAttribute&&this.setAttribute("checked","checked")});var s={title:"",prepend:"<div />",content:"",buttons:'<div class="pattern-modal-buttons"></div>',options:n.templateOptions};if(n.title===null){var o=e(n.titleSelector,i);s.title=o.html(),e(n.titleSelector,i).remove()}else s.title=n.title;n.prependContent&&(s.prepend=e("<div />").append(e(n.prependContent,i).clone()).html(),e(n.prependContent,i).remove()),n.content?s.content=e(n.content,i).html():s.content=i.html(),r.$modal=e(t.template(r.options.templateOptions.template,s)),r.$modalDialog=e("> ."+r.options.templateOptions.classDialog,r.$modal),e("form",r.$modal).on("keydown",function(t){if(t.keyCode!==13||t.target.nodeName==="TEXTAREA")return;t.preventDefault(),e("input[type=submit], button[type=submit], button:not(type)",this).eq(0).trigger("click")}),e(n.buttons,r.$modal).each(function(){var t=e(this);t.on("click",function(e){e.stopPropagation(),e.preventDefault()}).clone().appendTo(e(".pattern-modal-buttons",r.$modal)).off("click").on("click",function(e){e.stopPropagation(),e.preventDefault(),t.trigger("click")}),t.hide()}),r.trigger("before-events-setup"),e(".modal-header > a.close, .modal-footer > a.close",r.$modal).off("click").on("click",function(t){t.stopPropagation(),t.preventDefault(),e(t.target).trigger("destroy.modal.patterns")}),e(".row",r.$modal).removeClass("row"),n.form&&n.form.apply(r,[n.actions]),r.$modal.addClass(r.options.templateOptions.className).on("click",function(t){t.stopPropagation(),e.nodeName(t.target,"a")&&t.preventDefault(),r.$modal.trigger("modal-click")}).on("destroy.modal.patterns",function(e){e.stopPropagation(),r.hide()}).on("resize.modal.patterns",function(e){e.stopPropagation(),e.preventDefault(),r.positionModal()}).appendTo(r.$wrapperInner),r.$modal.data("pattern-"+r.name,r),r.trigger("after-render")}},reloadWindow:function(){window.parent.location.reload()},init:function(){var t=this;t.backdrop=new r(t.$el.parents(t.options.backdrop),t.options.backdropOptions),t.$wrapper=e("> ."+t.options.templateOptions.classWrapperName,t.backdrop.$el);if(t.$wrapper.size()===0){var n=t.options.backdropOptions.zIndex!==null?parseInt(t.options.backdropOptions.zIndex,10)+1:1041;t.$wrapper=e("<div/>").hide().css({"z-index":n,"overflow-y":"auto",position:"fixed",height:"100%",width:"100%",bottom:"0",left:"0",right:"0",top:"0"}).addClass(t.options.templateOptions.classWrapperName).insertBefore(t.backdrop.$backdrop).on("click",function(e){e.stopPropagation(),e.preventDefault(),t.options.backdropOptions.closeOnClick&&t.backdrop.hide()})}t.options.routerOptions.id!==null&&s.addRoute("modal",t.options.routerOptions.id,function(){this.show()},t,t.options.routerOptions.pathExp,t.options.routerOptions.expReplace),t.backdrop.on("hidden",function(e){t.$modal!==undefined&&t.$modal.hasClass(t.options.templateOptions.classActiveName)&&t.hide()}),t.options.backdropOptions.closeOnEsc===!0&&e(document).on("keydown",function(e,n){t.$el.is("."+t.options.templateOptions.classActiveName)&&e.keyCode===27&&t.hide()}),t.$wrapperInner=e("> ."+t.options.templateOptions.classWrapperInnerName,t.$wrapper),t.$wrapperInner.size()===0&&(t.$wrapperInner=e("<div/>").addClass(t.options.classWrapperInnerName).css({position:"absolute",bottom:"0",left:"0",right:"0",top:"0"}).appendTo(t.$wrapper)),t.loading=new o.ProgressIndicator({container:t.$wrapperInner,backdrop:t.backdrop,wrapper:t.$wrapper,zIndex:function(){if(!t.modalInitialized())return 10005;var e=t.$modal.css("zIndex");if(e)return parseInt(e,10)+1}}),e(window.parent).resize(function(){t.positionModal()}),t.options.triggers&&e.each(t.options.triggers,function(n,r){var i=r.substring(0,r.indexOf(" ")),s=r.substring(r.indexOf(" "),r.length);e(s||t.$el).on(i,function(e){e.stopPropagation(),e.preventDefault(),t.show()})}),t.$el.is("a")&&(t.$el.attr("href")&&(!t.options.target&&t.$el.attr("href").substr(0,1)==="#"&&(t.options.target=t.$el.attr("href"),t.options.content=""),!t.options.ajaxUrl&&t.$el.attr("href").substr(0,1)!=="#"&&(t.options.ajaxUrl=t.$el.attr("href"))),t.$el.on("click",function(e){e.stopPropagation(),e.preventDefault(),t.show()})),t.initModal()},createAjaxModal:function(){var t=this;t.trigger("before-ajax"),t.loading.show(),t.ajaxXHR=e.ajax({url:t.options.ajaxUrl,type:t.options.ajaxType}).done(function(n,r,i){t.ajaxXHR=undefined,t.loading.hide(),t.$raw=e("<div />").append(e(o.parseBodyTag(n))),t.trigger("after-ajax",t,r,i),t._show()})},createTargetModal:function(){var t=this;t.$raw=e(t.options.target).clone(),t._show()},createBasicModal:function(){var t=this;t.$raw=e("<div/>").html(t.$el.clone()),t._show()},createHtmlModal:function(){var t=this,n=e(t.options.html);t.$raw=n,t._show()},initModal:function(){var e=this;e.options.ajaxUrl?e.createModal=e.createAjaxModal:e.options.target?e.createModal=e.createTargetModal:e.options.html?e.createModal=e.createHtmlModal:e.createModal=e.createBasicModal},findPosition:function(e,t,n,r,i,s,o){var u={},a,f,l,c;return c=l=a=l="auto",e==="left"?(l=n+"px",r>s&&(l="0px"),u.left=l):e==="right"?(c=n+"px",r>s&&(c="0px"),u.right=c,u.left="auto"):(l=s/2-r/2-n+"px",r>s&&(l="0px"),u.left=l),t==="top"?(a=n+"px",i>o&&(a="0px"),u.top=a):t==="bottom"?(f=n+"px",i>o&&(f="0px"),u.bottom=f,u.top="auto"):(a=o/2-i/2-n+"px",i>o&&(a="0px"),u.top=a),u},modalInitialized:function(){var e=this;return e.$modal!==null&&e.$modal!==undefined},positionModal:function(){var t=this;if(!t.modalInitialized())return;t.$modal.removeAttr("style"),t.$wrapper.parent().is("body")&&t.$wrapper.height(e(window.parent).height());var n=typeof t.options.margin=="function"?t.options.margin():t.options.margin;t.$modal.css({position:"absolute",padding:n}),t.$modalDialog.css({margin:"0",padding:"0",width:t.options.width,height:t.options.height});var r=t.options.position.split(" "),i=r[0],s=r[1],o=t.$modalDialog.outerWidth(!0),u=t.$modalDialog.outerHeight(!0),a=t.$wrapperInner.width(),f=t.$wrapperInner.height(),l=t.findPosition(i,s,n,o,u,a,f);for(var c in l)t.$modalDialog.css(c,l[c])},render:function(e){var t=this;t.trigger("render"),t.options.render.apply(t,[e]),t.trigger("rendered")},show:function(){var e=this;e.createModal()},_show:function(){var t=this;t.render.apply(t,[t.options]),t.trigger("show"),t.backdrop.show(),t.$wrapper.show(),t.loading.hide(),t.$wrapper.parent().css("overflow","hidden"),t.$el.addClass(t.options.templateOptions.classActiveName),t.$modal.addClass(t.options.templateOptions.classActiveName),i.scan(t.$modal),t.positionModal(),e("img",t.$modal).load(function(){t.positionModal()}),e(window.parent).on("resize.modal.patterns",function(){t.positionModal()}),t.trigger("shown")},hide:function(){var t=this;t.ajaxXHR&&t.ajaxXHR.abort(),t.trigger("hide");if(t._suppressHide&&!confirm(t._suppressHide))return;e(".modal",t.$wrapper).size()<2&&(t.backdrop.hide(),t.$wrapper.hide(),t.$wrapper.parent().css("overflow","visible")),t.loading.hide(),t.$el.removeClass(t.options.templateOptions.classActiveName),t.$modal!==undefined&&(t.$modal.remove(),t.initModal()),e(window.parent).off("resize.modal.patterns"),t.trigger("hidden")},redraw:function(t,n){var r=this;r.trigger("beforeDraw"),r.$modal.remove(),r.$raw=e("<div />").append(e(o.parseBodyTag(t))),r.render.apply(r,[n||r.options]),r.$modal.addClass(r.options.templateOptions.classActiveName),r.positionModal(),i.scan(r.$modal),r.trigger("afterDraw")}});return u}),define("js/ui/views/base",["underscore","backbone"],function(e,t){var n=t.View.extend({isUIView:!0,eventPrefix:"ui",template:null,appendInContainer:!0,initialize:function(e){this.options=e;for(var t in this.options)this[t]=this.options[t]},render:function(){return this.applyTemplate(),this.trigger("render",this),this.afterRender(),!this.$el.attr("id")&&this.options.id&&this.$el.attr("id","gen-"+this.options.id),this},afterRender:function(){},serializedModel:function(){return this.options},applyTemplate:function(){this.template!==null&&this.$el.html(e.template(this.template,this.serializedModel()))},propagateEvent:function(e){if(e.indexOf(":")>0){var t=e.split(":")[0];if(this.eventPrefix!=="")if(t===this.eventPrefix||t===this.eventPrefix+"."+this.id)return!0}return!1},uiEventTrigger:function(e){var n=[].slice.call(arguments,0);this.eventPrefix!==""&&(n[0]=this.eventPrefix+":"+e,t.View.prototype.trigger.apply(this,n),this.id&&(n[0]=this.eventPrefix+"."+this.id+":"+e,t.View.prototype.trigger.apply(this,n)))}});return n}),define("js/ui/views/container",["jquery","underscore","backbone","js/ui/views/base"],function(e,t,n,r){var i=r.extend({id:"",items:[],itemContainer:null,isOffsetParent:!0,render:function(){return this.applyTemplate(),this.renderItems(),this.bindEvents(),this.isOffsetParent&&this.$el.addClass("ui-offset-parent"),this.trigger("render",this),this.afterRender(),this},renderItems:function(){var n;if(this.itemContainer!==null){n=e(this.itemContainer,this.$el);if(n.length===0)throw"Item Container element not found."}else n=this.$el;t.each(this.items,function(e){e.appendInContainer===!0?n.append(e.render().$el):e.render()},this)},bindEvents:function(){var e=this;t.each(this.items,function(t){t.on("all",function(){var t=[].slice,n=arguments[0],r,i=e.id!==""?e.id+"."+n:n;arguments.length>1&&(r=arguments[1]);if(i!==n){var s=t.call(arguments,0);s[0]=i,e.trigger.apply(e,s)}r!==undefined&&r.isUIView===!0&&r.propagateEvent(n)===!0&&e.trigger.apply(e,arguments)})})},get:function(e){return t.findWhere(this.items,{id:e})},add:function(e){if(e.id!==undefined&&this.get(e.id))throw"Another item with the same `id` already exists.";this.items.push(e)}});return i}),define("js/ui/views/toolbar",["underscore","backbone","js/ui/views/container"],function(e,t,n){var r=n.extend({tagName:"div",className:"navbar"});return r}),define("js/ui/views/buttongroup",["underscore","backbone","js/ui/views/container"],function(e,t,n){var r=n.extend({tagName:"div",className:"btn-group",disable:function(){e.each(this.items,function(e){e.trigger("disable")})},enable:function(){e.each(this.items,function(e){e.trigger("enable")})}});return r}),+function(e){var t=function(e,t){this.type=this.options=this.enabled=this.timeout=this.hoverState=this.$element=null,this.init("tooltip",e,t)};t.DEFAULTS={animation:!0,placement:"top",selector:!1,template:'<div class="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:!1,container:!1},t.prototype.init=function(t,n,r){this.enabled=!0,this.type=t,this.$element=e(n),this.options=this.getOptions(r);var i=this.options.trigger.split(" ");for(var s=i.length;s--;){var o=i[s];if(o=="click")this.$element.on("click."+this.type,this.options.selector,e.proxy(this.toggle,this));else if(o!="manual"){var u=o=="hover"?"mouseenter":"focusin",a=o=="hover"?"mouseleave":"focusout";this.$element.on(u+"."+this.type,this.options.selector,e.proxy(this.enter,this)),this.$element.on(a+"."+this.type,this.options.selector,e.proxy(this.leave,this))}}this.options.selector?this._options=e.extend({},this.options,{trigger:"manual",selector:""}):this.fixTitle()},t.prototype.getDefaults=function(){return t.DEFAULTS},t.prototype.getOptions=function(t){return t=e.extend({},this.getDefaults(),this.$element.data(),t),t.delay&&typeof t.delay=="number"&&(t.delay={show:t.delay,hide:t.delay}),t},t.prototype.getDelegateOptions=function(){var t={},n=this.getDefaults();return this._options&&e.each(this._options,function(e,r){n[e]!=r&&(t[e]=r)}),t},t.prototype.enter=function(t){var n=t instanceof this.constructor?t:e(t.currentTarget)[this.type](this.getDelegateOptions()).data("bs."+this.type);clearTimeout(n.timeout),n.hoverState="in";if(!n.options.delay||!n.options.delay.show)return n.show();n.timeout=setTimeout(function(){n.hoverState=="in"&&n.show()},n.options.delay.show)},t.prototype.leave=function(t){var n=t instanceof this.constructor?t:e(t.currentTarget)[this.type](this.getDelegateOptions()).data("bs."+this.type);clearTimeout(n.timeout),n.hoverState="out";if(!n.options.delay||!n.options.delay.hide)return n.hide();n.timeout=setTimeout(function(){n.hoverState=="out"&&n.hide()},n.options.delay.hide)},t.prototype.show=function(){var t=e.Event("show.bs."+this.type);if(this.hasContent()&&this.enabled){this.$element.trigger(t);if(t.isDefaultPrevented())return;var n=this,r=this.tip();this.setContent(),this.options.animation&&r.addClass("fade");var i=typeof this.options.placement=="function"?this.options.placement.call(this,r[0],this.$element[0]):this.options.placement,s=/\s?auto?\s?/i,o=s.test(i);o&&(i=i.replace(s,"")||"top"),r.detach().css({top:0,left:0,display:"block"}).addClass(i),this.options.container?r.appendTo(this.options.container):r.insertAfter(this.$element);var u=this.getPosition(),a=r[0].offsetWidth,f=r[0].offsetHeight;if(o){var l=this.$element.parent(),c=i,h=document.documentElement.scrollTop||document.body.scrollTop,p=this.options.container=="body"?window.innerWidth:l.outerWidth(),d=this.options.container=="body"?window.innerHeight:l.outerHeight(),v=this.options.container=="body"?0:l.offset().left;i=i=="bottom"&&u.top+u.height+f-h>d?"top":i=="top"&&u.top-h-f<0?"bottom":i=="right"&&u.right+a>p?"left":i=="left"&&u.left-a<v?"right":i,r.removeClass(c).addClass(i)}var m=this.getCalculatedOffset(i,u,a,f);this.applyPlacement(m,i),this.hoverState=null;var g=function(){n.$element.trigger("shown.bs."+n.type)};e.support.transition&&this.$tip.hasClass("fade")?r.one(e.support.transition.end,g).emulateTransitionEnd(150):g()}},t.prototype.applyPlacement=function(t,n){var r,i=this.tip(),s=i[0].offsetWidth,o=i[0].offsetHeight,u=parseInt(i.css("margin-top"),10),a=parseInt(i.css("margin-left"),10);isNaN(u)&&(u=0),isNaN(a)&&(a=0),t.top=t.top+u,t.left=t.left+a,e.offset.setOffset(i[0],e.extend({using:function(e){i.css({top:Math.round(e.top),left:Math.round(e.left)})}},t),0),i.addClass("in");var f=i[0].offsetWidth,l=i[0].offsetHeight;n=="top"&&l!=o&&(r=!0,t.top=t.top+o-l);if(/bottom|top/.test(n)){var c=0;t.left<0&&(c=t.left*-2,t.left=0,i.offset(t),f=i[0].offsetWidth,l=i[0].offsetHeight),this.replaceArrow(c-s+f,f,"left")}else this.replaceArrow(l-o,l,"top");r&&i.offset(t)},t.prototype.replaceArrow=function(e,t,n){this.arrow().css(n,e?50*(1-e/t)+"%":"")},t.prototype.setContent=function(){var e=this.tip(),t=this.getTitle();e.find(".tooltip-inner")[this.options.html?"html":"text"](t),e.removeClass("fade in top bottom left right")},t.prototype.hide=function(){function i(){t.hoverState!="in"&&n.detach(),t.$element.trigger("hidden.bs."+t.type)}var t=this,n=this.tip(),r=e.Event("hide.bs."+this.type);this.$element.trigger(r);if(r.isDefaultPrevented())return;return n.removeClass("in"),e.support.transition&&this.$tip.hasClass("fade")?n.one(e.support.transition.end,i).emulateTransitionEnd(150):i(),this.hoverState=null,this},t.prototype.fixTitle=function(){var e=this.$element;(e.attr("title")||typeof e.attr("data-original-title")!="string")&&e.attr("data-original-title",e.attr("title")||"").attr("title","")},t.prototype.hasContent=function(){return this.getTitle()},t.prototype.getPosition=function(){var t=this.$element[0];return e.extend({},typeof t.getBoundingClientRect=="function"?t.getBoundingClientRect():{width:t.offsetWidth,height:t.offsetHeight},this.$element.offset())},t.prototype.getCalculatedOffset=function(e,t,n,r){return e=="bottom"?{top:t.top+t.height,left:t.left+t.width/2-n/2}:e=="top"?{top:t.top-r,left:t.left+t.width/2-n/2}:e=="left"?{top:t.top+t.height/2-r/2,left:t.left-n}:{top:t.top+t.height/2-r/2,left:t.left+t.width}},t.prototype.getTitle=function(){var e,t=this.$element,n=this.options;return e=t.attr("data-original-title")||(typeof n.title=="function"?n.title.call(t[0]):n.title),e},t.prototype.tip=function(){return this.$tip=this.$tip||e(this.options.template)},t.prototype.arrow=function(){return this.$arrow=this.$arrow||this.tip().find(".tooltip-arrow")},t.prototype.validate=function(){this.$element[0].parentNode||(this.hide(),this.$element=null,this.options=null)},t.prototype.enable=function(){this.enabled=!0},t.prototype.disable=function(){this.enabled=!1},t.prototype.toggleEnabled=function(){this.enabled=!this.enabled},t.prototype.toggle=function(t){var n=t?e(t.currentTarget)[this.type](this.getDelegateOptions()).data("bs."+this.type):this;n.tip().hasClass("in")?n.leave(n):n.enter(n)},t.prototype.destroy=function(){clearTimeout(this.timeout),this.hide().$element.off("."+this.type).removeData("bs."+this.type)};var n=e.fn.tooltip;e.fn.tooltip=function(n){return this.each(function(){var r=e(this),i=r.data("bs.tooltip"),s=typeof n=="object"&&n;if(!i&&n=="destroy")return;i||r.data("bs.tooltip",i=new t(this,s)),typeof n=="string"&&i[n]()})},e.fn.tooltip.Constructor=t,e.fn.tooltip.noConflict=function(){return e.fn.tooltip=n,this}}(jQuery),define("bootstrap-tooltip",["jquery"],function(){}),define("js/ui/views/button",["jquery","backbone","underscore","js/ui/views/base","bootstrap-tooltip"],function(e,t,n,r){var i=r.extend({tagName:"a",className:"btn",eventPrefix:"button",context:"default",attributes:{href:"#"},tooltip:null,template:'<% if (icon) { %><span class="glyphicon glyphicon-<%= icon %>"></span><% } %> <%= title %>',events:{click:"handleClick"},initialize:function(e){if(!e.id){var t=e.title||"";e.id=t!==""?t.toLowerCase().replace(" ","-"):this.cid}r.prototype.initialize.apply(this,[e]),this.on("disable",function(){this.disable()},this),this.on("enable",function(){this.enable()},this),this.on("render",function(){this.context!==null&&this.$el.addClass("btn-"+this.context),this.tooltip!==null&&(this.$el.tooltip({title:this.tooltip}),this.$el.on("hidden",function(e){e.type==="hidden"&&e.stopPropagation()}))},this)},handleClick:function(e){e.preventDefault(),this.$el.is(".disabled")||this.uiEventTrigger("click",this,e)},serializedModel:function(){return n.extend({icon:"",title:""},this.options)},disable:function(){this.options.disabled=!0,this.$el.addClass("disabled")},enable:function(){this.options.disabled=!1,this.$el.removeClass("disabled")}});return i}),define("text",["module"],function(e){var t,n,r,i,s,o=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"],u=/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,a=/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im,f=typeof location!="undefined"&&location.href,l=f&&location.protocol&&location.protocol.replace(/\:/,""),c=f&&location.hostname,h=f&&(location.port||undefined),p={},d=e.config&&e.config()||{};t={version:"2.0.10",strip:function(e){if(e){e=e.replace(u,"");var t=e.match(a);t&&(e=t[1])}else e="";return e},jsEscape:function(e){return e.replace(/(['\\])/g,"\\$1").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r").replace(/[\u2028]/g,"\\u2028").replace(/[\u2029]/g,"\\u2029")},createXhr:d.createXhr||function(){var e,t,n;if(typeof XMLHttpRequest!="undefined")return new XMLHttpRequest;if(typeof ActiveXObject!="undefined")for(t=0;t<3;t+=1){n=o[t];try{e=new ActiveXObject(n)}catch(r){}if(e){o=[n];break}}return e},parseName:function(e){var t,n,r,i=!1,s=e.indexOf("."),o=e.indexOf("./")===0||e.indexOf("../")===0;return s!==-1&&(!o||s>1)?(t=e.substring(0,s),n=e.substring(s+1,e.length)):t=e,r=n||t,s=r.indexOf("!"),s!==-1&&(i=r.substring(s+1)==="strip",r=r.substring(0,s),n?n=r:t=r),{moduleName:t,ext:n,strip:i}},xdRegExp:/^((\w+)\:)?\/\/([^\/\\]+)/,useXhr:function(e,n,r,i){var s,o,u,a=t.xdRegExp.exec(e);return a?(s=a[2],o=a[3],o=o.split(":"),u=o[1],o=o[0],(!s||s===n)&&(!o||o.toLowerCase()===r.toLowerCase())&&(!u&&!o||u===i)):!0},finishLoad:function(e,n,r,i){r=n?t.strip(r):r,d.isBuild&&(p[e]=r),i(r)},load:function(e,n,r,i){if(i.isBuild&&!i.inlineText){r();return}d.isBuild=i.isBuild;var s=t.parseName(e),o=s.moduleName+(s.ext?"."+s.ext:""),u=n.toUrl(o),a=d.useXhr||t.useXhr;if(u.indexOf("empty:")===0){r();return}!f||a(u,l,c,h)?t.get(u,function(n){t.finishLoad(e,s.strip,n,r)},function(e){r.error&&r.error(e)}):n([o],function(e){t.finishLoad(s.moduleName+"."+s.ext,s.strip,e,r)})},write:function(e,n,r,i){if(p.hasOwnProperty(n)){var s=t.jsEscape(p[n]);r.asModule(e+"!"+n,"define(function () { return '"+s+"';});\n")}},writeFile:function(e,n,r,i,s){var o=t.parseName(n),u=o.ext?"."+o.ext:"",a=o.moduleName+u,f=r.toUrl(o.moduleName+u)+".js";t.load(a,r,function(n){var r=function(e){return i(f,e)};r.asModule=function(e,t){return i.asModule(e,f,t)},t.write(e,a,r,s)},s)}};if(d.env==="node"||!d.env&&typeof process!="undefined"&&process.versions&&!!process.versions.node&&!process.versions["node-webkit"])n=require.nodeRequire("fs"),t.get=function(e,t,r){try{var i=n.readFileSync(e,"utf8");i.indexOf("﻿")===0&&(i=i.substring(1)),t(i)}catch(s){r(s)}};else if(d.env==="xhr"||!d.env&&t.createXhr())t.get=function(e,n,r,i){var s=t.createXhr(),o;s.open("GET",e,!0);if(i)for(o in i)i.hasOwnProperty(o)&&s.setRequestHeader(o.toLowerCase(),i[o]);d.onXhr&&d.onXhr(s,e),s.onreadystatechange=function(t){var i,o;s.readyState===4&&(i=s.status,i>399&&i<600?(o=new Error(e+" HTTP status: "+i),o.xhr=s,r(o)):n(s.responseText),d.onXhrComplete&&d.onXhrComplete(s,e))},s.send(null)};else if(d.env==="rhino"||!d.env&&typeof Packages!="undefined"&&typeof java!="undefined")t.get=function(e,t){var n,r,i="utf-8",s=new java.io.File(e),o=java.lang.System.getProperty("line.separator"),u=new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(s),i)),a="";try{n=new java.lang.StringBuffer,r=u.readLine(),r&&r.length()&&r.charAt(0)===65279&&(r=r.substring(1)),r!==null&&n.append(r);while((r=u.readLine())!==null)n.append(o),n.append(r);a=String(n.toString())}finally{u.close()}t(a)};else if(d.env==="xpconnect"||!d.env&&typeof Components!="undefined"&&Components.classes&&Components.interfaces)r=Components.classes,i=Components.interfaces,Components.utils["import"]("resource://gre/modules/FileUtils.jsm"),s="@mozilla.org/windows-registry-key;1"in r,t.get=function(e,t){var n,o,u,a={};s&&(e=e.replace(/\//g,"\\")),u=new FileUtils.File(e);try{n=r["@mozilla.org/network/file-input-stream;1"].createInstance(i.nsIFileInputStream),n.init(u,1,0,!1),o=r["@mozilla.org/intl/converter-input-stream;1"].createInstance(i.nsIConverterInputStream),o.init(n,"utf-8",n.available(),i.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER),o.readString(n.available(),a),o.close(),n.close(),t(a.value)}catch(f){throw new Error((u&&u.path||"")+": "+f)}};return t}),define("text!js/patterns/structure/templates/actionmenu.xml",[],function(){return'<a class="btn btn-default btn-xs dropdown-toggle" data-toggle="dropdown" href="#">\n  <span class="glyphicon glyphicon-cog"></i>\n  <span class="caret"></span>\n</a>\n<ul class="dropdown-menu">\n  <% if(header) { %>\n    <li class="dropdown-header"><%- header %></li>\n    <li class="divider"></li>\n  <% } %>\n  <li class="cutItem"><a href="#">Cut</a></li>\n  <li class="copyItem"><a href="#">Copy</a></li>\n  <% if(pasteAllowed && attributes.is_folderish){ %>\n    <li class="pasteItem"><a href="#">Paste</a></li>\n  <% } %>\n  <% if(!inQueryMode && canMove){ %>\n    <li class="move-top"><a href="#">Move to top of folder</a></li>\n    <li class="move-bottom"><a href="#">Move to bottom of folder</a></li>\n  <% } %>\n  <% if(!attributes.is_folderish && canSetDefaultPage){ %>\n    <li class="set-default-page"><a href="#">Set as default page</a></li>\n  <% } %>\n  <li class="openItem"><a href="#">Open</a></li>\n  <li class="editItem"><a href="#">Edit</a></li>\n</ul>\n\n'}),+function(e){function i(r){e(t).remove(),e(n).each(function(){var t=s(e(this)),n={relatedTarget:this};if(!t.hasClass("open"))return;t.trigger(r=e.Event("hide.bs.dropdown",n));if(r.isDefaultPrevented())return;t.removeClass("open").trigger("hidden.bs.dropdown",n)})}function s(t){var n=t.attr("data-target");n||(n=t.attr("href"),n=n&&/#[A-Za-z]/.test(n)&&n.replace(/.*(?=#[^\s]*$)/,""));var r=n&&e(n);return r&&r.length?r:t.parent()}var t=".dropdown-backdrop",n="[data-toggle=dropdown]",r=function(t){e(t).on("click.bs.dropdown",this.toggle)};r.prototype.toggle=function(t){var n=e(this);if(n.is(".disabled, :disabled"))return;var r=s(n),o=r.hasClass("open");i();if(!o){"ontouchstart"in document.documentElement&&!r.closest(".navbar-nav").length&&e('<div class="dropdown-backdrop"/>').insertAfter(e(this)).on("click",i);var u={relatedTarget:this};r.trigger(t=e.Event("show.bs.dropdown",u));if(t.isDefaultPrevented())return;r.toggleClass("open").trigger("shown.bs.dropdown",u),n.focus()}return!1},r.prototype.keydown=function(t){if(!/(38|40|27)/.test(t.keyCode))return;var r=e(this);t.preventDefault(),t.stopPropagation();if(r.is(".disabled, :disabled"))return;var i=s(r),o=i.hasClass("open");if(!o||o&&t.keyCode==27)return t.which==27&&i.find(n).focus(),r.click();var u=" li:not(.divider):visible a",a=i.find("[role=menu]"+u+", [role=listbox]"+u);if(!a.length)return;var f=a.index(a.filter(":focus"));t.keyCode==38&&f>0&&f--,t.keyCode==40&&f<a.length-1&&f++,~f||(f=0),a.eq(f).focus()};var o=e.fn.dropdown;e.fn.dropdown=function(t){return this.each(function(){var n=e(this),i=n.data("bs.dropdown");i||n.data("bs.dropdown",i=new r(this)),typeof t=="string"&&i[t].call(n)})},e.fn.dropdown.Constructor=r,e.fn.dropdown.noConflict=function(){return e.fn.dropdown=o,this},e(document).on("click.bs.dropdown.data-api",i).on("click.bs.dropdown.data-api",".dropdown form",function(e){e.stopPropagation()}).on("click.bs.dropdown.data-api",n,r.prototype.toggle).on("keydown.bs.dropdown.data-api",n+", [role=menu], [role=listbox]",r.prototype.keydown)}(jQuery),define("bootstrap-dropdown",["jquery"],function(){}),define("js/patterns/structure/views/actionmenu",["jquery","underscore","backbone","js/ui/views/base","mockup-utils","text!js/patterns/structure/templates/actionmenu.xml","bootstrap-dropdown"],function(e,t,n,r,i,s){var o=r.extend({className:"btn-group actionmenu",template:t.template(s),events:{"click .cutItem a":"cutClicked","click .copyItem a":"copyClicked","click .pasteItem a":"pasteClicked","click .move-top a":"moveTopClicked","click .move-bottom a":"moveBottomClicked","click .set-default-page a":"setDefaultPageClicked","click .openItem a":"openClicked","click .editItem a":"editClicked"},initialize:function(e){this.options=e,this.app=e.app,this.model=e.model,this.selectedCollection=this.app.selectedCollection,e.canMove===!1?this.canMove=!1:this.canMove=!0},cutClicked:function(e){e.preventDefault(),this.cutCopyClicked("cut"),this.app.collection.pager()},copyClicked:function(e){e.preventDefault(),this.cutCopyClicked("copy"),this.app.collection.pager()},cutCopyClicked:function(e){var t=this;t.app.pasteOperation=e,t.app.pasteSelection=new n.Collection,t.app.pasteSelection.add(this.model),t.app.setStatus(e+" 1 item"),t.app.pasteAllowed=!0,t.app.buttons.primary.get("paste").enable()},pasteClicked:function(e){e.preventDefault(),this.app.pasteEvent(this.app.buttons.primary.get("paste"),e,{folder:this.model.attributes.path}),this.app.collection.pager()},moveTopClicked:function(e){e.preventDefault(),this.app.moveItem(this.model.attributes.id,"top")},moveBottomClicked:function(e){e.preventDefault(),this.app.moveItem(this.model.attributes.id,"bottom")},setDefaultPageClicked:function(t){t.preventDefault();var n=this;e.ajax({url:n.app.getAjaxUrl(n.app.setDefaultPageUrl),type:"POST",data:{_authenticator:e('[name="_authenticator"]').val(),id:this.$active.attr("data-id")},success:function(e){n.app.ajaxSuccessResponse.apply(n.app,[e])},error:function(e){n.app.ajaxErrorResponse.apply(n.app,[e])}})},getSelectedBaseUrl:function(){var e=this;return e.model.attributes.getURL},getWindow:function(){var e=window;return e.parent!==window&&(e=e.parent),e},openUrl:function(e){var t=this,n=t.getWindow(),r=this.app.keyEvent;r&&r.ctrlKey?n.open(e):n.location=e},openClicked:function(e){e.preventDefault();var t=this;t.openUrl(t.getSelectedBaseUrl()+"/view")},editClicked:function(e){e.preventDefault();var t=this;t.openUrl(t.getSelectedBaseUrl()+"/edit")},render:function(){var e=this;e.$el.empty();var t=this.model.toJSON();return t.attributes=e.model.attributes,t.pasteAllowed=e.app.pasteAllowed,t.canSetDefaultPage=e.app.setDefaultPageUrl,t.inQueryMode=e.app.inQueryMode(),t.header=e.options.header,t.canMove=e.canMove,e.$el.html(e.template(t)),e.$dropdown=e.$(".dropdown-toggle"),e.$dropdown.dropdown(),e.options.className&&e.$el.addClass(e.options.className),this}});return o}),define("text!js/patterns/structure/templates/tablerow.xml",[],function(){return'<td class="selection"><input type="checkbox" <% if(selected){ %> checked="checked" <% } %>/></td>\n<td class="title">\n  <a href="<%- getURL %>">\n    <% if([\'File\', \'Image\'].indexOf(attributes.Type) !== -1){ %>\n      <span class="glyphicon glyphicon-file"></span>\n    <% } %>\n    <% if(attributes.is_folderish) { %>\n      <span class="glyphicon glyphicon-folder-open"></span>\n    <% } %>\n    <% if(attributes.is_folderish) { %>\n      <span class="icon icon-folder-open"></span>\n    <% } %>\n    <%- Title %>\n  </a>\n</td>\n<% _.each(activeColumns, function(column){ %>\n  <% if(_.has(availableColumns, column)) { %>\n    <td class="<%- column %>"><%- attributes[column] %></td>\n  <% } %>\n<% }); %>\n<td class="actionmenu-container">\n</td>\n'}),define("js/patterns/structure/views/tablerow",["jquery","underscore","backbone","js/patterns/structure/views/actionmenu","text!js/patterns/structure/templates/tablerow.xml"],function(e,t,n,r,i){var s=n.View.extend({tagName:"tr",className:"itemRow",template:t.template(i),events:{"change input":"itemSelected","click td.title a":"itemClicked"},initialize:function(e){this.options=e,this.app=e.app,this.selectedCollection=this.app.selectedCollection,this.table=this.options.table},render:function(){var t=this,n=this.model.toJSON();n.selected=!1,this.selectedCollection.findWhere({UID:n.UID})&&(n.selected=!0),n.attributes=t.model.attributes,n.activeColumns=t.app.activeColumns,n.availableColumns=t.app.availableColumns,t.$el.html(t.template(n));var i=t.model.attributes;return t.$el.addClass("state-"+i.review_state).addClass("type-"+i.Type),i.is_folderish&&t.$el.addClass("folder"),t.$el.attr("data-path",n.path),t.$el.attr("data-UID",n.UID),t.$el.attr("data-id",n.id),t.$el.attr("data-type",n.Type),t.$el.attr("data-folderish",n.is_folderish),t.el.model=this.model,t.menu=new r({app:t.app,model:t.model}),e(".actionmenu-container",t.$el).append(t.menu.render().el),this},itemClicked:function(e){e.preventDefault();var t=this.app.keyEvent;if(t&&t.ctrlKey)this.menu.openClicked(e);else if(this.model.attributes.is_folderish){this.app.queryHelper.currentPath=this.model.attributes.path;var n=this.app.collection;n.goTo(n.information.firstPage)}else this.menu.openClicked(e)},itemSelected:function(){var t=this.$("input")[0];t.checked?this.app.selectedCollection.add(this.model):this.app.selectedCollection.removeResult(this.model);var n=this.selectedCollection,r=this.app.keyEvent;if(r&&r.shiftKey&&this.app.last_selected&&this.app.last_selected.parentNode!==null){var i=e(this.app.last_selected),s=i.index(),o=this.$el.index();this.app.tableView.$('input[type="checkbox"]').each(function(){i=e(this);var r=i.parents("tr").index();if(r>s&&r<o||r<s&&r>o){this.checked=t.checked;var u=e(this).closest("tr")[0].model,a=n.getByUID(u.attributes.UID);this.checked?a||n.add(u):a&&n.remove(a)}})}this.app.last_selected=this.el}});return s}),define("text!js/patterns/structure/templates/table.xml",[],function(){return'<div class="alert alert-<%= statusType %> status">\n    <%= status %>\n</div>\n<table class="table table-striped table-bordered">\n  <thead>\n    <tr class="breadcrumbs-container">\n      <td colspan="<%= activeColumns.length + 3 %>">\n        <% if(pathParts.length > 0) { %>\n          <div class="input-group context-buttons" style="display:none">\n            <span class="input-group-addon">\n              <input type="checkbox" />\n            </span>\n            <div class="input-group-btn">\n            </div>\n          </div>\n        <% } %>\n        <div class="breadcrumbs">\n          <a href="#" data-path="/">\n            <span class="glyphicon glyphicon-home"></span> /\n          </a>\n          <% _.each(pathParts, function(part, idx, list){\n            if(part){\n              if(idx > 0){ %>\n                /\n              <% } %>\n              <a href="#" class="crumb" data-path="<%- part %>"><%- part %></a>\n            <% }\n          }); %>\n        </div>\n      </td>\n    </tr>\n    <tr>\n      <th><input type="checkbox" class="select-all" /></th>\n      <th>Title</th>\n      <% _.each(activeColumns, function(column){ %>\n        <% if(_.has(availableColumns, column)) { %>\n          <th><%- availableColumns[column] %></th>\n        <% } %>\n      <% }); %>\n      <th>Actions</th>\n    </tr>\n  </thead>\n  <tbody>\n  </tbody>\n</table>\n'}),function(e){e.fn.drag=function(t,n,r){var i=typeof t=="string"?t:"",s=e.isFunction(t)?t:e.isFunction(n)?n:null;return i.indexOf("drag")!==0&&(i="drag"+i),r=(t==s?n:r)||{},s?this.bind(i,r,s):this.trigger(i)};var t=e.event,n=t.special,r=n.drag={defaults:{which:1,distance:0,not:":input",handle:null,relative:!1,drop:!0,click:!1},datakey:"dragdata",noBubble:!0,add:function(t){var n=e.data(this,r.datakey),i=t.data||{};n.related+=1,e.each(r.defaults,function(e,t){i[e]!==undefined&&(n[e]=i[e])})},remove:function(){e.data(this,r.datakey).related-=1},setup:function(){if(e.data(this,r.datakey))return;var n=e.extend({related:0},r.defaults);e.data(this,r.datakey,n),t.add(this,"touchstart mousedown",r.init,n),this.attachEvent&&this.attachEvent("ondragstart",r.dontstart)},teardown:function(){var n=e.data(this,r.datakey)||{};if(n.related)return;e.removeData(this,r.datakey),t.remove(this,"touchstart mousedown",r.init),r.textselect(!0),this.detachEvent&&this.detachEvent("ondragstart",r.dontstart)},init:function(i){if(r.touched)return;var s=i.data,o;if(i.which!=0&&s.which>0&&i.which!=s.which)return;if(e(i.target).is(s.not))return;if(s.handle&&!e(i.target).closest(s.handle,i.currentTarget).length)return;r.touched=i.type=="touchstart"?this:null,s.propagates=1,s.mousedown=this,s.interactions=[r.interaction(this,s)],s.target=i.target,s.pageX=i.pageX,s.pageY=i.pageY,s.dragging=null,o=r.hijack(i,"draginit",s);if(!s.propagates)return;o=r.flatten(o),o&&o.length&&(s.interactions=[],e.each(o,function(){s.interactions.push(r.interaction(this,s))})),s.propagates=s.interactions.length,s.drop!==!1&&n.drop&&n.drop.handler(i,s),r.textselect(!1),r.touched?t.add(r.touched,"touchmove touchend",r.handler,s):t.add(document,"mousemove mouseup",r.handler,s);if(!r.touched||s.live)return!1},interaction:function(t,n){var i=e(t)[n.relative?"position":"offset"]()||{top:0,left:0};return{drag:t,callback:new r.callback,droppable:[],offset:i}},handler:function(i){var s=i.data;switch(i.type){case!s.dragging&&"touchmove":i.preventDefault();case!s.dragging&&"mousemove":if(Math.pow(i.pageX-s.pageX,2)+Math.pow(i.pageY-s.pageY,2)<Math.pow(s.distance,2))break;i.target=s.target,r.hijack(i,"dragstart",s),s.propagates&&(s.dragging=!0);case"touchmove":i.preventDefault();case"mousemove":if(s.dragging){r.hijack(i,"drag",s);if(s.propagates){s.drop!==!1&&n.drop&&n.drop.handler(i,s);break}i.type="mouseup"};case"touchend":case"mouseup":default:r.touched?t.remove(r.touched,"touchmove touchend",r.handler):t.remove(document,"mousemove mouseup",r.handler),s.dragging&&(s.drop!==!1&&n.drop&&n.drop.handler(i,s),r.hijack(i,"dragend",s)),r.textselect(!0),s.click===!1&&s.dragging&&e.data(s.mousedown,"suppress.click",(new Date).getTime()+5),s.dragging=r.touched=!1}},hijack:function(n,i,s,o,u){if(!s)return;var a={event:n.originalEvent,type:n.type},f=i.indexOf("drop")?"drag":"drop",l,c=o||0,h,p,d,v=isNaN(o)?s.interactions.length:o;n.type=i,n.originalEvent=null,s.results=[];do if(h=s.interactions[c]){if(i!=="dragend"&&h.cancelled)continue;d=r.properties(n,s,h),h.results=[],e(u||h[f]||s.droppable).each(function(o,u){d.target=u,n.isPropagationStopped=function(){return!1},l=u?t.dispatch.call(u,n,d):null,l===!1?(f=="drag"&&(h.cancelled=!0,s.propagates-=1),i=="drop"&&(h[f][o]=null)):i=="dropinit"&&h.droppable.push(r.element(l)||u),i=="dragstart"&&(h.proxy=e(r.element(l)||h.drag)[0]),h.results.push(l),delete n.result;if(i!=="dropinit")return l}),s.results[c]=r.flatten(h.results),i=="dropinit"&&(h.droppable=r.flatten(h.droppable)),i=="dragstart"&&!h.cancelled&&d.update()}while(++c<v);return n.type=a.type,n.originalEvent=a.event,r.flatten(s.results)},properties:function(e,t,n){var i=n.callback;return i.drag=n.drag,i.proxy=n.proxy||n.drag,i.startX=t.pageX,i.startY=t.pageY,i.deltaX=e.pageX-t.pageX,i.deltaY=e.pageY-t.pageY,i.originalX=n.offset.left,i.originalY=n.offset.top,i.offsetX=i.originalX+i.deltaX,i.offsetY=i.originalY+i.deltaY,i.drop=r.flatten((n.drop||[]).slice()),i.available=r.flatten((n.droppable||[]).slice()),i},element:function(e){if(e&&(e.jquery||e.nodeType==1))return e},flatten:function(t){return e.map(t,function(t){return t&&t.jquery?e.makeArray(t):t&&t.length?r.flatten(t):t})},textselect:function(t){e(document)[t?"unbind":"bind"]("selectstart",r.dontstart).css("MozUserSelect",t?"":"none"),document.unselectable=t?"off":"on"},dontstart:function(){return!1},callback:function(){}};r.callback.prototype={update:function(){n.drop&&this.available.length&&e.each(this.available,function(e){n.drop.locate(this,e)})}};var i=t.dispatch;t.dispatch=function(t){if(e.data(this,"suppress."+t.type)-(new Date).getTime()>0){e.removeData(this,"suppress."+t.type);return}return i.apply(this,arguments)};var s=t.fixHooks.touchstart=t.fixHooks.touchmove=t.fixHooks.touchend=t.fixHooks.touchcancel={props:"clientX clientY pageX pageY screenX screenY".split(" "),filter:function(t,n){if(n){var r=n.touches&&n.touches[0]||n.changedTouches&&n.changedTouches[0]||null;r&&e.each(s.props,function(e,n){t[n]=r[n]})}return t}};n.draginit=n.dragstart=n.dragend=r}(jQuery),define("jquery.event.drag",["jquery"],function(){}),function(e){e.fn.drop=function(t,n,r){var i=typeof t=="string"?t:"",s=e.isFunction(t)?t:e.isFunction(n)?n:null;return i.indexOf("drop")!==0&&(i="drop"+i),r=(t==s?n:r)||{},s?this.bind(i,r,s):this.trigger(i)},e.drop=function(t){t=t||{},r.multi=t.multi===!0?Infinity:t.multi===!1?1:isNaN(t.multi)?r.multi:t.multi,r.delay=t.delay||r.delay,r.tolerance=e.isFunction(t.tolerance)?t.tolerance:t.tolerance===null?null:r.tolerance,r.mode=t.mode||r.mode||"intersect"};var t=e.event,n=t.special,r=e.event.special.drop={multi:1,delay:20,mode:"overlap",targets:[],datakey:"dropdata",noBubble:!0,add:function(t){var n=e.data(this,r.datakey);n.related+=1},remove:function(){e.data(this,r.datakey).related-=1},setup:function(){if(e.data(this,r.datakey))return;var t={related:0,active:[],anyactive:0,winner:0,location:{}};e.data(this,r.datakey,t),r.targets.push(this)},teardown:function(){var t=e.data(this,r.datakey)||{};if(t.related)return;e.removeData(this,r.datakey);var n=this;r.targets=e.grep(r.targets,function(e){return e!==n})},handler:function(t,i){var s,o;if(!i)return;switch(t.type){case"mousedown":case"touchstart":o=e(r.targets),typeof i.drop=="string"&&(o=o.filter(i.drop)),o.each(function(){var t=e.data(this,r.datakey);t.active=[],t.anyactive=0,t.winner=0}),i.droppable=o,n.drag.hijack(t,"dropinit",i);break;case"mousemove":case"touchmove":r.event=t,r.timer||r.tolerate(i);break;case"mouseup":case"touchend":r.timer=clearTimeout(r.timer),i.propagates&&(n.drag.hijack(t,"drop",i),n.drag.hijack(t,"dropend",i))}},locate:function(t,n){var i=e.data(t,r.datakey),s=e(t),o=s.offset()||{},u=s.outerHeight(),a=s.outerWidth(),f={elem:t,width:a,height:u,top:o.top,left:o.left,right:o.left+a,bottom:o.top+u};return i&&(i.location=f,i.index=n,i.elem=t),f},contains:function(e,t){return(t[0]||t.left)>=e.left&&(t[0]||t.right)<=e.right&&(t[1]||t.top)>=e.top&&(t[1]||t.bottom)<=e.bottom},modes:{intersect:function(e,t,n){return this.contains(n,[e.pageX,e.pageY])?1e9:this.modes.overlap.apply(this,arguments)},overlap:function(e,t,n){return Math.max(0,Math.min(n.bottom,t.bottom)-Math.max(n.top,t.top))*Math.max(0,Math.min(n.right,t.right)-Math.max(n.left,t.left))},fit:function(e,t,n){return this.contains(n,t)?1:0},middle:function(e,t,n){return this.contains(n,[t.left+t.width*.5,t.top+t.height*.5])?1:0}},sort:function(e,t){return t.winner-e.winner||e.index-t.index},tolerate:function(t){var i,s,o,u,a,f,l,c=0,h,p=t.interactions.length,d=[r.event.pageX,r.event.pageY],v=r.tolerance||r.modes[r.mode];do if(h=t.interactions[c]){if(!h)return;h.drop=[],a=[],f=h.droppable.length,v&&(o=r.locate(h.proxy)),i=0;do if(l=h.droppable[i]){u=e.data(l,r.datakey),s=u.location;if(!s)continue;u.winner=v?v.call(r,r.event,o,s):r.contains(s,d)?1:0,a.push(u)}while(++i<f);a.sort(r.sort),i=0;do if(u=a[i])u.winner&&h.drop.length<r.multi?(!u.active[c]&&!u.anyactive&&(n.drag.hijack(r.event,"dropstart",t,c,u.elem)[0]!==!1?(u.active[c]=1,u.anyactive+=1):u.winner=0),u.winner&&h.drop.push(u.elem)):u.active[c]&&u.anyactive==1&&(n.drag.hijack(r.event,"dropend",t,c,u.elem),u.active[c]=0,u.anyactive-=1);while(++i<f)}while(++c<p);r.last&&d[0]==r.last.pageX&&d[1]==r.last.pageY?delete r.timer:r.timer=setTimeout(function(){r.tolerate(t)},r.delay),r.last=r.event}};n.dropinit=n.dropstart=n.dropend=r}(jQuery),define("jquery.event.drop",["jquery"],function(e){return function(){var t,n;return t||e.$.drop}}(this)),define("mockup-patterns-sortable",["jquery","mockup-patterns-base","jquery.event.drag","jquery.event.drop"],function(e,t,n,r){var i=t.extend({name:"sortable",defaults:{selector:"li",dragClass:"item-dragging",cloneClass:"dragging",drop:null},init:function(){var t=this,n=0;t.$el.find(t.options.selector).drag("start",function(i,s){var o=this;return e(o).addClass(t.options.dragClass),r({tolerance:function(n,r,i){if(e(i.elem).closest(t.$el).length===0)return;var s=n.pageY>i.top+i.height/2;return e.data(i.elem,"drop+reorder",s?"insertAfter":"insertBefore"),this.contains(i,[n.pageX,n.pageY])}}),n=e(this).index(),e(this).clone().addClass(t.options.cloneClass).css({opacity:.75,position:"absolute"}).appendTo(document.body)}).drag(function(t,n){e(n.proxy).css({top:n.offsetY,left:n.offsetX});var r=n.drop[0],i=e.data(r||{},"drop+reorder");i&&r&&(r!=n.current||i!=n.method)&&(e(this)[i](r),n.current=r,n.method=i,n.update())}).drag("end",function(r,i){var s=e(this);s.removeClass(t.options.dragClass),e(i.proxy).remove(),t.options.drop&&t.options.drop(s,s.index()-n)}).drop("init",function(e,t){return this==t.drag?!1:!0})}});return i}),function(e){function J(e,t){return function(n){return tt(e.call(this,n),t)}}function K(e,t){return function(n){return this.lang().ordinal(e.call(this,n),t)}}function Q(){}function G(e){pt(e),Z(this,e)}function Y(e){var t=ut(e),n=t.year||0,r=t.month||0,i=t.week||0,s=t.day||0,o=t.hour||0,u=t.minute||0,a=t.second||0,f=t.millisecond||0;this._milliseconds=+f+a*1e3+u*6e4+o*36e5,this._days=+s+i*7,this._months=+r+n*12,this._data={},this._bubble()}function Z(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n]);return t.hasOwnProperty("toString")&&(e.toString=t.toString),t.hasOwnProperty("valueOf")&&(e.valueOf=t.valueOf),e}function et(e){return e<0?Math.ceil(e):Math.floor(e)}function tt(e,t,n){var r=Math.abs(e)+"",i=e>=0;while(r.length<t)r="0"+r;return(i?n?"+":"":"-")+r}function nt(e,n,r,i){var s=n._milliseconds,o=n._days,u=n._months,a,f;s&&e._d.setTime(+e._d+s*r);if(o||u)a=e.minute(),f=e.hour();o&&e.date(e.date()+o*r),u&&e.month(e.month()+u*r),s&&!i&&t.updateOffset(e);if(o||u)e.minute(a),e.hour(f)}function rt(e){return Object.prototype.toString.call(e)==="[object Array]"}function it(e){return Object.prototype.toString.call(e)==="[object Date]"||e instanceof Date}function st(e,t,n){var r=Math.min(e.length,t.length),i=Math.abs(e.length-t.length),s=0,o;for(o=0;o<r;o++)(n&&e[o]!==t[o]||!n&&ft(e[o])!==ft(t[o]))&&s++;return s+i}function ot(e){if(e){var t=e.toLowerCase().replace(/(.)s$/,"$1");e=R[e]||U[t]||t}return e}function ut(e){var t={},n,r;for(r in e)e.hasOwnProperty(r)&&(n=ot(r),n&&(t[n]=e[r]));return t}function at(n){var r,i;if(n.indexOf("week")===0)r=7,i="day";else{if(n.indexOf("month")!==0)return;r=12,i="month"}t[n]=function(s,o){var u,a,f=t.fn._lang[n],l=[];typeof s=="number"&&(o=s,s=e),a=function(e){var n=t().utc().set(i,e);return f.call(t.fn._lang,n,s||"")};if(o!=null)return a(o);for(u=0;u<r;u++)l.push(a(u));return l}}function ft(e){var t=+e,n=0;return t!==0&&isFinite(t)&&(t>=0?n=Math.floor(t):n=Math.ceil(t)),n}function lt(e,t){return(new Date(Date.UTC(e,t+1,0))).getUTCDate()}function ct(e){return ht(e)?366:365}function ht(e){return e%4===0&&e%100!==0||e%400===0}function pt(e){var t;e._a&&e._pf.overflow===-2&&(t=e._a[u]<0||e._a[u]>11?u:e._a[a]<1||e._a[a]>lt(e._a[o],e._a[u])?a:e._a[f]<0||e._a[f]>23?f:e._a[l]<0||e._a[l]>59?l:e._a[c]<0||e._a[c]>59?c:e._a[h]<0||e._a[h]>999?h:-1,e._pf._overflowDayOfYear&&(t<o||t>a)&&(t=a),e._pf.overflow=t)}function dt(e){e._pf={empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1}}function vt(e){return e._isValid==null&&(e._isValid=!isNaN(e._d.getTime())&&e._pf.overflow<0&&!e._pf.empty&&!e._pf.invalidMonth&&!e._pf.nullInput&&!e._pf.invalidFormat&&!e._pf.userInvalidated,e._strict&&(e._isValid=e._isValid&&e._pf.charsLeftOver===0&&e._pf.unusedTokens.length===0)),e._isValid}function mt(e){return e?e.toLowerCase().replace("_","-"):e}function gt(e,n){return n._isUTC?t(e).zone(n._offset||0):t(e).local()}function yt(e,t){return t.abbr=e,p[e]||(p[e]=new Q),p[e].set(t),p[e]}function bt(e){delete p[e]}function wt(e){var n=0,r,i,s,o,u=function(e){if(!p[e]&&d)try{require("./lang/"+e)}catch(t){}return p[e]};if(!e)return t.fn._lang;if(!rt(e)){i=u(e);if(i)return i;e=[e]}while(n<e.length){o=mt(e[n]).split("-"),r=o.length,s=mt(e[n+1]),s=s?s.split("-"):null;while(r>0){i=u(o.slice(0,r).join("-"));if(i)return i;if(s&&s.length>=r&&st(o,s,!0)>=r-1)break;r--}n++}return t.fn._lang}function Et(e){return e.match(/\[[\s\S]/)?e.replace(/^\[|\]$/g,""):e.replace(/\\/g,"")}function St(e){var t=e.match(y),n,r;for(n=0,r=t.length;n<r;n++)V[t[n]]?t[n]=V[t[n]]:t[n]=Et(t[n]);return function(i){var s="";for(n=0;n<r;n++)s+=t[n]instanceof Function?t[n].call(i,e):t[n];return s}}function xt(e,t){return e.isValid()?(t=Tt(t,e.lang()),z[t]||(z[t]=St(t)),z[t](e)):e.lang().invalidDate()}function Tt(e,t){function r(e){return t.longDateFormat(e)||e}var n=5;b.lastIndex=0;while(n>=0&&b.test(e))e=e.replace(b,r),b.lastIndex=0,n-=1;return e}function Nt(e,t){var n,r=t._strict;switch(e){case"DDDD":return M;case"YYYY":case"GGGG":case"gggg":return r?_:S;case"YYYYYY":case"YYYYY":case"GGGGG":case"ggggg":return r?D:x;case"S":if(r)return A;case"SS":if(r)return O;case"SSS":case"DDD":return r?M:E;case"MMM":case"MMMM":case"dd":case"ddd":case"dddd":return N;case"a":case"A":return wt(t._l)._meridiemParse;case"X":return L;case"Z":case"ZZ":return C;case"T":return k;case"SSSS":return T;case"MM":case"DD":case"YY":case"GG":case"gg":case"HH":case"hh":case"mm":case"ss":case"ww":case"WW":return r?O:w;case"M":case"D":case"d":case"H":case"h":case"m":case"s":case"w":case"W":case"e":case"E":return r?A:w;default:return n=new RegExp(Dt(_t(e.replace("\\","")),"i")),n}}function Ct(e){e=e||"";var t=e.match(C)||[],n=t[t.length-1]||[],r=(n+"").match(F)||["-",0,0],i=+(r[1]*60)+ft(r[2]);return r[0]==="+"?-i:i}function kt(e,t,n){var r,i=n._a;switch(e){case"M":case"MM":t!=null&&(i[u]=ft(t)-1);break;case"MMM":case"MMMM":r=wt(n._l).monthsParse(t),r!=null?i[u]=r:n._pf.invalidMonth=t;break;case"D":case"DD":t!=null&&(i[a]=ft(t));break;case"DDD":case"DDDD":t!=null&&(n._dayOfYear=ft(t));break;case"YY":i[o]=ft(t)+(ft(t)>68?1900:2e3);break;case"YYYY":case"YYYYY":case"YYYYYY":i[o]=ft(t);break;case"a":case"A":n._isPm=wt(n._l).isPM(t);break;case"H":case"HH":case"h":case"hh":i[f]=ft(t);break;case"m":case"mm":i[l]=ft(t);break;case"s":case"ss":i[c]=ft(t);break;case"S":case"SS":case"SSS":case"SSSS":i[h]=ft(("0."+t)*1e3);break;case"X":n._d=new Date(parseFloat(t)*1e3);break;case"Z":case"ZZ":n._useUTC=!0,n._tzm=Ct(t);break;case"w":case"ww":case"W":case"WW":case"d":case"dd":case"ddd":case"dddd":case"e":case"E":e=e.substr(0,1);case"gg":case"gggg":case"GG":case"GGGG":case"GGGGG":e=e.substr(0,2),t&&(n._w=n._w||{},n._w[e]=t)}}function Lt(e){var n,r,i=[],s,c,h,p,d,v,m,g;if(e._d)return;s=Ot(e),e._w&&e._a[a]==null&&e._a[u]==null&&(h=function(n){var r=parseInt(n,10);return n?n.length<3?r>68?1900+r:2e3+r:r:e._a[o]==null?t().weekYear():e._a[o]},p=e._w,p.GG!=null||p.W!=null||p.E!=null?d=zt(h(p.GG),p.W||1,p.E,4,1):(v=wt(e._l),m=p.d!=null?It(p.d,v):p.e!=null?parseInt(p.e,10)+v._week.dow:0,g=parseInt(p.w,10)||1,p.d!=null&&m<v._week.dow&&g++,d=zt(h(p.gg),g,m,v._week.doy,v._week.dow)),e._a[o]=d.year,e._dayOfYear=d.dayOfYear),e._dayOfYear&&(c=e._a[o]==null?s[o]:e._a[o],e._dayOfYear>ct(c)&&(e._pf._overflowDayOfYear=!0),r=Ft(c,0,e._dayOfYear),e._a[u]=r.getUTCMonth(),e._a[a]=r.getUTCDate());for(n=0;n<3&&e._a[n]==null;++n)e._a[n]=i[n]=s[n];for(;n<7;n++)e._a[n]=i[n]=e._a[n]==null?n===2?1:0:e._a[n];i[f]+=ft((e._tzm||0)/60),i[l]+=ft((e._tzm||0)%60),e._d=(e._useUTC?Ft:jt).apply(null,i)}function At(e){var t;if(e._d)return;t=ut(e._i),e._a=[t.year,t.month,t.day,t.hour,t.minute,t.second,t.millisecond],Lt(e)}function Ot(e){var t=new Date;return e._useUTC?[t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate()]:[t.getFullYear(),t.getMonth(),t.getDate()]}function Mt(e){e._a=[],e._pf.empty=!0;var t=wt(e._l),n=""+e._i,r,i,s,o,u,a=n.length,l=0;s=Tt(e._f,t).match(y)||[];for(r=0;r<s.length;r++)o=s[r],i=(n.match(Nt(o,e))||[])[0],i&&(u=n.substr(0,n.indexOf(i)),u.length>0&&e._pf.unusedInput.push(u),n=n.slice(n.indexOf(i)+i.length),l+=i.length),V[o]?(i?e._pf.empty=!1:e._pf.unusedTokens.push(o),kt(o,i,e)):e._strict&&!i&&e._pf.unusedTokens.push(o);e._pf.charsLeftOver=a-l,n.length>0&&e._pf.unusedInput.push(n),e._isPm&&e._a[f]<12&&(e._a[f]+=12),e._isPm===!1&&e._a[f]===12&&(e._a[f]=0),Lt(e),pt(e)}function _t(e){return e.replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(e,t,n,r,i){return t||n||r||i})}function Dt(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function Pt(e){var t,n,r,i,s;if(e._f.length===0){e._pf.invalidFormat=!0,e._d=new Date(NaN);return}for(i=0;i<e._f.length;i++){s=0,t=Z({},e),dt(t),t._f=e._f[i],Mt(t);if(!vt(t))continue;s+=t._pf.charsLeftOver,s+=t._pf.unusedTokens.length*10,t._pf.score=s;if(r==null||s<r)r=s,n=t}Z(e,n||t)}function Ht(e){var t,n=e._i,r=P.exec(n);if(r){e._pf.iso=!0;for(t=4;t>0;t--)if(r[t]){e._f=B[t-1]+(r[6]||" ");break}for(t=0;t<4;t++)if(j[t][1].exec(n)){e._f+=j[t][0];break}n.match(C)&&(e._f+="Z"),Mt(e)}else e._d=new Date(n)}function Bt(t){var n=t._i,r=v.exec(n);n===e?t._d=new Date:r?t._d=new Date(+r[1]):typeof n=="string"?Ht(t):rt(n)?(t._a=n.slice(0),Lt(t)):it(n)?t._d=new Date(+n):typeof n=="object"?At(t):t._d=new Date(n)}function jt(e,t,n,r,i,s,o){var u=new Date(e,t,n,r,i,s,o);return e<1970&&u.setFullYear(e),u}function Ft(e){var t=new Date(Date.UTC.apply(null,arguments));return e<1970&&t.setUTCFullYear(e),t}function It(e,t){if(typeof e=="string")if(!isNaN(e))e=parseInt(e,10);else{e=t.weekdaysParse(e);if(typeof e!="number")return null}return e}function qt(e,t,n,r,i){return i.relativeTime(t||1,!!n,e,r)}function Rt(e,t,n){var r=i(Math.abs(e)/1e3),s=i(r/60),o=i(s/60),u=i(o/24),a=i(u/365),f=r<45&&["s",r]||s===1&&["m"]||s<45&&["mm",s]||o===1&&["h"]||o<22&&["hh",o]||u===1&&["d"]||u<=25&&["dd",u]||u<=45&&["M"]||u<345&&["MM",i(u/30)]||a===1&&["y"]||["yy",a];return f[2]=t,f[3]=e>0,f[4]=n,qt.apply({},f)}function Ut(e,n,r){var i=r-n,s=r-e.day(),o;return s>i&&(s-=7),s<i-7&&(s+=7),o=t(e).add("d",s),{week:Math.ceil(o.dayOfYear()/7),year:o.year()}}function zt(e,t,n,r,i){var s=(new Date(tt(e,6,!0)+"-01-01")).getUTCDay(),o,u;return n=n!=null?n:i,o=i-s+(s>r?7:0),u=7*(t-1)+(n-i)+o+1,{year:u>0?e:e-1,dayOfYear:u>0?u:ct(e-1)+u}}function Wt(e){var n=e._i,r=e._f;return typeof e._pf=="undefined"&&dt(e),n===null?t.invalid({nullInput:!0}):(typeof n=="string"&&(e._i=n=wt().preparse(n)),t.isMoment(n)?(e=Z({},n),e._d=new Date(+n._d)):r?rt(r)?Pt(e):Mt(e):Bt(e),new G(e))}function Xt(e,n){t.fn[e]=t.fn[e+"s"]=function(e){var r=this._isUTC?"UTC":"";return e!=null?(this._d["set"+r+n](e),t.updateOffset(this),this):this._d["get"+r+n]()}}function Vt(e){t.duration.fn[e]=function(){return this._data[e]}}function $t(e,n){t.duration.fn["as"+e]=function(){return+this/n}}function Jt(e){var n=!1,i=t;if(typeof ender!="undefined")return;e?(r.moment=function(){return!n&&console&&console.warn&&(n=!0,console.warn("Accessing Moment through the global scope is deprecated, and will be removed in an upcoming release.")),i.apply(null,arguments)},Z(r.moment,i)):r.moment=t}var t,n="2.5.0",r=this,i=Math.round,s,o=0,u=1,a=2,f=3,l=4,c=5,h=6,p={},d=typeof module!="undefined"&&module.exports&&typeof require!="undefined",v=/^\/?Date\((\-?\d+)/i,m=/(\-)?(?:(\d*)\.)?(\d+)\:(\d+)(?:\:(\d+)\.?(\d{3})?)?/,g=/^(-)?P(?:(?:([0-9,.]*)Y)?(?:([0-9,.]*)M)?(?:([0-9,.]*)D)?(?:T(?:([0-9,.]*)H)?(?:([0-9,.]*)M)?(?:([0-9,.]*)S)?)?|([0-9,.]*)W)$/,y=/(\[[^\[]*\])|(\\)?(Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|mm?|ss?|S{1,4}|X|zz?|ZZ?|.)/g,b=/(\[[^\[]*\])|(\\)?(LT|LL?L?L?|l{1,4})/g,w=/\d\d?/,E=/\d{1,3}/,S=/\d{1,4}/,x=/[+\-]?\d{1,6}/,T=/\d+/,N=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,C=/Z|[\+\-]\d\d:?\d\d/gi,k=/T/i,L=/[\+\-]?\d+(\.\d{1,3})?/,A=/\d/,O=/\d\d/,M=/\d{3}/,_=/\d{4}/,D=/[+\-]?\d{6}/,P=/^\s*\d{4}-(?:(\d\d-\d\d)|(W\d\d$)|(W\d\d-\d)|(\d\d\d))((T| )(\d\d(:\d\d(:\d\d(\.\d+)?)?)?)?([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,H="YYYY-MM-DDTHH:mm:ssZ",B=["YYYY-MM-DD","GGGG-[W]WW","GGGG-[W]WW-E","YYYY-DDD"],j=[["HH:mm:ss.SSSS",/(T| )\d\d:\d\d:\d\d\.\d{1,3}/],["HH:mm:ss",/(T| )\d\d:\d\d:\d\d/],["HH:mm",/(T| )\d\d:\d\d/],["HH",/(T| )\d\d/]],F=/([\+\-]|\d\d)/gi,I="Date|Hours|Minutes|Seconds|Milliseconds".split("|"),q={Milliseconds:1,Seconds:1e3,Minutes:6e4,Hours:36e5,Days:864e5,Months:2592e6,Years:31536e6},R={ms:"millisecond",s:"second",m:"minute",h:"hour",d:"day",D:"date",w:"week",W:"isoWeek",M:"month",y:"year",DDD:"dayOfYear",e:"weekday",E:"isoWeekday",gg:"weekYear",GG:"isoWeekYear"},U={dayofyear:"dayOfYear",isoweekday:"isoWeekday",isoweek:"isoWeek",weekyear:"weekYear",isoweekyear:"isoWeekYear"},z={},W="DDD w W M D d".split(" "),X="M D H h m s w W".split(" "),V={M:function(){return this.month()+1},MMM:function(e){return this.lang().monthsShort(this,e)},MMMM:function(e){return this.lang().months(this,e)},D:function(){return this.date()},DDD:function(){return this.dayOfYear()},d:function(){return this.day()},dd:function(e){return this.lang().weekdaysMin(this,e)},ddd:function(e){return this.lang().weekdaysShort(this,e)},dddd:function(e){return this.lang().weekdays(this,e)},w:function(){return this.week()},W:function(){return this.isoWeek()},YY:function(){return tt(this.year()%100,2)},YYYY:function(){return tt(this.year(),4)},YYYYY:function(){return tt(this.year(),5)},YYYYYY:function(){var e=this.year(),t=e>=0?"+":"-";return t+tt(Math.abs(e),6)},gg:function(){return tt(this.weekYear()%100,2)},gggg:function(){return this.weekYear()},ggggg:function(){return tt(this.weekYear(),5)},GG:function(){return tt(this.isoWeekYear()%100,2)},GGGG:function(){return this.isoWeekYear()},GGGGG:function(){return tt(this.isoWeekYear(),5)},e:function(){return this.weekday()},E:function(){return this.isoWeekday()},a:function(){return this.lang().meridiem(this.hours(),this.minutes(),!0)},A:function(){return this.lang().meridiem(this.hours(),this.minutes(),!1)},H:function(){return this.hours()},h:function(){return this.hours()%12||12},m:function(){return this.minutes()},s:function(){return this.seconds()},S:function(){return ft(this.milliseconds()/100)},SS:function(){return tt(ft(this.milliseconds()/10),2)},SSS:function(){return tt(this.milliseconds(),3)},SSSS:function(){return tt(this.milliseconds(),3)},Z:function(){var e=-this.zone(),t="+";return e<0&&(e=-e,t="-"),t+tt(ft(e/60),2)+":"+tt(ft(e)%60,2)},ZZ:function(){var e=-this.zone(),t="+";return e<0&&(e=-e,t="-"),t+tt(ft(e/60),2)+tt(ft(e)%60,2)},z:function(){return this.zoneAbbr()},zz:function(){return this.zoneName()},X:function(){return this.unix()},Q:function(){return this.quarter()}},$=["months","monthsShort","weekdays","weekdaysShort","weekdaysMin"];while(W.length)s=W.pop(),V[s+"o"]=K(V[s],s);while(X.length)s=X.pop(),V[s+s]=J(V[s],2);V.DDDD=J(V.DDD,3),Z(Q.prototype,{set:function(e){var t,n;for(n in e)t=e[n],typeof t=="function"?this[n]=t:this["_"+n]=t},_months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),months:function(e){return this._months[e.month()]},_monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),monthsShort:function(e){return this._monthsShort[e.month()]},monthsParse:function(e){var n,r,i;this._monthsParse||(this._monthsParse=[]);for(n=0;n<12;n++){this._monthsParse[n]||(r=t.utc([2e3,n]),i="^"+this.months(r,"")+"|^"+this.monthsShort(r,""),this._monthsParse[n]=new RegExp(i.replace(".",""),"i"));if(this._monthsParse[n].test(e))return n}},_weekdays:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),weekdays:function(e){return this._weekdays[e.day()]},_weekdaysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),weekdaysShort:function(e){return this._weekdaysShort[e.day()]},_weekdaysMin:"Su_Mo_Tu_We_Th_Fr_Sa".split("_"),weekdaysMin:function(e){return this._weekdaysMin[e.day()]},weekdaysParse:function(e){var n,r,i;this._weekdaysParse||(this._weekdaysParse=[]);for(n=0;n<7;n++){this._weekdaysParse[n]||(r=t([2e3,1]).day(n),i="^"+this.weekdays(r,"")+"|^"+this.weekdaysShort(r,"")+"|^"+this.weekdaysMin(r,""),this._weekdaysParse[n]=new RegExp(i.replace(".",""),"i"));if(this._weekdaysParse[n].test(e))return n}},_longDateFormat:{LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D YYYY",LLL:"MMMM D YYYY LT",LLLL:"dddd, MMMM D YYYY LT"},longDateFormat:function(e){var t=this._longDateFormat[e];return!t&&this._longDateFormat[e.toUpperCase()]&&(t=this._longDateFormat[e.toUpperCase()].replace(/MMMM|MM|DD|dddd/g,function(e){return e.slice(1)}),this._longDateFormat[e]=t),t},isPM:function(e){return(e+"").toLowerCase().charAt(0)==="p"},_meridiemParse:/[ap]\.?m?\.?/i,meridiem:function(e,t,n){return e>11?n?"pm":"PM":n?"am":"AM"},_calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},calendar:function(e,t){var n=this._calendar[e];return typeof n=="function"?n.apply(t):n},_relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},relativeTime:function(e,t,n,r){var i=this._relativeTime[n];return typeof i=="function"?i(e,t,n,r):i.replace(/%d/i,e)},pastFuture:function(e,t){var n=this._relativeTime[e>0?"future":"past"];return typeof n=="function"?n(t):n.replace(/%s/i,t)},ordinal:function(e){return this._ordinal.replace("%d",e)},_ordinal:"%d",preparse:function(e){return e},postformat:function(e){return e},week:function(e){return Ut(e,this._week.dow,this._week.doy).week},_week:{dow:0,doy:6},_invalidDate:"Invalid date",invalidDate:function(){return this._invalidDate}}),t=function(t,n,r,i){return typeof r=="boolean"&&(i=r,r=e),Wt({_i:t,_f:n,_l:r,_strict:i,_isUTC:!1})},t.utc=function(t,n,r,i){var s;return typeof r=="boolean"&&(i=r,r=e),s=Wt({_useUTC:!0,_isUTC:!0,_l:r,_i:t,_f:n,_strict:i}).utc(),s},t.unix=function(e){return t(e*1e3)},t.duration=function(e,n){var r=e,i=null,s,o,u;return t.isDuration(e)?r={ms:e._milliseconds,d:e._days,M:e._months}:typeof e=="number"?(r={},n?r[n]=e:r.milliseconds=e):(i=m.exec(e))?(s=i[1]==="-"?-1:1,r={y:0,d:ft(i[a])*s,h:ft(i[f])*s,m:ft(i[l])*s,s:ft(i[c])*s,ms:ft(i[h])*s}):!(i=g.exec(e))||(s=i[1]==="-"?-1:1,u=function(e){var t=e&&parseFloat(e.replace(",","."));return(isNaN(t)?0:t)*s},r={y:u(i[2]),M:u(i[3]),d:u(i[4]),h:u(i[5]),m:u(i[6]),s:u(i[7]),w:u(i[8])}),o=new Y(r),t.isDuration(e)&&e.hasOwnProperty("_lang")&&(o._lang=e._lang),o},t.version=n,t.defaultFormat=H,t.updateOffset=function(){},t.lang=function(e,n){var r;return e?(n?yt(mt(e),n):n===null?(bt(e),e="en"):p[e]||wt(e),r=t.duration.fn._lang=t.fn._lang=wt(e),r._abbr):t.fn._lang._abbr},t.langData=function(e){return e&&e._lang&&e._lang._abbr&&(e=e._lang._abbr),wt(e)},t.isMoment=function(e){return e instanceof G},t.isDuration=function(e){return e instanceof Y};for(s=$.length-1;s>=0;--s)at($[s]);t.normalizeUnits=function(e){return ot(e)},t.invalid=function(e){var n=t.utc(NaN);return e!=null?Z(n._pf,e):n._pf.userInvalidated=!0,n},t.parseZone=function(e){return t(e).parseZone()},Z(t.fn=G.prototype,{clone:function(){return t(this)},valueOf:function(){return+this._d+(this._offset||0)*6e4},unix:function(){return Math.floor(+this/1e3)},toString:function(){return this.clone().lang("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")},toDate:function(){return this._offset?new Date(+this):this._d},toISOString:function(){var e=t(this).utc();return 0<e.year()&&e.year()<=9999?xt(e,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]"):xt(e,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]")},toArray:function(){var e=this;return[e.year(),e.month(),e.date(),e.hours(),e.minutes(),e.seconds(),e.milliseconds()]},isValid:function(){return vt(this)},isDSTShifted:function(){return this._a?this.isValid()&&st(this._a,(this._isUTC?t.utc(this._a):t(this._a)).toArray())>0:!1},parsingFlags:function(){return Z({},this._pf)},invalidAt:function(){return this._pf.overflow},utc:function(){return this.zone(0)},local:function(){return this.zone(0),this._isUTC=!1,this},format:function(e){var n=xt(this,e||t.defaultFormat);return this.lang().postformat(n)},add:function(e,n){var r;return typeof e=="string"?r=t.duration(+n,e):r=t.duration(e,n),nt(this,r,1),this},subtract:function(e,n){var r;return typeof e=="string"?r=t.duration(+n,e):r=t.duration(e,n),nt(this,r,-1),this},diff:function(e,n,r){var i=gt(e,this),s=(this.zone()-i.zone())*6e4,o,u;return n=ot(n),n==="year"||n==="month"?(o=(this.daysInMonth()+i.daysInMonth())*432e5,u=(this.year()-i.year())*12+(this.month()-i.month()),u+=(this-t(this).startOf("month")-(i-t(i).startOf("month")))/o,u-=(this.zone()-t(this).startOf("month").zone()-(i.zone()-t(i).startOf("month").zone()))*6e4/o,n==="year"&&(u/=12)):(o=this-i,u=n==="second"?o/1e3:n==="minute"?o/6e4:n==="hour"?o/36e5:n==="day"?(o-s)/864e5:n==="week"?(o-s)/6048e5:o),r?u:et(u)},from:function(e,n){return t.duration(this.diff(e)).lang(this.lang()._abbr).humanize(!n)},fromNow:function(e){return this.from(t(),e)},calendar:function(){var e=gt(t(),this).startOf("day"),n=this.diff(e,"days",!0),r=n<-6?"sameElse":n<-1?"lastWeek":n<0?"lastDay":n<1?"sameDay":n<2?"nextDay":n<7?"nextWeek":"sameElse";return this.format(this.lang().calendar(r,this))},isLeapYear:function(){return ht(this.year())},isDST:function(){return this.zone()<this.clone().month(0).zone()||this.zone()<this.clone().month(5).zone()},day:function(e){var t=this._isUTC?this._d.getUTCDay():this._d.getDay();return e!=null?(e=It(e,this.lang()),this.add({d:e-t})):t},month:function(e){var n=this._isUTC?"UTC":"",r;if(e!=null){if(typeof e=="string"){e=this.lang().monthsParse(e);if(typeof e!="number")return this}return r=this.date(),this.date(1),this._d["set"+n+"Month"](e),this.date(Math.min(r,this.daysInMonth())),t.updateOffset(this),this}return this._d["get"+n+"Month"]()},startOf:function(e){e=ot(e);switch(e){case"year":this.month(0);case"month":this.date(1);case"week":case"isoWeek":case"day":this.hours(0);case"hour":this.minutes(0);case"minute":this.seconds(0);case"second":this.milliseconds(0)}return e==="week"?this.weekday(0):e==="isoWeek"&&this.isoWeekday(1),this},endOf:function(e){return e=ot(e),this.startOf(e).add(e==="isoWeek"?"week":e,1).subtract("ms",1)},isAfter:function(e,n){return n=typeof n!="undefined"?n:"millisecond",+this.clone().startOf(n)>+t(e).startOf(n)},isBefore:function(e,n){return n=typeof n!="undefined"?n:"millisecond",+this.clone().startOf(n)<+t(e).startOf(n)},isSame:function(e,t){return t=t||"ms",+this.clone().startOf(t)===+gt(e,this).startOf(t)},min:function(e){return e=t.apply(null,arguments),e<this?this:e},max:function(e){return e=t.apply(null,arguments),e>this?this:e},zone:function(e){var n=this._offset||0;return e==null?this._isUTC?n:this._d.getTimezoneOffset():(typeof e=="string"&&(e=Ct(e)),Math.abs(e)<16&&(e*=60),this._offset=e,this._isUTC=!0,n!==e&&nt(this,t.duration(n-e,"m"),1,!0),this)},zoneAbbr:function(){return this._isUTC?"UTC":""},zoneName:function(){return this._isUTC?"Coordinated Universal Time":""},parseZone:function(){return this._tzm?this.zone(this._tzm):typeof this._i=="string"&&this.zone(this._i),this},hasAlignedHourOffset:function(e){return e?e=t(e).zone():e=0,(this.zone()-e)%60===0},daysInMonth:function(){return lt(this.year(),this.month())},dayOfYear:function(e){var n=i((t(this).startOf("day")-t(this).startOf("year"))/864e5)+1;return e==null?n:this.add("d",e-n)},quarter:function(){return Math.ceil((this.month()+1)/3)},weekYear:function(e){var t=Ut(this,this.lang()._week.dow,this.lang()._week.doy).year;return e==null?t:this.add("y",e-t)},isoWeekYear:function(e){var t=Ut(this,1,4).year;return e==null?t:this.add("y",e-t)},week:function(e){var t=this.lang().week(this);return e==null?t:this.add("d",(e-t)*7)},isoWeek:function(e){var t=Ut(this,1,4).week;return e==null?t:this.add("d",(e-t)*7)},weekday:function(e){var t=(this.day()+7-this.lang()._week.dow)%7;return e==null?t:this.add("d",e-t)},isoWeekday:function(e){return e==null?this.day()||7:this.day(this.day()%7?e:e-7)},get:function(e){return e=ot(e),this[e]()},set:function(e,t){return e=ot(e),typeof this[e]=="function"&&this[e](t),this},lang:function(t){return t===e?this._lang:(this._lang=wt(t),this)}});for(s=0;s<I.length;s++)Xt(I[s].toLowerCase().replace(/s$/,""),I[s]);Xt("year","FullYear"),t.fn.days=t.fn.day,t.fn.months=t.fn.month,t.fn.weeks=t.fn.week,t.fn.isoWeeks=t.fn.isoWeek,t.fn.toJSON=t.fn.toISOString,Z(t.duration.fn=Y.prototype,{_bubble:function(){var e=this._milliseconds,t=this._days,n=this._months,r=this._data,i,s,o,u;r.milliseconds=e%1e3,i=et(e/1e3),r.seconds=i%60,s=et(i/60),r.minutes=s%60,o=et(s/60),r.hours=o%24,t+=et(o/24),r.days=t%30,n+=et(t/30),r.months=n%12,u=et(n/12),r.years=u},weeks:function(){return et(this.days()/7)},valueOf:function(){return this._milliseconds+this._days*864e5+this._months%12*2592e6+ft(this._months/12)*31536e6},humanize:function(e){var t=+this,n=Rt(t,!e,this.lang());return e&&(n=this.lang().pastFuture(t,n)),this.lang().postformat(n)},add:function(e,n){var r=t.duration(e,n);return this._milliseconds+=r._milliseconds,this._days+=r._days,this._months+=r._months,this._bubble(),this},subtract:function(e,n){var r=t.duration(e,n);return this._milliseconds-=r._milliseconds,this._days-=r._days,this._months-=r._months,this._bubble(),this},get:function(e){return e=ot(e),this[e.toLowerCase()+"s"]()},as:function(e){return e=ot(e),this["as"+e.charAt(0).toUpperCase()+e.slice(1)+"s"]()},lang:t.fn.lang,toIsoString:function(){var e=Math.abs(this.years()),t=Math.abs(this.months()),n=Math.abs(this.days()),r=Math.abs(this.hours()),i=Math.abs(this.minutes()),s=Math.abs(this.seconds()+this.milliseconds()/1e3);return this.asSeconds()?(this.asSeconds()<0?"-":"")+"P"+(e?e+"Y":"")+(t?t+"M":"")+(n?n+"D":"")+(r||i||s?"T":"")+(r?r+"H":"")+(i?i+"M":"")+(s?s+"S":""):"P0D"}});for(s in q)q.hasOwnProperty(s)&&($t(s,q[s]),Vt(s.toLowerCase()));$t("Weeks",6048e5),t.duration.fn.asMonths=function(){return(+this-this.years()*31536e6)/2592e6+this.years()*12},t.lang("en",{ordinal:function(e){var t=e%10,n=ft(e%100/10)===1?"th":t===1?"st":t===2?"nd":t===3?"rd":"th";return e+n}}),d?(module.exports=t,Jt(!0)):typeof define=="function"&&define.amd?define("moment",["require","exports","module"],function(n,r,i){return i.config&&i.config()&&i.config().noGlobal!==!0&&Jt(i.config().noGlobal===e),t}):Jt()}.call(this),define("mockup-patterns-moment",["jquery","mockup-patterns-base","moment"],function(e,t,n){var r=t.extend({name:"moment",defaults:{selector:null,format:"MMMM Do YYYY, h:mm:ss a"},convert:function(t){var r=this,i=t.attr("data-date");i||(i=e.trim(t.html())),i=n(i);if(!i.isValid())return;r.options.format==="relative"?i=i.fromNow():r.options.format==="calendar"?i=i.calendar():i=i.format(r.options.format),i&&t.html(i)},init:function(){var t=this;t.options.selector?t.$el.find(t.options.selector).each(function(){t.convert(e(this))}):t.convert(t.$el)}});return r}),define("js/patterns/structure/models/result",["backbone"],function(e){var t=e.Model.extend({defaults:function(){return{is_folderish:!1,review_state:""}},uid:function(){return this.attributes.UID}});return t}),define("js/patterns/structure/views/table",["jquery","underscore","backbone","js/patterns/structure/views/tablerow","text!js/patterns/structure/templates/table.xml","js/ui/views/base","mockup-patterns-sortable","mockup-patterns-moment","js/patterns/structure/models/result","js/patterns/structure/views/actionmenu"],function(e,t,n,r,i,s,o,u,a,f){var l=s.extend({tagName:"div",template:t.template(i),initialize:function(e){var t=this;s.prototype.initialize.apply(t,[e]),t.collection=t.app.collection,t.selectedCollection=t.app.selectedCollection,t.listenTo(t.collection,"sync",t.render),t.listenTo(t.selectedCollection,"remove",t.render),t.listenTo(t.selectedCollection,"reset",t.render),t.collection.pager(),t.subsetIds=[],t.contextInfo=t.folderModel=t.folderMenu=null,t.app.on("context-info-loaded",function(e){t.contextInfo=e,t.setContextInfo()})},events:{"click .breadcrumbs a":"breadcrumbClicked","change .select-all":"selectAll",'change .breadcrumbs-container input[type="checkbox"]':"selectFolder"},setContextInfo:function(){var n=this,r=n.contextInfo,i=n.$('[data-id="'+r.defaultPage+'"]');i.length>0&&(i.find("td.title").prepend("<span>*</span> "),i.addClass("default-page"));var s=r.breadcrumbs;if(s&&s.length){var o=n.$(".breadcrumbs a.crumb");t.each(s,function(e,t){o.eq(t).html(e.title)})}r.object?(n.folderModel=new a(r.object),e(".context-buttons",n.$el).show(),n.selectedCollection.findWhere({UID:r.object.UID})&&(e('input[type="checkbox"]',n.$breadcrumbs)[0].checked=!0),n.folderMenu=new f({app:n.app,model:n.folderModel,header:"Actions on current folder",canMove:!1}),e(".input-group-btn",n.$breadcrumbs).empty().append(n.folderMenu.render().el)):n.folderModel=null},render:function(){var n=this;n.$el.html(n.template({pathParts:t.filter(n.app.queryHelper.getCurrentPath().split("/").slice(1),function(e){return e.length>0}),status:n.app.status,statusType:n.app.statusType,activeColumns:n.app.activeColumns,availableColumns:n.app.availableColumns})),n.$breadcrumbs=e(".breadcrumbs-container",n.$el);if(n.collection.length){var i=n.$("tbody");n.collection.each(function(e){var t=(new r({model:e,app:n.app,table:n})).render();i.append(t.el)})}return n.moment=new u(n.$el,{selector:".ModificationDate,.EffectiveDate,.CreationDate",format:"relative"}),n.addReordering(),n.storeOrder(),this},breadcrumbClicked:function(t){t.preventDefault();var n=e(t.target);n[0].tagName!=="A"&&(n=n.parent("a"));var r="";e(n.prevAll("a").get().reverse()).each(function(){var t=e(this).attr("data-path");r+=t,t!=="/"&&(r+="/")}),r+=n.attr("data-path"),this.app.queryHelper.currentPath=r,this.collection.pager()},selectFolder:function(t){var n=this;n.folderModel&&(e(t.target).is(":checked")?n.selectedCollection.add(n.folderModel):this.selectedCollection.removeByUID(n.folderModel.attributes.UID),n.setContextInfo())},selectAll:function(t){e(t.target).is(":checked")?e('input[type="checkbox"]',this.$("tbody")).attr("checked","checked").change():this.selectedCollection.remove(this.collection.models),this.setContextInfo()},toggleSelectAll:function(t){var n=e(t.target);n.is(":checked")||this.$(".select-all").removeAttr("checked")},addReordering:function(){var e=this;if(e.app.inQueryMode()){e.app.setStatus("Can not order items while querying"),e.$el.removeClass("order-support");return}e.$el.addClass("order-support");var t=new o(e.$("tbody"),{selector:"tr",dragClass:"structure-dragging",drop:function(t,n){n!==0&&(e.app.moveItem(t.attr("data-id"),n,e.subsetIds),e.storeOrder())}})},storeOrder:function(){var t=this,n=[];t.$("tbody tr.itemRow").each(function(t){n.push(e(this).attr("data-id"))}),t.subsetIds=n}});return l}),define("text!js/ui/templates/popover.xml",[],function(){return'<div class="arrow"></div>\n<div class="popover-title">\n</div>\n<div class="items popover-content">\n</div>\n\n'}),define("js/ui/views/popover",["jquery","underscore","backbone","js/ui/views/container","mockup-patterns-backdrop","text!js/ui/templates/popover.xml"],function(e,t,n,r,i,s){var o=r.extend({tagName:"div",className:"popover",eventPrefix:"popover",template:s,content:null,title:null,triggerView:null,triggerEvents:{"button:click":"toggle"},placement:"bottom",events:{},opened:!1,closeOnOutClick:!0,appendInContainer:!0,backdrop:undefined,$backdrop:null,useBackdrop:!0,backdropOptions:{zIndex:"1009",opacity:"0.4",className:"backdrop backdrop-popover",classActiveName:"backdrop-active",closeOnEsc:!1,closeOnClick:!0},afterRender:function(){var e=this;this.bindTriggerEvents(),this.$(".popover-title").append(this.title(this.options)),this.$(".popover-content").append(this.content(this.options))},bindTriggerEvents:function(){this.triggerView&&t.each(this.triggerEvents,function(t,n){var r=this[t];r||e.error("Function not found."),this.stopListening(this.triggerView,n),this.listenTo(this.triggerView,n,r)},this)},getPosition:function(){var t=this.triggerView.$el;return e.extend({},{width:t[0].offsetWidth,height:t[0].offsetHeight},t.offset())},show:function(){var e=this.getPosition(),t=this.$el,n,r,i,s;r=this.placement,t.css({top:0,left:0}).addClass("active"),i=t[0].offsetWidth,s=t[0].offsetHeight;switch(r){case"bottom":n={top:e.top+e.height,left:e.left+e.width/2-i/2};break;case"top":n={top:e.top-s,left:e.left+e.width/2-i/2};break;case"left":n={top:e.top+e.height/2-s/2,left:e.left-i};break;case"right":n={top:e.top+e.height/2-s/2,left:e.left+e.width}}this.applyPlacement(n,r),this.setBackdrop(),this.useBackdrop===!0&&this.backdrop.show(),this.opened=!0,this.triggerView&&this.triggerView.$el.addClass("active"),this.uiEventTrigger("show",this)},applyPlacement:function(e,t){var n=this.$el,r=this.$el,i=r[0].offsetWidth,s=r[0].offsetHeight,o,u,a,f;n.offset(e).addClass(t).addClass("active"),o=r[0].offsetWidth,u=r[0].offsetHeight,t==="top"&&u!==s&&(e.top=e.top+s-u,f=!0),t==="bottom"||t==="top"?(a=0,e.left<0&&(a=e.left*-2,e.left=0,n.offset(e),o=r[0].offsetWidth,u=r[0].offsetHeight),this.positionArrow(a-i+o,o,"left")):this.positionArrow(u-s,u,"top"),f&&n.offset(e)},positionArrow:function(e,t,n){var r=this.$(".arrow");r.css(n,e?50*(1-e/t)+"%":"")},hide:function(){this.opened=!1,this.$el.removeClass("active"),this.triggerView&&this.triggerView.$el.removeClass("active"),this.uiEventTrigger("hide",this)},toggle:function(e,t){this.opened?this.hide():this.show()},setBackdrop:function(){if(this.useBackdrop===!0&&this.backdrop===undefined){var t=this;this.$backdrop=this.$el.closest(".ui-backdrop-element"),this.$backdrop.length===0&&(this.$backdrop=e("body")),this.backdrop=new i(this.$backdrop,this.backdropOptions),this.backdrop.$el.on("hidden.backdrop.patterns",function(e){e.namespace==="backdrop.patterns"&&(e.stopPropagation(),t.opened===!0&&t.hide())}),this.on("popover:hide",function(){this.backdrop.hide()},this)}}});return o}),define("text!js/patterns/structure/templates/selection_item.xml",[],function(){return'<span class="selected-item">\r  <a href="#" data-uid="<%= UID %>" title="remove" class="remove">\r    <span class="glyphicon glyphicon-remove-circle"></span>\r  </a>\r  <%= Title %>\r</span>\r'}),define("js/patterns/structure/views/selectionwell",["jquery","underscore","backbone","js/ui/views/popover","text!js/patterns/structure/templates/selection_item.xml"],function(e,t,n,r,i){var s=r.extend({className:"popover selected",title:t.template('<input type="text" class="filter" placeholder="Filter" /><a href="#" class=" remove-all"><span class="glyphicon glyphicon-remove-circle"></span> remove all</a>'),content:t.template("<% collection.each(function(item) { %><%= item_template(item.toJSON()) %><% }); %>"),events:{"click a.remove":"itemRemoved","keyup input.filter":"filterSelected","click .remove-all":"removeAll"},initialize:function(e){r.prototype.initialize.apply(this,[e]),this.listenTo(this.collection,"reset all add remove",this.render),this.options.item_template=t.template(i)},render:function(){return r.prototype.render.call(this),this.collection.length===0&&this.$el.removeClass("active"),this},itemRemoved:function(t){t.preventDefault();var n=e(t.currentTarget).data("uid");this.collection.removeByUID(n),this.collection.length!==0&&this.show()},filterSelected:function(t){var n=e(t.target).val().toLowerCase();e(".selected-item",this.$el).each(function(){var t=e(this);t.text().toLowerCase().indexOf(n)===-1?t.hide():t.show()})},removeAll:function(e){e.preventDefault(),this.collection.reset(),this.hide()}});return s}),function(e){typeof e.fn.each2=="undefined"&&e.extend(e.fn,{each2:function(t){var n=e([0]),r=-1,i=this.length;while(++r<i&&(n.context=n[0]=this[r])&&t.call(n[0],r,n)!==!1);return this}})}(jQuery),function(e,t){function p(e){var t,n,r,i;if(!e||e.length<1)return e;t="";for(n=0,r=e.length;n<r;n++)i=e.charAt(n),t+=h[i]||i;return t}function d(e,t){var n=0,r=t.length;for(;n<r;n+=1)if(m(e,t[n]))return n;return-1}function v(){var t=e(c);t.appendTo("body");var n={width:t.width()-t[0].clientWidth,height:t.height()-t[0].clientHeight};return t.remove(),n}function m(e,n){return e===n?!0:e===t||n===t?!1:e===null||n===null?!1:e.constructor===String?e+""==n+"":n.constructor===String?n+""==e+"":!1}function g(t,n){var r,i,s;if(t===null||t.length<1)return[];r=t.split(n);for(i=0,s=r.length;i<s;i+=1)r[i]=e.trim(r[i]);return r}function y(e){return e.outerWidth(!1)-e.width()}function b(n){var r="keyup-change-value";n.on("keydown",function(){e.data(n,r)===t&&e.data(n,r,n.val())}),n.on("keyup",function(){var i=e.data(n,r);i!==t&&n.val()!==i&&(e.removeData(n,r),n.trigger("keyup-change"))})}function w(n){n.on("mousemove",function(n){var r=a;(r===t||r.x!==n.pageX||r.y!==n.pageY)&&e(n.target).trigger("mousemove-filtered",n)})}function E(e,n,r){r=r||t;var i;return function(){var t=arguments;window.clearTimeout(i),i=window.setTimeout(function(){n.apply(r,t)},e)}}function S(e){var t=!1,n;return function(){return t===!1&&(n=e(),t=!0),n}}function x(e,t){var n=E(e,function(e){t.trigger("scroll-debounced",e)});t.on("scroll",function(e){d(e.target,t.get())>=0&&n(e)})}function T(e){if(e[0]===document.activeElement)return;window.setTimeout(function(){var t=e[0],n=e.val().length,r;e.focus(),e.is(":visible")&&t===document.activeElement&&(t.setSelectionRange?t.setSelectionRange(n,n):t.createTextRange&&(r=t.createTextRange(),r.collapse(!1),r.select()))},0)}function N(t){t=e(t)[0];var n=0,r=0;if("selectionStart"in t)n=t.selectionStart,r=t.selectionEnd-n;else if("selection"in document){t.focus();var i=document.selection.createRange();r=document.selection.createRange().text.length,i.moveStart("character",-t.value.length),n=i.text.length-r}return{offset:n,length:r}}function C(e){e.preventDefault(),e.stopPropagation()}function k(e){e.preventDefault(),e.stopImmediatePropagation()}function L(t){if(!u){var n=t[0].currentStyle||window.getComputedStyle(t[0],null);u=e(document.createElement("div")).css({position:"absolute",left:"-10000px",top:"-10000px",display:"none",fontSize:n.fontSize,fontFamily:n.fontFamily,fontStyle:n.fontStyle,fontWeight:n.fontWeight,letterSpacing:n.letterSpacing,textTransform:n.textTransform,whiteSpace:"nowrap"}),u.attr("class","select2-sizer"),e("body").append(u)}return u.text(t.val()),u.width()}function A(t,n,r){var i,s=[],o;i=t.attr("class"),i&&(i=""+i,e(i.split(" ")).each2(function(){this.indexOf("select2-")===0&&s.push(this)})),i=n.attr("class"),i&&(i=""+i,e(i.split(" ")).each2(function(){this.indexOf("select2-")!==0&&(o=r(this),o&&s.push(o))})),t.attr("class",s.join(" "))}function O(e,t,n,r){var i=p(e.toUpperCase()).indexOf(p(t.toUpperCase())),s=t.length;if(i<0){n.push(r(e));return}n.push(r(e.substring(0,i))),n.push("<span class='select2-match'>"),n.push(r(e.substring(i,i+s))),n.push("</span>"),n.push(r(e.substring(i+s,e.length)))}function M(e){var t={"\\":"&#92;","&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#47;"};return String(e).replace(/[&<>"'\/\\]/g,function(e){return t[e]})}function _(n){var r,i=null,s=n.quietMillis||100,o=n.url,u=this;return function(a){window.clearTimeout(r),r=window.setTimeout(function(){var r=n.data,s=o,f=n.transport||e.fn.select2.ajaxDefaults.transport,l={type:n.type||"GET",cache:n.cache||!1,jsonpCallback:n.jsonpCallback||t,dataType:n.dataType||"json"},c=e.extend({},e.fn.select2.ajaxDefaults.params,l);r=r?r.call(u,a.term,a.page,a.context):null,s=typeof s=="function"?s.call(u,a.term,a.page,a.context):s,i&&i.abort(),n.params&&(e.isFunction(n.params)?e.extend(c,n.params.call(u)):e.extend(c,n.params)),e.extend(c,{url:s,dataType:n.dataType,data:r,success:function(e){var t=n.results(e,a.page);a.callback(t)}}),i=f.call(u,c)},s)}}function D(t){var n=t,r,i,s=function(e){return""+e.text};e.isArray(n)&&(i=n,n={results:i}),e.isFunction(n)===!1&&(i=n,n=function(){return i});var o=n();return o.text&&(s=o.text,e.isFunction(s)||(r=o.text,s=function(e){return e[r]})),function(t){var r=t.term,i={results:[]},o;if(r===""){t.callback(n());return}o=function(n,i){var u,a;n=n[0];if(n.children){u={};for(a in n)n.hasOwnProperty(a)&&(u[a]=n[a]);u.children=[],e(n.children).each2(function(e,t){o(t,u.children)}),(u.children.length||t.matcher(r,s(u),n))&&i.push(u)}else t.matcher(r,s(n),n)&&i.push(n)},e(n().results).each2(function(e,t){o(t,i.results)}),t.callback(i)}}function P(n){var r=e.isFunction(n);return function(i){var s=i.term,o={results:[]};e(r?n():n).each(function(){var e=this.text!==t,n=e?this.text:this;(s===""||i.matcher(s,n))&&o.results.push(e?this:{id:this,text:this})}),i.callback(o)}}function H(t,n){if(e.isFunction(t))return!0;if(!t)return!1;throw new Error(n+" must be a function or a falsy value")}function B(t){return e.isFunction(t)?t():t}function j(t){var n=0;return e.each(t,function(e,t){t.children?n+=j(t.children):n++}),n}function F(e,n,r,i){var s=e,o=!1,u,a,f,l,c;if(!i.createSearchChoice||!i.tokenSeparators||i.tokenSeparators.length<1)return t;for(;;){a=-1;for(f=0,l=i.tokenSeparators.length;f<l;f++){c=i.tokenSeparators[f],a=e.indexOf(c);if(a>=0)break}if(a<0)break;u=e.substring(0,a),e=e.substring(a+c.length);if(u.length>0){u=i.createSearchChoice.call(this,u,n);if(u!==t&&u!==null&&i.id(u)!==t&&i.id(u)!==null){o=!1;for(f=0,l=n.length;f<l;f++)if(m(i.id(u),i.id(n[f]))){o=!0;break}o||r(u)}}}if(s!==e)return e}function I(t,n){var r=function(){};return r.prototype=new t,r.prototype.constructor=r,r.prototype.parent=t.prototype,r.prototype=e.extend(r.prototype,n),r}if(window.Select2!==t)return;var n,r,i,s,o,u,a={x:0,y:0},f,l,n={TAB:9,ENTER:13,ESC:27,SPACE:32,LEFT:37,UP:38,RIGHT:39,DOWN:40,SHIFT:16,CTRL:17,ALT:18,PAGE_UP:33,PAGE_DOWN:34,HOME:36,END:35,BACKSPACE:8,DELETE:46,isArrow:function(e){e=e.which?e.which:e;switch(e){case n.LEFT:case n.RIGHT:case n.UP:case n.DOWN:return!0}return!1},isControl:function(e){var t=e.which;switch(t){case n.SHIFT:case n.CTRL:case n.ALT:return!0}return e.metaKey?!0:!1},isFunctionKey:function(e){return e=e.which?e.which:e,e>=112&&e<=123}},c="<div class='select2-measure-scrollbar'></div>",h={"Ⓐ":"A","Ａ":"A","À":"A","Á":"A","Â":"A","Ầ":"A","Ấ":"A","Ẫ":"A","Ẩ":"A","Ã":"A","Ā":"A","Ă":"A","Ằ":"A","Ắ":"A","Ẵ":"A","Ẳ":"A","Ȧ":"A","Ǡ":"A","Ä":"A","Ǟ":"A","Ả":"A","Å":"A","Ǻ":"A","Ǎ":"A","Ȁ":"A","Ȃ":"A","Ạ":"A","Ậ":"A","Ặ":"A","Ḁ":"A","Ą":"A","Ⱥ":"A","Ɐ":"A","Ꜳ":"AA","Æ":"AE","Ǽ":"AE","Ǣ":"AE","Ꜵ":"AO","Ꜷ":"AU","Ꜹ":"AV","Ꜻ":"AV","Ꜽ":"AY","Ⓑ":"B","Ｂ":"B","Ḃ":"B","Ḅ":"B","Ḇ":"B","Ƀ":"B","Ƃ":"B","Ɓ":"B","Ⓒ":"C","Ｃ":"C","Ć":"C","Ĉ":"C","Ċ":"C","Č":"C","Ç":"C","Ḉ":"C","Ƈ":"C","Ȼ":"C","Ꜿ":"C","Ⓓ":"D","Ｄ":"D","Ḋ":"D","Ď":"D","Ḍ":"D","Ḑ":"D","Ḓ":"D","Ḏ":"D","Đ":"D","Ƌ":"D","Ɗ":"D","Ɖ":"D","Ꝺ":"D","Ǳ":"DZ","Ǆ":"DZ","ǲ":"Dz","ǅ":"Dz","Ⓔ":"E","Ｅ":"E","È":"E","É":"E","Ê":"E","Ề":"E","Ế":"E","Ễ":"E","Ể":"E","Ẽ":"E","Ē":"E","Ḕ":"E","Ḗ":"E","Ĕ":"E","Ė":"E","Ë":"E","Ẻ":"E","Ě":"E","Ȅ":"E","Ȇ":"E","Ẹ":"E","Ệ":"E","Ȩ":"E","Ḝ":"E","Ę":"E","Ḙ":"E","Ḛ":"E","Ɛ":"E","Ǝ":"E","Ⓕ":"F","Ｆ":"F","Ḟ":"F","Ƒ":"F","Ꝼ":"F","Ⓖ":"G","Ｇ":"G","Ǵ":"G","Ĝ":"G","Ḡ":"G","Ğ":"G","Ġ":"G","Ǧ":"G","Ģ":"G","Ǥ":"G","Ɠ":"G","Ꞡ":"G","Ᵹ":"G","Ꝿ":"G","Ⓗ":"H","Ｈ":"H","Ĥ":"H","Ḣ":"H","Ḧ":"H","Ȟ":"H","Ḥ":"H","Ḩ":"H","Ḫ":"H","Ħ":"H","Ⱨ":"H","Ⱶ":"H","Ɥ":"H","Ⓘ":"I","Ｉ":"I","Ì":"I","Í":"I","Î":"I","Ĩ":"I","Ī":"I","Ĭ":"I","İ":"I","Ï":"I","Ḯ":"I","Ỉ":"I","Ǐ":"I","Ȉ":"I","Ȋ":"I","Ị":"I","Į":"I","Ḭ":"I","Ɨ":"I","Ⓙ":"J","Ｊ":"J","Ĵ":"J","Ɉ":"J","Ⓚ":"K","Ｋ":"K","Ḱ":"K","Ǩ":"K","Ḳ":"K","Ķ":"K","Ḵ":"K","Ƙ":"K","Ⱪ":"K","Ꝁ":"K","Ꝃ":"K","Ꝅ":"K","Ꞣ":"K","Ⓛ":"L","Ｌ":"L","Ŀ":"L","Ĺ":"L","Ľ":"L","Ḷ":"L","Ḹ":"L","Ļ":"L","Ḽ":"L","Ḻ":"L","Ł":"L","Ƚ":"L","Ɫ":"L","Ⱡ":"L","Ꝉ":"L","Ꝇ":"L","Ꞁ":"L","Ǉ":"LJ","ǈ":"Lj","Ⓜ":"M","Ｍ":"M","Ḿ":"M","Ṁ":"M","Ṃ":"M","Ɱ":"M","Ɯ":"M","Ⓝ":"N","Ｎ":"N","Ǹ":"N","Ń":"N","Ñ":"N","Ṅ":"N","Ň":"N","Ṇ":"N","Ņ":"N","Ṋ":"N","Ṉ":"N","Ƞ":"N","Ɲ":"N","Ꞑ":"N","Ꞥ":"N","Ǌ":"NJ","ǋ":"Nj","Ⓞ":"O","Ｏ":"O","Ò":"O","Ó":"O","Ô":"O","Ồ":"O","Ố":"O","Ỗ":"O","Ổ":"O","Õ":"O","Ṍ":"O","Ȭ":"O","Ṏ":"O","Ō":"O","Ṑ":"O","Ṓ":"O","Ŏ":"O","Ȯ":"O","Ȱ":"O","Ö":"O","Ȫ":"O","Ỏ":"O","Ő":"O","Ǒ":"O","Ȍ":"O","Ȏ":"O","Ơ":"O","Ờ":"O","Ớ":"O","Ỡ":"O","Ở":"O","Ợ":"O","Ọ":"O","Ộ":"O","Ǫ":"O","Ǭ":"O","Ø":"O","Ǿ":"O","Ɔ":"O","Ɵ":"O","Ꝋ":"O","Ꝍ":"O","Ƣ":"OI","Ꝏ":"OO","Ȣ":"OU","Ⓟ":"P","Ｐ":"P","Ṕ":"P","Ṗ":"P","Ƥ":"P","Ᵽ":"P","Ꝑ":"P","Ꝓ":"P","Ꝕ":"P","Ⓠ":"Q","Ｑ":"Q","Ꝗ":"Q","Ꝙ":"Q","Ɋ":"Q","Ⓡ":"R","Ｒ":"R","Ŕ":"R","Ṙ":"R","Ř":"R","Ȑ":"R","Ȓ":"R","Ṛ":"R","Ṝ":"R","Ŗ":"R","Ṟ":"R","Ɍ":"R","Ɽ":"R","Ꝛ":"R","Ꞧ":"R","Ꞃ":"R","Ⓢ":"S","Ｓ":"S","ẞ":"S","Ś":"S","Ṥ":"S","Ŝ":"S","Ṡ":"S","Š":"S","Ṧ":"S","Ṣ":"S","Ṩ":"S","Ș":"S","Ş":"S","Ȿ":"S","Ꞩ":"S","Ꞅ":"S","Ⓣ":"T","Ｔ":"T","Ṫ":"T","Ť":"T","Ṭ":"T","Ț":"T","Ţ":"T","Ṱ":"T","Ṯ":"T","Ŧ":"T","Ƭ":"T","Ʈ":"T","Ⱦ":"T","Ꞇ":"T","Ꜩ":"TZ","Ⓤ":"U","Ｕ":"U","Ù":"U","Ú":"U","Û":"U","Ũ":"U","Ṹ":"U","Ū":"U","Ṻ":"U","Ŭ":"U","Ü":"U","Ǜ":"U","Ǘ":"U","Ǖ":"U","Ǚ":"U","Ủ":"U","Ů":"U","Ű":"U","Ǔ":"U","Ȕ":"U","Ȗ":"U","Ư":"U","Ừ":"U","Ứ":"U","Ữ":"U","Ử":"U","Ự":"U","Ụ":"U","Ṳ":"U","Ų":"U","Ṷ":"U","Ṵ":"U","Ʉ":"U","Ⓥ":"V","Ｖ":"V","Ṽ":"V","Ṿ":"V","Ʋ":"V","Ꝟ":"V","Ʌ":"V","Ꝡ":"VY","Ⓦ":"W","Ｗ":"W","Ẁ":"W","Ẃ":"W","Ŵ":"W","Ẇ":"W","Ẅ":"W","Ẉ":"W","Ⱳ":"W","Ⓧ":"X","Ｘ":"X","Ẋ":"X","Ẍ":"X","Ⓨ":"Y","Ｙ":"Y","Ỳ":"Y","Ý":"Y","Ŷ":"Y","Ỹ":"Y","Ȳ":"Y","Ẏ":"Y","Ÿ":"Y","Ỷ":"Y","Ỵ":"Y","Ƴ":"Y","Ɏ":"Y","Ỿ":"Y","Ⓩ":"Z","Ｚ":"Z","Ź":"Z","Ẑ":"Z","Ż":"Z","Ž":"Z","Ẓ":"Z","Ẕ":"Z","Ƶ":"Z","Ȥ":"Z","Ɀ":"Z","Ⱬ":"Z","Ꝣ":"Z","ⓐ":"a","ａ":"a","ẚ":"a","à":"a","á":"a","â":"a","ầ":"a","ấ":"a","ẫ":"a","ẩ":"a","ã":"a","ā":"a","ă":"a","ằ":"a","ắ":"a","ẵ":"a","ẳ":"a","ȧ":"a","ǡ":"a","ä":"a","ǟ":"a","ả":"a","å":"a","ǻ":"a","ǎ":"a","ȁ":"a","ȃ":"a","ạ":"a","ậ":"a","ặ":"a","ḁ":"a","ą":"a","ⱥ":"a","ɐ":"a","ꜳ":"aa","æ":"ae","ǽ":"ae","ǣ":"ae","ꜵ":"ao","ꜷ":"au","ꜹ":"av","ꜻ":"av","ꜽ":"ay","ⓑ":"b","ｂ":"b","ḃ":"b","ḅ":"b","ḇ":"b","ƀ":"b","ƃ":"b","ɓ":"b","ⓒ":"c","ｃ":"c","ć":"c","ĉ":"c","ċ":"c","č":"c","ç":"c","ḉ":"c","ƈ":"c","ȼ":"c","ꜿ":"c","ↄ":"c","ⓓ":"d","ｄ":"d","ḋ":"d","ď":"d","ḍ":"d","ḑ":"d","ḓ":"d","ḏ":"d","đ":"d","ƌ":"d","ɖ":"d","ɗ":"d","ꝺ":"d","ǳ":"dz","ǆ":"dz","ⓔ":"e","ｅ":"e","è":"e","é":"e","ê":"e","ề":"e","ế":"e","ễ":"e","ể":"e","ẽ":"e","ē":"e","ḕ":"e","ḗ":"e","ĕ":"e","ė":"e","ë":"e","ẻ":"e","ě":"e","ȅ":"e","ȇ":"e","ẹ":"e","ệ":"e","ȩ":"e","ḝ":"e","ę":"e","ḙ":"e","ḛ":"e","ɇ":"e","ɛ":"e","ǝ":"e","ⓕ":"f","ｆ":"f","ḟ":"f","ƒ":"f","ꝼ":"f","ⓖ":"g","ｇ":"g","ǵ":"g","ĝ":"g","ḡ":"g","ğ":"g","ġ":"g","ǧ":"g","ģ":"g","ǥ":"g","ɠ":"g","ꞡ":"g","ᵹ":"g","ꝿ":"g","ⓗ":"h","ｈ":"h","ĥ":"h","ḣ":"h","ḧ":"h","ȟ":"h","ḥ":"h","ḩ":"h","ḫ":"h","ẖ":"h","ħ":"h","ⱨ":"h","ⱶ":"h","ɥ":"h","ƕ":"hv","ⓘ":"i","ｉ":"i","ì":"i","í":"i","î":"i","ĩ":"i","ī":"i","ĭ":"i","ï":"i","ḯ":"i","ỉ":"i","ǐ":"i","ȉ":"i","ȋ":"i","ị":"i","į":"i","ḭ":"i","ɨ":"i","ı":"i","ⓙ":"j","ｊ":"j","ĵ":"j","ǰ":"j","ɉ":"j","ⓚ":"k","ｋ":"k","ḱ":"k","ǩ":"k","ḳ":"k","ķ":"k","ḵ":"k","ƙ":"k","ⱪ":"k","ꝁ":"k","ꝃ":"k","ꝅ":"k","ꞣ":"k","ⓛ":"l","ｌ":"l","ŀ":"l","ĺ":"l","ľ":"l","ḷ":"l","ḹ":"l","ļ":"l","ḽ":"l","ḻ":"l","ſ":"l","ł":"l","ƚ":"l","ɫ":"l","ⱡ":"l","ꝉ":"l","ꞁ":"l","ꝇ":"l","ǉ":"lj","ⓜ":"m","ｍ":"m","ḿ":"m","ṁ":"m","ṃ":"m","ɱ":"m","ɯ":"m","ⓝ":"n","ｎ":"n","ǹ":"n","ń":"n","ñ":"n","ṅ":"n","ň":"n","ṇ":"n","ņ":"n","ṋ":"n","ṉ":"n","ƞ":"n","ɲ":"n","ŉ":"n","ꞑ":"n","ꞥ":"n","ǌ":"nj","ⓞ":"o","ｏ":"o","ò":"o","ó":"o","ô":"o","ồ":"o","ố":"o","ỗ":"o","ổ":"o","õ":"o","ṍ":"o","ȭ":"o","ṏ":"o","ō":"o","ṑ":"o","ṓ":"o","ŏ":"o","ȯ":"o","ȱ":"o","ö":"o","ȫ":"o","ỏ":"o","ő":"o","ǒ":"o","ȍ":"o","ȏ":"o","ơ":"o","ờ":"o","ớ":"o","ỡ":"o","ở":"o","ợ":"o","ọ":"o","ộ":"o","ǫ":"o","ǭ":"o","ø":"o","ǿ":"o","ɔ":"o","ꝋ":"o","ꝍ":"o","ɵ":"o","ƣ":"oi","ȣ":"ou","ꝏ":"oo","ⓟ":"p","ｐ":"p","ṕ":"p","ṗ":"p","ƥ":"p","ᵽ":"p","ꝑ":"p","ꝓ":"p","ꝕ":"p","ⓠ":"q","ｑ":"q","ɋ":"q","ꝗ":"q","ꝙ":"q","ⓡ":"r","ｒ":"r","ŕ":"r","ṙ":"r","ř":"r","ȑ":"r","ȓ":"r","ṛ":"r","ṝ":"r","ŗ":"r","ṟ":"r","ɍ":"r","ɽ":"r","ꝛ":"r","ꞧ":"r","ꞃ":"r","ⓢ":"s","ｓ":"s","ß":"s","ś":"s","ṥ":"s","ŝ":"s","ṡ":"s","š":"s","ṧ":"s","ṣ":"s","ṩ":"s","ș":"s","ş":"s","ȿ":"s","ꞩ":"s","ꞅ":"s","ẛ":"s","ⓣ":"t","ｔ":"t","ṫ":"t","ẗ":"t","ť":"t","ṭ":"t","ț":"t","ţ":"t","ṱ":"t","ṯ":"t","ŧ":"t","ƭ":"t","ʈ":"t","ⱦ":"t","ꞇ":"t","ꜩ":"tz","ⓤ":"u","ｕ":"u","ù":"u","ú":"u","û":"u","ũ":"u","ṹ":"u","ū":"u","ṻ":"u","ŭ":"u","ü":"u","ǜ":"u","ǘ":"u","ǖ":"u","ǚ":"u","ủ":"u","ů":"u","ű":"u","ǔ":"u","ȕ":"u","ȗ":"u","ư":"u","ừ":"u","ứ":"u","ữ":"u","ử":"u","ự":"u","ụ":"u","ṳ":"u","ų":"u","ṷ":"u","ṵ":"u","ʉ":"u","ⓥ":"v","ｖ":"v","ṽ":"v","ṿ":"v","ʋ":"v","ꝟ":"v","ʌ":"v","ꝡ":"vy","ⓦ":"w","ｗ":"w","ẁ":"w","ẃ":"w","ŵ":"w","ẇ":"w","ẅ":"w","ẘ":"w","ẉ":"w","ⱳ":"w","ⓧ":"x","ｘ":"x","ẋ":"x","ẍ":"x","ⓨ":"y","ｙ":"y","ỳ":"y","ý":"y","ŷ":"y","ỹ":"y","ȳ":"y","ẏ":"y","ÿ":"y","ỷ":"y","ẙ":"y","ỵ":"y","ƴ":"y","ɏ":"y","ỿ":"y","ⓩ":"z","ｚ":"z","ź":"z","ẑ":"z","ż":"z","ž":"z","ẓ":"z","ẕ":"z","ƶ":"z","ȥ":"z","ɀ":"z","ⱬ":"z","ꝣ":"z"};f=e(document),o=function(){var e=1;return function(){return e++}}(),f.on("mousemove",function(e){a.x=e.pageX,a.y=e.pageY}),r=I(Object,{bind:function(e){var t=this;return function(){e.apply(t,arguments)}},init:function(n){var r,i,s=".select2-results";this.opts=n=this.prepareOpts(n),this.id=n.id,n.element.data("select2")!==t&&n.element.data("select2")!==null&&n.element.data("select2").destroy(),this.container=this.createContainer(),this.containerId="s2id_"+(n.element.attr("id")||"autogen"+o()),this.containerSelector="#"+this.containerId.replace(/([;&,\.\+\*\~':"\!\^#$%@\[\]\(\)=>\|])/g,"\\$1"),this.container.attr("id",this.containerId),this.body=S(function(){return n.element.closest("body")}),A(this.container,this.opts.element,this.opts.adaptContainerCssClass),this.container.attr("style",n.element.attr("style")),this.container.css(B(n.containerCss)),this.container.addClass(B(n.containerCssClass)),this.elementTabIndex=this.opts.element.attr("tabindex"),this.opts.element.data("select2",this).attr("tabindex","-1").before(this.container).on("click.select2",C),this.container.data("select2",this),this.dropdown=this.container.find(".select2-drop"),A(this.dropdown,this.opts.element,this.opts.adaptDropdownCssClass),this.dropdown.addClass(B(n.dropdownCssClass)),this.dropdown.data("select2",this),this.dropdown.on("click",C),this.results=r=this.container.find(s),this.search=i=this.container.find("input.select2-input"),this.queryCount=0,this.resultsPage=0,this.context=null,this.initContainer(),this.container.on("click",C),w(this.results),this.dropdown.on("mousemove-filtered touchstart touchmove touchend",s,this.bind(this.highlightUnderEvent)),x(80,this.results),this.dropdown.on("scroll-debounced",s,this.bind(this.loadMoreIfNeeded)),e(this.container).on("change",".select2-input",function(e){e.stopPropagation()}),e(this.dropdown).on("change",".select2-input",function(e){e.stopPropagation()}),e.fn.mousewheel&&r.mousewheel(function(e,t,n,i){var s=r.scrollTop();i>0&&s-i<=0?(r.scrollTop(0),C(e)):i<0&&r.get(0).scrollHeight-r.scrollTop()+i<=r.height()&&(r.scrollTop(r.get(0).scrollHeight-r.height()),C(e))}),b(i),i.on("keyup-change input paste",this.bind(this.updateResults)),i.on("focus",function(){i.addClass("select2-focused")}),i.on("blur",function(){i.removeClass("select2-focused")}),this.dropdown.on("mouseup",s,this.bind(function(t){e(t.target).closest(".select2-result-selectable").length>0&&(this.highlightUnderEvent(t),this.selectHighlighted(t))})),this.dropdown.on("click mouseup mousedown",function(e){e.stopPropagation()}),e.isFunction(this.opts.initSelection)&&(this.initSelection(),this.monitorSource()),n.maximumInputLength!==null&&this.search.attr("maxlength",n.maximumInputLength);var u=n.element.prop("disabled");u===t&&(u=!1),this.enable(!u);var a=n.element.prop("readonly");a===t&&(a=!1),this.readonly(a),l=l||v(),this.autofocus=n.element.prop("autofocus"),n.element.prop("autofocus",!1),this.autofocus&&this.focus(),this.nextSearchTerm=t},destroy:function(){var e=this.opts.element,n=e.data("select2");this.close(),this.propertyObserver&&(delete this.propertyObserver,this.propertyObserver=null),n!==t&&(n.container.remove(),n.dropdown.remove(),e.removeClass("select2-offscreen").removeData("select2").off(".select2").prop("autofocus",this.autofocus||!1),this.elementTabIndex?e.attr({tabindex:this.elementTabIndex}):e.removeAttr("tabindex"),e.show())},optionToData:function(e){if(e.is("option"))return{id:e.prop("value"),text:e.text(),element:e.get(),css:e.attr("class"),disabled:e.prop("disabled"),locked:m(e.attr("locked"),"locked")||m(e.data("locked"),!0)};if(e.is("optgroup"))return{text:e.attr("label"),children:[],element:e.get(),css:e.attr("class")}},prepareOpts:function(n){var r,i,s,o,u=this;r=n.element,r.get(0).tagName.toLowerCase()==="select"&&(this.select=i=n.element),i&&e.each(["id","multiple","ajax","query","createSearchChoice","initSelection","data","tags"],function(){if(this in n)throw new Error("Option '"+this+"' is not allowed for Select2 when attached to a <select> element.")}),n=e.extend({},{populateResults:function(r,i,s){var o,a=this.opts.id;o=function(r,i,f){var l,c,h,p,d,v,m,g,y,b;r=n.sortResults(r,i,s);for(l=0,c=r.length;l<c;l+=1)h=r[l],d=h.disabled===!0,p=!d&&a(h)!==t,v=h.children&&h.children.length>0,m=e("<li></li>"),m.addClass("select2-results-dept-"+f),m.addClass("select2-result"),m.addClass(p?"select2-result-selectable":"select2-result-unselectable"),d&&m.addClass("select2-disabled"),v&&m.addClass("select2-result-with-children"),m.addClass(u.opts.formatResultCssClass(h)),g=e(document.createElement("div")),g.addClass("select2-result-label"),b=n.formatResult(h,g,s,u.opts.escapeMarkup),b!==t&&g.html(b),m.append(g),v&&(y=e("<ul></ul>"),y.addClass("select2-result-sub"),o(h.children,y,f+1),m.append(y)),m.data("select2-data",h),i.append(m)},o(i,r,0)}},e.fn.select2.defaults,n),typeof n.id!="function"&&(s=n.id,n.id=function(e){return e[s]});if(e.isArray(n.element.data("select2Tags"))){if("tags"in n)throw"tags specified as both an attribute 'data-select2-tags' and in options of Select2 "+n.element.attr("id");n.tags=n.element.data("select2Tags")}i?(n.query=this.bind(function(e){var n={results:[],more:!1},i=e.term,s,o,a;a=function(t,n){var r;t.is("option")?e.matcher(i,t.text(),t)&&n.push(u.optionToData(t)):t.is("optgroup")&&(r=u.optionToData(t),t.children().each2(function(e,t){a(t,r.children)}),r.children.length>0&&n.push(r))},s=r.children(),this.getPlaceholder()!==t&&s.length>0&&(o=this.getPlaceholderOption(),o&&(s=s.not(o))),s.each2(function(e,t){a(t,n.results)}),e.callback(n)}),n.id=function(e){return e.id},n.formatResultCssClass=function(e){return e.css}):"query"in n||("ajax"in n?(o=n.element.data("ajax-url"),o&&o.length>0&&(n.ajax.url=o),n.query=_.call(n.element,n.ajax)):"data"in n?n.query=D(n.data):"tags"in n&&(n.query=P(n.tags),n.createSearchChoice===t&&(n.createSearchChoice=function(t){return{id:e.trim(t),text:e.trim(t)}}),n.initSelection===t&&(n.initSelection=function(t,r){var i=[];e(g(t.val(),n.separator)).each(function(){var t={id:this,text:this},r=n.tags;e.isFunction(r)&&(r=r()),e(r).each(function(){if(m(this.id,t.id))return t=this,!1}),i.push(t)}),r(i)})));if(typeof n.query!="function")throw"query function not defined for Select2 "+n.element.attr("id");return n},monitorSource:function(){var e=this.opts.element,n,r;e.on("change.select2",this.bind(function(e){this.opts.element.data("select2-change-triggered")!==!0&&this.initSelection()})),n=this.bind(function(){var n=e.prop("disabled");n===t&&(n=!1),this.enable(!n);var r=e.prop("readonly");r===t&&(r=!1),this.readonly(r),A(this.container,this.opts.element,this.opts.adaptContainerCssClass),this.container.addClass(B(this.opts.containerCssClass)),A(this.dropdown,this.opts.element,this.opts.adaptDropdownCssClass),this.dropdown.addClass(B(this.opts.dropdownCssClass))}),e.on("propertychange.select2",n),this.mutationCallback===t&&(this.mutationCallback=function(e){e.forEach(n)}),r=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver,r!==t&&(this.propertyObserver&&(delete this.propertyObserver,this.propertyObserver=null),this.propertyObserver=new r(this.mutationCallback),this.propertyObserver.observe(e.get(0),{attributes:!0,subtree:!1}))},triggerSelect:function(t){var n=e.Event("select2-selecting",{val:this.id(t),object:t});return this.opts.element.trigger(n),!n.isDefaultPrevented()},triggerChange:function(t){t=t||{},t=e.extend({},t,{type:"change",val:this.val()}),this.opts.element.data("select2-change-triggered",!0),this.opts.element.trigger(t),this.opts.element.data("select2-change-triggered",!1),this.opts.element.click(),this.opts.blurOnChange&&this.opts.element.blur()},isInterfaceEnabled:function(){return this.enabledInterface===!0},enableInterface:function(){var e=this._enabled&&!this._readonly,t=!e;return e===this.enabledInterface?!1:(this.container.toggleClass("select2-container-disabled",t),this.close(),this.enabledInterface=e,!0)},enable:function(e){e===t&&(e=!0);if(this._enabled===e)return;this._enabled=e,this.opts.element.prop("disabled",!e),this.enableInterface()},disable:function(){this.enable(!1)},readonly:function(e){return e===t&&(e=!1),this._readonly===e?!1:(this._readonly=e,this.opts.element.prop("readonly",e),this.enableInterface(),!0)},opened:function(){return this.container.hasClass("select2-dropdown-open")},positionDropdown:function(){var t=this.dropdown,n=this.container.offset(),r=this.container.outerHeight(!1),i=this.container.outerWidth(!1),s=t.outerHeight(!1),o=e(window),u=o.width(),a=o.height(),f=o.scrollLeft()+u,c=o.scrollTop()+a,h=n.top+r,p=n.left,d=h+s<=c,v=n.top-s>=this.body().scrollTop(),m=t.outerWidth(!1),g=p+m<=f,y=t.hasClass("select2-drop-above"),b,w,E,S,x;y?(w=!0,!v&&d&&(E=!0,w=!1)):(w=!1,!d&&v&&(E=!0,w=!0)),E&&(t.hide(),n=this.container.offset(),r=this.container.outerHeight(!1),i=this.container.outerWidth(!1),s=t.outerHeight(!1),f=o.scrollLeft()+u,c=o.scrollTop()+a,h=n.top+r,p=n.left,m=t.outerWidth(!1),g=p+m<=f,t.show()),this.opts.dropdownAutoWidth?(x=e(".select2-results",t)[0],t.addClass("select2-drop-auto-width"),t.css("width",""),m=t.outerWidth(!1)+(x.scrollHeight===x.clientHeight?0:l.width),m>i?i=m:m=i,g=p+m<=f):this.container.removeClass("select2-drop-auto-width"),this.body().css("position")!=="static"&&(b=this.body().offset(),h-=b.top,p-=b.left),g||(p=n.left+i-m),S={left:p,width:i},w?(S.bottom=a-n.top,S.top="auto",this.container.addClass("select2-drop-above"),t.addClass("select2-drop-above")):(S.top=h,S.bottom="auto",this.container.removeClass("select2-drop-above"),t.removeClass("select2-drop-above")),S=e.extend(S,B(this.opts.dropdownCss)),t.css(S)},shouldOpen:function(){var t;return this.opened()?!1:this._enabled===!1||this._readonly===!0?!1:(t=e.Event("select2-opening"),this.opts.element.trigger(t),!t.isDefaultPrevented())},clearDropdownAlignmentPreference:function(){this.container.removeClass("select2-drop-above"),this.dropdown.removeClass("select2-drop-above")},open:function(){return this.shouldOpen()?(this.opening(),!0):!1},opening:function(){var t=this.containerId,n="scroll."+t,r="resize."+t,i="orientationchange."+t,s;this.container.addClass("select2-dropdown-open").addClass("select2-container-active"),this.clearDropdownAlignmentPreference(),this.dropdown[0]!==this.body().children().last()[0]&&this.dropdown.detach().appendTo(this.body()),s=e("#select2-drop-mask"),s.length==0&&(s=e(document.createElement("div")),s.attr("id","select2-drop-mask").attr("class","select2-drop-mask"),s.hide(),s.appendTo(this.body()),s.on("mousedown touchstart click",function(t){var n=e("#select2-drop"),r;n.length>0&&(r=n.data("select2"),r.opts.selectOnBlur&&r.selectHighlighted({noFocus:!0}),r.close({focus:!0}),t.preventDefault(),t.stopPropagation())})),this.dropdown.prev()[0]!==s[0]&&this.dropdown.before(s),e("#select2-drop").removeAttr("id"),this.dropdown.attr("id","select2-drop"),s.show(),this.positionDropdown(),this.dropdown.show(),this.positionDropdown(),this.dropdown.addClass("select2-drop-active");var o=this;this.container.parents().add(window).each(function(){e(this).on(r+" "+n+" "+i,function(e){o.positionDropdown()})})},close:function(){if(!this.opened())return;var t=this.containerId,n="scroll."+t,r="resize."+t,i="orientationchange."+t;this.container.parents().add(window).each(function(){e(this).off(n).off(r).off(i)}),this.clearDropdownAlignmentPreference(),e("#select2-drop-mask").hide(),this.dropdown.removeAttr("id"),this.dropdown.hide(),this.container.removeClass("select2-dropdown-open").removeClass("select2-container-active"),this.results.empty(),this.clearSearch(),this.search.removeClass("select2-active"),this.opts.element.trigger(e.Event("select2-close"))},externalSearch:function(e){this.open(),this.search.val(e),this.updateResults(!1)},clearSearch:function(){},getMaximumSelectionSize:function(){return B(this.opts.maximumSelectionSize)},ensureHighlightVisible:function(){var t=this.results,n,r,i,s,o,u,a;r=this.highlight();if(r<0)return;if(r==0){t.scrollTop(0);return}n=this.findHighlightableChoices().find(".select2-result-label"),i=e(n[r]),s=i.offset().top+i.outerHeight(!0),r===n.length-1&&(a=t.find("li.select2-more-results"),a.length>0&&(s=a.offset().top+a.outerHeight(!0))),o=t.offset().top+t.outerHeight(!0),s>o&&t.scrollTop(t.scrollTop()+(s-o)),u=i.offset().top-t.offset().top,u<0&&i.css("display")!="none"&&t.scrollTop(t.scrollTop()+u)},findHighlightableChoices:function(){return this.results.find(".select2-result-selectable:not(.select2-disabled, .select2-selected)")},moveHighlight:function(t){var n=this.findHighlightableChoices(),r=this.highlight();while(r>-1&&r<n.length){r+=t;var i=e(n[r]);if(i.hasClass("select2-result-selectable")&&!i.hasClass("select2-disabled")&&!i.hasClass("select2-selected")){this.highlight(r);break}}},highlight:function(t){var n=this.findHighlightableChoices(),r,i;if(arguments.length===0)return d(n.filter(".select2-highlighted")[0],n.get());t>=n.length&&(t=n.length-1),t<0&&(t=0),this.removeHighlight(),r=e(n[t]),r.addClass("select2-highlighted"),this.ensureHighlightVisible(),i=r.data("select2-data"),i&&this.opts.element.trigger({type:"select2-highlight",val:this.id(i),choice:i})},removeHighlight:function(){this.results.find(".select2-highlighted").removeClass("select2-highlighted")},countSelectableResults:function(){return this.findHighlightableChoices().length},highlightUnderEvent:function(t){var n=e(t.target).closest(".select2-result-selectable");if(n.length>0&&!n.is(".select2-highlighted")){var r=this.findHighlightableChoices();this.highlight(r.index(n))}else n.length==0&&this.removeHighlight()},loadMoreIfNeeded:function(){var e=this.results,t=e.find("li.select2-more-results"),n,r=this.resultsPage+1,i=this,s=this.search.val(),o=this.context;if(t.length===0)return;n=t.offset().top-e.offset().top-e.height(),n<=this.opts.loadMorePadding&&(t.addClass("select2-active"),this.opts.query({element:this.opts.element,term:s,page:r,context:o,matcher:this.opts.matcher,callback:this.bind(function(n){if(!i.opened())return;i.opts.populateResults.call(this,e,n.results,{term:s,page:r,context:o}),i.postprocessResults(n,!1,!1),n.more===!0?(t.detach().appendTo(e).text(i.opts.formatLoadMore(r+1)),window.setTimeout(function(){i.loadMoreIfNeeded()},10)):t.remove(),i.positionDropdown(),i.resultsPage=r,i.context=n.context,this.opts.element.trigger({type:"select2-loaded",items:n})})}))},tokenize:function(){},updateResults:function(n){function h(){r.removeClass("select2-active"),u.positionDropdown()}function p(e){i.html(e),h()}var r=this.search,i=this.results,s=this.opts,o,u=this,a,f=r.val(),l=e.data(this.container,"select2-last-term"),c;if(n!==!0&&l&&m(f,l))return;e.data(this.container,"select2-last-term",f);if(n!==!0&&(this.showSearchInput===!1||!this.opened()))return;c=++this.queryCount;var d=this.getMaximumSelectionSize();if(d>=1){o=this.data();if(e.isArray(o)&&o.length>=d&&H(s.formatSelectionTooBig,"formatSelectionTooBig")){p("<li class='select2-selection-limit'>"+s.formatSelectionTooBig(d)+"</li>");return}}if(r.val().length<s.minimumInputLength){H(s.formatInputTooShort,"formatInputTooShort")?p("<li class='select2-no-results'>"+s.formatInputTooShort(r.val(),s.minimumInputLength)+"</li>"):p(""),n&&this.showSearch&&this.showSearch(!0);return}if(s.maximumInputLength&&r.val().length>s.maximumInputLength){H(s.formatInputTooLong,"formatInputTooLong")?p("<li class='select2-no-results'>"+s.formatInputTooLong(r.val(),s.maximumInputLength)+"</li>"):p("");return}s.formatSearching&&this.findHighlightableChoices().length===0&&p("<li class='select2-searching'>"+s.formatSearching()+"</li>"),r.addClass("select2-active"),this.removeHighlight(),a=this.tokenize(),a!=t&&a!=null&&r.val(a),this.resultsPage=1,s.query({element:s.element,term:r.val(),page:this.resultsPage,context:null,matcher:s.matcher,callback:this.bind(function(o){var a;if(c!=this.queryCount)return;if(!this.opened()){this.search.removeClass("select2-active");return}this.context=o.context===t?null:o.context,this.opts.createSearchChoice&&r.val()!==""&&(a=this.opts.createSearchChoice.call(u,r.val(),o.results),a!==t&&a!==null&&u.id(a)!==t&&u.id(a)!==null&&e(o.results).filter(function(){return m(u.id(this),u.id(a))}).length===0&&o.results.unshift(a));if(o.results.length===0&&H(s.formatNoMatches,"formatNoMatches")){p("<li class='select2-no-results'>"+s.formatNoMatches(r.val())+"</li>");return}i.empty(),u.opts.populateResults.call(this,i,o.results,{term:r.val(),page:this.resultsPage,context:null}),o.more===!0&&H(s.formatLoadMore,"formatLoadMore")&&(i.append("<li class='select2-more-results'>"+u.opts.escapeMarkup(s.formatLoadMore(this.resultsPage))+"</li>"),window.setTimeout(function(){u.loadMoreIfNeeded()},10)),this.postprocessResults(o,n),h(),this.opts.element.trigger({type:"select2-loaded",items:o})})})},cancel:function(){this.close()},blur:function(){this.opts.selectOnBlur&&this.selectHighlighted({noFocus:!0}),this.close(),this.container.removeClass("select2-container-active"),this.search[0]===document.activeElement&&this.search.blur(),this.clearSearch(),this.selection.find(".select2-search-choice-focus").removeClass("select2-search-choice-focus")},focusSearch:function(){T(this.search)},selectHighlighted:function(e){var t=this.highlight(),n=this.results.find(".select2-highlighted"),r=n.closest(".select2-result").data("select2-data");r?(this.highlight(t),this.onSelect(r,e)):e&&e.noFocus&&this.close()},getPlaceholder:function(){var e;return this.opts.element.attr("placeholder")||this.opts.element.attr("data-placeholder")||this.opts.element.data("placeholder")||this.opts.placeholder||((e=this.getPlaceholderOption())!==t?e.text():t)},getPlaceholderOption:function(){if(this.select){var e=this.select.children("option").first();if(this.opts.placeholderOption!==t)return this.opts.placeholderOption==="first"&&e||typeof this.opts.placeholderOption=="function"&&this.opts.placeholderOption(this.select);if(e.text()===""&&e.val()==="")return e}},initContainerWidth:function(){function n(){var n,r,i,s,o,u;if(this.opts.width==="off")return null;if(this.opts.width==="element")return this.opts.element.outerWidth(!1)===0?"auto":this.opts.element.outerWidth(!1)+"px";if(this.opts.width==="copy"||this.opts.width==="resolve"){n=this.opts.element.attr("style");if(n!==t){r=n.split(";");for(s=0,o=r.length;s<o;s+=1){u=r[s].replace(/\s/g,""),i=u.match(/^width:(([-+]?([0-9]*\.)?[0-9]+)(px|em|ex|%|in|cm|mm|pt|pc))/i);if(i!==null&&i.length>=1)return i[1]}}return this.opts.width==="resolve"?(n=this.opts.element.css("width"),n.indexOf("%")>0?n:this.opts.element.outerWidth(!1)===0?"auto":this.opts.element.outerWidth(!1)+"px"):null}return e.isFunction(this.opts.width)?this.opts.width():this.opts.width}var r=n.call(this);r!==null&&this.container.css("width",r)}}),i=I(r,{createContainer:function(){var t=e(document.createElement("div")).attr({"class":"select2-container"}).html(["<a href='javascript:void(0)' onclick='return false;' class='select2-choice' tabindex='-1'>","   <span class='select2-chosen'>&nbsp;</span><abbr class='select2-search-choice-close'></abbr>","   <span class='select2-arrow'><b></b></span>","</a>","<input class='select2-focusser select2-offscreen' type='text'/>","<div class='select2-drop select2-display-none'>","   <div class='select2-search'>","       <input type='text' autocomplete='off' autocorrect='off' autocapitalize='off' spellcheck='false' class='select2-input'/>","   </div>","   <ul class='select2-results'>","   </ul>","</div>"].join(""));return t},enableInterface:function(){this.parent.enableInterface.apply(this,arguments)&&this.focusser.prop("disabled",!this.isInterfaceEnabled())},opening:function(){var n,r,i;this.opts.minimumResultsForSearch>=0&&this.showSearch(!0),this.parent.opening.apply(this,arguments),this.showSearchInput!==!1&&this.search.val(this.focusser.val()),this.search.focus(),n=this.search.get(0),n.createTextRange?(r=n.createTextRange(),r.collapse(!1),r.select()):n.setSelectionRange&&(i=this.search.val().length,n.setSelectionRange(i,i)),this.search.val()===""&&this.nextSearchTerm!=t&&(this.search.val(this.nextSearchTerm),this.search.select()),this.focusser.prop("disabled",!0).val(""),this.updateResults(!0),this.opts.element.trigger(e.Event("select2-open"))},close:function(e){if(!this.opened())return;this.parent.close.apply(this,arguments),e=e||{focus:!0},this.focusser.removeAttr("disabled"),e.focus&&this.focusser.focus()},focus:function(){this.opened()?this.close():(this.focusser.removeAttr("disabled"),this.focusser.focus())},isFocused:function(){return this.container.hasClass("select2-container-active")},cancel:function(){this.parent.cancel.apply(this,arguments),this.focusser.removeAttr("disabled"),this.focusser.focus()},destroy:function(){e("label[for='"+this.focusser.attr("id")+"']").attr("for",this.opts.element.attr("id")),this.parent.destroy.apply(this,arguments)},initContainer:function(){var t,r=this.container,i=this.dropdown;this.opts.minimumResultsForSearch<0?this.showSearch(!1):this.showSearch(!0),this.selection=t=r.find(".select2-choice"),this.focusser=r.find(".select2-focusser"),this.focusser.attr("id","s2id_autogen"+o()),e("label[for='"+this.opts.element.attr("id")+"']").attr("for",this.focusser.attr("id")),this.focusser.attr("tabindex",this.elementTabIndex),this.search.on("keydown",this.bind(function(e){if(!this.isInterfaceEnabled())return;if(e.which===n.PAGE_UP||e.which===n.PAGE_DOWN){C(e);return}switch(e.which){case n.UP:case n.DOWN:this.moveHighlight(e.which===n.UP?-1:1),C(e);return;case n.ENTER:this.selectHighlighted(),C(e);return;case n.TAB:this.selectHighlighted({noFocus:!0});return;case n.ESC:this.cancel(e),C(e);return}})),this.search.on("blur",this.bind(function(e){document.activeElement===this.body().get(0)&&window.setTimeout(this.bind(function(){this.search.focus()}),0)})),this.focusser.on("keydown",this.bind(function(e){if(!this.isInterfaceEnabled())return;if(e.which===n.TAB||n.isControl(e)||n.isFunctionKey(e)||e.which===n.ESC)return;if(this.opts.openOnEnter===!1&&e.which===n.ENTER){C(e);return}if(e.which==n.DOWN||e.which==n.UP||e.which==n.ENTER&&this.opts.openOnEnter){if(e.altKey||e.ctrlKey||e.shiftKey||e.metaKey)return;this.open(),C(e);return}if(e.which==n.DELETE||e.which==n.BACKSPACE){this.opts.allowClear&&this.clear(),C(e);return}})),b(this.focusser),this.focusser.on("keyup-change input",this.bind(function(e){if(this.opts.minimumResultsForSearch>=0){e.stopPropagation();if(this.opened())return;this.open()}})),t.on("mousedown","abbr",this.bind(function(e){if(!this.isInterfaceEnabled())return;this.clear(),k(e),this.close(),this.selection.focus()})),t.on("mousedown",this.bind(function(t){this.container.hasClass("select2-container-active")||this.opts.element.trigger(e.Event("select2-focus")),this.opened()?this.close():this.isInterfaceEnabled()&&this.open(),C(t)})),i.on("mousedown",this.bind(function(){this.search.focus()})),t.on("focus",this.bind(function(e){C(e)})),this.focusser.on("focus",this.bind(function(){this.container.hasClass("select2-container-active")||this.opts.element.trigger(e.Event("select2-focus")),this.container.addClass("select2-container-active")})).on("blur",this.bind(function(){this.opened()||(this.container.removeClass("select2-container-active"),this.opts.element.trigger(e.Event("select2-blur")))})),this.search.on("focus",this.bind(function(){this.container.hasClass("select2-container-active")||this.opts.element.trigger(e.Event("select2-focus")),this.container.addClass("select2-container-active")})),this.initContainerWidth(),this.opts.element.addClass("select2-offscreen"),this.setPlaceholder()},clear:function(t){var n=this.selection.data("select2-data");if(n){var r=e.Event("select2-clearing");this.opts.element.trigger(r);if(r.isDefaultPrevented())return;var i=this.getPlaceholderOption();this.opts.element.val(i?i.val():""),this.selection.find(".select2-chosen").empty(),this.selection.removeData("select2-data"),this.setPlaceholder(),t!==!1&&(this.opts.element.trigger({type:"select2-removed",val:this.id(n),choice:n}),this.triggerChange({removed:n}))}},initSelection:function(){var e;if(this.isPlaceholderOptionSelected())this.updateSelection(null),this.close(),this.setPlaceholder();else{var n=this;this.opts.initSelection.call(null,this.opts.element,function(e){e!==t&&e!==null&&(n.updateSelection(e),n.close(),n.setPlaceholder())})}},isPlaceholderOptionSelected:function(){var e;return this.getPlaceholder()?(e=this.getPlaceholderOption())!==t&&e.prop("selected")||this.opts.element.val()===""||this.opts.element.val()===t||this.opts.element.val()===null:!1},prepareOpts:function(){var t=this.parent.prepareOpts.apply(this,arguments),n=this;return t.element.get(0).tagName.toLowerCase()==="select"?t.initSelection=function(e,t){var r=e.find("option").filter(function(){return this.selected});t(n.optionToData(r))}:"data"in t&&(t.initSelection=t.initSelection||function(n,r){var i=n.val(),s=null;t.query({matcher:function(e,n,r){var o=m(i,t.id(r));return o&&(s=r),o},callback:e.isFunction(r)?function(){r(s)}:e.noop})}),t},getPlaceholder:function(){return this.select&&this.getPlaceholderOption()===t?t:this.parent.getPlaceholder.apply(this,arguments)},setPlaceholder:function(){var e=this.getPlaceholder();if(this.isPlaceholderOptionSelected()&&e!==t){if(this.select&&this.getPlaceholderOption()===t)return;this.selection.find(".select2-chosen").html(this.opts.escapeMarkup(e)),this.selection.addClass("select2-default"),this.container.removeClass("select2-allowclear")}},postprocessResults:function(e,t,n){var r=0,i=this,s=!0;this.findHighlightableChoices().each2(function(e,t){if(m(i.id(t.data("select2-data")),i.opts.element.val()))return r=e,!1}),n!==!1&&(t===!0&&r>=0?this.highlight(r):this.highlight(0));if(t===!0){var o=this.opts.minimumResultsForSearch;o>=0&&this.showSearch(j(e.results)>=o)}},showSearch:function(t){if(this.showSearchInput===t)return;this.showSearchInput=t,this.dropdown.find(".select2-search").toggleClass("select2-search-hidden",!t),this.dropdown.find(".select2-search").toggleClass("select2-offscreen",!t),e(this.dropdown,this.container).toggleClass("select2-with-searchbox",t)},onSelect:function(e,t){if(!this.triggerSelect(e))return;var n=this.opts.element.val(),r=this.data();this.opts.element.val(this.id(e)),this.updateSelection(e),this.opts.element.trigger({type:"select2-selected",val:this.id(e),choice:e}),this.nextSearchTerm=this.opts.nextSearchTerm(e,this.search.val()),this.close(),(!t||!t.noFocus)&&this.focusser.focus(),m(n,this.id(e))||this.triggerChange({added:e,removed:r})},updateSelection:function(e){var n=this.selection.find(".select2-chosen"),r,i;this.selection.data("select2-data",e),n.empty(),e!==null&&(r=this.opts.formatSelection(e,n,this.opts.escapeMarkup)),r!==t&&n.append(r),i=this.opts.formatSelectionCssClass(e,n),i!==t&&n.addClass(i),this.selection.removeClass("select2-default"),this.opts.allowClear&&this.getPlaceholder()!==t&&this.container.addClass("select2-allowclear")},val:function(){var e,n=!1,r=null,i=this,s=this.data();if(arguments.length===0)return this.opts.element.val();e=arguments[0],arguments.length>1&&(n=arguments[1]);if(this.select)this.select.val(e).find("option").filter(function(){return this.selected}).each2(function(e,t){return r=i.optionToData(t),!1}),this.updateSelection(r),this.setPlaceholder(),n&&this.triggerChange({added:r,removed:s});else{if(!e&&e!==0){this.clear(n);return}if(this.opts.initSelection===t)throw new Error("cannot call val() if initSelection() is not defined");this.opts.element.val(e),this.opts.initSelection(this.opts.element,function(e){i.opts.element.val(e?i.id(e):""),i.updateSelection(e),i.setPlaceholder(),n&&i.triggerChange({added:e,removed:s})})}},clearSearch:function(){this.search.val(""),this.focusser.val("")},data:function(e){var n,r=!1;if(arguments.length===0)return n=this.selection.data("select2-data"),n==t&&(n=null),n;arguments.length>1&&(r=arguments[1]),e?(n=this.data(),this.opts.element.val(e?this.id(e):""),this.updateSelection(e),r&&this.triggerChange({added:e,removed:n})):this.clear(r)}}),s=I(r,{createContainer:function(){var t=e(document.createElement("div")).attr({"class":"select2-container select2-container-multi"}).html(["<ul class='select2-choices'>","  <li class='select2-search-field'>","    <input type='text' autocomplete='off' autocorrect='off' autocapitalize='off' spellcheck='false' class='select2-input'>","  </li>","</ul>","<div class='select2-drop select2-drop-multi select2-display-none'>","   <ul class='select2-results'>","   </ul>","</div>"].join(""));return t},prepareOpts:function(){var t=this.parent.prepareOpts.apply(this,arguments),n=this;return t.element.get(0).tagName.toLowerCase()==="select"?t.initSelection=function(e,t){var r=[];e.find("option").filter(function(){return this.selected}).each2(function(e,t){r.push(n.optionToData(t))}),t(r)}:"data"in t&&(t.initSelection=t.initSelection||function(n,r){var i=g(n.val(),t.separator),s=[];t.query({matcher:function(n,r,o){var u=e.grep(i,function(e){return m(e,t.id(o))}).length;return u&&s.push(o),u},callback:e.isFunction(r)?function(){var e=[];for(var n=0;n<i.length;n++){var o=i[n];for(var u=0;u<s.length;u++){var a=s[u];if(m(o,t.id(a))){e.push(a),s.splice(u,1);break}}}r(e)}:e.noop})}),t},selectChoice:function(e){var t=this.container.find(".select2-search-choice-focus");if(!t.length||!e||e[0]!=t[0])t.length&&this.opts.element.trigger("choice-deselected",t),t.removeClass("select2-search-choice-focus"),e&&e.length&&(this.close(),e.addClass("select2-search-choice-focus"),this.opts.element.trigger("choice-selected",e))},destroy:function(){e("label[for='"+this.search.attr("id")+"']").attr("for",this.opts.element.attr("id")),this.parent.destroy.apply(this,arguments)},initContainer:function(){var t=".select2-choices",r;this.searchContainer=this.container.find(".select2-search-field"),this.selection=r=this.container.find(t);var i=this;this.selection.on("click",".select2-search-choice:not(.select2-locked)",function(t){i.search[0].focus(),i.selectChoice(e(this))}),this.search.attr("id","s2id_autogen"+o()),e("label[for='"+this.opts.element.attr("id")+"']").attr("for",this.search.attr("id")),this.search.on("input paste",this.bind(function(){if(!this.isInterfaceEnabled())return;this.opened()||this.open()})),this.search.attr("tabindex",this.elementTabIndex),this.keydowns=0,this.search.on("keydown",this.bind(function(e){if(!this.isInterfaceEnabled())return;++this.keydowns;var t=r.find(".select2-search-choice-focus"),i=t.prev(".select2-search-choice:not(.select2-locked)"),s=t.next(".select2-search-choice:not(.select2-locked)"),o=N(this.search);if(!(!t.length||e.which!=n.LEFT&&e.which!=n.RIGHT&&e.which!=n.BACKSPACE&&e.which!=n.DELETE&&e.which!=n.ENTER)){var u=t;e.which==n.LEFT&&i.length?u=i:e.which==n.RIGHT?u=s.length?s:null:e.which===n.BACKSPACE?(this.unselect(t.first()),this.search.width(10),u=i.length?i:s):e.which==n.DELETE?(this.unselect(t.first()),this.search.width(10),u=s.length?s:null):e.which==n.ENTER&&(u=null),this.selectChoice(u),C(e),(!u||!u.length)&&this.open();return}if((e.which===n.BACKSPACE&&this.keydowns==1||e.which==n.LEFT)&&o.offset==0&&!o.length){this.selectChoice(r.find(".select2-search-choice:not(.select2-locked)").last()),C(e);return}this.selectChoice(null);if(this.opened())switch(e.which){case n.UP:case n.DOWN:this.moveHighlight(e.which===n.UP?-1:1),C(e);return;case n.ENTER:this.selectHighlighted(),C(e);return;case n.TAB:this.selectHighlighted({noFocus:!0}),this.close();return;case n.ESC:this.cancel(e),C(e);return}if(e.which===n.TAB||n.isControl(e)||n.isFunctionKey(e)||e.which===n.BACKSPACE||e.which===n.ESC)return;if(e.which===n.ENTER){if(this.opts.openOnEnter===!1)return;if(e.altKey||e.ctrlKey||e.shiftKey||e.metaKey)return}this.open(),(e.which===n.PAGE_UP||e.which===n.PAGE_DOWN)&&C(e),e.which===n.ENTER&&C(e)})),this.search.on("keyup",this.bind(function(e){this.keydowns=0,this.resizeSearch()})),this.search.on("blur",this.bind(function(t){this.container.removeClass("select2-container-active"),this.search.removeClass("select2-focused"),this.selectChoice(null),this.opened()||this.clearSearch(),t.stopImmediatePropagation(),this.opts.element.trigger(e.Event("select2-blur"))})),this.container.on("click",t,this.bind(function(t){if(!this.isInterfaceEnabled())return;if(e(t.target).closest(".select2-search-choice").length>0)return;this.selectChoice(null),this.clearPlaceholder(),this.container.hasClass("select2-container-active")||this.opts.element.trigger(e.Event("select2-focus")),this.open(),this.focusSearch(),t.preventDefault()})),this.container.on("focus",t,this.bind(function(){if(!this.isInterfaceEnabled())return;this.container.hasClass("select2-container-active")||this.opts.element.trigger(e.Event("select2-focus")),this.container.addClass("select2-container-active"),this.dropdown.addClass("select2-drop-active"),this.clearPlaceholder()})),this.initContainerWidth(),this.opts.element.addClass("select2-offscreen"),this.clearSearch()},enableInterface:function(){this.parent.enableInterface.apply(this,arguments)&&this.search.prop("disabled",!this.isInterfaceEnabled())},initSelection:function(){var e;this.opts.element.val()===""&&this.opts.element.text()===""&&(this.updateSelection([]),this.close(),this.clearSearch());if(this.select||this.opts.element.val()!==""){var n=this;this.opts.initSelection.call(null,this.opts.element,function(e){e!==t&&e!==null&&(n.updateSelection(e),n.close(),n.clearSearch())})}},clearSearch:function(){var e=this.getPlaceholder(),n=this.getMaxSearchWidth();e!==t&&this.getVal().length===0&&this.search.hasClass("select2-focused")===!1?(this.search.val(e).addClass("select2-default"),this.search.width(n>0?n:this.container.css("width"))):this.search.val("").width(10)},clearPlaceholder:function(){this.search.hasClass("select2-default")&&this.search.val("").removeClass("select2-default")},opening:function(){this.clearPlaceholder(),this.resizeSearch(),this.parent.opening.apply(this,arguments),this.focusSearch(),this.updateResults(!0),this.search.focus(),this.opts.element.trigger(e.Event("select2-open"))},close:function(){if(!this.opened())return;this.parent.close.apply(this,arguments)},focus:function(){this.close(),this.search.focus()},isFocused:function(){return this.search.hasClass("select2-focused")},updateSelection:function(t){var n=[],r=[],i=this;e(t).each(function(){d(i.id(this),n)<0&&(n.push(i.id(this)),r.push(this))}),t=r,this.selection.find(".select2-search-choice").remove(),e(t).each(function(){i.addSelectedChoice(this)}),i.postprocessResults()},tokenize:function(){var e=this.search.val();e=this.opts.tokenizer.call(this,e,this.data(),this.bind(this.onSelect),this.opts),e!=null&&e!=t&&(this.search.val(e),e.length>0&&this.open())},onSelect:function(e,t){if(!this.triggerSelect(e))return;this.addSelectedChoice(e),this.opts.element.trigger({type:"selected",val:this.id(e),choice:e}),(this.select||!this.opts.closeOnSelect)&&this.postprocessResults(e,!1,this.opts.closeOnSelect===!0),this.opts.closeOnSelect?(this.close(),this.search.width(10)):this.countSelectableResults()>0?(this.search.width(10),this.resizeSearch(),this.getMaximumSelectionSize()>0&&this.val().length>=this.getMaximumSelectionSize()&&this.updateResults(!0),this.positionDropdown()):(this.close(),this.search.width(10)),this.triggerChange({added:e}),(!t||!t.noFocus)&&this.focusSearch()},cancel:function(){this.close(),this.focusSearch()},addSelectedChoice:function(n){var r=!n.locked,i=e("<li class='select2-search-choice'>    <div></div>    <a href='#' onclick='return false;' class='select2-search-choice-close' tabindex='-1'></a></li>"),s=e("<li class='select2-search-choice select2-locked'><div></div></li>"),o=r?i:s,u=this.id(n),a=this.getVal(),f,l;f=this.opts.formatSelection(n,o.find("div"),this.opts.escapeMarkup),f!=t&&o.find("div").replaceWith("<div>"+f+"</div>"),l=this.opts.formatSelectionCssClass(n,o.find("div")),l!=t&&o.addClass(l),r&&o.find(".select2-search-choice-close").on("mousedown",C).on("click dblclick",this.bind(function(t){if(!this.isInterfaceEnabled())return;e(t.target).closest(".select2-search-choice").fadeOut("fast",this.bind(function(){this.unselect(e(t.target)),this.selection.find(".select2-search-choice-focus").removeClass("select2-search-choice-focus"),this.close(),this.focusSearch()})).dequeue(),C(t)})).on("focus",this.bind(function(){if(!this.isInterfaceEnabled())return;this.container.addClass("select2-container-active"),this.dropdown.addClass("select2-drop-active")})),o.data("select2-data",n),o.insertBefore(this.searchContainer),a.push(u),this.setVal(a)},unselect:function(t){var n=this.getVal(),r,i;t=t.closest(".select2-search-choice");if(t.length===0)throw"Invalid argument: "+t+". Must be .select2-search-choice";r=t.data("select2-data");if(!r)return;while((i=d(this.id(r),n))>=0)n.splice(i,1),this.setVal(n),this.select&&this.postprocessResults();var s=e.Event("select2-removing");s.val=this.id(r),s.choice=r,this.opts.element.trigger(s);if(s.isDefaultPrevented())return;t.remove(),this.opts.element.trigger({type:"select2-removed",val:this.id(r),choice:r}),this.triggerChange({removed:r})},postprocessResults:function(e,t,n){var r=this.getVal(),i=this.results.find(".select2-result"),s=this.results.find(".select2-result-with-children"),o=this;i.each2(function(e,t){var n=o.id(t.data("select2-data"));d(n,r)>=0&&(t.addClass("select2-selected"),t.find(".select2-result-selectable").addClass("select2-selected"))}),s.each2(function(e,t){!t.is(".select2-result-selectable")&&t.find(".select2-result-selectable:not(.select2-selected)").length===0&&t.addClass("select2-selected")}),this.highlight()==-1&&n!==!1&&o.highlight(0),!this.opts.createSearchChoice&&!i.filter(".select2-result:not(.select2-selected)").length>0&&(!e||e&&!e.more&&this.results.find(".select2-no-results").length===0)&&H(o.opts.formatNoMatches,"formatNoMatches")&&this.results.append("<li class='select2-no-results'>"+o.opts.formatNoMatches(o.search.val())+"</li>")},getMaxSearchWidth:function(){return this.selection.width()-y(this.search)},resizeSearch:function(){var e,t,n,r,i,s=y(this.search);e=L(this.search)+10,t=this.search.offset().left,n=this.selection.width(),r=this.selection.offset().left,i=n-(t-r)-s,i<e&&(i=n-s),i<40&&(i=n-s),i<=0&&(i=e),this.search.width(Math.floor(i))},getVal:function(){var e;return this.select?(e=this.select.val(),e===null?[]:e):(e=this.opts.element.val(),g(e,this.opts.separator))},setVal:function(t){var n;this.select?this.select.val(t):(n=[],e(t).each(function(){d(this,n)<0&&n.push(this)}),this.opts.element.val(n.length===0?"":n.join(this.opts.separator)))},buildChangeDetails:function(e,t){var t=t.slice(0),e=e.slice(0);for(var n=0;n<t.length;n++)for(var r=0;r<e.length;r++)m(this.opts.id(t[n]),this.opts.id(e[r]))&&(t.splice(n,1),n>0&&n--,e.splice(r,1),r--);return{added:t,removed:e}},val:function(n,r){var i,s=this;if(arguments.length===0)return this.getVal();i=this.data(),i.length||(i=[]);if(!n&&n!==0){this.opts.element.val(""),this.updateSelection([]),this.clearSearch(),r&&this.triggerChange({added:this.data(),removed:i});return}this.setVal(n);if(this.select)this.opts.initSelection(this.select,this.bind(this.updateSelection)),r&&this.triggerChange(this.buildChangeDetails(i,this.data()));else{if(this.opts.initSelection===t)throw new Error("val() cannot be called if initSelection() is not defined");this.opts.initSelection(this.opts.element,function(t){var n=e.map(t,s.id);s.setVal(n),s.updateSelection(t),s.clearSearch(),r&&s.triggerChange(s.buildChangeDetails(i,s.data()))})}this.clearSearch()},onSortStart:function(){if(this.select)throw new Error("Sorting of elements is not supported when attached to <select>. Attach to <input type='hidden'/> instead.");this.search.width(0),this.searchContainer.hide()},onSortEnd:function(){var t=[],n=this;this.searchContainer.show(),this.searchContainer.appendTo(this.searchContainer.parent()),this.resizeSearch(),this.selection.find(".select2-search-choice").each(function(){t.push(n.opts.id(e(this).data("select2-data")))}),this.setVal(t),this.triggerChange()},data:function(t,n){var r=this,i,s;if(arguments.length===0)return this.selection.find(".select2-search-choice").map(function(){return e(this).data("select2-data")}).get();s=this.data(),t||(t=[]),i=e.map(t,function(e){return r.opts.id(e)}),this.setVal(i),this.updateSelection(t),this.clearSearch(),n&&this.triggerChange(this.buildChangeDetails(s,this.data()))}}),e.fn.select2=function(){var n=Array.prototype.slice.call(arguments,0),r,o,u,a,f,l=["val","destroy","opened","open","close","focus","isFocused","container","dropdown","onSortStart","onSortEnd","enable","disable","readonly","positionDropdown","data","search"],c=["opened","isFocused","container","dropdown"],h=["val","data"],p={search:"externalSearch"};return this.each(function(){if(n.length===0||typeof n[0]=="object")r=n.length===0?{}:e.extend({},n[0]),r.element=e(this),r.element.get(0).tagName.toLowerCase()==="select"?f=r.element.prop("multiple"):(f=r.multiple||!1,"tags"in r&&(r.multiple=f=!0)),o=f?new s:new i,o.init(r);else{if(typeof n[0]!="string")throw"Invalid arguments to select2 plugin: "+n;if(d(n[0],l)<0)throw"Unknown method: "+n[0];a=t,o=e(this).data("select2");if(o===t)return;u=n[0],u==="container"?a=o.container:u==="dropdown"?a=o.dropdown:(p[u]&&(u=p[u]),a=o[u].apply(o,n.slice(1)));if(d(n[0],c)>=0||d(n[0],h)&&n.length==1)return!1}}),a===t?this:a},e.fn.select2.defaults={width:"copy",loadMorePadding:0,closeOnSelect:!0,openOnEnter:!0,containerCss:{},dropdownCss:{},containerCssClass:"",dropdownCssClass:"",formatResult:function(e,t,n,r){var i=[];return O(e.text,n.term,i,r),i.join("")},formatSelection:function(e,n,r){return e?r(e.text):t},sortResults:function(e,t,n){return e},formatResultCssClass:function(e){return t},formatSelectionCssClass:function(e,n){return t},formatNoMatches:function(){return"No matches found"},formatInputTooShort:function(e,t){var n=t-e.length;return"Please enter "+n+" more character"+(n==1?"":"s")},formatInputTooLong:function(e,t){var n=e.length-t;return"Please delete "+n+" character"+(n==1?"":"s")},formatSelectionTooBig:function(e){return"You can only select "+e+" item"+(e==1?"":"s")},formatLoadMore:function(e){return"Loading more results..."},formatSearching:function(){return"Searching..."},minimumResultsForSearch:0,minimumInputLength:0,maximumInputLength:null,maximumSelectionSize:0,id:function(e){return e.id},matcher:function(e,t){return p(""+t).toUpperCase().indexOf(p(""+e).toUpperCase())>=0},separator:",",tokenSeparators:[],tokenizer:F,escapeMarkup:M,blurOnChange:!1,selectOnBlur:!1,adaptContainerCssClass:function(e){return e},adaptDropdownCssClass:function(e){return null},nextSearchTerm:function(e,n){return t}},e.fn.select2.ajaxDefaults={transport:e.ajax,params:{type:"GET",cache:!1,dataType:"json"}},window.Select2={query:{ajax:_,local:D,tags:P},util:{debounce:E,markMatch:O,escapeMarkup:M,stripDiacritics:p},"class":{"abstract":r,single:i,multi:s}}}(jQuery),define("select2",function(){}),define("mockup-patterns-select2",["jquery","mockup-patterns-base","select2","jquery.event.drag","jquery.event.drop"],function(e,t){var n=t.extend({name:"select2",defaults:{separator:","},initializeValues:function(){var t=this;t.options.initialValues&&(t.options.id=function(e){return e.id},t.options.initSelection=function(n,r){var i=[],s=n.val(),o=t.options.initialValues;typeof t.options.initialValues=="string"&&t.options.initialValues!==""&&(t.options.initialValues[0]==="{"?o=JSON.parse(t.options.initialValues):(o={},e(t.options.initialValues.split(t.options.separator)).each(function(){var t=this.split(":"),n=e.trim(t[0]),r=e.trim(t[1]);o[n]=r}))),e(s.split(t.options.separator)).each(function(){var e=this;o[this]&&(e=o[this]),i.push({id:this,text:e})}),r(i)})},initializeTags:function(){var t=this;t.options.tags&&typeof t.options.tags=="string"&&(t.options.tags.substr(0,1)==="["?t.options.tags=JSON.parse(t.options.tags):t.options.tags=t.options.tags.split(t.options.separator)),t.options.tags&&!t.options.allowNewItems&&(t.options.data=e.map(t.options.tags,function(e,t){return{id:e,text:e}}),t.options.multiple=!0,delete t.options.tags)},initializeOrdering:function(){var t=this;if(t.options.orderable){var n=function(e,t){return e?e.text:undefined};t.options.formatSelection&&(n=t.options.formatSelection),t.options.formatSelection=function(r,i){return i.parents("li").drag("start",function(n,r){return e(this).addClass("select2-choice-dragging"),t.$el.select2("onSortStart"),e.drop({tolerance:function(t,n,r){var i=t.pageY>r.top+r.height/2;return e.data(r.elem,"drop+reorder",i?"insertAfter":"insertBefore"),this.contains(r,[t.pageX,t.pageY])}}),e(this).clone().addClass("dragging").css({opacity:.75,position:"absolute"}).appendTo(document.body)}).drag(function(t,n){e(n.proxy).css({top:n.offsetY,left:n.offsetX});var r=n.drop[0],i=e.data(r||{},"drop+reorder");r&&(r!=n.current||i!=n.method)&&(e(this)[i](r),n.current=r,n.method=i,n.update())}).drag("end",function(n,r){e(this).removeClass("select2-choice-dragging"),t.$el.select2("onSortEnd"),e(r.proxy).remove()}).drop("init",function(e,t){return this==t.drag?!1:!0}),n(r,i)}}},initializeSelect2:function(){var e=this;e.$el.select2(e.options),e.$select2=e.$el.parent().find(".select2-container"),e.$el.parent().off("close.modal.patterns"),e.options.orderable&&e.$select2.addClass("select2-orderable")},init:function(){var t=this;t.options.allowNewItems=t.options.hasOwnProperty("allowNewItems")?JSON.parse(t.options.allowNewItems):!0;if(t.options.ajax||t.options.vocabularyUrl){t.options.vocabularyUrl&&(t.options.multiple=!0,t.options.ajax=t.options.ajax||{},t.options.ajax.url=t.options.vocabularyUrl,t.options.initSelection=function(n,r){var i=[],s=n.val();e(s.split(t.options.separator)).each(function(){i.push({id:this,text:this})}),r(i)});var n="";t.options.ajax=e.extend({quietMillis:300,data:function(e,t){return n=e,{query:e,page_limit:10,page:t}},results:function(r,i){var s=r.results;if(t.options.vocabularyUrl){var o=[];e.each(r.results,function(e,t){o.push(t.id)}),s=[];var u=n===""||e.inArray(n,o)>=0;t.options.allowNewItems&&!u&&s.push({id:n,text:n}),(u||t.options.allowNewItems)&&e.each(r.results,function(e,t){s.push(t)})}return{results:s}}},t.options.ajax)}else if(t.options.multiple&&t.$el.is("select")){var r=t.$el.val()||[],i=e.map(t.$el.find("option"),function(t){return{text:e(t).html(),id:t.value}}),s=e('<input type="hidden" />');s.val(r.join(t.options.separator)),s.attr("class",t.$el.attr("class")),s.attr("name",t.$el.attr("name")),s.attr("id",t.$el.attr("id")),t.$orig=t.$el,t.$el.replaceWith(s),t.$el=s,t.options.data=i}t.initializeValues(),t.initializeTags(),t.initializeOrdering(),t.initializeSelect2()}});return n}),define("js/patterns/structure/views/tags",["jquery","underscore","backbone","js/ui/views/popover","mockup-patterns-select2"],function(e,t,n,r,i){var s=r.extend({title:t.template("Add/Remove tags"),content:t.template('<label>Tags to remove</label><div class="form-group"><select multiple class="toremove" style="width: 300px"></select></div><label>Tags to add</label><div class="form-group"><input class="toadd" style="width:300px" /></div><button class="btn btn-block btn-primary">Apply</button>'),events:{"click button":"applyButtonClicked"},initialize:function(e){this.app=e.app,this.removeSelect2=null,this.addSelect2=null,r.prototype.initialize.apply(this,[e])},render:function(){return r.prototype.render.call(this),this.$remove=this.$(".toremove"),this.$add=this.$(".toadd"),this.$remove.select2(),this.addSelect2=new i(this.$add,{multiple:!0,vocabularyUrl:this.app.options.tagsVocabularyUrl}),this},getSelect2Values:function(e){var n=[];return t.each(e.select2("data"),function(e){n.push(e.id)}),n},applyButtonClicked:function(e){this.app.defaultButtonClickEvent(this.triggerView,{remove:JSON.stringify(this.getSelect2Values(this.$remove)),add:JSON.stringify(this.getSelect2Values(this.$add))}),this.hide()},toggle:function(e,n){r.prototype.toggle.apply(this,[e,n]);var i=this;if(!this.opened)return;i.$remove.select2("destroy"),i.$remove.empty(),i.$add.select2("data",[]),i.app.selectedCollection.each(function(e){if(!e.attributes.Subject)return;t.each(e.attributes.Subject,function(e){i.$remove.find('[value="'+e+'"]').length===0&&i.$remove.append('<option value="'+e+'">'+e+"</option>")})}),i.$remove.select2()}});return s}),function(e){typeof define=="function"&&define.amd?define("picker",["jquery"],e):this.Picker=e(jQuery)}(function(e){function n(r,i,s,o){function p(){return n._.node("div",n._.node("div",n._.node("div",n._.node("div",h.component.nodes(u.open),f.box),f.wrap),f.frame),f.holder)}function d(e){e.stopPropagation(),e.type=="focus"&&h.$root.addClass(f.focused),h.open()}if(!r)return n;var u={id:Math.abs(~~(Math.random()*1e9))},a=s?e.extend(!0,{},s.defaults,o):o||{},f=e.extend({},n.klasses(),a.klass),l=e(r),c=function(){return this.start()},h=c.prototype={constructor:c,$node:l,start:function(){return u&&u.start?h:(u.methods={},u.start=!0,u.open=!1,u.type=r.type,r.autofocus=r==document.activeElement,r.type="text",r.readOnly=!a.editable,h.component=new s(h,a),h.$root=e(n._.node("div",p(),f.picker)).on({focusin:function(e){h.$root.removeClass(f.focused),e.stopPropagation()},"mousedown click":function(t){var n=t.target;n!=h.$root.children()[0]&&(t.stopPropagation(),t.type=="mousedown"&&!e(n).is(":input")&&n.nodeName!="OPTION"&&(t.preventDefault(),r.focus()))}}).on("click","[data-pick], [data-nav], [data-clear]",function(){var t=e(this),i=t.data(),s=t.hasClass(f.navDisabled)||t.hasClass(f.disabled),o=document.activeElement;o=o&&(o.type||o.href),(s||o&&!e.contains(h.$root[0],o))&&r.focus(),i.nav&&!s?h.set("highlight",h.component.item.highlight,{nav:i.nav}):n._.isInteger(i.pick)&&!s?h.set("select",i.pick).close(!0):i.clear&&h.clear().close(!0)}),a.formatSubmit&&(h._hidden=e('<input type=hidden name="'+(typeof a.hiddenPrefix=="string"?a.hiddenPrefix:"")+r.name+(typeof a.hiddenSuffix=="string"?a.hiddenSuffix:"_submit")+'"'+(l.data("value")||r.value?' value="'+n._.trigger(h.component.formats.toString,h.component,[a.formatSubmit,h.component.item.select])+'"':"")+">")[0]),l.data(i,h).addClass(f.input).val(l.data("value")?n._.trigger(h.component.formats.toString,h.component,[a.format,h.component.item.select]):r.value).after(h._hidden).on("focus.P"+u.id+" click.P"+u.id,d).on("change.P"+u.id,function(){h._hidden&&(h._hidden.value=r.value?n._.trigger(h.component.formats.toString,h.component,[a.formatSubmit,h.component.item.select]):"")}),a.editable||l.on("keydown.P"+u.id,function(e){var t=e.keyCode,n=/^(8|46)$/.test(t);if(t==27)return h.close(),!1;if(t==32||n||!u.open&&h.component.key[t])e.preventDefault(),e.stopPropagation(),n?h.clear().close():h.open()}),a.container?e(a.container).append(h.$root):l.after(h.$root),h.on({start:h.component.onStart,render:h.component.onRender,stop:h.component.onStop,open:h.component.onOpen,close:h.component.onClose,set:h.component.onSet}).on({start:a.onStart,render:a.onRender,stop:a.onStop,open:a.onOpen,close:a.onClose,set:a.onSet}),r.autofocus&&h.open(),h.trigger("start").trigger("render"))},render:function(e){return e?h.$root.html(p()):h.$root.find("."+f.box).html(h.component.nodes(u.open)),h.trigger("render")},stop:function(){return u.start?(h.close(),h._hidden&&h._hidden.parentNode.removeChild(h._hidden),h.$root.remove(),l.removeClass(f.input).removeData(i),setTimeout(function(){l.off(".P"+u.id)},0),r.type=u.type,r.readOnly=!1,h.trigger("stop"),u.methods={},u.start=!1,h):h},open:function(i){return u.open?h:(l.addClass(f.active),h.$root.addClass(f.opened),i!==!1&&(u.open=!0,l.trigger("focus"),t.on("click.P"+u.id+" focusin.P"+u.id,function(e){var t=e.target;t!=r&&t!=document&&h.close(t===h.$root.children()[0])}).on("keydown.P"+u.id,function(t){var i=t.keyCode,s=h.component.key[i],o=t.target;i==27?h.close(!0):o!=r||!s&&i!=13?e.contains(h.$root[0],o)&&i==13&&(t.preventDefault(),o.click()):(t.preventDefault(),s?n._.trigger(h.component.key.go,h,[n._.trigger(s)]):h.$root.find("."+f.highlighted).hasClass(f.disabled)||h.set("select",h.component.item.highlight).close())})),h.trigger("open"))},close:function(e){return e&&(l.off("focus.P"+u.id).trigger("focus"),setTimeout(function(){l.on("focus.P"+u.id,d)},0)),l.removeClass(f.active),h.$root.removeClass(f.opened+" "+f.focused),u.open?(u.open=!1,t.off(".P"+u.id),h.trigger("close")):h},clear:function(){return h.set("clear")},set:function(t,r,i){var s,o,u=e.isPlainObject(t),f=u?t:{};i=u&&e.isPlainObject(r)?r:i||{};if(t){u||(f[t]=r);for(s in f)o=f[s],h.component.item[s]&&h.component.set(s,o,i),(s=="select"||s=="clear")&&l.val(s=="clear"?"":n._.trigger(h.component.formats.toString,h.component,[a.format,h.component.get(s)])).trigger("change");h.render()}return i.muted?h:h.trigger("set",f)},get:function(e,t){e=e||"value";if(u[e]!=null)return u[e];if(e=="value")return r.value;if(h.component.item[e])return typeof t=="string"?n._.trigger(h.component.formats.toString,h.component,[t,h.component.get(e)]):h.component.get(e)},on:function(t,n){var r,i,s=e.isPlainObject(t),o=s?t:{};if(t){s||(o[t]=n);for(r in o)i=o[r],u.methods[r]=u.methods[r]||[],u.methods[r].push(i)}return h},trigger:function(e,t){var r=u.methods[e];return r&&r.map(function(e){n._.trigger(e,h,[t])}),h}};return new c}var t=e(document);return n.klasses=function(e){return e=e||"picker",{picker:e,opened:e+"--opened",focused:e+"--focused",input:e+"__input",active:e+"__input--active",holder:e+"__holder",frame:e+"__frame",wrap:e+"__wrap",box:e+"__box"}},n._={group:function(e){var t,r="",i=n._.trigger(e.min,e);for(;i<=n._.trigger(e.max,e,[i]);i+=e.i)t=n._.trigger(e.item,e,[i]),r+=n._.node(e.node,t[0],t[1],t[2]);return r},node:function(t,n,r,i){return n?(n=e.isArray(n)?n.join(""):n,r=r?' class="'+r+'"':"",i=i?" "+i:"","<"+t+r+i+">"+n+"</"+t+">"):""},lead:function(e){return(e<10?"0":"")+e},trigger:function(e,t,n){return typeof e=="function"?e.apply(t,n||[]):e},digits:function(e){return/\d/.test(e[1])?2:1},isDate:function(e){return{}.toString.call(e).indexOf("Date")>-1&&this.isInteger(e.getDate())},isInteger:function(e){return{}.toString.call(e).indexOf("Number")>-1&&e%1===0}},n.extend=function(t,r){e.fn[t]=function(i,s){var o=this.data(t);return i=="picker"?o:o&&typeof i=="string"?(n._.trigger(o[i],o,[s]),this):this.each(function(){var s=e(this);s.data(t)||new n(this,t,r,i)})},e.fn[t].defaults=r.defaults},n}),function(e){typeof define=="function"&&define.amd?define("picker.date",["picker","jquery"],e):e(Picker,jQuery)}(function(e,t){function i(e,t){var n=this,r=e.$node[0].value,i=e.$node.data("value"),s=i||r,o=i?t.formatSubmit:t.format,u=function(){return getComputedStyle(e.$root[0]).direction==="rtl"};n.settings=t,n.queue={min:"measure create",max:"measure create",now:"now create",select:"parse create validate",highlight:"navigate create validate",view:"create validate viewset",disable:"flipItem",enable:"flipItem"},n.item={},n.item.disable=(t.disable||[]).slice(0),n.item.enable=-function(e){return e[0]===!0?e.shift():-1}(n.item.disable),n.set("min",t.min).set("max",t.max).set("now").set("select",s||n.item.now,{format:o,data:function(e){return s&&(e.indexOf("mm")>-1||e.indexOf("m")>-1)}(n.formats.toArray(o))}),n.key={40:7,38:-7,39:function(){return u()?-1:1},37:function(){return u()?1:-1},go:function(e){n.set("highlight",[n.item.highlight.year,n.item.highlight.month,n.item.highlight.date+e],{interval:e}),this.render()}},e.on("render",function(){e.$root.find("."+t.klass.selectMonth).on("change",function(){e.set("highlight",[e.get("view").year,this.value,e.get("highlight").date]),e.$root.find("."+t.klass.selectMonth).trigger("focus")}),e.$root.find("."+t.klass.selectYear).on("change",function(){e.set("highlight",[this.value,e.get("view").month,e.get("highlight").date]),e.$root.find("."+t.klass.selectYear).trigger("focus")})}).on("open",function(){e.$root.find("button, select").attr("disabled",!1)}).on("close",function(){e.$root.find("button, select").attr("disabled",!0)})}var n=7,r=6;i.prototype.set=function(e,t,n){var r=this;return r.item[e=="enable"?"disable":e=="flip"?"enable":e]=r.queue[e].split(" ").map(function(i){return t=r[i](e,t,n)}).pop(),e=="select"?r.set("highlight",r.item.select,n):e=="highlight"?r.set("view",r.item.highlight,n):(e=="flip"||e=="min"||e=="max"||e=="disable"||e=="enable")&&r.item.select&&r.item.highlight&&r.set("select",r.item.select,n).set("highlight",r.item.highlight,n),r},i.prototype.get=function(e){return this.item[e]},i.prototype.create=function(n,r,i){var s,o=this;return r=r===undefined?n:r,r==-Infinity||r==Infinity?s=r:t.isPlainObject(r)&&e._.isInteger(r.pick)?r=r.obj:t.isArray(r)?(r=new Date(r[0],r[1],r[2]),r=e._.isDate(r)?r:o.create().obj):e._.isInteger(r)||e._.isDate(r)?r=o.normalize(new Date(r),i):r=o.now(n,r,i),{year:s||r.getFullYear(),month:s||r.getMonth(),date:s||r.getDate(),day:s||r.getDay(),obj:s||r,pick:s||r.getTime()}},i.prototype.now=function(e,t,n){return t=new Date,n&&n.rel&&t.setDate(t.getDate()+n.rel),this.normalize(t,n)},i.prototype.navigate=function(n,r,i){if(t.isPlainObject(r)){var s=new Date(r.year,r.month+(i&&i.nav?i.nav:0),1),o=s.getFullYear(),u=s.getMonth(),a=r.date;while(e._.isDate(s)&&(new Date(o,u,a)).getMonth()!==u)a-=1;r=[o,u,a]}return r},i.prototype.normalize=function(e){return e.setHours(0,0,0,0),e},i.prototype.measure=function(t,n){var r=this;return n?e._.isInteger(n)&&(n=r.now(t,n,{rel:n})):n=t=="min"?-Infinity:Infinity,n},i.prototype.viewset=function(e,t){return this.create([t.year,t.month,1])},i.prototype.validate=function(n,r,i){var s=this,o=r,u=i&&i.interval?i.interval:1,a=s.item.enable===-1,f,l,c=s.item.min,h=s.item.max,p,d,v=a&&s.item.disable.filter(function(n){if(t.isArray(n)){var i=s.create(n).pick;i<r.pick?f=!0:i>r.pick&&(l=!0)}return e._.isInteger(n)}).length;if(!i.nav)if(!a&&s.disabled(r)||a&&s.disabled(r)&&(v||f||l)||r.pick<=c.pick||r.pick>=h.pick){a&&!v&&(!l&&u>0||!f&&u<0)&&(u*=-1);while(s.disabled(r)){Math.abs(u)>1&&(r.month<o.month||r.month>o.month)&&(r=o,u=Math.abs(u)/u),r.pick<=c.pick?(p=!0,u=1):r.pick>=h.pick&&(d=!0,u=-1);if(p&&d)break;r=s.create([r.year,r.month,r.date+u])}}return r},i.prototype.disabled=function(n){var r=this,i=r.item.disable.filter(function(i){if(e._.isInteger(i))return n.day===(r.settings.firstDay?i:i-1)%7;if(t.isArray(i)||e._.isDate(i))return n.pick===r.create(i).pick});return i=i.length&&!i.filter(function(e){return t.isArray(e)&&e[3]=="inverted"}).length,r.item.enable===-1?!i:i||n.pick<r.item.min.pick||n.pick>r.item.max.pick},i.prototype.parse=function(n,r,i){var s=this,o={};if(!r||e._.isInteger(r)||t.isArray(r)||e._.isDate(r)||t.isPlainObject(r)&&e._.isInteger(r.pick))return r;if(!i||!i.format)throw"Need a formatting option to parse this..";return s.formats.toArray(i.format).map(function(t){var n=s.formats[t],i=n?e._.trigger(n,s,[r,o]):t.replace(/^!/,"").length;n&&(o[t]=r.substr(0,i)),r=r.substr(i)}),[o.yyyy||o.yy,+(o.mm||o.m)-(i.data?1:0),o.dd||o.d]},i.prototype.formats=function(){function t(e,t,n){var r=e.match(/\w+/)[0];return!n.mm&&!n.m&&(n.m=t.indexOf(r)),r.length}function n(e){return e.match(/\w+/)[0].length}return{d:function(t,n){return t?e._.digits(t):n.date},dd:function(t,n){return t?2:e._.lead(n.date)},ddd:function(e,t){return e?n(e):this.settings.weekdaysShort[t.day]},dddd:function(e,t){return e?n(e):this.settings.weekdaysFull[t.day]},m:function(t,n){return t?e._.digits(t):n.month+1},mm:function(t,n){return t?2:e._.lead(n.month+1)},mmm:function(e,n){var r=this.settings.monthsShort;return e?t(e,r,n):r[n.month]},mmmm:function(e,n){var r=this.settings.monthsFull;return e?t(e,r,n):r[n.month]},yy:function(e,t){return e?2:(""+t.year).slice(2)},yyyy:function(e,t){return e?4:t.year},toArray:function(e){return e.split(/(d{1,4}|m{1,4}|y{4}|yy|!.)/g)},toString:function(t,n){var r=this;return r.formats.toArray(t).map(function(t){return e._.trigger(r.formats[t],r,[0,n])||t.replace(/^!/,"")}).join("")}}}(),i.prototype.flipItem=function(e,n){var r=this,i=r.item.disable,s=r.item.enable===-1;return n=="flip"?r.item.enable=s?1:-1:e=="enable"&&n===!0||e=="disable"&&n===!1?(r.item.enable=1,i=[]):e=="enable"&&n===!1||e=="disable"&&n===!0?(r.item.enable=-1,i=[]):t.isArray(n)&&(s&&e=="enable"||!s&&e=="disable"?i=r.addDisabled(i,n):!s&&e=="enable"?i=r.addEnabled(i,n):s&&e=="disable"&&(i=r.removeDisabled(i,n))),i},i.prototype.addEnabled=function(n,r){var i=this;return r.map(function(r){i.filterDisabled(n,r,1).length&&(n=i.removeDisabled(n,[r]),t.isArray(r)&&n.filter(function(t){return e._.isInteger(t)&&i.create(r).day===t-1}).length&&(r=r.slice(0),r.push("inverted"),n.push(r)))}),n},i.prototype.addDisabled=function(e,n){var r=this;return n.map(function(n){r.filterDisabled(e,n).length?t.isArray(n)&&r.filterDisabled(e,n,1).length&&(e=r.removeDisabled(e,[n])):e.push(n)}),e},i.prototype.removeDisabled=function(e,t){var n=this;return t.map(function(t){e=n.filterDisabled(e,t,1)}),e},i.prototype.filterDisabled=function(n,r,i){var s=this,o=t.isArray(r)||e._.isDate(r),u=o&&s.create(r).pick;return n.filter(function(n){var a=o&&(t.isArray(n)||e._.isDate(n))?u===s.create(n).pick:r===n;return i?!a:a})},i.prototype.nodes=function(t){var i=this,s=i.settings,o=i.item.now,u=i.item.select,a=i.item.highlight,f=i.item.view,l=i.item.disable,c=i.item.min,h=i.item.max,p=function(t){return s.firstDay&&t.push(t.shift()),e._.node("thead",e._.group({min:0,max:n-1,i:1,node:"th",item:function(e){return[t[e],s.klass.weekdays]}}))}((s.showWeekdaysFull?s.weekdaysFull:s.weekdaysShort).slice(0)),d=function(t){return e._.node("div"," ",s.klass["nav"+(t?"Next":"Prev")]+(t&&f.year>=h.year&&f.month>=h.month||!t&&f.year<=c.year&&f.month<=c.month?" "+s.klass.navDisabled:""),"data-nav="+(t||-1))},v=function(n){return s.selectMonths?e._.node("select",e._.group({min:0,max:11,i:1,node:"option",item:function(e){return[n[e],0,"value="+e+(f.month==e?" selected":"")+(f.year==c.year&&e<c.month||f.year==h.year&&e>h.month?" disabled":"")]}}),s.klass.selectMonth,t?"":"disabled"):e._.node("div",n[f.month],s.klass.month)},m=function(){var n=f.year,r=s.selectYears===!0?5:~~(s.selectYears/2);if(r){var i=c.year,o=h.year,u=n-r,a=n+r;i>u&&(a+=i-u,u=i);if(o<a){var l=u-i,p=a-o;u-=l>p?p:l,a=o}return e._.node("select",e._.group({min:u,max:a,i:1,node:"option",item:function(e){return[e,0,"value="+e+(n==e?" selected":"")]}}),s.klass.selectYear,t?"":"disabled")}return e._.node("div",n,s.klass.year)};return e._.node("div",d()+d(1)+v(s.showMonthsShort?s.monthsShort:s.monthsFull)+m(),s.klass.header)+e._.node("table",p+e._.node("tbody",e._.group({min:0,max:r-1,i:1,node:"tr",item:function(t){var r=s.firstDay&&i.create([f.year,f.month,1]).day===0?-7:0;return[e._.group({min:n*t-f.day+r+1,max:function(){return this.min+n-1},i:1,node:"td",item:function(t){return t=i.create([f.year,f.month,t+(s.firstDay?1:0)]),[e._.node("div",t.date,function(e){return e.push(f.month==t.month?s.klass.infocus:s.klass.outfocus),o.pick==t.pick&&e.push(s.klass.now),u&&u.pick==t.pick&&e.push(s.klass.selected),a&&a.pick==t.pick&&e.push(s.klass.highlighted),(l&&i.disabled(t)||t.pick<c.pick||t.pick>h.pick)&&e.push(s.klass.disabled),e.join(" ")}([s.klass.day]),"data-pick="+t.pick)]}})]}})),s.klass.table)+e._.node("div",e._.node("button",s.today,s.klass.buttonToday,"type=button data-pick="+o.pick+(t?"":" disabled"))+e._.node("button",s.clear,s.klass.buttonClear,"type=button data-clear=1"+(t?"":" disabled")),s.klass.footer)},i.defaults=function(e){return{monthsFull:["January","February","March","April","May","June","July","August","September","October","November","December"],monthsShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdaysFull:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdaysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],today:"Today",clear:"Clear",format:"d mmmm, yyyy",klass:{table:e+"table",header:e+"header",navPrev:e+"nav--prev",navNext:e+"nav--next",navDisabled:e+"nav--disabled",month:e+"month",year:e+"year",selectMonth:e+"select--month",selectYear:e+"select--year",weekdays:e+"weekday",day:e+"day",disabled:e+"day--disabled",selected:e+"day--selected",highlighted:e+"day--highlighted",now:e+"day--today",infocus:e+"day--infocus",outfocus:e+"day--outfocus",footer:e+"footer",buttonClear:e+"button--clear",buttonToday:e+"button--today"}}}(e.klasses().picker+"__"),e.extend("pickadate",i)}),function(e){typeof define=="function"&&define.amd?define("picker.time",["picker","jquery"],e):e(Picker,jQuery)}(function(e,t){function o(e,t){var n=this,r=e.$node.data("value");n.settings=t,n.queue={interval:"i",min:"measure create",max:"measure create",now:"now create",select:"parse create validate",highlight:"create validate",view:"create validate",disable:"flipItem",enable:"flipItem"},n.item={},n.item.interval=t.interval||30,n.item.disable=(t.disable||[]).slice(0),n.item.enable=-function(e){return e[0]===!0?e.shift():-1}(n.item.disable),n.set("min",t.min).set("max",t.max).set("now").set("select",r||e.$node[0].value||n.item.min,{format:r?t.formatSubmit:t.format}),n.key={40:1,38:-1,39:1,37:-1,go:function(e){n.set("highlight",n.item.highlight.pick+e*n.item.interval,{interval:e*n.item.interval}),this.render()}},e.on("render",function(){var n=e.$root.children(),r=n.find("."+t.klass.viewset);r.length&&(n[0].scrollTop=~~r.position().top-r[0].clientHeight*2)}).on("open",function(){e.$root.find("button").attr("disable",!1)}).on("close",function(){e.$root.find("button").attr("disable",!0)})}var n=24,r=60,i=12,s=n*r;o.prototype.set=function(e,t,n){var r=this;return r.item[e=="enable"?"disable":e=="flip"?"enable":e]=r.queue[e].split(" ").map(function(i){return t=r[i](e,t,n)}).pop(),e=="select"?r.set("highlight",r.item.select,n):e=="highlight"?r.set("view",r.item.highlight,n):e=="interval"?r.set("min",r.item.min,n).set("max",r.item.max,n):(e=="flip"||e=="min"||e=="max"||e=="disable"||e=="enable")&&r.item.select&&r.item.highlight&&(e=="min"&&r.set("max",r.item.max,n),r.set("select",r.item.select,n).set("highlight",r.item.highlight,n)),r},o.prototype.get=function(e){return this.item[e]},o.prototype.create=function(i,o,u){var a=this;return o=o===undefined?i:o,e._.isDate(o)&&(o=[o.getHours(),o.getMinutes()]),t.isPlainObject(o)&&e._.isInteger(o.pick)?o=o.pick:t.isArray(o)?o=+o[0]*r+ +o[1]:e._.isInteger(o)||(o=a.now(i,o,u)),i=="max"&&o<a.item.min.pick&&(o+=s),i!="min"&&i!="max"&&(o-a.item.min.pick)%a.item.interval!==0&&(o+=a.item.interval),o=a.normalize(i,o,u),{hour:~~(n+o/r)%n,mins:(r+o%r)%r,time:(s+o)%s,pick:o}},o.prototype.now=function(t,n){var i=new Date,s=i.getHours()*r+i.getMinutes();return s-=s%this.item.interval,e._.isInteger(n)?n+=t=="min"&&n<0&&s===0?2:1:n=1,n*this.item.interval+s},o.prototype.normalize=function(e,t){var n=this.item.interval,r=e=="min"?0:(t-this.item.min.pick)%n;return t-(r+(t<0?n:0))},o.prototype.measure=function(i,s,o){var u=this;return s?s===!0||e._.isInteger(s)?s=u.now(i,s,o):t.isPlainObject(s)&&e._.isInteger(s.pick)&&(s=u.normalize(i,s.pick,o)):s=i=="min"?[0,0]:[n-1,r-1],s},o.prototype.validate=function(e,t,n){var r=this,i=n&&n.interval?n.interval:r.item.interval;return r.disabled(t)&&(t=r.shift(t,i)),t=r.scope(t),r.disabled(t)&&(t=r.shift(t,i*-1)),t},o.prototype.disabled=function(n){var r=this,i=r.item.disable.filter(function(i){if(e._.isInteger(i))return n.hour==i;if(t.isArray(i)||e._.isDate(i))return n.pick==r.create(i).pick});return i=i.length&&!i.filter(function(e){return t.isArray(e)&&e[2]=="inverted"}).length,r.item.enable===-1?!i:i||n.pick<r.item.min.pick||n.pick>r.item.max.pick},o.prototype.shift=function(e,t){var n=this,r=n.item.min.pick,i=n.item.max.pick;t=t||n.item.interval;while(n.disabled(e)){e=n.create(e.pick+=t);if(e.pick<=r||e.pick>=i)break}return e},o.prototype.scope=function(e){var t=this.item.min.pick,n=this.item.max.pick;return this.create(e.pick>n?n:e.pick<t?t:e)},o.prototype.parse=function(n,i,s){var o=this,u={};if(!i||e._.isInteger(i)||t.isArray(i)||e._.isDate(i)||t.isPlainObject(i)&&e._.isInteger(i.pick))return i;if(!s||!s.format)throw"Need a formatting option to parse this..";return o.formats.toArray(s.format).map(function(t){var n=o.formats[t],r=n?e._.trigger(n,o,[i,u]):t.replace(/^!/,"").length;n&&(u[t]=i.substr(0,r)),i=i.substr(r)}),+u.i+r*(+(u.H||u.HH)||+(u.h||u.hh)%12+(/^p/i.test(u.A||u.a)?12:0))},o.prototype.formats={h:function(t,n){return t?e._.digits(t):n.hour%i||i},hh:function(t,n){return t?2:e._.lead(n.hour%i||i)},H:function(t,n){return t?e._.digits(t):""+n.hour%24},HH:function(t,n){return t?e._.digits(t):e._.lead(n.hour%24)},i:function(t,n){return t?2:e._.lead(n.mins)},a:function(e,t){return e?4:s/2>t.time%s?"a.m.":"p.m."},A:function(e,t){return e?2:s/2>t.time%s?"AM":"PM"},toArray:function(e){return e.split(/(h{1,2}|H{1,2}|i|a|A|!.)/g)},toString:function(t,n){var r=this;return r.formats.toArray(t).map(function(t){return e._.trigger(r.formats[t],r,[0,n])||t.replace(/^!/,"")}).join("")}},o.prototype.flipItem=function(e,n){var r=this,i=r.item.disable,s=r.item.enable===-1;return n=="flip"?r.item.enable=s?1:-1:e=="enable"&&n===!0||e=="disable"&&n===!1?(r.item.enable=1,i=[]):e=="enable"&&n===!1||e=="disable"&&n===!0?(r.item.enable=-1,i=[]):t.isArray(n)&&(s&&e=="enable"||!s&&e=="disable"?i=r.addDisabled(i,n):!s&&e=="enable"?i=r.addEnabled(i,n):s&&e=="disable"&&(i=r.removeDisabled(i,n))),i},o.prototype.addEnabled=function(n,r){var i=this;return r.map(function(r){i.filterDisabled(n,r,1).length&&(n=i.removeDisabled(n,[r]),t.isArray(r)&&n.filter(function(t){return e._.isInteger(t)&&i.create(r).hour===t}).length&&(r=r.slice(0),r.push("inverted"),n.push(r)))}),n},o.prototype.addDisabled=function(e,n){var r=this;return n.map(function(n){r.filterDisabled(e,n).length?t.isArray(n)&&r.filterDisabled(e,n,1).length&&(e=r.removeDisabled(e,[n])):e.push(n)}),e},o.prototype.removeDisabled=function(e,t){var n=this;return t.map(function(t){e=n.filterDisabled(e,t,1)}),e},o.prototype.filterDisabled=function(e,n,r){var i=t.isArray(n);return e.filter(function(e){var s=!i&&n===e||i&&t.isArray(e)&&n.toString()===e.toString();return r?!s:s})},o.prototype.i=function(t,n){return e._.isInteger(n)&&n>0?n:this.item.interval},o.prototype.nodes=function(t){var n=this,r=n.settings,i=n.item.select,s=n.item.highlight,o=n.item.view,u=n.item.disable;return e._.node("ul",e._.group({min:n.item.min.pick,max:n.item.max.pick,i:n.item.interval,node:"li",item:function(t){return t=n.create(t),[e._.trigger(n.formats.toString,n,[e._.trigger(r.formatLabel,n,[t])||r.format,t]),function(e,a){return i&&i.pick==a&&e.push(r.klass.selected),s&&s.pick==a&&e.push(r.klass.highlighted),o&&o.pick==a&&e.push(r.klass.viewset),u&&n.disabled(t)&&e.push(r.klass.disabled),e.join(" ")}([r.klass.listItem],t.pick),"data-pick="+t.pick]}})+e._.node("li",e._.node("button",r.clear,r.klass.buttonClear,"type=button data-clear=1"+(t?"":" disable"))),r.klass.list)},o.defaults=function(e){return{clear:"Clear",format:"h:i A",interval:30,klass:{picker:e+" "+e+"--time",holder:e+"__holder",list:e+"__list",listItem:e+"__list-item",disabled:e+"__list-item--disabled",selected:e+"__list-item--selected",highlighted:e+"__list-item--highlighted",viewset:e+"__list-item--viewset",now:e+"__list-item--now",buttonClear:e+"__button--clear"}}}(e.klasses().picker),e.extend("pickatime",o)}),define("mockup-patterns-pickadate",["jquery","mockup-patterns-base","picker","picker.date","picker.time"],function(e,t){var n=t.extend({name:"pickadate",defaults:{separator:" ",date:{selectYears:!0,selectMonths:!0},time:{},classWrapperName:"pattern-pickadate-wrapper",classSeparatorName:"pattern-pickadate-separator",classDateName:"pattern-pickadate-date",classDateWrapperName:"pattern-pickadate-date-wrapper",classTimeName:"pattern-pickadate-time",classTimeWrapperName:"pattern-pickadate-time-wrapper",classClearName:"pattern-pickadate-clear",placeholderDate:"Enter date...",placeholderTime:"Enter time..."},isFalse:function(e){return typeof e=="string"&&e==="false"?!1:e},init:function(){var t=this,n=t.$el.val().split(" "),r=n[0]||"",i=n[1]||"";t.options.date=t.isFalse(t.options.date),t.options.time=t.isFalse(t.options.time),t.options.date===!1&&(i=n[0]),t.$el.hide(),t.$wrapper=e("<div/>").addClass(t.options.classWrapperName).insertAfter(t.$el),t.options.date!==!1&&(t.options.date.formatSubmit="yyyy-mm-dd",t.$date=e('<input type="text"/>').attr("placeholder",t.options.placeholderDate).attr("data-value",r).addClass(t.options.classDateName).appendTo(e("<div/>").addClass(t.options.classDateWrapperName).appendTo(t.$wrapper)).pickadate(e.extend(!0,{},t.options.date,{onSet:function(e){e.select!==undefined&&(t.$date.attr("data-value",e.select),(t.options.time===!1||t.$time.attr("data-value")!=="")&&t.updateValue.call(t)),e.hasOwnProperty("clear")&&(t.$el.removeAttr("value"),t.$date.attr("data-value",""))}}))),t.options.date!==!1&&t.options.time!==!1&&(t.$separator=e("<span/>").addClass(t.options.classSeparatorName).html(t.options.separator===" "?"&nbsp;":t.options.separator).appendTo(t.$wrapper)),t.options.time!==!1&&(t.options.time.formatSubmit="HH:i",t.$time=e('<input type="text"/>').attr("placeholder",t.options.placeholderTime).attr("data-value",i).addClass(t.options.classTimeName).appendTo(e("<div/>").addClass(t.options.classTimeWrapperName).appendTo(t.$wrapper)).pickatime(e.extend(!0,{},t.options.time,{onSet:function(e){e.select!==undefined&&(t.$time.attr("data-value",e.select),(t.options.date===!1||t.$date.attr("data-value")!=="")&&t.updateValue.call(t)),e.hasOwnProperty("clear")&&(t.$el.removeAttr("value"),t.$time.attr("data-value",""))}})),typeof i=="string"&&i.substring(0,2)==="00"&&(t.$time.pickatime("picker").set("select",i.split(":")),t.$time.attr("data-value",i))),t.$clear=e("<div/>").addClass(t.options.classClearName).appendTo(t.$wrapper)},updateValue:function(){var e=this,t="";if(e.options.date!==!1){var n=e.$date.data("pickadate").component,r=e.$date.data("pickadate").get("select"),i=n.formats.toString;t+=i.apply(n,["yyyy-mm-dd",r])}e.options.date!==!1&&e.options.time!==!1&&(t+=" ");if(e.options.time!==!1){var s=e.$time.data("pickatime").component,o=e.$time.data("pickatime").get("select"),u=s.formats.toString;t+=u.apply(s,["HH:i",o])}e.$el.attr("value",t),e.trigger("updated")}});return n}),define("js/patterns/structure/views/properties",["jquery","underscore","backbone","js/ui/views/popover","mockup-patterns-pickadate","mockup-patterns-select2"],function(e,t,n,r,i,s){var o=r.extend({className:"popover properties",title:t.template("Modify properties on items"),content:t.template('<div class="form-group"><label>Publication Date</label><input class="form-control" name="effective" /></div><div class="form-group"><label>Expiration Date</label><input class="form-control" name="expiration" /></div><div class="form-group"><label>Copyright</label><textarea class="form-control" name="copyright"></textarea></div><label>Creators</label><div class="form-group"><input name="creators" style="width: 300px" /></div><label>Contributors</label><div class="form-group"><input name="contributors" style="width: 300px" /></div><label>Exclude from nav</label><div class="radio"><label><input type="radio" name="exclude-from-nav" value="yes" />Yes</label></div><div class="radio"><label><input type="radio" name="exclude-from-nav" value="no" />No</label></div><button class="btn btn-block btn-primary">Apply</button>'),events:{"click button":"applyButtonClicked"},initialize:function(e){this.app=e.app,r.prototype.initialize.apply(this,[e])},render:function(){return r.prototype.render.call(this),this.$effective=this.$('[name="effective"]'),this.$expiration=this.$('[name="expiration"]'),this.$copyright=this.$('[name="copyright"]'),this.$creators=this.$('[name="creators"]'),this.$contributors=this.$('[name="contributors"]'),this.$exclude=this.$('[name="exclude-from-nav"]'),this.creatorsSelect2=new s(this.$creators,{multiple:!0,vocabularyUrl:this.app.options.usersVocabularyUrl}),this.contributorsSelect2=new s(this.$contributors,{multiple:!0,vocabularyUrl:this.app.options.usersVocabularyUrl}),this.effectivePickADate=new i(this.$effective),this.expirationPickADate=new i(this.$expiration),this},applyButtonClicked:function(e){var t={effectiveDate:this.effectivePickADate.$date.attr("value"),effectiveTime:this.effectivePickADate.$time.attr("value"),expirationDate:this.expirationPickADate.$date.attr("value"),expirationTime:this.expirationPickADate.$time.attr("value"),copyright:this.$copyright.val(),contributors:JSON.stringify(this.$contributors.select2("data")),creators:JSON.stringify(this.$creators.select2("data"))};this.$('[name="exclude-from-nav"]:checked').length>0&&(t.exclude_from_nav=this.$('[name="exclude-from-nav"]:checked').val()),this.app.defaultButtonClickEvent(this.triggerView,t),this.hide()},toggle:function(e,t){r.prototype.toggle.apply(this,[e,t]);var n=this;if(!this.opened)return;this.$effective.attr("value",""),this.$expiration.attr("value",""),this.$copyright.html(""),this.$creators.select2("data",[]),this.$contributors.select2("data",[]),this.$exclude.each(function(){this.checked=!1})}});return o}),define("js/patterns/structure/views/workflow",["jquery","underscore","backbone","js/ui/views/popover"],function(e,t,n,r){var i=r.extend({className:"popover workflow",title:t.template("Modify dates on items"),content:t.template('<form><fieldset><div class="form-group"><label>Comments</label><textarea class="form-control" rows="4"></textarea><p class="help-block">Select the transition to be used for modifying the items state.</p></div><div class="form-group"><label>Change State</label><p class="help-block">Select the transition to be used for modifying the items state.</p><select class="form-control" name="transition"></select></div><div class="checkbox"><label><input type="checkbox" name="recurse" />Include contained items?</label><p class="help-block">If checked, this will attempt to modify the status of all content in any selected folders and their subfolders.</p></div></fieldset></form><button class="btn btn-block btn-primary">Apply</button>'),events:{"click button":"applyButtonClicked"},initialize:function(e){this.app=e.app,r.prototype.initialize.apply(this,[e])},render:function(){return r.prototype.render.call(this),this.$comments=this.$("textarea"),this.$transition=this.$("select"),this},applyButtonClicked:function(e){var t={comments:this.$comments.val(),transition:this.$transition.val()};this.$('[name="recurse"]')[0].checked&&(t.recurse="yes"),this.app.defaultButtonClickEvent(this.triggerView,t),this.hide()},toggle:function(n,i){r.prototype.toggle.apply(this,[n,i]);var s=this;if(!s.opened)return;s.$comments.val(""),s.$transition.empty(),e.ajax({url:s.triggerView.url,type:"GET",data:{selection:JSON.stringify(s.app.getSelectedUids()),transitions:!0},success:function(e){t.each(e.transitions,function(e){s.$transition.append('<option value="'+e.id+'">'+e.title+"</option>")})},error:function(e){window.alert("error getting transition data")}})}});return i}),define("js/patterns/structure/views/delete",["jquery","underscore","backbone","js/ui/views/popover"],function(e,t,n,r){var i=r.extend({className:"popover delete",title:t.template("Delete selected items"),content:t.template('<label>Are you certain you want to delete the selected items</label><button class="btn btn-block btn-danger">Yes</button>'),events:{"click button":"applyButtonClicked"},initialize:function(e){this.app=e.app,r.prototype.initialize.apply(this,[e])},render:function(){return r.prototype.render.call(this),this},applyButtonClicked:function(e){var t=this;this.app.defaultButtonClickEvent(this.triggerView,{},function(e){t.app.selectedCollection.reset()}),this.hide()}});return i}),define("js/patterns/structure/views/rename",["jquery","underscore","backbone","js/ui/views/popover"],function(e,t,n,r){var i=r.extend({className:"popover rename",title:t.template("Rename items"),content:t.template('<div class="itemstoremove"></div><button class="btn btn-block btn-primary">Apply</button>'),itemTemplate:t.template('<div class="item"><div class="form-group"><input name="UID" type="hidden" value="<%- UID %>" /><label>Title</label><input class="form-control" name="newtitle" value="<%= Title %>" /><label>Short name</label><input class="form-control" name="newid" value="<%= id %>" /></div></div>'),events:{"click button":"applyButtonClicked"},initialize:function(e){this.app=e.app,r.prototype.initialize.apply(this,[e])},render:function(){return r.prototype.render.call(this),this.$items=this.$(".itemstoremove"),this},applyButtonClicked:function(t){var n=[];this.$items.find(".item").each(function(){var t=e(this);n.push({UID:t.find('[name="UID"]').val(),newid:t.find('[name="newid"]').val(),newtitle:t.find('[name="newtitle"]').val()})});var r=this;this.app.defaultButtonClickEvent(this.triggerView,{torename:JSON.stringify(n)}),this.hide()},toggle:function(e,t){r.prototype.toggle.apply(this,[e,t]);var n=this;if(!n.opened)return;n.$items.empty(),n.app.selectedCollection.each(function(e){n.$items.append(n.itemTemplate(e.toJSON()))})}});return i}),define("js/patterns/structure/views/rearrange",["jquery","underscore","js/ui/views/popover"],function(e,t,n){var r=n.extend({className:"popover rearrange",title:t.template("Rearrange items in this folder"),content:t.template('<div class="form-group"><label>What to rearrange on</label><select name="rearrange_on" class="form-control"><% _.each(rearrangeProperties, function(title, property) { %><option value="<%- property %>"><%- title %></option><% }); %></select><p class="help-block">This permanently changes the order of items in this folder.This operation may take a long time depending on the size of the folder.</p></div><div class="checkbox"><label>Reverse <input type="checkbox" name="reversed" /></label></div><button class="btn btn-block btn-primary">Rearrange</button>'),events:{"click button":"rearrangeButtonClicked"},initialize:function(e){this.app=e.app,n.prototype.initialize.apply(this,[e]),this.options.rearrangeProperties=this.app.options.rearrange.properties},render:function(){return n.prototype.render.call(this),this.$rearrangeOn=this.$('[name="rearrange_on"]'),this.$reversed=this.$('[name="reversed"]'),this},rearrangeButtonClicked:function(){var e={rearrange_on:this.$rearrangeOn.val(),reversed:!1};this.$reversed[0].checked&&(e.reversed=!0),this.app.defaultButtonClickEvent(this.triggerView,e),this.hide()}});return r}),define("text!js/patterns/structure/templates/selection_button.xml",[],function(){return'<%= title %> \r<span class="label<% if (length > 0) { %> label-success<% } else { %> label-default<% } %>">\r  <%= length %>\r</span>\r'}),define("js/patterns/structure/views/selectionbutton",["jquery","backbone","underscore","js/ui/views/button","text!js/patterns/structure/templates/selection_button.xml"],function(e,t,n,r,i){var s=r.extend({collection:null,template:i,initialize:function(e){r.prototype.initialize.apply(this,[e]),this.collection!==null&&this.collection.on("add remove reset",function(){this.render(),this.collection.length===0&&this.$el.removeClass("active")},this)},serializedModel:function(){var e={icon:"",title:this.options.title,length:0};return this.collection!==null&&(e.length=this.collection.length),e}});return s}),define("text!js/patterns/structure/templates/paging.xml",[],function(){return'  <ul class="pagination pagination-sm pagination-centered">\n    <li class="<% if (currentPage === 1) { %>disabled<% } %>">\n      <a href="#" class="serverfirst">\n        &laquo;\n      </a>\n    </li>\n    <li class="<% if (currentPage === 1) { %>disabled<% } %>">\n      <a href="#" class="serverprevious">\n        &lt;\n      </a>\n    </li>\n    <% _.each(pages, function(p){ %>\n    <li class="<% if (currentPage == p) { %>active<% } %>">\n      <a href="#" class="page"><%= p %></a>\n    </li>\n    <% }); %>\n    <li class="<% if (currentPage === lastPage) { %>disabled<% } %>">\n      <a href="#" class="servernext">\n        &gt;\n      </a>\n    </li>\n    <li class="<% if (currentPage === lastPage) { %>disabled<% } %>">\n      <a href="#" class="serverlast">\n        &raquo;\n      </a>\n    </li>\n  </ul>\n\n  <ul class="pagination pagination-sm">\n    <li class="disabled"><a href="#">Show:</a></li>\n    <li class="serverhowmany serverhowmany15 <% if(perPage == 15){ %>disabled<% } %>">\n      <a href="#" class="">15</a>\n    </li>\n    <li class="serverhowmany serverhowmany30 <% if(perPage == 30){ %>disabled<% } %>">\n      <a href="#" class="">30</a>\n    </li>\n    <li class="serverhowmany serverhowmany50 <% if(perPage == 50){ %>disabled<% } %>">\n      <a href="#" class="">50</a>\n    </li>\n  </ul>\n\n  <ul class="pagination pagination-sm">\n    <li class="disabled">\n      <a href="#">\n        Page: <span class="current"><%= currentPage %></span>\n        of\n        <span class="total"><%= totalPages %></span>\n              shown\n      </a>\n    </li>\n  </ul>\n'}),define("js/patterns/structure/views/paging",["jquery","underscore","backbone","text!js/patterns/structure/templates/paging.xml"],function(e,t,n,r){var i=n.View.extend({events:{"click a.servernext":"nextResultPage","click a.serverprevious":"previousResultPage","click a.serverlast":"gotoLast","click a.page":"gotoPage","click a.serverfirst":"gotoFirst","click a.serverpage":"gotoPage","click .serverhowmany a":"changeCount"},tagName:"aside",template:t.template(r),maxPages:7,initialize:function(e){this.options=e,this.app=this.options.app,this.collection=this.app.collection,this.collection.on("reset",this.render,this),this.collection.on("sync",this.render,this),this.$el.appendTo("#pagination")},render:function(){var e=this.collection.info();e.pages=this.getPages(e);var t=this.template(e);return this.$el.html(t),this},getPages:function(e){var t=e.perPage,n=e.totalPages;if(!n)return[];var r=e.currentPage,i=1,s=n;n>this.maxPages&&(i=Math.max(1,Math.floor(r-this.maxPages/2)),s=Math.min(i+this.maxPages,n),s-i<this.maxPages&&(i-=Math.floor(this.maxPages/2)));var o=[];for(var u=i;u<=s;u+=1)o.push(u);return o[0]>1&&(o[0]>2&&(o=["..."].concat(o)),o=[1].concat(o)),o[o.length-1]<n-1&&(o[o.length-2]<n-2&&o.push("..."),o.push(n)),o},nextResultPage:function(e){e.preventDefault(),this.collection.requestNextPage()},previousResultPage:function(e){e.preventDefault(),this.collection.requestPreviousPage()},gotoFirst:function(e){e.preventDefault(),this.collection.goTo(this.collection.information.firstPage)},gotoLast:function(e){e.preventDefault(),this.collection.goTo(this.collection.information.totalPages)},gotoPage:function(t){t.preventDefault();var n=e(t.target).text();this.collection.goTo(n)},changeCount:function(t){t.preventDefault();var n=e(t.target).text();this.collection.howManyPer(n)}});return i}),define("js/patterns/structure/views/addmenu",["jquery","underscore","backbone","js/ui/views/buttongroup","js/ui/views/button","mockup-patterns-modal","mockup-utils","bootstrap-dropdown"],function(e,t,n,r,i,s,o){var u=r.extend({title:"Add",className:"btn-group addnew",events:{},initialize:function(n){var s=this;r.prototype.initialize.apply(s,[n]),s.app.on("context-info-loaded",function(n){s.$items.empty(),t.each(n.addButtons,function(t){var n=new i({id:t.id,title:t.title,url:t.action});n.render();var r=e("<li/>");n.$el.removeClass("btn"),r.append(n.el),s.$items.append(r),n.$el.click(function(e){return s.buttonClicked.apply(s,[e,n]),!1})})})},buttonClicked:function(t,n){var r=this;t.preventDefault(),r.app.loading.show(),e.ajax({url:n.url,type:"POST",data:{_authenticator:e('[name="_authenticator"]').val()},success:function(e){r.app.loading.hide();var t=new s(r.$el,{html:o.parseBodyTag(e),content:"#content",width:"80%",backdropOptions:{closeOnClick:!1},automaticallyAddButtonActions:!1,actionOptions:{displayInModal:!1,reloadWindowOnClose:!1},actions:{'input#form-buttons-save, .formControls input[name="form.button.save"]':{onSuccess:function(e,t,n,i,s){r.app.collection.pager(),r.$items.is(":visible")&&r.$dropdown.dropdown("toggle"),e.hide()},onError:function(){alert("error on form")}},'input#form-buttons-cancel, .formControls input[name="form.button.cancel"]':{modalFunction:"hide"}}});t.show()},error:function(){r.app.loading.hide()}})},render:function(){var e=this;return e.$el.empty(),e.$el.append('<a class="btn dropdown-toggle btn-success" data-toggle="dropdown" href="#">'+e.title+'<span class="caret"></span>'+"</a>"+'<ul class="dropdown-menu">'+"</ul>"+"</div>"),e.$items=e.$(".dropdown-menu"),e.$dropdown=e.$(".dropdown-toggle"),e.$dropdown.dropdown(),this}});return u}),define("js/patterns/structure/views/columns",["jquery","underscore","backbone","js/ui/views/popover","mockup-patterns-sortable"],function(e,t,n,r,i){var s=r.extend({className:"popover columns",title:t.template("Columns"),content:t.template('<label>Select columns to show, drag and drop to reorder</label><ul></ul><button class="btn btn-block btn-success">Save</button>'),itemTemplate:t.template('<li><label><input type="checkbox" value="<%- id %>"/><%- title %></label></li>'),events:{"click button":"applyButtonClicked"},initialize:function(e){this.app=e.app,r.prototype.initialize.apply(this,[e])},render:function(){var n=this;r.prototype.render.call(this),n.$container=n.$("ul"),t.each(n.app.activeColumns,function(t){var r=e(n.itemTemplate({title:n.app.availableColumns[t],id:t}));r.find("input")[0].checked=!0,n.$container.append(r)}),t.each(t.omit(n.app.availableColumns,n.app.activeColumns),function(t,r){var i=e(n.itemTemplate({title:t,id:r}));n.$container.append(i)});var s=new i(n.$container,{selector:"li"});return this},applyButtonClicked:function(){var t=this;this.hide(),t.app.activeColumns=[],t.$("input:checked").each(function(){t.app.activeColumns.push(e(this).val())}),t.app.setCookieSetting("activeColumns",this.app.activeColumns),t.app.tableView.render()}});return s}),define("mockup-patterns-querystring",["jquery","mockup-patterns-base","mockup-patterns-select2","mockup-patterns-pickadate","select2"],function(e,t,n,r,i){var s=function(){this.init.apply(this,arguments)};s.prototype={defaults:{indexWidth:"20em",placeholder:"Select criteria",remove:"",results:" items matching your search.",days:"days",betweendt:"to",classBetweenDtName:"querystring-criteria-betweendt",classWrapperName:"querystring-criteria-wrapper",classIndexName:"querystring-criteria-index",classOperatorName:"querystring-criteria-operator",classValueName:"querystring-criteria-value",classRemoveName:"querystring-criteria-remove",classResultsName:"querystring-criteria-results",classClearName:"querystring-criteria-clear"},init:function(t,n,r,s,o,u){var a=this;a.options=e.extend(!0,{},a.defaults,n),a.indexes=r,a.indexGroups={},a.$wrapper=e("<div/>").addClass(a.options.classWrapperName).appendTo(t),a.$remove=e("<div>"+a.options.remove+"</div>").addClass(a.options.classRemoveName).appendTo(a.$wrapper).on("click",function(e){a.remove()}),a.$index=e("<select><option></option></select>").attr("placeholder",a.options.placeholder),e.each(a.indexes,function(t,n){n.enabled&&(a.indexGroups[n.group]||(a.indexGroups[n.group]=e("<optgroup/>").attr("label",n.group).appendTo(a.$index)),a.indexGroups[n.group].append(e("<option/>").attr("value",t).html(n.title)))}),a.$wrapper.append(e("<div/>").addClass(a.options.classIndexName).append(a.$index)),a.$index.patternSelect2({width:a.options.indexWidth,placeholder:a.options.placeholder}).on("change",function(e){a.removeValue(),a.createOperator(e.val),a.createClear(),a.trigger("index-changed")}),s!==i&&(a.$index.select2("val",s),a.createOperator(s,o,u),a.createClear()),a.trigger("create-criteria")},createOperator:function(t,n,r){var s=this;s.removeOperator(),s.$operator=e("<select/>"),s.indexes[t]&&e.each(s.indexes[t].operators,function(t,n){e("<option/>").attr("value",t).html(n.title).appendTo(s.$operator)}),s.$wrapper.append(e("<div/>").addClass(s.options.classOperatorName).append(s.$operator)),s.$operator.patternSelect2({width:"10em"}).on("change",function(e){s.createValue(t),s.createClear(),s.trigger("operator-changed")}),n===i&&(n=s.$operator.select2("val")),s.$operator.select2("val",n),s.createValue(t,r),s.trigger("create-operator")},createValue:function(t,n){var r=this,s=r.indexes[t].operators[r.$operator.val()].widget,o=e("<div/>").addClass(r.options.classValueName).appendTo(r.$wrapper);r.removeValue();if(s==="StringWidget")r.$value=e('<input type="text"/>').addClass(r.options.classValueName+"-"+s).val(n).appendTo(o).change(function(){r.trigger("value-changed")});else if(s==="DateWidget")r.$value=e('<input type="text"/>').addClass(r.options.classValueName+"-"+s).appendTo(o).patternPickadate({time:!1,date:{format:"dd/mm/yyyy"}}).change(function(){r.trigger("value-changed")});else if(s==="DateRangeWidget"){var u=e("<span/>").appendTo(o),a=e('<input type="text"/>').addClass(r.options.classValueName+"-"+s).addClass(r.options.classValueName+"-"+s+"-start").appendTo(u).patternPickadate({time:!1,date:{format:"dd/mm/yyyy"}});o.append(e("<span/>").html(r.options.betweendt).addClass(r.options.classBetweenDtName));var f=e("<span/>").appendTo(o),l=e('<input type="text"/>').addClass(r.options.classValueName+"-"+s).addClass(r.options.classValueName+"-"+s+"-end").appendTo(f).patternPickadate({time:!1,date:{format:"dd/mm/yyyy"}});o.find(".picker__input").change(function(){r.trigger("value-changed")}),r.$value=[a,l]}else s==="RelativeDateWidget"?r.$value=e('<input type="text"/>').after(e("<span/>").html(r.options.days)).addClass(r.options.classValueName+"-"+s).appendTo(o).change(function(){r.trigger("value-changed")}):s==="ReferenceWidget"?r.$value=e('<input type="text"/>').addClass(r.options.classValueName+"-"+s).appendTo(o).change(function(){r.trigger("value-changed")}):s==="RelativePathWidget"?r.$value=e('<input type="text"/>').addClass(r.options.classValueName+"-"+s).appendTo(o).val(n).change(function(){r.trigger("value-changed")}):s==="MultipleSelectionWidget"&&(r.$value=e("<select/>").attr("multiple",!0).addClass(r.options.classValueName+"-"+s).appendTo(o).change(function(){r.trigger("value-changed")}),r.indexes[t]&&e.each(r.indexes[t].values,function(t,n){e("<option/>").attr("value",t).html(n.title).appendTo(r.$value)}),r.$value.patternSelect2({width:"250px"}));n!==i&&typeof r.$value!="undefined"&&r.$value.select2("val",n),r.trigger("create-value")},createClear:function(){var t=this;t.removeClear(),t.$clear=e("<div/>").addClass(t.options.classClearName).appendTo(t.$wrapper)},remove:function(){var e=this;e.trigger("remove"),e.$remove.remove(),e.$index.parent().remove(),e.removeOperator(),e.removeValue(),e.removeClear(),e.$wrapper.remove()},removeClear:function(){var e=this;e.trigger("remove-clear"),e.$clear&&e.$clear.remove()},removeOperator:function(){var e=this;e.trigger("remove-operator"),e.$operator&&e.$operator.parent().remove()},removeValue:function(){var t=this;t.trigger("remove-value"),t.$value&&(e.isArray(t.$value)?t.$value[0].parents(".querystring-criteria-value").remove():t.$value.parents(".querystring-criteria-value").remove())},buildQueryPart:function(){var t=this,n=t.$index.select2("val");if(n==="")return"";var r="query.i:records="+n;if(typeof t.$operator=="undefined")return"";var i=t.$operator.val(),s="query.o:records="+i,o="query.v:records=",u="query.v:records:list=",a=[];return typeof t.$value=="undefined"?a.push(o):e.isArray(t.$value)?e.each(t.$value,function(t,n){a.push(u+e(this).parent().find(".picker__input").val())}):a.push(o+t.$value.val()),r+"&"+s+"&"+a.join("&")},getJSONListStr:function(){var t=this,n=t.$index.select2("val");if(n==="")return"";if(typeof t.$operator=="undefined")return"";var r=t.$operator.val(),i=[];e.isArray(t.$value)?e.each(t.$value,function(t,n){i.push(e(this).parent().find(".picker__input").val())}):typeof t.$value!="undefined"&&i.push(t.$value.val());var s;return i.length>1?s="[j"+i.join('","')+'"]':i.length===1?s=JSON.stringify(i[0]):s='""','{"i":"'+n+'", "o":"'+r+'", "v":'+s+"}"},trigger:function(e){this.$wrapper.trigger(e+"-criteria.querystring.patterns",[this])},on:function(e,t){this.$wrapper.on(e+"-criteria.querystring.patterns",t)}};var o=t.extend({name:"querystring",defaults:{indexes:[],classWrapperName:"querystring-wrapper",criteria:{},indexOptionsUrl:null,previewURL:"portal_factory/@@querybuilder_html_results",previewCountURL:"portal_factory/@@querybuildernumberofresults",sorttxt:"Sort On",reversetxt:"Reversed Order",previewTitle:"Preview",previewDescription:"Preview of at most 10 items",classSortLabelName:"querystring-sort-label",classSortReverseName:"querystring-sortreverse",classSortReverseLabelName:"querystring-sortreverse-label",classPreviewCountWrapperName:"querystring-previewcount-wrapper",classPreviewResultsWrapperName:"querystring-previewresults-wrapper",classPreviewWrapperName:"querystring-preview-wrapper",classPreviewName:"querystring-preview",classPreviewTitleName:"querystring-preview-title",classPreviewDescriptionName:"querystring-preview-description",classSortWrapperName:"querystring-sort-wrapper",showPreviews:!0},init:function(){var t=this;t.$el.hide(),t.$wrapper=e("<div/>"),t.$el.after(t.$wrapper),t.initialized=!1,t.options.indexOptionsUrl?e.ajax({url:t.options.indexOptionsUrl,success:function(e){t.options.indexes=e.indexes,t.options.sortable_indexes=e.sortable_indexes,t._init()},error:function(e){}}):t._init()},_init:function(){var t=this;t.$criteriaWrapper=e("<div/>").addClass(t.options.classWrapperName).appendTo(t.$wrapper),t.$sortWrapper=e("<div/>").addClass(t.options.classSortWrapperName).appendTo(t.$wrapper),t.options.showPreviews==="false"&&(t.options.showPreviews=!1),t.options.showPreviews&&(t.$previewWrapper=e("<div/>").addClass(t.options.classPreviewWrapperName).appendTo(t.$wrapper),e("<div/>").addClass(t.options.classPreviewTitleName).html(t.options.previewTitle).appendTo(t.$previewWrapper),e("<div/>").addClass(t.options.classPreviewDescriptionName).html(t.options.previewDescription).appendTo(t.$previewWrapper)),t.criterias=[],t.$el.val()&&e.each(JSON.parse(t.$el.val()),function(e,n){t.createCriteria(n.i,n.o,n.v)}),t.createCriteria(),t.createSort(),t.options.showPreviews&&t.refreshPreviewEvent(),t.$el.trigger("initialized"),t.initialized=!0},createCriteria:function(e,t,n){var r=this,i=new s(r.$criteriaWrapper,r.options.criteria,r.options.indexes,e,t,n);i.on("remove",function(e){r.criterias[r.criterias.length-1]===i&&r.createCriteria()}),i.on("index-changed",function(e){r.criterias[r.criterias.length-1]===i&&r.createCriteria()});var o=function(){r.refreshPreviewEvent(),r.updateValue()};i.on("remove",function(e,t){r.criterias.indexOf(t)!==-1&&r.criterias.splice(r.criterias.indexOf(t),1),o(e,t)}),i.on("remove-clear",o),i.on("remove-operator",o),i.on("remove-value",o),i.on("index-changed",o),i.on("operator-changed",o),i.on("create-criteria",o),i.on("create-operator",o),i.on("create-value",o),i.on("value-changed",o),r.criterias.push(i)},createSort:function(){var t=this,n=e('[id$="-sort_on"]').filter('[id^="formfield-"]'),r=e('[id$="-sort_reversed"]').filter('[id^="formfield-"]');e("<span/>").addClass(t.options.classSortLabelName).html(t.options.sorttxt).appendTo(t.$sortWrapper),t.$sortOn=e("<select/>").attr("name","sort_on").appendTo(t.$sortWrapper).change(function(){t.refreshPreviewEvent.call(t),e('[id$="sort_on"]',n).val(e(this).val())}),t.$sortOn.append(e('<option value="">No sorting</option>'));for(var i in t.options.sortable_indexes)t.$sortOn.append(e("<option/>").attr("value",i).html(t.options.indexes[i].title));t.$sortOn.patternSelect2({width:150}),t.$sortOrder=e('<input type="checkbox" />').attr("name","sort_reversed:boolean").change(function(){t.refreshPreviewEvent.call(t),e(this).attr("checked")==="checked"?e('.option input[type="checkbox"]',r).attr("checked","checked"):e('.option input[type="checkbox"]',r).removeAttr("checked")}),e("<span/>").addClass(t.options.classSortReverseName).appendTo(t.$sortWrapper).append(t.$sortOrder).append(e("<span/>").html(t.options.reversetxt).addClass(t.options.classSortReverseLabelName));if(n.length>=1&&r.length>=1){var s=e('.option input[type="checkbox"]',r).attr("checked")==="checked",o=e('[id$="-sort_on"]',n).val();s&&t.$sortOrder.attr("checked","checked"),t.$sortOn.select2("val",o),e(n).hide(),e(r).hide()}},refreshPreviewEvent:function(){var t=this;if(!t.options.showPreviews)return;typeof t._previewXhr!="undefined"&&t._previewXhr.abort(),typeof t.$previewPane!="undefined"&&t.$previewPane.remove();var n=[],r;e.each(t.criterias,function(e,t){r=t.buildQueryPart(),r!==""&&n.push(t.buildQueryPart())}),t.$previewPane=e("<div/>").addClass(t.options.classPreviewName).appendTo(t.$previewWrapper);if(n.length<=0){e("<div/>").addClass(t.options.classPreviewCountWrapperName).html("No results to preview").prependTo(t.$previewPane);return}n.push("sort_on="+t.$sortOn.val());var i=t.$sortOrder.attr("checked");i==="checked"&&n.push("sort_order=reverse"),t._previewXhr=e.get(t.options.previewURL+"?"+n.join("&")).done(function(n,r){e("<div/>").addClass(t.options.classPreviewResultsWrapperName).html(n).appendTo(t.$previewPane)})},updateValue:function(){var t=this,n=[];e.each(t.criterias,function(e,t){var r=t.getJSONListStr();r!==""&&n.push(r)});var r=t.$el.val(),i="["+n.join(",")+"]";t.$el.val(i),t.$el.trigger("change")}});return o}),define("js/patterns/structure/views/textfilter",["jquery","backbone","underscore","js/ui/views/base","js/ui/views/button","js/ui/views/popover","mockup-patterns-querystring"],function(e,t,n,r,i,s,o){var u=r.extend({tagName:"div",className:"navbar-search form-search ui-offset-parent",template:n.template('<div class="input-group"><input type="text" class="form-control search-query" placeholder="Filter"><span class="input-group-btn"></span></div>'),popoverContent:n.template('<input class="pat-querystring" />'),events:{"keyup .search-query":"filter"},term:null,timeoutId:null,keyupDelay:300,initialize:function(e){r.prototype.initialize.apply(this,[e]),this.app=this.options.app},render:function(){this.$el.html(this.template({})),this.button=new i({title:"Query"}),this.popover=new s({triggerView:this.button,title:n.template("Query"),content:this.popoverContent,placement:"left"}),this.$(".input-group-btn").append(this.button.render().el),this.$el.append(this.popover.render().el),this.popover.$el.addClass("query"),this.$queryString=this.popover.$("input.pat-querystring"),this.queryString=new o(this.$queryString,{indexOptionsUrl:this.app.options.indexOptionsUrl,showPreviews:!1});var t=this;return t.queryString.$el.on("change",function(){t.timeoutId&&clearTimeout(t.timeoutId),t.timeoutId=setTimeout(function(){var n=e.parseJSON(t.$queryString.val());t.app.additionalCriterias=n,t.app.collection.pager()},this.keyupDelay)}),t.queryString.$el.on("initialized",function(){t.queryString.$sortOn.on("change",function(){t.app.sort_on=t.queryString.$sortOn.val(),t.app.collection.pager()}),t.queryString.$sortOrder.change(function(){t.queryString.$sortOrder[0].checked?t.app.sort_order="reverse":t.app.sort_order="ascending",t.app.collection.pager()})}),this},filter:function(t){var n=this;n.timeoutId&&clearTimeout(n.timeoutId),n.timeoutId=setTimeout(function(){n.term=e(t.currentTarget).val(),n.app.collection.pager()},this.keyupDelay)}});return u}),Backbone.Paginator=function(e,t,n){var r=t.map(e.VERSION.split("."),function(e){return parseInt(e,10)}),i={};i.version="<%= pkg.version %>",i.clientPager=e.Collection.extend({useDiacriticsPlugin:!0,useLevenshteinPlugin:!0,sortColumn:"",sortDirection:"desc",lastSortColumn:"",fieldFilterRules:[],lastFieldFilterRules:[],filterFields:"",filterExpression:"",lastFilterExpression:"",defaults_ui:{firstPage:0,currentPage:1,perPage:5,totalPages:10,pagesInRange:4},initialize:function(){this.on("add",this.addModel,this),this.on("remove",this.removeModel,this),this.setDefaults()},setDefaults:function(){var e=t.defaults(this.paginator_ui,this.defaults_ui);t.defaults(this,e)},addModel:function(e){this.origModels.push(e)},removeModel:function(e){var n=t.indexOf(this.origModels,e);this.origModels.splice(n,1)},sync:function(i,s,o){var u=this;this.setDefaults();var a={};t.each(t.result(u,"server_api"),function(e,n){t.isFunction(e)&&(e=t.bind(e,u),e=e()),a[n]=e});var f=t.clone(u.paginator_core);t.each(f,function(e,n){t.isFunction(e)&&(e=t.bind(e,u),e=e()),f[n]=e}),f=t.defaults(f,{timeout:25e3,cache:!1,type:"GET",dataType:"jsonp"}),f=t.extend(f,{data:decodeURIComponent(n.param(a)),processData:!1,url:t.result(f,"url")},o);var l=r[0]!==0||r[1]!==9||r[2]!==10,c=f.success;f.success=function(e,t,n){c&&(l?c(e,t,n):c(s,e,f)),s&&s.trigger&&s.trigger("sync",s,e,f)};var h=f.error;f.error=function(e){h&&h(s,e,f),s&&s.trigger&&s.trigger("error",s,e,f)};var p=f.xhr=e.ajax(f);return s&&s.trigger&&s.trigger("request",s,p,f),p},nextPage:function(e){this.currentPage<this.information.totalPages&&(this.currentPage=++this.currentPage,this.pager(e))},previousPage:function(e){this.currentPage>1&&(this.currentPage=--this.currentPage,this.pager(e))},goTo:function(e,t){e!==undefined&&(this.currentPage=parseInt(e,10),this.pager(t))},howManyPer:function(e){if(e!==undefined){var t=this.perPage;this.perPage=parseInt(e,10),this.currentPage=Math.ceil((t*(this.currentPage-1)+1)/e),this.pager()}},setSort:function(e,t){e!==undefined&&t!==undefined&&(this.lastSortColumn=this.sortColumn,this.sortColumn=e,this.sortDirection=t,this.pager(),this.info())},setFieldFilter:function(e){t.isEmpty(e)?(this.lastFieldFilterRules=this.fieldFilterRules,this.fieldFilterRules="",this.pager(),this.info()):(this.lastFieldFilterRules=this.fieldFilterRules,this.fieldFilterRules=e,this.pager(),this.info())},doFakeFieldFilter:function(e){if(!t.isEmpty(e)){var n=this.origModels;return n===undefined&&(n=this.models),n=this._fieldFilter(n,e),this.filterExpression!==""&&(n=this._filter(n,this.filterFields,this.filterExpression)),n.length}},setFilter:function(e,t){e!==undefined&&t!==undefined&&(this.filterFields=e,this.lastFilterExpression=this.filterExpression,this.filterExpression=t,this.pager(),this.info())},doFakeFilter:function(e,n){if(e!==undefined&&n!==undefined){var r=this.origModels;return r===undefined&&(r=this.models),t.isEmpty(this.fieldFilterRules)||(r=this._fieldFilter(r,this.fieldFilterRules)),r=this._filter(r,e,n),r.length}},pager:function(e){var n=this,r=this.perPage,i=(n.currentPage-1)*r,s=i+r;n.origModels===undefined&&(n.origModels=n.models),n.models=n.origModels.slice(),this.sortColumn!==""&&(n.models=n._sort(n.models,this.sortColumn,this.sortDirection)),t.isEmpty(this.fieldFilterRules)||(n.models=n._fieldFilter(n.models,this.fieldFilterRules)),this.filterExpression!==""&&(n.models=n._filter(n.models,this.filterFields,this.filterExpression));if(this.lastSortColumn!==this.sortColumn||this.lastFilterExpression!==this.filterExpression||!t.isEqual(this.fieldFilterRules,this.lastFieldFilterRules))i=0,s=i+r,n.currentPage=1,this.lastSortColumn=this.sortColumn,this.lastFieldFilterRules=this.fieldFilterRules,this.lastFilterExpression=this.filterExpression;n.sortedAndFilteredModels=n.models.slice(),n.info(),n.reset(n.models.slice(i,s)),t.result(e,"success")},_sort:function(e,n,r){return e=e.sort(function(e,i){var s=e.get(n),o=i.get(n);if(t.isUndefined(s)||t.isUndefined(o)||s===null||o===null)return 0;s=s.toString().toLowerCase(),o=o.toString().toLowerCase();if(r==="desc")if(!s.match(/[^\-\d\.]/)&&s.match(/-?[\d\.]+/)&&!o.match(/[^\-\d\.]/)&&o.match(/-?[\d\.]+/)){if(s-0<o-0)return 1;if(s-0>o-0)return-1}else{if(s<o)return 1;if(s>o)return-1}else if(!s.match(/[^\-\d\.]/)&&s.match(/-?[\d\.]+/)&&!o.match(/[^\-\d\.]/)&&o.match(/-?[\d\.]+/)){if(s-0<o-0)return-1;if(s-0>o-0)return 1}else{if(s<o)return-1;if(s>o)return 1}if(e.cid&&i.cid){var u=e.cid,a=i.cid;if(u<a)return-1;if(u>a)return 1}return 0}),e},_fieldFilter:function(e,n){if(t.isEmpty(n))return e;var r=[];return t.each(e,function(e){var i=!0;t.each(n,function(n){if(!i)return!1;i=!1;if(n.type==="function"){var r=t.wrap(n.value,function(t){return t(e.get(n.field))});r()&&(i=!0)}else n.type==="required"?t.isEmpty(e.get(n.field).toString())||(i=!0):n.type==="min"?!t.isNaN(Number(e.get(n.field)))&&!t.isNaN(Number(n.value))&&Number(e.get(n.field))>=Number(n.value)&&(i=!0):n.type==="max"?!t.isNaN(Number(e.get(n.field)))&&!t.isNaN(Number(n.value))&&Number(e.get(n.field))<=Number(n.value)&&(i=!0):n.type==="range"?!t.isNaN(Number(e.get(n.field)))&&t.isObject(n.value)&&!t.isNaN(Number(n.value.min))&&!t.isNaN(Number(n.value.max))&&Number(e.get(n.field))>=Number(n.value.min)&&Number(e.get(n.field))<=Number(n.value.max)&&(i=!0):n.type==="minLength"?e.get(n.field).toString().length>=n.value&&(i=!0):n.type==="maxLength"?e.get(n.field).toString().length<=n.value&&(i=!0):n.type==="rangeLength"?t.isObject(n.value)&&!t.isNaN(Number(n.value.min))&&!t.isNaN(Number(n.value.max))&&e.get(n.field).toString().length>=n.value.min&&e.get(n.field).toString().length<=n.value.max&&(i=!0):n.type==="oneOf"?t.isArray(n.value)&&t.include(n.value,e.get(n.field))&&(i=!0):n.type==="equalTo"?n.value===e.get(n.field)&&(i=!0):n.type==="containsAllOf"?t.isArray(n.value)&&t.isArray(e.get(n.field))&&t.intersection(n.value,e.get(n.field)).length===n.value.length&&(i=!0):n.type==="pattern"?e.get(n.field).toString().match(n.value)&&(i=!0):i=!1}),i&&r.push(e)}),r},_filter:function(n,r,i){var s=this,o={};t.isString(r)?o[r]={cmp_method:"regexp"}:t.isArray(r)?t.each(r,function(e){o[e]={cmp_method:"regexp"}}):t.each(r,function(e,n){o[n]=t.defaults(e,{cmp_method:"regexp"})}),r=o,t.has(e.Paginator,"removeDiacritics")&&s.useDiacriticsPlugin&&(i=e.Paginator.removeDiacritics(i));if(i===""||!t.isString(i))return n;var u=t.map(i.match(/\w+/ig),function(e){return e.toLowerCase()}),a="("+t.uniq(u).join("|")+")",f=new RegExp(a,"igm"),l=[];return t.each(n,function(n){var o=[];t.each(r,function(r,a){var l=n.get(a);if(l){var c=[];t.has(e.Paginator,"removeDiacritics")&&s.useDiacriticsPlugin?l=e.Paginator.removeDiacritics(l.toString()):l=l.toString();if(r.cmp_method==="levenshtein"&&t.has(e.Paginator,"levenshtein")&&s.useLevenshteinPlugin){var h=e.Paginator.levenshtein(l,i);t.defaults(r,{max_distance:0}),h<=r.max_distance&&(c=t.uniq(u))}else c=l.match(f);c=t.map(c,function(e){return e.toString().toLowerCase()}),t.each(c,function(e){o.push(e)})}}),o=t.uniq(t.without(o,"")),t.isEmpty(t.difference(u,o))&&l.push(n)}),l},info:function(){var e=this,t={},n=e.sortedAndFilteredModels?e.sortedAndFilteredModels.length:e.length,r=Math.ceil(n/e.perPage);return t={totalUnfilteredRecords:e.origModels.length,totalRecords:n,currentPage:e.currentPage,perPage:this.perPage,totalPages:r,lastPage:r,previous:!1,next:!1,startRecord:n===0?0:(e.currentPage-1)*this.perPage+1,endRecord:Math.min(n,e.currentPage*this.perPage)},e.currentPage>1&&(t.previous=e.currentPage-1),e.currentPage<t.totalPages&&(t.next=e.currentPage+1),t.pageSet=e.setPagination(t),e.information=t,t},setPagination:function(e){var t=[],n=0,r=0,i=this.pagesInRange*2,s=Math.ceil(e.totalRecords/e.perPage);if(s>1)if(s<=1+i)for(n=1,r=s;n<=r;n++)t.push(n);else if(e.currentPage<=this.pagesInRange+1)for(n=1,r=2+i;n<r;n++)t.push(n);else if(s-this.pagesInRange>e.currentPage&&e.currentPage>this.pagesInRange)for(n=e.currentPage-this.pagesInRange;n<=e.currentPage+this.pagesInRange;n++)t.push(n);else for(n=s-i;n<=s;n++)t.push(n);return t},bootstrap:function(e){return t.extend(this,e),this.goTo(1),this.info(),this}}),i.clientPager.prototype.prevPage=i.clientPager.prototype.previousPage;var s=function(){var e=new n.Deferred;return e.reject(),e.promise()};return i.requestPager=e.Collection.extend({sync:function(i,s,o){var u=this;u.setDefaults();var a={};t.each(t.result(u,"server_api"),function(e,n){t.isFunction(e)&&(e=t.bind(e,u),e=e()),a[n]=e});var f=t.clone(u.paginator_core);t.each(f,function(e,n){t.isFunction(e)&&(e=t.bind(e,u),e=e()),f[n]=e}),f=t.defaults(f,{timeout:25e3,cache:!1,type:"GET",dataType:"jsonp"}),o.data?o.data=decodeURIComponent(n.param(t.extend(a,o.data))):o.data=decodeURIComponent(n.param(a)),f=t.extend(f,{data:decodeURIComponent(n.param(a)),processData:!1,url:t.result(f,"url")},o);var l=r[0]!==0||r[1]!==9||r[2]!==10,c=f.success;f.success=function(e,t,n){c&&(l?c(e,t,n):c(s,e,f)),r[0]<1&&s&&s.trigger&&s.trigger("sync",s,e,f)};var h=f.error;f.error=function(e){h&&h(e),s&&s.trigger&&s.trigger("error",s,e,f)};var p=f.xhr=e.ajax(f);return s&&s.trigger&&s.trigger("request",s,p,f),p},setDefaults:function(){var e=this;t.defaults(e.paginator_ui,{firstPage:0,currentPage:1,perPage:5,totalPages:10,pagesInRange:4}),t.each(e.paginator_ui,function(n,r){t.isUndefined(e[r])&&(e[r]=e.paginator_ui[r])})},requestNextPage:function(e){return this.currentPage!==undefined?(this.currentPage+=1,this.pager(e)):s()},requestPreviousPage:function(e){return this.currentPage!==undefined?(this.currentPage-=1,this.pager(e)):s()},updateOrder:function(e,t){return e!==undefined?(this.sortField=e,this.pager(t)):s()},goTo:function(e,t){return e!==undefined?(this.currentPage=parseInt(e,10),this.pager(t)):s()},howManyPer:function(e,t){return e!==undefined?(this.currentPage=this.firstPage,this.perPage=e,this.pager(t)):s()},info:function(){var e={totalRecords:this.totalRecords||0,currentPage:this.currentPage,firstPage:this.firstPage,totalPages:Math.ceil(this.totalRecords/this.perPage),lastPage:this.totalPages,perPage:this.perPage,previous:!1,next:!1};return this.currentPage>1&&(e.previous=this.currentPage-1),this.currentPage<e.totalPages&&(e.next=this.currentPage+1),e.hasNext=e.next,e.hasPrevious=e.next,e.pageSet=this.setPagination(e),this.information=e,e},setPagination:function(e){var t=[],n=0,r=0,i=this.pagesInRange*2,s=Math.ceil(e.totalRecords/e.perPage);if(s>1)if(s<=1+i)for(n=1,r=s;n<=r;n++)t.push(n);else if(e.currentPage<=this.pagesInRange+1)for(n=1,r=2+i;n<r;n++)t.push(n);else if(s-this.pagesInRange>e.currentPage&&e.currentPage>this.pagesInRange)for(n=e.currentPage-this.pagesInRange;n<=e.currentPage+this.pagesInRange;n++)t.push(n);else for(n=s-i;n<=s;n++)t.push(n);return t},pager:function(e){return t.isObject(e)||(e={}),this.fetch(e)},url:function(){return this.paginator_core!==undefined&&this.paginator_core.url!==undefined?this.paginator_core.url:null},bootstrap:function(e){return t.extend(this,e),this.setDefaults(),this.info(),this}}),i.requestPager.prototype.nextPage=i.requestPager.prototype.requestNextPage,i.requestPager.prototype.prevPage=i.requestPager.prototype.requestPreviousPage,i}(Backbone,_,jQuery),define("backbone.paginator",["backbone"],function(e){return function(){var t,n;return t||e.window.Backbone.Paginator}}(this)),define("js/patterns/structure/collections/result",["underscore","backbone","js/patterns/structure/models/result","backbone.paginator"],function(e,t,n){var r=t.Paginator.requestPager.extend({model:n,queryHelper:null,initialize:function(e,n){this.options=n,this.url=n.url,this.queryParser=n.queryParser,this.queryHelper=n.queryHelper,t.Paginator.requestPager.prototype.initialize.apply(this,[e,n])},pager:function(){this.trigger("pager"),t.Paginator.requestPager.prototype.pager.apply(this,[])},paginator_core:{type:"GET",dataType:"json",url:function(){return this.url}},paginator_ui:{firstPage:1,currentPage:1,perPage:15},server_api:{query:function(){return this.queryParser()},batch:function(){return this.queryHelper.options.batchSize=this.perPage,JSON.stringify(this.queryHelper.getBatch(this.currentPage))},attributes:function(){return JSON.stringify(this.queryHelper.options.attributes)}},parse:function(t){this.totalRecords=t.total;var n=t.results;return e.each(n,function(e,t){e._sort=t}),n},comparator:"_sort"});return r}),define("js/patterns/structure/collections/selected",["backbone","js/patterns/structure/models/result"],function(e,t){var n=e.Collection.extend({model:t,removeResult:function(e){return this.removeByUID(e.uid())},removeByUID:function(e){var t=this.getByUID(e);return t&&this.remove(t),t},getByUID:function(e){return this.findWhere({UID:e})}});return n}),function(e){typeof define=="function"&&define.amd?define("dropzone",["jquery"],e):e(jQuery)}(function(e){function n(e){if(e)return r(e)}function r(e){for(var t in n.prototype)e[t]=n.prototype[t];return e}var t={exports:{}};return t.exports=n,n.prototype.on=n.prototype.addEventListener=function(e,t){return this._callbacks=this._callbacks||{},(this._callbacks[e]=this._callbacks[e]||[]).push(t),this},n.prototype.once=function(e,t){function r(){n.off(e,r),t.apply(this,arguments)}var n=this;return this._callbacks=this._callbacks||{},r.fn=t,this.on(e,r),this},n.prototype.off=n.prototype.removeListener=n.prototype.removeAllListeners=n.prototype.removeEventListener=function(e,t){this._callbacks=this._callbacks||{};if(0==arguments.length)return this._callbacks={},this;var n=this._callbacks[e];if(!n)return this;if(1==arguments.length)return delete this._callbacks[e],this;var r;for(var i=0;i<n.length;i++){r=n[i];if(r===t||r.fn===t){n.splice(i,1);break}}return this},n.prototype.emit=function(e){this._callbacks=this._callbacks||{};var t=[].slice.call(arguments,1),n=this._callbacks[e];if(n){n=n.slice(0);for(var r=0,i=n.length;r<i;++r)n[r].apply(this,t)}return this},n.prototype.listeners=function(e){return this._callbacks=this._callbacks||{},this._callbacks[e]||[]},n.prototype.hasListeners=function(e){return!!this.listeners(e).length},function(){var r,i,s,o,u,a,f,l,c={}.hasOwnProperty,h=function(e,t){function r(){this.constructor=e}for(var n in t)c.call(t,n)&&(e[n]=t[n]);return r.prototype=t.prototype,e.prototype=new r,e.__super__=t.prototype,e},p=[].slice;i=typeof n!="undefined"&&n!==null?n:require("emitter"),f=function(){},r=function(e){function n(e,r){var i,s,o;this.element=e,this.version=n.version,this.defaultOptions.previewTemplate=this.defaultOptions.previewTemplate.replace(/\n*/g,""),this.clickableElements=[],this.listeners=[],this.files=[],typeof this.element=="string"&&(this.element=document.querySelector(this.element));if(!this.element||this.element.nodeType==null)throw new Error("Invalid dropzone element.");if(this.element.dropzone)throw new Error("Dropzone already attached.");n.instances.push(this),this.element.dropzone=this,i=(o=n.optionsForElement(this.element))!=null?o:{},this.options=t({},this.defaultOptions,i,r!=null?r:{});if(this.options.forceFallback||!n.isBrowserSupported())return this.options.fallback.call(this);this.options.url==null&&(this.options.url=this.element.getAttribute("action"));if(!this.options.url)throw new Error("No URL provided.");if(this.options.acceptedFiles&&this.options.acceptedMimeTypes)throw new Error("You can't provide both 'acceptedFiles' and 'acceptedMimeTypes'. 'acceptedMimeTypes' is deprecated.");this.options.acceptedMimeTypes&&(this.options.acceptedFiles=this.options.acceptedMimeTypes,delete this.options.acceptedMimeTypes),this.options.method=this.options.method.toUpperCase(),(s=this.getExistingFallback())&&s.parentNode&&s.parentNode.removeChild(s),this.options.previewsContainer?this.previewsContainer=n.getElement(this.options.previewsContainer,"previewsContainer"):this.previewsContainer=this.element,this.options.clickable&&(this.options.clickable===!0?this.clickableElements=[this.element]:this.clickableElements=n.getElements(this.options.clickable,"clickable")),this.init()}var t;return h(n,e),n.prototype.events=["drop","dragstart","dragend","dragenter","dragover","dragleave","addedfile","removedfile","thumbnail","error","errormultiple","processing","processingmultiple","uploadprogress","totaluploadprogress","sending","sendingmultiple","success","successmultiple","canceled","canceledmultiple","complete","completemultiple","reset","maxfilesexceeded","maxfilesreached"],n.prototype.defaultOptions={url:null,method:"post",withCredentials:!1,parallelUploads:2,uploadMultiple:!1,maxFilesize:256,paramName:"file",createImageThumbnails:!0,maxThumbnailFilesize:10,thumbnailWidth:100,thumbnailHeight:100,maxFiles:null,params:{},clickable:!0,ignoreHiddenFiles:!0,acceptedFiles:null,acceptedMimeTypes:null,autoProcessQueue:!0,addRemoveLinks:!1,previewsContainer:null,dictDefaultMessage:"Drop files here to upload",dictFallbackMessage:"Your browser does not support drag'n'drop file uploads.",dictFallbackText:"Please use the fallback form below to upload your files like in the olden days.",dictFileTooBig:"File is too big ({{filesize}}MiB). Max filesize: {{maxFilesize}}MiB.",dictInvalidFileType:"You can't upload files of this type.",dictResponseError:"Server responded with {{statusCode}} code.",dictCancelUpload:"Cancel upload",dictCancelUploadConfirmation:"Are you sure you want to cancel this upload?",dictRemoveFile:"Remove file",dictRemoveFileConfirmation:null,dictMaxFilesExceeded:"You can not upload any more files.",accept:function(e,t){return t()},init:function(){return f},forceFallback:!1,fallback:function(){var e,t,r,i,s,o;this.element.className=""+this.element.className+" dz-browser-not-supported",o=this.element.getElementsByTagName("div");for(i=0,s=o.length;i<s;i++){e=o[i];if(/(^| )dz-message($| )/.test(e.className)){t=e,e.className="dz-message";continue}}return t||(t=n.createElement('<div class="dz-message"><span></span></div>'),this.element.appendChild(t)),r=t.getElementsByTagName("span")[0],r&&(r.textContent=this.options.dictFallbackMessage),this.element.appendChild(this.getFallbackForm())},resize:function(e){var t,n,r;return t={srcX:0,srcY:0,srcWidth:e.width,srcHeight:e.height},n=e.width/e.height,r=this.options.thumbnailWidth/this.options.thumbnailHeight,e.height<this.options.thumbnailHeight||e.width<this.options.thumbnailWidth?(t.trgHeight=t.srcHeight,t.trgWidth=t.srcWidth):n>r?(t.srcHeight=e.height,t.srcWidth=t.srcHeight*r):(t.srcWidth=e.width,t.srcHeight=t.srcWidth/r),t.srcX=(e.width-t.srcWidth)/2,t.srcY=(e.height-t.srcHeight)/2,t},drop:function(e){return this.element.classList.remove("dz-drag-hover")},dragstart:f,dragend:function(e){return this.element.classList.remove("dz-drag-hover")},dragenter:function(e){return this.element.classList.add("dz-drag-hover")},dragover:function(e){return this.element.classList.add("dz-drag-hover")},dragleave:function(e){return this.element.classList.remove("dz-drag-hover")},paste:f,reset:function(){return this.element.classList.remove("dz-started")},addedfile:function(e){var t,r,i,s,o,u,a,f,l,c,h,p,d,v=this;this.element===this.previewsContainer&&this.element.classList.add("dz-started"),e.previewElement=n.createElement(this.options.previewTemplate.trim()),e.previewTemplate=e.previewElement,this.previewsContainer.appendChild(e.previewElement),c=e.previewElement.querySelectorAll("[data-dz-name]");for(s=0,a=c.length;s<a;s++)t=c[s],t.textContent=e.name;h=e.previewElement.querySelectorAll("[data-dz-size]");for(o=0,f=h.length;o<f;o++)t=h[o],t.innerHTML=this.filesize(e.size);this.options.addRemoveLinks&&(e._removeLink=n.createElement('<a class="dz-remove" href="javascript:undefined;" data-dz-remove>'+this.options.dictRemoveFile+"</a>"),e.previewElement.appendChild(e._removeLink)),r=function(t){return t.preventDefault(),t.stopPropagation(),e.status===n.UPLOADING?n.confirm(v.options.dictCancelUploadConfirmation,function(){return v.removeFile(e)}):v.options.dictRemoveFileConfirmation?n.confirm(v.options.dictRemoveFileConfirmation,function(){return v.removeFile(e)}):v.removeFile(e)},p=e.previewElement.querySelectorAll("[data-dz-remove]"),d=[];for(u=0,l=p.length;u<l;u++)i=p[u],d.push(i.addEventListener("click",r));return d},removedfile:function(e){var t;return(t=e.previewElement)!=null&&t.parentNode.removeChild(e.previewElement),this._updateMaxFilesReachedClass()},thumbnail:function(e,t){var n,r,i,s,o;e.previewElement.classList.remove("dz-file-preview"),e.previewElement.classList.add("dz-image-preview"),s=e.previewElement.querySelectorAll("[data-dz-thumbnail]"),o=[];for(r=0,i=s.length;r<i;r++)n=s[r],n.alt=e.name,o.push(n.src=t);return o},error:function(e,t){var n,r,i,s,o;e.previewElement.classList.add("dz-error"),typeof t!="String"&&t.error&&(t=t.error),s=e.previewElement.querySelectorAll("[data-dz-errormessage]"),o=[];for(r=0,i=s.length;r<i;r++)n=s[r],o.push(n.textContent=t);return o},errormultiple:f,processing:function(e){e.previewElement.classList.add("dz-processing");if(e._removeLink)return e._removeLink.textContent=this.options.dictCancelUpload},processingmultiple:f,uploadprogress:function(e,t,n){var r,i,s,o,u;o=e.previewElement.querySelectorAll("[data-dz-uploadprogress]"),u=[];for(i=0,s=o.length;i<s;i++)r=o[i],u.push(r.style.width=""+t+"%");return u},totaluploadprogress:f,sending:f,sendingmultiple:f,success:function(e){return e.previewElement.classList.add("dz-success")},successmultiple:f,canceled:function(e){return this.emit("error",e,"Upload canceled.")},canceledmultiple:f,complete:function(e){if(e._removeLink)return e._removeLink.textContent=this.options.dictRemoveFile},completemultiple:f,maxfilesexceeded:f,maxfilesreached:f,previewTemplate:'<div class="dz-preview dz-file-preview">\n  <div class="dz-details">\n    <div class="dz-filename"><span data-dz-name></span></div>\n    <div class="dz-size" data-dz-size></div>\n    <img data-dz-thumbnail />\n  </div>\n  <div class="dz-progress"><span class="dz-upload" data-dz-uploadprogress></span></div>\n  <div class="dz-success-mark"><span>✔</span></div>\n  <div class="dz-error-mark"><span>✘</span></div>\n  <div class="dz-error-message"><span data-dz-errormessage></span></div>\n</div>'},t=function(){var e,t,n,r,i,s,o;r=arguments[0],n=2<=arguments.length?p.call(arguments,1):[];for(s=0,o=n.length;s<o;s++){t=n[s];for(e in t)i=t[e],r[e]=i}return r},n.prototype.getAcceptedFiles=function(){var e,t,n,r,i;r=this.files,i=[];for(t=0,n=r.length;t<n;t++)e=r[t],e.accepted&&i.push(e);return i},n.prototype.getRejectedFiles=function(){var e,t,n,r,i;r=this.files,i=[];for(t=0,n=r.length;t<n;t++)e=r[t],e.accepted||i.push(e);return i},n.prototype.getQueuedFiles=function(){var e,t,r,i,s;i=this.files,s=[];for(t=0,r=i.length;t<r;t++)e=i[t],e.status===n.QUEUED&&s.push(e);return s},n.prototype.getUploadingFiles=function(){var e,t,r,i,s;i=this.files,s=[];for(t=0,r=i.length;t<r;t++)e=i[t],e.status===n.UPLOADING&&s.push(e);return s},n.prototype.init=function(){var e,t,r,i,s,o,u,a=this;this.element.tagName==="form"&&this.element.setAttribute("enctype","multipart/form-data"),this.element.classList.contains("dropzone")&&!this.element.querySelector(".dz-message")&&this.element.appendChild(n.createElement('<div class="dz-default dz-message"><span>'+this.options.dictDefaultMessage+"</span></div>")),this.clickableElements.length&&(r=function(){return a.hiddenFileInput&&document.body.removeChild(a.hiddenFileInput),a.hiddenFileInput=document.createElement("input"),a.hiddenFileInput.setAttribute("type","file"),(a.options.maxFiles==null||a.options.maxFiles>1)&&a.hiddenFileInput.setAttribute("multiple","multiple"),a.options.acceptedFiles!=null&&a.hiddenFileInput.setAttribute("accept",a.options.acceptedFiles),a.hiddenFileInput.style.visibility="hidden",a.hiddenFileInput.style.position="absolute",a.hiddenFileInput.style.top="0",a.hiddenFileInput.style.left="0",a.hiddenFileInput.style.height="0",a.hiddenFileInput.style.width="0",document.body.appendChild(a.hiddenFileInput),a.hiddenFileInput.addEventListener("change",function(){var e,t,n,i;t=a.hiddenFileInput.files;if(t.length)for(n=0,i=t.length;n<i;n++)e=t[n],a.addFile(e);return r()})},r()),this.URL=(o=window.URL)!=null?o:window.webkitURL,u=this.events;for(i=0,s=u.length;i<s;i++)e=u[i],this.on(e,this.options[e]);return this.on("uploadprogress",function(){return a.updateTotalUploadProgress()}),this.on("removedfile",function(){return a.updateTotalUploadProgress()}),this.on("canceled",function(e){return a.emit("complete",e)}),this.on("complete",function(e){if(a.getUploadingFiles().length===0&&a.getQueuedFiles().length===0)return setTimeout(function(){return a.emit("queuecomplete")},0)}),t=function(e){return e.stopPropagation(),e.preventDefault?e.preventDefault():e.returnValue=!1},this.listeners=[{element:this.element,events:{dragstart:function(e){return a.emit("dragstart",e)},dragenter:function(e){return t(e),a.emit("dragenter",e)},dragover:function(e){var n;try{n=e.dataTransfer.effectAllowed}catch(r){}return e.dataTransfer.dropEffect="move"===n||"linkMove"===n?"move":"copy",t(e),a.emit("dragover",e)},dragleave:function(e){return a.emit("dragleave",e)},drop:function(e){return t(e),a.drop(e)},dragend:function(e){return a.emit("dragend",e)},paste:function(e){return t(e),a.paste(e)}}}],this.clickableElements.forEach(function(e){return a.listeners.push({element:e,events:{click:function(t){if(e!==a.element||t.target===a.element||n.elementInside(t.target,a.element.querySelector(".dz-message")))return a.hiddenFileInput.click()}}})}),this.enable(),this.options.init.call(this)},n.prototype.destroy=function(){var e;this.disable(),this.removeAllFiles(!0);if((e=this.hiddenFileInput)!=null?e.parentNode:void 0)this.hiddenFileInput.parentNode.removeChild(this.hiddenFileInput),this.hiddenFileInput=null;return delete this.element.dropzone,n.instances.splice(n.instances.indexOf(this),1)},n.prototype.updateTotalUploadProgress=function(){var e,t,n,r,i,s,o,u;r=0,n=0,e=this.getAcceptedFiles();if(e.length){u=this.getAcceptedFiles();for(s=0,o=u.length;s<o;s++)t=u[s],r+=t.upload.bytesSent,n+=t.upload.total;i=100*r/n}else i=100;return this.emit("totaluploadprogress",i,n,r)},n.prototype.getFallbackForm=function(){var e,t,r,i;return(e=this.getExistingFallback())?e:(r='<div class="dz-fallback">',this.options.dictFallbackText&&(r+="<p>"+this.options.dictFallbackText+"</p>"),r+='<input type="file" name="'+this.options.paramName+(this.options.uploadMultiple?"[]":"")+'" '+(this.options.uploadMultiple?'multiple="multiple"':void 0)+' /><input type="submit" value="Upload!"></div>',t=n.createElement(r),this.element.tagName!=="FORM"?(i=n.createElement('<form action="'+this.options.url+'" enctype="multipart/form-data" method="'+this.options.method+'"></form>'),i.appendChild(t)):(this.element.setAttribute("enctype","multipart/form-data"),this.element.setAttribute("method",this.options.method)),i!=null?i:t)},n.prototype.getExistingFallback=function(){var e,t,n,r,i,s;t=function(e){var t,n,r;for(n=0,r=e.length;n<r;n++){t=e[n];if(/(^| )fallback($| )/.test(t.className))return t}},s=["div","form"];for(r=0,i=s.length;r<i;r++){n=s[r];if(e=t(this.element.getElementsByTagName(n)))return e}},n.prototype.setupEventListeners=function(){var e,t,n,r,i,s,o;s=this.listeners,o=[];for(r=0,i=s.length;r<i;r++)e=s[r],o.push(function(){var r,i;r=e.events,i=[];for(t in r)n=r[t],i.push(e.element.addEventListener(t,n,!1));return i}());return o},n.prototype.removeEventListeners=function(){var e,t,n,r,i,s,o;s=this.listeners,o=[];for(r=0,i=s.length;r<i;r++)e=s[r],o.push(function(){var r,i;r=e.events,i=[];for(t in r)n=r[t],i.push(e.element.removeEventListener(t,n,!1));return i}());return o},n.prototype.disable=function(){var e,t,n,r,i;this.clickableElements.forEach(function(e){return e.classList.remove("dz-clickable")}),this.removeEventListeners(),r=this.files,i=[];for(t=0,n=r.length;t<n;t++)e=r[t],i.push(this.cancelUpload(e));return i},n.prototype.enable=function(){return this.clickableElements.forEach(function(e){return e.classList.add("dz-clickable")}),this.setupEventListeners()},n.prototype.filesize=function(e){var t;return e>=109951162777.6?(e/=109951162777.6,t="TiB"):e>=107374182.4?(e/=107374182.4,t="GiB"):e>=104857.6?(e/=104857.6,t="MiB"):e>=102.4?(e/=102.4,t="KiB"):(e*=10,t="b"),"<strong>"+Math.round(e)/10+"</strong> "+t},n.prototype._updateMaxFilesReachedClass=function(){return this.options.maxFiles!=null&&this.getAcceptedFiles().length>=this.options.maxFiles?(this.getAcceptedFiles().length===this.options.maxFiles&&this.emit("maxfilesreached",this.files),this.element.classList.add("dz-max-files-reached")):this.element.classList.remove("dz-max-files-reached")},n.prototype.drop=function(e){var t,n;if(!e.dataTransfer)return;this.emit("drop",e),t=e.dataTransfer.files,t.length&&(n=e.dataTransfer.items,n&&n.length&&n[0].webkitGetAsEntry!=null?this._addFilesFromItems(n):this.handleFiles(t))},n.prototype.paste=function(e){var t,n;return},n.prototype.handleFiles=function(e){var t,n,r,i;i=[];for(n=0,r=e.length;n<r;n++)t=e[n],i.push(this.addFile(t));return i},n.prototype._addFilesFromItems=function(e){var t,n,r,i,s;s=[];for(r=0,i=e.length;r<i;r++)n=e[r],n.webkitGetAsEntry!=null&&(t=n.webkitGetAsEntry())?t.isFile?s.push(this.addFile(n.getAsFile())):t.isDirectory?s.push(this._addFilesFromDirectory(t,t.name)):s.push(void 0):n.getAsFile!=null?n.kind==null||n.kind==="file"?s.push(this.addFile(n.getAsFile())):s.push(void 0):s.push(void 0);return s},n.prototype._addFilesFromDirectory=function(e,t){var n,r,i=this;return n=e.createReader(),r=function(e){var n,r,s;for(r=0,s=e.length;r<s;r++)n=e[r],n.isFile?n.file(function(e){if(i.options.ignoreHiddenFiles&&e.name.substring(0,1)===".")return;return e.fullPath=""+t+"/"+e.name,i.addFile(e)}):n.isDirectory&&i._addFilesFromDirectory(n,""+t+"/"+n.name)},n.readEntries(r,function(e){return typeof console!="undefined"&&console!==null?typeof console.log=="function"?console.log(e):void 0:void 0})},n.prototype.accept=function(e,t){return e.size>this.options.maxFilesize*1024*1024?t(this.options.dictFileTooBig.replace("{{filesize}}",Math.round(e.size/1024/10.24)/100).replace("{{maxFilesize}}",this.options.maxFilesize)):n.isValidFile(e,this.options.acceptedFiles)?this.options.maxFiles!=null&&this.getAcceptedFiles().length>=this.options.maxFiles?(t(this.options.dictMaxFilesExceeded.replace("{{maxFiles}}",this.options.maxFiles)),this.emit("maxfilesexceeded",e)):this.options.accept.call(this,e,t):t(this.options.dictInvalidFileType)},n.prototype.addFile=function(e){var t=this;return e.upload={progress:0,total:e.size,bytesSent:0},this.files.push(e),e.status=n.ADDED,this.emit("addedfile",e),this._enqueueThumbnail(e),this.accept(e,function(n){return n?(e.accepted=!1,t._errorProcessing([e],n)):t.enqueueFile(e),t._updateMaxFilesReachedClass()})},n.prototype.enqueueFiles=function(e){var t,n,r;for(n=0,r=e.length;n<r;n++)t=e[n],this.enqueueFile(t);return null},n.prototype.enqueueFile=function(e){var t=this;e.accepted=!0;if(e.status!==n.ADDED)throw new Error("This file can't be queued because it has already been processed or was rejected.");e.status=n.QUEUED;if(this.options.autoProcessQueue)return setTimeout(function(){return t.processQueue()},0)},n.prototype._thumbnailQueue=[],n.prototype._processingThumbnail=!1,n.prototype._enqueueThumbnail=function(e){var t=this;if(this.options.createImageThumbnails&&e.type.match(/image.*/)&&e.size<=this.options.maxThumbnailFilesize*1024*1024)return this._thumbnailQueue.push(e),setTimeout(function(){return t._processThumbnailQueue()},0)},n.prototype._processThumbnailQueue=function(){var e=this;if(this._processingThumbnail||this._thumbnailQueue.length===0)return;return this._processingThumbnail=!0,this.createThumbnail(this._thumbnailQueue.shift(),function(){return e._processingThumbnail=!1,e._processThumbnailQueue()})},n.prototype.removeFile=function(e){e.status===n.UPLOADING&&this.cancelUpload(e),this.files=l(this.files,e),this.emit("removedfile",e);if(this.files.length===0)return this.emit("reset")},n.prototype.removeAllFiles=function(e){var t,r,i,s;e==null&&(e=!1),s=this.files.slice();for(r=0,i=s.length;r<i;r++)t=s[r],(t.status!==n.UPLOADING||e)&&this.removeFile(t);return null},n.prototype.createThumbnail=function(e,t){var n,r=this;return n=new FileReader,n.onload=function(){var i;return i=document.createElement("img"),i.onload=function(){var n,s,o,u,f,l,c,h;e.width=i.width,e.height=i.height,o=r.options.resize.call(r,e),o.trgWidth==null&&(o.trgWidth=r.options.thumbnailWidth),o.trgHeight==null&&(o.trgHeight=r.options.thumbnailHeight),n=document.createElement("canvas"),s=n.getContext("2d"),n.width=o.trgWidth,n.height=o.trgHeight,a(s,i,(f=o.srcX)!=null?f:0,(l=o.srcY)!=null?l:0,o.srcWidth,o.srcHeight,(c=o.trgX)!=null?c:0,(h=o.trgY)!=null?h:0,o.trgWidth,o.trgHeight),u=n.toDataURL("image/png"),r.emit("thumbnail",e,u);if(t!=null)return t()},i.src=n.result},n.readAsDataURL(e)},n.prototype.processQueue=function(){var e,t,n,r;t=this.options.parallelUploads,n=this.getUploadingFiles().length,e=n;if(n>=t)return;r=this.getQueuedFiles();if(!(r.length>0))return;if(this.options.uploadMultiple)return this.processFiles(r.slice(0,t-n));while(e<t){if(!r.length)return;this.processFile(r.shift()),e++}},n.prototype.processFile=function(e){return this.processFiles([e])},n.prototype.processFiles=function(e){var t,r,i;for(r=0,i=e.length;r<i;r++)t=e[r],t.processing=!0,t.status=n.UPLOADING,this.emit("processing",t);return this.options.uploadMultiple&&this.emit("processingmultiple",e),this.uploadFiles(e)},n.prototype._getFilesWithXhr=function(e){var t,n;return n=function(){var n,r,i,s;i=this.files,s=[];for(n=0,r=i.length;n<r;n++)t=i[n],t.xhr===e&&s.push(t);return s}.call(this)},n.prototype.cancelUpload=function(e){var t,r,i,s,o,u,a;if(e.status===n.UPLOADING){r=this._getFilesWithXhr(e.xhr);for(i=0,o=r.length;i<o;i++)t=r[i],t.status=n.CANCELED;e.xhr.abort();for(s=0,u=r.length;s<u;s++)t=r[s],this.emit("canceled",t);this.options.uploadMultiple&&this.emit("canceledmultiple",r)}else if((a=e.status)===n.ADDED||a===n.QUEUED)e.status=n.CANCELED,this.emit("canceled",e),this.options.uploadMultiple&&this.emit("canceledmultiple",[e]);if(this.options.autoProcessQueue)return this.processQueue()},n.prototype.uploadFile=function(e){return this.uploadFiles([e])},n.prototype.uploadFiles=function(e){var r,i,s,o,u,a,f,l,c,h,p,d,v,m,g,y,b,w,E,S,x,T,N,C,k,L,A,O,M,_,D,P=this;y=new XMLHttpRequest;for(b=0,x=e.length;b<x;b++)r=e[b],r.xhr=y;y.open(this.options.method,this.options.url,!0),y.withCredentials=!!this.options.withCredentials,v=null,s=function(){var t,n,i;i=[];for(t=0,n=e.length;t<n;t++)r=e[t],i.push(P._errorProcessing(e,v||P.options.dictResponseError.replace("{{statusCode}}",y.status),y));return i},m=function(t){var n,i,s,o,u,a,f,l,c;if(t!=null){i=100*t.loaded/t.total;for(s=0,a=e.length;s<a;s++)r=e[s],r.upload={progress:i,total:t.total,bytesSent:t.loaded}}else{n=!0,i=100;for(o=0,f=e.length;o<f;o++){r=e[o];if(r.upload.progress!==100||r.upload.bytesSent!==r.upload.total)n=!1;r.upload.progress=i,r.upload.bytesSent=r.upload.total}if(n)return}c=[];for(u=0,l=e.length;u<l;u++)r=e[u],c.push(P.emit("uploadprogress",r,i,r.upload.bytesSent));return c},y.onload=function(t){var r;if(e[0].status===n.CANCELED)return;if(y.readyState!==4)return;v=y.responseText;if(y.getResponseHeader("content-type")&&~y.getResponseHeader("content-type").indexOf("application/json"))try{v=JSON.parse(v)}catch(i){t=i,v="Invalid JSON response from server."}return m(),200<=(r=y.status)&&r<300?P._finished(e,v,t):s()},y.onerror=function(){if(e[0].status===n.CANCELED)return;return s()},d=(A=y.upload)!=null?A:y,d.onprogress=m,a={Accept:"application/json","Cache-Control":"no-cache","X-Requested-With":"XMLHttpRequest"},this.options.headers&&t(a,this.options.headers);for(o in a)u=a[o],y.setRequestHeader(o,u);i=new FormData;if(this.options.params){O=this.options.params;for(h in O)g=O[h],i.append(h,g)}for(w=0,T=e.length;w<T;w++)r=e[w],this.emit("sending",r,y,i);this.options.uploadMultiple&&this.emit("sendingmultiple",e,y,i);if(this.element.tagName==="FORM"){M=this.element.querySelectorAll("input, textarea, select, button");for(E=0,N=M.length;E<N;E++){f=M[E],l=f.getAttribute("name"),c=f.getAttribute("type");if(f.tagName==="SELECT"&&f.hasAttribute("multiple")){_=f.options;for(S=0,C=_.length;S<C;S++)p=_[S],p.selected&&i.append(l,p.value)}else(!c||(D=c.toLowerCase())!=="checkbox"&&D!=="radio"||f.checked)&&i.append(l,f.value)}}for(L=0,k=e.length;L<k;L++)r=e[L],i.append(""+this.options.paramName+(this.options.uploadMultiple?"[]":""),r,r.name);return y.send(i)},n.prototype._finished=function(e,t,r){var i,s,o;for(s=0,o=e.length;s<o;s++)i=e[s],i.status=n.SUCCESS,this.emit("success",i,t,r),this.emit("complete",i);this.options.uploadMultiple&&(this.emit("successmultiple",e,t,r),this.emit("completemultiple",e));if(this.options.autoProcessQueue)return this.processQueue()},n.prototype._errorProcessing=function(e,t,r){var i,s,o;for(s=0,o=e.length;s<o;s++)i=e[s],i.status=n.ERROR,this.emit("error",i,t,r),this.emit("complete",i);this.options.uploadMultiple&&(this.emit("errormultiple",e,t,r),this.emit("completemultiple",e));if(this.options.autoProcessQueue)return this.processQueue()},n}(i),r.version="3.8.3",r.options={},r.optionsForElement=function(e){return e.getAttribute("id")?r.options[s(e.getAttribute("id"))]:void 0},r.instances=[],r.forElement=function(e){typeof e=="string"&&(e=document.querySelector(e));if((e!=null?e.dropzone:void 0)==null)throw new Error("No Dropzone found for given element. This is probably because you're trying to access it before Dropzone had the time to initialize. Use the `init` option to setup any additional observers on your Dropzone.");return e.dropzone},r.autoDiscover=!0,r.discover=function(){var e,t,n,i,s,o;document.querySelectorAll?n=document.querySelectorAll(".dropzone"):(n=[],e=function(e){var t,r,i,s;s=[];for(r=0,i=e.length;r<i;r++)t=e[r],/(^| )dropzone($| )/.test(t.className)?s.push(n.push(t)):s.push(void 0);return s},e(document.getElementsByTagName("div")),e(document.getElementsByTagName("form"))),o=[];for(i=0,s=n.length;i<s;i++)t=n[i],r.optionsForElement(t)!==!1?o.push(new r(t)):o.push(void 0);return o},r.blacklistedBrowsers=[/opera.*Macintosh.*version\/12/i],r.isBrowserSupported=function(){var e,t,n,i,s;e=!0;if(window.File&&window.FileReader&&window.FileList&&window.Blob&&window.FormData&&document.querySelector)if("classList"in document.createElement("a")){s=r.blacklistedBrowsers;for(n=0,i=s.length;n<i;n++){t=s[n];if(t.test(navigator.userAgent)){e=!1;continue}}}else e=!1;else e=!1;return e},l=function(e,t){var n,r,i,s;s=[];for(r=0,i=e.length;r<i;r++)n=e[r],n!==t&&s.push(n);return s},s=function(e){return e.replace(/[\-_](\w)/g,function(e){return e[1].toUpperCase()})},r.createElement=function(e){var t;return t=document.createElement("div"),t.innerHTML=e,t.childNodes[0]},r.elementInside=function(e,t){if(e===t)return!0;while(e=e.parentNode)if(e===t)return!0;return!1},r.getElement=function(e,t){var n;typeof e=="string"?n=document.querySelector(e):e.nodeType!=null&&(n=e);if(n==null)throw new Error("Invalid `"+t+"` option provided. Please provide a CSS selector or a plain HTML element.");return n},r.getElements=function(e,t){var n,r,i,s,o,u,a,f;if(e instanceof Array){i=[];try{for(s=0,u=e.length;s<u;s++)r=e[s],i.push(this.getElement(r,t))}catch(l){n=l,i=null}}else if(typeof e=="string"){i=[],f=document.querySelectorAll(e);for(o=0,a=f.length;o<a;o++)r=f[o],i.push(r)}else e.nodeType!=null&&(i=[e]);if(i==null||!i.length)throw new Error("Invalid `"+t+"` option provided. Please provide a CSS selector, a plain HTML element or a list of those.");return i},r.confirm=function(e,t,n){if(window.confirm(e))return t();if(n!=null)return n()},r.isValidFile=function(e,t){var n,r,i,s,o;if(!t)return!0;t=t.split(","),r=e.type,n=r.replace(/\/.*$/,"");for(s=0,o=t.length;s<o;s++){i=t[s],i=i.trim();if(i.charAt(0)==="."){if(e.name.toLowerCase().indexOf(i.toLowerCase(),e.name.length-i.length)!==-1)return!0}else if(/\/\*$/.test(i)){if(n===i.replace(/\/.*$/,""))return!0}else if(r===i)return!0}return!1},typeof e!="undefined"&&e!==null&&(e.fn.dropzone=function(e){return this.each(function(){return new r(this,e)})}),typeof t!="undefined"&&t!==null?t.exports=r:window.Dropzone=r,r.ADDED="added",r.QUEUED="queued",r.ACCEPTED=r.QUEUED,r.UPLOADING="uploading",r.PROCESSING=r.UPLOADING,r.CANCELED="canceled",r.ERROR="error",r.SUCCESS="success",u=function(e){var t,n,r,i,s,o,u,a,f,l;u=e.naturalWidth,o=e.naturalHeight,n=document.createElement("canvas"),n.width=1,n.height=o,r=n.getContext("2d"),r.drawImage(e,0,0),i=r.getImageData(0,0,1,o).data,l=0,s=o,a=o;while(a>l)t=i[(a-1)*4+3],t===0?s=a:l=a,a=s+l>>1;return f=a/o,f===0?1:f},a=function(e,t,n,r,i,s,o,a,f,l){var c;return c=u(t),e.drawImage(t,n,r,i,s,o,a,f,l/c)},o=function(e,t){var n,r,i,s,o,u,a,f,l;i=!1,l=!0,r=e.document,f=r.documentElement,n=r.addEventListener?"addEventListener":"attachEvent",a=r.addEventListener?"removeEventListener":"detachEvent",u=r.addEventListener?"":"on",s=function(n){if(n.type==="readystatechange"&&r.readyState!=="complete")return;(n.type==="load"?e:r)[a](u+n.type,s,!1);if(!i&&(i=!0))return t.call(e,n.type||n)},o=function(){var e;try{f.doScroll("left")}catch(t){e=t,setTimeout(o,50);return}return s("poll")};if(r.readyState!=="complete"){if(r.createEventObject&&f.doScroll){try{l=!e.frameElement}catch(c){}l&&o()}return r[n](u+"DOMContentLoaded",s,!1),r[n](u+"readystatechange",s,!1),e[n](u+"load",s,!1)}},r._autoDiscoverFunction=function(){if(r.autoDiscover)return r.discover()},o(window,r._autoDiscoverFunction)}.call(this),t.exports}),define("mockup-patterns-dropzone",["jquery","mockup-patterns-base","dropzone","underscore"],function(e,t,n,r){n.autoDiscover=!1;var i=t.extend({name:"dropzone",defaults:{url:null,className:"dropzone",paramName:"file",uploadMultiple:!1,clickable:!1,wrap:!1,addRemoveLinks:!1,wrapperTemplate:'<div class="dropzone-container"/>',autoCleanResults:!1,previewsContainer:".dropzone-previews",previewsTemplate:'<div class="dropzone-previews"></div>',fileaddedClassName:"dropping",useTus:!1,maxFilesize:99999999},init:function(){function c(){l=!0;if(t.dropzone.files.length===0){l=!1,t.$dropzone.removeClass(o);return}var r=t.dropzone.files[0],i=e(r.previewElement);if([n.SUCCESS,n.ERROR,n.CANCELED].indexOf(r.status)!==-1)t.dropzone.removeFile(r),c();else if(r.status!==n.UPLOADING){if(u&&window.tus){var s=i.find("[data-dz-uploadprogress]");r.status=n.UPLOADING,window.tus.upload(r,{endpoint:t.options.url,headers:{FILENAME:r.name},chunkSize:5242880}).fail(function(){alert("Error uploading with TUS resumable uploads"),r.status=n.ERROR}).progress(function(e,n,r){var o=n/r*100;s.css("width",o+"%"),s.parent().css("display","block");var u=i.find(".dz-size");u.html("uploading...<br />"+t.formatBytes(n)+" / "+t.formatBytes(r))}).done(function(e,r){r.status=n.SUCCESS,t.dropzone.emit("success",r),t.dropzone.emit("complete",r)})}else t.dropzone.processFile(r);setTimeout(c,100)}else setTimeout(c,100)}var t=this;typeof t.options.clickable=="string"&&(t.options.clickable==="true"?t.options.clickable=!0:t.options.clickable=!1);if(!t.options.url&&t.$el[0].tagName==="FORM"){var r=t.$el.attr("action");r||(r=window.location.href),t.options.url=r}var i=t.$el;t.options.wrap&&(t.options.wrap==="inner"?(i.wrapInner(t.options.wrapperTemplate),i=i.children().eq(0)):(i.wrap(t.options.wrapperTemplate),i=i.parent())),i.append('<div class="dz-notice"><p>Drop files here...</p></div>'),t.options.previewsContainer===".dropzone-previews"&&i.append(t.options.previewsTemplate);var s=t.options.autoCleanResults;i.addClass(t.options.className);var o=t.options.fileaddedClassName,u=t.options.useTus,a=e.extend({},t.options);delete a.wrap,delete a.wrapperTemplate,delete a.resultTemplate,delete a.autoCleanResults,delete a.previewsTemplate,delete a.fileaddedClassName,delete a.useTus;if(t.options.previewsContainer){var f=i.find(t.options.previewsContainer);f.length>0&&(a.previewsContainer=f[0])}a.autoProcessQueue=!1,t.dropzone=new n(i[0],a),t.$dropzone=i,s&&t.dropzone.on("complete",function(t){setTimeout(function(){e(t.previewElement).fadeOut()},3e3)});var l=!1;t.dropzone.on("addedfile",function(){t.$dropzone.addClass(o),setTimeout(function(){l||c()},100)})},formatBytes:function(e){var t=Math.round(e/1024);if(t<1024)return t+" KiB";var n=Math.round(t/1024);return n<1024?n+" MB":Math.round(n/1024)+" GB"}});return i}),function(e){typeof define=="function"&&define.amd?define("jquery.cookie",["jquery"],e):e(jQuery)}(function(e){function n(e){return u.raw?e:encodeURIComponent(e)}function r(e){return u.raw?e:decodeURIComponent(e)}function i(e){return n(u.json?JSON.stringify(e):String(e))}function s(e){e.indexOf('"')===0&&(e=e.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,"\\"));try{e=decodeURIComponent(e.replace(t," "))}catch(n){return}try{return u.json?JSON.parse(e):e}catch(n){}}function o(t,n){var r=u.raw?t:s(t);return e.isFunction(n)?n(r):r}var t=/\+/g,u=e.cookie=function(t,s,a){if(s!==undefined&&!e.isFunction(s)){a=e.extend({},u.defaults,a);if(typeof a.expires=="number"){var f=a.expires,l=a.expires=new Date;l.setDate(l.getDate()+f)}return document.cookie=[n(t),"=",i(s),a.expires?"; expires="+a.expires.toUTCString():"",a.path?"; path="+a.path:"",a.domain?"; domain="+a.domain:"",a.secure?"; secure":""].join("")}var c=t?undefined:{},h=document.cookie?document.cookie.split("; "):[];for(var p=0,d=h.length;p<d;p++){var v=h[p].split("="),m=r(v.shift()),g=v.join("=");if(t&&t===m){c=o(g,s);break}!t&&(g=o(g))!==undefined&&(c[m]=g)}return c};u.defaults={},e.removeCookie=function(t,n){return e.cookie(t)!==undefined?(e.cookie(t,"",e.extend({},n,{expires:-1})),!0):!1}}),define("js/patterns/structure/views/app",["jquery","underscore","backbone","js/ui/views/toolbar","js/ui/views/buttongroup","js/ui/views/button","js/ui/views/base","js/patterns/structure/views/table","js/patterns/structure/views/selectionwell","js/patterns/structure/views/tags","js/patterns/structure/views/properties","js/patterns/structure/views/workflow","js/patterns/structure/views/delete","js/patterns/structure/views/rename","js/patterns/structure/views/rearrange","js/patterns/structure/views/selectionbutton","js/patterns/structure/views/paging","js/patterns/structure/views/addmenu","js/patterns/structure/views/columns","js/patterns/structure/views/textfilter","js/patterns/structure/collections/result","js/patterns/structure/collections/selected","mockup-patterns-dropzone","mockup-utils","jquery.cookie"],function(e,t,n,r,i,s,o,u,a,f,l,c,h,p,d,v,m,g,y,b,w,E,S,x){var T="DISABLE",N=o.extend({tagName:"div",buttonClickEvents:{cut:"cutCopyClickEvent",copy:"cutCopyClickEvent",paste:"pasteEvent",tags:T,properties:T,workflow:T,"delete":T,rename:T,rearrange:T},buttonViewMapping:{"secondary.tags":f,"secondary.properties":l,"secondary.workflow":c,"primary.delete":h,"secondary.rename":p},status:"",statusType:"warning",pasteOperation:null,sort_on:"getObjPositionInParent",sort_order:"ascending",additionalCriterias:[],pasteSelection:null,cookieSettingPrefix:"_fc_",initialize:function(n){var r=this;o.prototype.initialize.apply(r,[n]),r.setAllCookieSettings(),r.loading=new x.ProgressIndicator({container:r.$el}),r.loading.show(),r.collection=new w([],{url:r.options.collectionUrl,queryParser:function(){var e=null;r.toolbar&&(e=r.toolbar.get("filter").term);var t=r.sort_on;return t||(t="getObjPositionInParent"),JSON.stringify({criteria:r.queryHelper.getCriterias(e,{additionalCriterias:r.additionalCriterias}),sort_on:t,sort_order:r.sort_order})},queryHelper:r.options.queryHelper}),r.queryHelper=r.options.queryHelper,r.selectedCollection=new E,r.tableView=new u({app:r}),r.pagingView=new m({app:r}),r.pasteAllowed=r.options.pasteAllowed,r.setupButtons(),r.wellView=new a({collection:r.selectedCollection,triggerView:r.toolbar.get("selected"),app:r}),r.buttonViews={},t.map(r.buttonViewMapping,function(e,t,n){var i=t.split("."),s=i[0],o=i[1];r.buttonViews[t]=new e({triggerView:r.buttons[s].get(o),app:r})}),r.toolbar.get("selected").disable(),r.buttons.primary.disable(),r.buttons.secondary.disable(),r.selectedCollection.on("add remove reset",function(e,t){t.length?(r.toolbar.get("selected").enable(),r.buttons.primary.enable(),r.buttons.secondary.enable(),r.pasteAllowed||r.buttons.primary.get("paste").disable()):(this.toolbar.get("selected").disable(),r.buttons.primary.disable(),r.buttons.secondary.disable())},r),r.collection.on("sync",function(){if(r.selectedCollection.models.length>0){var n=[];r.selectedCollection.each(function(e){n.push(e.attributes.UID)}),r.queryHelper.search("UID","plone.app.querystring.operation.list.contains",n,function(e){t.each(e.results,function(e){var t=r.selectedCollection.getByUID(e.UID);t.attributes=e})},!1)}r.contextInfoUrl&&e.ajax({url:r.getAjaxUrl(r.contextInfoUrl),dataType:"json",success:function(e){r.trigger("context-info-loaded",e)},error:function(e){e.status===404&&console.log("context info url not found")}}),r.loading.hide()}),r.collection.on("pager",function(){r.loading.show()}),e(document).bind("keyup keydown",function(e){r.keyEvent=e})},inQueryMode:function(){return this.additionalCriterias.length>0?!0:this.sort_on&&this.sort_on!=="getObjPositionInParent"?!0:this.sort_order!=="ascending"?!0:!1},getSelectedUids:function(e){var t=this;e===undefined&&(e=t.selectedCollection);var n=[];return e.each(function(e){n.push(e.uid())}),n},getAjaxUrl:function(e){return e.replace("{path}",this.options.queryHelper.getCurrentPath())},defaultButtonClickEvent:function(t){var n=this,r=null,i=null;if(t.url){n.loading.show();if(arguments.length>1){var s=arguments[1];s.preventDefault||(r=s)}if(arguments.length>2){var o=arguments[2];typeof o=="function"&&(i=o)}r===null&&(r={}),r.selection===undefined&&(r.selection=JSON.stringify(n.getSelectedUids())),r._authenticator=e('input[name="_authenticator"]').val(),r.folder===undefined&&(r.folder=n.options.queryHelper.getCurrentPath());var u=n.getAjaxUrl(t.url);e.ajax({url:u,type:"POST",data:r,success:function(e){n.ajaxSuccessResponse.apply(n,[e,i]),n.loading.hide()},error:function(e){n.ajaxErrorResponse.apply(n,[e,u]),n.loading.hide()}},n)}},ajaxSuccessResponse:function(e,t){var n=this;e.status==="success"&&n.collection.reset(),e.msg&&n.setStatus(e.msg),t!==null&&t!==undefined&&t(e),n.collection.pager()},ajaxErrorResponse:function(e,t){var n=this;e.status===404?window.alert('operation url "'+t+'" is not valid'):window.alert("there was an error performing action")},pasteEvent:function(t,n,r){var i=this;r===undefined&&(r={}),r=e.extend(!0,{},{selection:JSON.stringify(i.getSelectedUids(i.pasteSelection)),pasteOperation:i.pasteOperation},r),i.defaultButtonClickEvent(t,r)},cutCopyClickEvent:function(e){var t=this,r;e.id==="cut"?(r="cut ",t.pasteOperation="cut"):(r="copied ",t.pasteOperation="copy"),t.pasteSelection=new n.Collection,t.selectedCollection.each(function(e){t.pasteSelection.add(e)}),r+="selection",t.setStatus(r),t.pasteAllowed=!0,t.buttons.primary.get("paste").enable()},setupButtons:function(){var e=this;e.buttons={};var n=[],o=new s({id:"columns",tooltip:"Configure displayed columns",icon:"align-justify"});e.columnsView=new y({app:e,triggerView:o}),n.push(o),n.push(new v({title:"Selected",id:"selected",collection:this.selectedCollection})),e.options.contextInfoUrl&&n.push(new g({contextInfoUrl:e.options.contextInfoUrl,app:e}));if(e.options.rearrange){var u=new s({id:"rearrange",title:"Rearrange",tooltip:"Rearrange folder contents",url:e.options.rearrange.url});e.rearrangeView=new d({triggerView:u,app:e}),n.push(u)}t.each(t.pairs(this.options.buttonGroups),function(r){var o=[];t.each(r[1],function(t){t=new s(t),o.push(t);var n=e.buttonClickEvents[t.id];n!==T&&(n===undefined&&(n="defaultButtonClickEvent"),t.on("button:click",e[n],e))}),e.buttons[r[0]]=new i({items:o,id:r[0],app:e}),n.push(e.buttons[r[0]])});if(e.options.uploadUrl){var a=new s({title:"Upload",context:"success",icon:"upload"});n.push(a),a.on("button:click",function(){e.dropzone.options.url=e.getAjaxUrl(e.options.uploadUrl),e.dropzone.hiddenFileInput.click()})}n.push(new b({id:"filter",app:this})),this.toolbar=new r({items:n})},moveItem:function(t,n,r){var i=this;e.ajax({url:this.getAjaxUrl(this.options.moveUrl),type:"POST",data:{delta:n,id:t,_authenticator:e('[name="_authenticator"]').val(),subsetIds:JSON.stringify(r)},dataType:"json",success:function(e){e.msg?i.setStatus(e.msg):e.status!=="success"&&i.setStatus("error moving item"),i.collection.pager()},error:function(e){i.setStatus("error moving item")}})},setStatus:function(e,t){this.status=e,t===undefined&&(t="warning"),this.statusType=t,this.$(".status").addClass(t).html(e)},render:function(){var n=this;return n.$el.append(n.toolbar.render().el),n.$el.append(n.wellView.render().el),n.$el.append(n.columnsView.render().el),n.rearrangeView&&n.$el.append(n.rearrangeView.render().el),t.each(n.buttonViews,function(e){n.$el.append(e.render().el)}),n.$el.append(n.tableView.render().el),n.$el.append(n.pagingView.render().el),n.options.uploadUrl&&(n.dropzone=(new S(n.$el,{className:"structure-dropzone",clickable:e("<div/>")[0],url:n.getAjaxUrl(n.options.uploadUrl),autoCleanResults:!0,useTus:n.options.useTus,success:function(){n.collection.pager()}})).dropzone,n.dropzone.on("drop",function(){n.dropzone.options.url=n.getAjaxUrl(n.options.uploadUrl)}),e(n.dropzone.hiddenFileInput).attr("multiple","true")),n.options.backdropSelector!==null?e(n.options.backdropSelector).addClass("ui-backdrop-element"):n.$el.addClass("ui-backdrop-element"),n},getCookieSetting:function(t,n){n===undefined&&(n=null);var r;try{r=e.cookie(this.cookieSettingPrefix+t),r=e.parseJSON(r).value}catch(i){return n}return r===undefined||r===null?n:r},setCookieSetting:function(t,n){e.cookie(this.cookieSettingPrefix+t,JSON.stringify({value:n}))},setAllCookieSettings:function(){this.activeColumns=this.getCookieSetting("activeColumns",this.activeColumns)}});return N}),define("mockup-patterns-structure",["jquery","mockup-patterns-base","mockup-utils","js/patterns/structure/views/app","text!js/patterns/structure/templates/paging.xml","text!js/patterns/structure/templates/selection_button.xml","text!js/patterns/structure/templates/selection_item.xml","text!js/patterns/structure/templates/tablerow.xml","text!js/patterns/structure/templates/table.xml","text!js/ui/templates/popover.xml"],function(e,t,n,r){var i=t.extend({name:"structure",defaults:{vocabularyUrl:null,tagsVocabularyUrl:null,usersVocabularyUrl:null,indexOptionsUrl:null,contextInfoUrl:null,setDefaultPageUrl:null,backdropSelector:".modal",attributes:["UID","Title","Type","path","review_state","ModificationDate","EffectiveDate","CreationDate","is_folderish","Subject","getURL","id","exclude_from_nav","getObjSize","last_comment_date","total_comments"],activeColumns:["ModificationDate","EffectiveDate","review_state"],availableColumns:{ModificationDate:"Last modified",EffectiveDate:"Published",CreationDate:"Created",review_state:"Review state",Subject:"Tags",Type:"Type",is_folderish:"Folder",exclude_from_nav:"Excluded from nav",getObjSize:"Object Size",last_comment_date:"Last comment date",total_comments:"Total comments"},rearrange:{properties:{id:"ID",sortable_title:"Title",modified:"Last Modified",created:"Created on",effective:"Publication Date",Type:"Type"},url:"/rearrange"},basePath:"/",uploadUrl:null,moveUrl:null,buttonGroups:{primary:[{title:"Cut",url:"/cut"},{title:"Copy",url:"/copy"},{title:"Paste",url:"/paste"},{title:"Delete",url:"/delete",context:"danger",icon:"trash"}],secondary:[{title:"Workflow",url:"/workflow"},{title:"Tags",url:"/tags"},{title:"Properties",url:"/properties"},{title:"Rename",url:"/rename"}]},useTus:!1},init:function(){var t=this;t.browsing=!0,t.options.collectionUrl=t.options.vocabularyUrl,t.options.queryHelper=new n.QueryHelper(e.extend(!0,{},t.options,{pattern:t})),delete t.options.attributes,t.view=new r(t.options),t.$el.append(t.view.render().$el)}});return i}),window.jQuery&&define("jquery",[],function(){return window.jQuery}),define("mockup-bundles-structure",["jquery","mockup-registry","mockup-patterns-base","mockup-patterns-modal","mockup-patterns-structure"],function(e,t,n,r,i){return e(document).ready(function(){var t=e(".pat-structure");if(t.length===1){var n=t.parents("#content");n.length===0&&(n=t.parent().parent());var r=n.patternModal({position:"middle top",width:"95%",title:"Folder Contents",backdropOptions:{closeOnEsc:!1,closeOnClick:!1}}),i=r.data("pattern-modal");i.show(),i.$modal.find("a.close").on("destroy.modal.patterns",function(){var t=e("base"),n;t.length===0?n=window.location.href.replace("@@folder_contents","").replace("folder_contents",""):n=t.attr("href"),window.location=n})}}),{}}),require(["mockup-bundles-structure"]);
