# Copyright 2010 Boris Figovsky <borfig@gmail.com>
#
# This file is part of pybfc.

# pybfc is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# pybfc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with pybfc.  If not, see <http://www.gnu.org/licenses/>.

class Environment(object):
    """
    An environment instance is used to describe the environment of running
    dependencies in the graph.
    
    """
    __slots__ = ['keep_on_error',
                 ]
    def __init__(self,
                 keep_on_error = False,
                 ):
        """
        keep_on_error - continue running where possible
        """
        self.keep_on_error = keep_on_error

    def on_dfs_start(self, dep): # pragma: no cover
        """
        Called before running a dependency in DFS mode.
        """
        pass

    def on_dfs_end(self, dep): # pragma: no cover
        """
        Called after running a dependencies in DFS mode.
        """
        pass

    def on_threaded_start(self, dep): # pragma: no cover
        """
        Called before running a dependencies in threaded/processed mode.
        """
        pass

    def on_threaded_done(self, dep, success, result): # pragma: no cover
        """
        Called after running a dependencies in threaded/processed mode.
        """
        pass
