# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2015-12-26 03:46
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import filebrowser.fields
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('slug', models.CharField(blank=True, max_length=60, null=True, verbose_name='Slug')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('image', models.ImageField(blank=True, null=True, upload_to='H:\\GITHUB\\virtenviro\\..\\media\\img\\shop\\category', verbose_name='Image')),
                ('ordering', models.IntegerField(blank=True, default=0, null=True, verbose_name='Ordering')),
                ('view_count', models.IntegerField(blank=True, default=0, null=True, verbose_name='Count of views')),
                ('meta_title', models.CharField(blank=True, max_length=250, null=True, verbose_name='Meta Title')),
                ('meta_keywords', models.TextField(blank=True, null=True, verbose_name='Meta Keywords')),
                ('meta_description', models.TextField(blank=True, null=True, verbose_name='Meta Description')),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='subcategories', to='shop.Category', verbose_name='Parent')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
            },
            managers=[
                ('_default_manager', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Currency',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='Currency')),
                ('default', models.BooleanField(default=False, verbose_name='Is default currency')),
                ('symbol', models.CharField(blank=True, max_length=10, null=True, verbose_name='Symbol')),
                ('char_code', models.CharField(blank=True, max_length=10, null=True, verbose_name='Char code of currency')),
                ('num_code', models.IntegerField(blank=True, null=True, verbose_name='Code of currency')),
                ('nominal', models.FloatField(blank=True, null=True, verbose_name='Nominal')),
                ('value', models.FloatField(blank=True, null=True, verbose_name='Value')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'Currency',
                'verbose_name_plural': 'Currencies',
            },
        ),
        migrations.CreateModel(
            name='File',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', filebrowser.fields.FileBrowseField(blank=True, max_length=200, null=True, verbose_name=b'File')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Name')),
            ],
        ),
        migrations.CreateModel(
            name='Image',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', filebrowser.fields.FileBrowseField(blank=True, max_length=200, null=True, verbose_name=b'Image')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Name')),
                ('is_main', models.BooleanField(default=False, verbose_name='Is Main')),
            ],
            options={
                'ordering': ['image_type', 'name'],
                'verbose_name': 'Image',
                'verbose_name_plural': 'Images',
            },
        ),
        migrations.CreateModel(
            name='ImageType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'Images Type',
                'verbose_name_plural': 'Images Types',
            },
        ),
        migrations.CreateModel(
            name='ImageTypeCategoryRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('max_count', models.IntegerField(default=1, help_text='Maximum number of images by this image type in category', verbose_name='Count')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.Category', verbose_name='Category')),
                ('image_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.ImageType', verbose_name='Image type')),
            ],
        ),
        migrations.CreateModel(
            name='Manufacturer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='Manufacturer')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('slug', models.CharField(blank=True, max_length=60, null=True, verbose_name='Slug')),
                ('logo', models.ImageField(blank=True, null=True, upload_to=b'H:\\GITHUB\\virtenviro\\..\\media\\img\\shop\\manufacturers', verbose_name='Logo')),
                ('country', models.CharField(blank=True, max_length=150, null=True, verbose_name='Country')),
                ('city', models.CharField(blank=True, max_length=150, null=True, verbose_name='City')),
                ('address', models.CharField(blank=True, max_length=255, null=True, verbose_name='Address')),
                ('phones', models.TextField(blank=True, null=True, verbose_name='Phones')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'Manufacturer',
                'verbose_name_plural': 'Manufacturers',
            },
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('modified_time', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['-created_time'],
                'verbose_name': 'Order',
                'verbose_name_plural': 'Orders',
            },
        ),
        migrations.CreateModel(
            name='OrderStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, verbose_name='Name')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'Order status',
                'verbose_name_plural': 'Order statuses',
            },
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('slug', models.CharField(blank=True, max_length=60, null=True, verbose_name='Slug')),
                ('articul', models.CharField(blank=True, max_length=200, null=True, verbose_name='Articul')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('price', models.FloatField(default=0.0, verbose_name='Price')),
                ('discount', models.FloatField(default=0, verbose_name='Discount')),
                ('ordering', models.IntegerField(blank=True, default=0, null=True, verbose_name='Ordering')),
                ('view_count', models.IntegerField(blank=True, default=0, null=True, verbose_name='Count of views')),
                ('meta_title', models.CharField(blank=True, max_length=250, null=True, verbose_name='Meta Title')),
                ('meta_keywords', models.TextField(blank=True, null=True, verbose_name='Meta Keywords')),
                ('meta_description', models.TextField(blank=True, null=True, verbose_name='Meta Description')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='shop.Category', verbose_name='Category')),
                ('manufacturer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='shop.Manufacturer', verbose_name='Manufacturer')),
                ('subcategory', models.ManyToManyField(blank=True, related_name='products', to='shop.Category', verbose_name='Subcategory')),
            ],
            options={
                'ordering': ['ordering', 'name'],
                'verbose_name': 'Product',
                'verbose_name_plural': 'Products',
            },
        ),
        migrations.CreateModel(
            name='ProductOrderRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('count', models.IntegerField(default=1, verbose_name='Count')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.Order', verbose_name='Order')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.Product', verbose_name='Product')),
            ],
        ),
        migrations.CreateModel(
            name='Property',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.TextField(verbose_name='Value')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.Product', verbose_name='Product')),
            ],
            options={
                'ordering': ['property_type__name', 'value'],
                'verbose_name': 'Property',
                'verbose_name_plural': 'Properties',
            },
        ),
        migrations.CreateModel(
            name='PropertySlug',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.TextField(verbose_name='Value')),
                ('slug', models.CharField(max_length=60, verbose_name='Slug')),
            ],
            options={
                'ordering': ['value'],
                'verbose_name': 'Property slug',
                'verbose_name_plural': 'Property slugs',
            },
        ),
        migrations.CreateModel(
            name='PropertyType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('data_type', models.IntegerField(choices=[(-1, 'Integer'), (-2, 'Float'), (-3, 'String'), (-4, 'Text'), (-5, 'Boolean'), (-6, 'Html')], default=-1, verbose_name='Data type')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'Properties type',
                'verbose_name_plural': 'Properties Types',
            },
        ),
        migrations.CreateModel(
            name='PropertyTypeCategoryRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('max_count', models.IntegerField(default=1, help_text='Maximum number of properties by this property type in category', verbose_name='Count')),
                ('slug', models.CharField(blank=True, max_length=60, null=True, verbose_name='Slug')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.Category', verbose_name='Category')),
                ('property_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.PropertyType', verbose_name='Property Type')),
            ],
        ),
        migrations.CreateModel(
            name='Seller',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('slug', models.CharField(max_length=60, verbose_name='Slug')),
                ('image', models.ImageField(blank=True, null=True, upload_to=b'H:\\GITHUB\\virtenviro\\..\\media\\img\\shop\\sellers', verbose_name='Image')),
                ('address', models.CharField(blank=True, max_length=255, null=True, verbose_name='Address')),
                ('city', models.CharField(blank=True, max_length=255, null=True, verbose_name='City')),
                ('country', models.CharField(blank=True, max_length=255, null=True, verbose_name='Country')),
                ('postal_zip', models.CharField(blank=True, max_length=255, null=True, verbose_name='ZIP')),
                ('site', models.URLField(blank=True, null=True, verbose_name='Site')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='Email')),
                ('phones', models.TextField(blank=True, null=True, verbose_name='Phones')),
                ('itn', models.CharField(blank=True, max_length=255, null=True, verbose_name='Individual Taxpayer Number')),
                ('ordering', models.IntegerField(default=999, verbose_name='Ordering')),
                ('map_code', models.TextField(blank=True, null=True, verbose_name="Map's code")),
            ],
            options={
                'ordering': ['ordering', 'name'],
                'verbose_name': 'Seller',
                'verbose_name_plural': 'Sellers',
            },
        ),
        migrations.AddField(
            model_name='propertytype',
            name='category',
            field=models.ManyToManyField(through='shop.PropertyTypeCategoryRelation', to='shop.Category'),
        ),
        migrations.AddField(
            model_name='propertyslug',
            name='property_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.PropertyType', verbose_name='Propert type'),
        ),
        migrations.AddField(
            model_name='property',
            name='property_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.PropertyType'),
        ),
        migrations.AddField(
            model_name='order',
            name='product',
            field=models.ManyToManyField(related_name='production', through='shop.ProductOrderRelation', to='shop.Product', verbose_name='Product'),
        ),
        migrations.AddField(
            model_name='order',
            name='status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.OrderStatus', verbose_name='Status'),
        ),
        migrations.AddField(
            model_name='order',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.AddField(
            model_name='imagetype',
            name='category',
            field=models.ManyToManyField(through='shop.ImageTypeCategoryRelation', to='shop.Category', verbose_name='Production Type'),
        ),
        migrations.AddField(
            model_name='image',
            name='image_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.ImageType', verbose_name='Image Type'),
        ),
        migrations.AddField(
            model_name='image',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.Product', verbose_name='Product'),
        ),
        migrations.AddField(
            model_name='file',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.Product', verbose_name='Product'),
        ),
    ]
