#!/usr/bin/env python
"""API errors definitions."""


class Error(RuntimeError):
  """Errors generated by API client library."""


class ResourceNotFoundError(Error):
  """Raised when resource is not found."""


class AccessForbiddenError(Error):
  """Raised when resource access is forbidden."""


class ApiNotImplementedError(Error):
  """Raised when API method is not implemented."""


class UnknownError(Error):
  """Unknown server error."""
