# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, Optional, TypeVar

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._sql_vulnerability_assessment_scans_operations import build_get_request, build_list_request

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class SqlVulnerabilityAssessmentScansOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.v2020_07_01_preview.aio.SecurityCenter`'s
        :attr:`sql_vulnerability_assessment_scans` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, scan_id: str, workspace_id: str, resource_id: str, **kwargs: Any) -> _models.Scan:
        """Gets the scan details of a single scan record.

        Gets the scan details of a single scan record.

        :param scan_id: The scan Id. Type 'latest' to get the scan record for the latest scan.
         Required.
        :type scan_id: str
        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Scan or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2020_07_01_preview.models.Scan
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2020-07-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2020-07-01-preview")
        )
        cls: ClsType[_models.Scan] = kwargs.pop("cls", None)

        request = build_get_request(
            scan_id=scan_id,
            resource_id=resource_id,
            workspace_id=workspace_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Scan", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}"
    }

    @distributed_trace_async
    async def list(self, workspace_id: str, resource_id: str, **kwargs: Any) -> _models.Scans:
        """Gets a list of scan records.

        Gets a list of scan records.

        :param workspace_id: The workspace Id. Required.
        :type workspace_id: str
        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Scans or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2020_07_01_preview.models.Scans
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2020-07-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2020-07-01-preview")
        )
        cls: ClsType[_models.Scans] = kwargs.pop("cls", None)

        request = build_list_request(
            resource_id=resource_id,
            workspace_id=workspace_id,
            api_version=api_version,
            template_url=self.list.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Scans", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list.metadata = {"url": "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans"}
