# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin

from .._serialization import Deserializer, Serializer
from ._configuration import SecurityCenterConfiguration

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implemetation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class SecurityCenter(MultiApiClientMixin, _SDKClient):
    """API spec for Microsoft.Security (Azure Security Center) resource provider.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Azure subscription ID. Required.
    :type subscription_id: str
    :param api_version: API version to use if no profile is provided, or if missing in profile.
    :type api_version: str
    :param base_url: Service URL
    :type base_url: str
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    DEFAULT_API_VERSION = '2022-05-01'
    _PROFILE_TAG = "azure.mgmt.security.SecurityCenter"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
            'adaptive_application_controls': '2020-01-01',
            'adaptive_network_hardenings': '2020-01-01',
            'advanced_threat_protection': '2019-01-01',
            'alerts': '2022-01-01',
            'alerts_suppression_rules': '2019-01-01-preview',
            'allowed_connections': '2020-01-01',
            'assessments': '2021-06-01',
            'assessments_metadata': '2021-06-01',
            'auto_provisioning_settings': '2017-08-01-preview',
            'automations': '2019-01-01-preview',
            'compliance_results': '2017-08-01',
            'compliances': '2017-08-01-preview',
            'connectors': '2020-01-01-preview',
            'custom_assessment_automations': '2021-07-01-preview',
            'custom_entity_store_assignments': '2021-07-01-preview',
            'device_security_groups': '2019-08-01',
            'discovered_security_solutions': '2020-01-01',
            'external_security_solutions': '2020-01-01',
            'governance_assignments': '2022-01-01-preview',
            'governance_rules': '2022-01-01-preview',
            'information_protection_policies': '2017-08-01-preview',
            'ingestion_settings': '2021-01-15-preview',
            'iot_security_solution': '2019-08-01',
            'iot_security_solution_analytics': '2019-08-01',
            'iot_security_solutions_analytics_aggregated_alert': '2019-08-01',
            'iot_security_solutions_analytics_recommendation': '2019-08-01',
            'jit_network_access_policies': '2020-01-01',
            'locations': '2015-06-01-preview',
            'mde_onboardings': '2021-10-01-preview',
            'operations': '2015-06-01-preview',
            'pricings': '2022-03-01',
            'regulatory_compliance_assessments': '2019-01-01-preview',
            'regulatory_compliance_controls': '2019-01-01-preview',
            'regulatory_compliance_standards': '2019-01-01-preview',
            'secure_score_control_definitions': '2020-01-01',
            'secure_score_controls': '2020-01-01',
            'secure_scores': '2020-01-01',
            'security_contacts': '2017-08-01-preview',
            'security_solutions': '2020-01-01',
            'security_solutions_reference_data': '2020-01-01',
            'server_vulnerability_assessment': '2020-01-01',
            'software_inventories': '2021-05-01-preview',
            'sql_vulnerability_assessment_baseline_rules': '2020-07-01-preview',
            'sql_vulnerability_assessment_scan_results': '2020-07-01-preview',
            'sql_vulnerability_assessment_scans': '2020-07-01-preview',
            'sub_assessments': '2019-01-01-preview',
            'tasks': '2015-06-01-preview',
            'topology': '2020-01-01',
            'workspace_settings': '2017-08-01-preview',
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        api_version: Optional[str] = None,
        base_url: str = "https://management.azure.com",
        profile: KnownProfiles = KnownProfiles.default,
        **kwargs: Any
    ) -> None:
        self._config = SecurityCenterConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)
        super(SecurityCenter, self).__init__(
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2015-06-01-preview: :mod:`v2015_06_01_preview.models<azure.mgmt.security.v2015_06_01_preview.models>`
           * 2017-08-01: :mod:`v2017_08_01.models<azure.mgmt.security.v2017_08_01.models>`
           * 2017-08-01-preview: :mod:`v2017_08_01_preview.models<azure.mgmt.security.v2017_08_01_preview.models>`
           * 2018-06-01: :mod:`v2018_06_01.models<azure.mgmt.security.v2018_06_01.models>`
           * 2019-01-01: :mod:`v2019_01_01.models<azure.mgmt.security.v2019_01_01.models>`
           * 2019-01-01-preview: :mod:`v2019_01_01_preview.models<azure.mgmt.security.v2019_01_01_preview.models>`
           * 2019-08-01: :mod:`v2019_08_01.models<azure.mgmt.security.v2019_08_01.models>`
           * 2020-01-01: :mod:`v2020_01_01.models<azure.mgmt.security.v2020_01_01.models>`
           * 2020-01-01-preview: :mod:`v2020_01_01_preview.models<azure.mgmt.security.v2020_01_01_preview.models>`
           * 2020-07-01-preview: :mod:`v2020_07_01_preview.models<azure.mgmt.security.v2020_07_01_preview.models>`
           * 2021-01-01: :mod:`v2021_01_01.models<azure.mgmt.security.v2021_01_01.models>`
           * 2021-01-15-preview: :mod:`v2021_01_15_preview.models<azure.mgmt.security.v2021_01_15_preview.models>`
           * 2021-05-01-preview: :mod:`v2021_05_01_preview.models<azure.mgmt.security.v2021_05_01_preview.models>`
           * 2021-06-01: :mod:`v2021_06_01.models<azure.mgmt.security.v2021_06_01.models>`
           * 2021-07-01: :mod:`v2021_07_01.models<azure.mgmt.security.v2021_07_01.models>`
           * 2021-07-01-preview: :mod:`v2021_07_01_preview.models<azure.mgmt.security.v2021_07_01_preview.models>`
           * 2021-10-01-preview: :mod:`v2021_10_01_preview.models<azure.mgmt.security.v2021_10_01_preview.models>`
           * 2022-01-01: :mod:`v2022_01_01.models<azure.mgmt.security.v2022_01_01.models>`
           * 2022-01-01-preview: :mod:`v2022_01_01_preview.models<azure.mgmt.security.v2022_01_01_preview.models>`
           * 2022-03-01: :mod:`v2022_03_01.models<azure.mgmt.security.v2022_03_01.models>`
           * 2022-05-01: :mod:`v2022_05_01.models<azure.mgmt.security.v2022_05_01.models>`
           * 2022-05-01-preview: :mod:`v2022_05_01_preview.models<azure.mgmt.security.v2022_05_01_preview.models>`
           * 2022-07-01-preview: :mod:`v2022_07_01_preview.models<azure.mgmt.security.v2022_07_01_preview.models>`
           * 2022-08-01-preview: :mod:`v2022_08_01_preview.models<azure.mgmt.security.v2022_08_01_preview.models>`
        """
        if api_version == '2015-06-01-preview':
            from ..v2015_06_01_preview import models
            return models
        elif api_version == '2017-08-01':
            from ..v2017_08_01 import models
            return models
        elif api_version == '2017-08-01-preview':
            from ..v2017_08_01_preview import models
            return models
        elif api_version == '2018-06-01':
            from ..v2018_06_01 import models
            return models
        elif api_version == '2019-01-01':
            from ..v2019_01_01 import models
            return models
        elif api_version == '2019-01-01-preview':
            from ..v2019_01_01_preview import models
            return models
        elif api_version == '2019-08-01':
            from ..v2019_08_01 import models
            return models
        elif api_version == '2020-01-01':
            from ..v2020_01_01 import models
            return models
        elif api_version == '2020-01-01-preview':
            from ..v2020_01_01_preview import models
            return models
        elif api_version == '2020-07-01-preview':
            from ..v2020_07_01_preview import models
            return models
        elif api_version == '2021-01-01':
            from ..v2021_01_01 import models
            return models
        elif api_version == '2021-01-15-preview':
            from ..v2021_01_15_preview import models
            return models
        elif api_version == '2021-05-01-preview':
            from ..v2021_05_01_preview import models
            return models
        elif api_version == '2021-06-01':
            from ..v2021_06_01 import models
            return models
        elif api_version == '2021-07-01':
            from ..v2021_07_01 import models
            return models
        elif api_version == '2021-07-01-preview':
            from ..v2021_07_01_preview import models
            return models
        elif api_version == '2021-10-01-preview':
            from ..v2021_10_01_preview import models
            return models
        elif api_version == '2022-01-01':
            from ..v2022_01_01 import models
            return models
        elif api_version == '2022-01-01-preview':
            from ..v2022_01_01_preview import models
            return models
        elif api_version == '2022-03-01':
            from ..v2022_03_01 import models
            return models
        elif api_version == '2022-05-01':
            from ..v2022_05_01 import models
            return models
        elif api_version == '2022-05-01-preview':
            from ..v2022_05_01_preview import models
            return models
        elif api_version == '2022-07-01-preview':
            from ..v2022_07_01_preview import models
            return models
        elif api_version == '2022-08-01-preview':
            from ..v2022_08_01_preview import models
            return models
        raise ValueError("API version {} is not available".format(api_version))

    @property
    def adaptive_application_controls(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`AdaptiveApplicationControlsOperations<azure.mgmt.security.v2020_01_01.aio.operations.AdaptiveApplicationControlsOperations>`
        """
        api_version = self._get_api_version('adaptive_application_controls')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import AdaptiveApplicationControlsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'adaptive_application_controls'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def adaptive_network_hardenings(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`AdaptiveNetworkHardeningsOperations<azure.mgmt.security.v2020_01_01.aio.operations.AdaptiveNetworkHardeningsOperations>`
        """
        api_version = self._get_api_version('adaptive_network_hardenings')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import AdaptiveNetworkHardeningsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'adaptive_network_hardenings'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def advanced_threat_protection(self):
        """Instance depends on the API version:

           * 2019-01-01: :class:`AdvancedThreatProtectionOperations<azure.mgmt.security.v2019_01_01.aio.operations.AdvancedThreatProtectionOperations>`
        """
        api_version = self._get_api_version('advanced_threat_protection')
        if api_version == '2019-01-01':
            from ..v2019_01_01.aio.operations import AdvancedThreatProtectionOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'advanced_threat_protection'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def alerts(self):
        """Instance depends on the API version:

           * 2021-01-01: :class:`AlertsOperations<azure.mgmt.security.v2021_01_01.aio.operations.AlertsOperations>`
           * 2022-01-01: :class:`AlertsOperations<azure.mgmt.security.v2022_01_01.aio.operations.AlertsOperations>`
        """
        api_version = self._get_api_version('alerts')
        if api_version == '2021-01-01':
            from ..v2021_01_01.aio.operations import AlertsOperations as OperationClass
        elif api_version == '2022-01-01':
            from ..v2022_01_01.aio.operations import AlertsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'alerts'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def alerts_suppression_rules(self):
        """Instance depends on the API version:

           * 2019-01-01-preview: :class:`AlertsSuppressionRulesOperations<azure.mgmt.security.v2019_01_01_preview.aio.operations.AlertsSuppressionRulesOperations>`
        """
        api_version = self._get_api_version('alerts_suppression_rules')
        if api_version == '2019-01-01-preview':
            from ..v2019_01_01_preview.aio.operations import AlertsSuppressionRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'alerts_suppression_rules'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def allowed_connections(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`AllowedConnectionsOperations<azure.mgmt.security.v2020_01_01.aio.operations.AllowedConnectionsOperations>`
        """
        api_version = self._get_api_version('allowed_connections')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import AllowedConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'allowed_connections'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def application(self):
        """Instance depends on the API version:

           * 2022-07-01-preview: :class:`ApplicationOperations<azure.mgmt.security.v2022_07_01_preview.aio.operations.ApplicationOperations>`
        """
        api_version = self._get_api_version('application')
        if api_version == '2022-07-01-preview':
            from ..v2022_07_01_preview.aio.operations import ApplicationOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'application'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def applications(self):
        """Instance depends on the API version:

           * 2022-07-01-preview: :class:`ApplicationsOperations<azure.mgmt.security.v2022_07_01_preview.aio.operations.ApplicationsOperations>`
        """
        api_version = self._get_api_version('applications')
        if api_version == '2022-07-01-preview':
            from ..v2022_07_01_preview.aio.operations import ApplicationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'applications'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def assessments(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`AssessmentsOperations<azure.mgmt.security.v2020_01_01.aio.operations.AssessmentsOperations>`
           * 2021-06-01: :class:`AssessmentsOperations<azure.mgmt.security.v2021_06_01.aio.operations.AssessmentsOperations>`
        """
        api_version = self._get_api_version('assessments')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import AssessmentsOperations as OperationClass
        elif api_version == '2021-06-01':
            from ..v2021_06_01.aio.operations import AssessmentsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'assessments'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def assessments_metadata(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`AssessmentsMetadataOperations<azure.mgmt.security.v2020_01_01.aio.operations.AssessmentsMetadataOperations>`
           * 2021-06-01: :class:`AssessmentsMetadataOperations<azure.mgmt.security.v2021_06_01.aio.operations.AssessmentsMetadataOperations>`
        """
        api_version = self._get_api_version('assessments_metadata')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import AssessmentsMetadataOperations as OperationClass
        elif api_version == '2021-06-01':
            from ..v2021_06_01.aio.operations import AssessmentsMetadataOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'assessments_metadata'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def auto_provisioning_settings(self):
        """Instance depends on the API version:

           * 2017-08-01-preview: :class:`AutoProvisioningSettingsOperations<azure.mgmt.security.v2017_08_01_preview.aio.operations.AutoProvisioningSettingsOperations>`
        """
        api_version = self._get_api_version('auto_provisioning_settings')
        if api_version == '2017-08-01-preview':
            from ..v2017_08_01_preview.aio.operations import AutoProvisioningSettingsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'auto_provisioning_settings'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def automations(self):
        """Instance depends on the API version:

           * 2019-01-01-preview: :class:`AutomationsOperations<azure.mgmt.security.v2019_01_01_preview.aio.operations.AutomationsOperations>`
        """
        api_version = self._get_api_version('automations')
        if api_version == '2019-01-01-preview':
            from ..v2019_01_01_preview.aio.operations import AutomationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'automations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def compliance_results(self):
        """Instance depends on the API version:

           * 2017-08-01: :class:`ComplianceResultsOperations<azure.mgmt.security.v2017_08_01.aio.operations.ComplianceResultsOperations>`
        """
        api_version = self._get_api_version('compliance_results')
        if api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations import ComplianceResultsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'compliance_results'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def compliances(self):
        """Instance depends on the API version:

           * 2017-08-01-preview: :class:`CompliancesOperations<azure.mgmt.security.v2017_08_01_preview.aio.operations.CompliancesOperations>`
        """
        api_version = self._get_api_version('compliances')
        if api_version == '2017-08-01-preview':
            from ..v2017_08_01_preview.aio.operations import CompliancesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'compliances'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def connectors(self):
        """Instance depends on the API version:

           * 2020-01-01-preview: :class:`ConnectorsOperations<azure.mgmt.security.v2020_01_01_preview.aio.operations.ConnectorsOperations>`
        """
        api_version = self._get_api_version('connectors')
        if api_version == '2020-01-01-preview':
            from ..v2020_01_01_preview.aio.operations import ConnectorsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'connectors'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def custom_assessment_automations(self):
        """Instance depends on the API version:

           * 2021-07-01-preview: :class:`CustomAssessmentAutomationsOperations<azure.mgmt.security.v2021_07_01_preview.aio.operations.CustomAssessmentAutomationsOperations>`
        """
        api_version = self._get_api_version('custom_assessment_automations')
        if api_version == '2021-07-01-preview':
            from ..v2021_07_01_preview.aio.operations import CustomAssessmentAutomationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'custom_assessment_automations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def custom_entity_store_assignments(self):
        """Instance depends on the API version:

           * 2021-07-01-preview: :class:`CustomEntityStoreAssignmentsOperations<azure.mgmt.security.v2021_07_01_preview.aio.operations.CustomEntityStoreAssignmentsOperations>`
        """
        api_version = self._get_api_version('custom_entity_store_assignments')
        if api_version == '2021-07-01-preview':
            from ..v2021_07_01_preview.aio.operations import CustomEntityStoreAssignmentsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'custom_entity_store_assignments'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def device_security_groups(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`DeviceSecurityGroupsOperations<azure.mgmt.security.v2019_08_01.aio.operations.DeviceSecurityGroupsOperations>`
        """
        api_version = self._get_api_version('device_security_groups')
        if api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations import DeviceSecurityGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'device_security_groups'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def discovered_security_solutions(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`DiscoveredSecuritySolutionsOperations<azure.mgmt.security.v2020_01_01.aio.operations.DiscoveredSecuritySolutionsOperations>`
        """
        api_version = self._get_api_version('discovered_security_solutions')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import DiscoveredSecuritySolutionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'discovered_security_solutions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def external_security_solutions(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`ExternalSecuritySolutionsOperations<azure.mgmt.security.v2020_01_01.aio.operations.ExternalSecuritySolutionsOperations>`
        """
        api_version = self._get_api_version('external_security_solutions')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import ExternalSecuritySolutionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'external_security_solutions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def governance_assignments(self):
        """Instance depends on the API version:

           * 2022-01-01-preview: :class:`GovernanceAssignmentsOperations<azure.mgmt.security.v2022_01_01_preview.aio.operations.GovernanceAssignmentsOperations>`
        """
        api_version = self._get_api_version('governance_assignments')
        if api_version == '2022-01-01-preview':
            from ..v2022_01_01_preview.aio.operations import GovernanceAssignmentsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'governance_assignments'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def governance_rules(self):
        """Instance depends on the API version:

           * 2022-01-01-preview: :class:`GovernanceRulesOperations<azure.mgmt.security.v2022_01_01_preview.aio.operations.GovernanceRulesOperations>`
        """
        api_version = self._get_api_version('governance_rules')
        if api_version == '2022-01-01-preview':
            from ..v2022_01_01_preview.aio.operations import GovernanceRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'governance_rules'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def information_protection_policies(self):
        """Instance depends on the API version:

           * 2017-08-01-preview: :class:`InformationProtectionPoliciesOperations<azure.mgmt.security.v2017_08_01_preview.aio.operations.InformationProtectionPoliciesOperations>`
        """
        api_version = self._get_api_version('information_protection_policies')
        if api_version == '2017-08-01-preview':
            from ..v2017_08_01_preview.aio.operations import InformationProtectionPoliciesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'information_protection_policies'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ingestion_settings(self):
        """Instance depends on the API version:

           * 2021-01-15-preview: :class:`IngestionSettingsOperations<azure.mgmt.security.v2021_01_15_preview.aio.operations.IngestionSettingsOperations>`
        """
        api_version = self._get_api_version('ingestion_settings')
        if api_version == '2021-01-15-preview':
            from ..v2021_01_15_preview.aio.operations import IngestionSettingsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'ingestion_settings'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def iot_security_solution(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`IotSecuritySolutionOperations<azure.mgmt.security.v2019_08_01.aio.operations.IotSecuritySolutionOperations>`
        """
        api_version = self._get_api_version('iot_security_solution')
        if api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations import IotSecuritySolutionOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'iot_security_solution'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def iot_security_solution_analytics(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`IotSecuritySolutionAnalyticsOperations<azure.mgmt.security.v2019_08_01.aio.operations.IotSecuritySolutionAnalyticsOperations>`
        """
        api_version = self._get_api_version('iot_security_solution_analytics')
        if api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations import IotSecuritySolutionAnalyticsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'iot_security_solution_analytics'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def iot_security_solutions_analytics_aggregated_alert(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`IotSecuritySolutionsAnalyticsAggregatedAlertOperations<azure.mgmt.security.v2019_08_01.aio.operations.IotSecuritySolutionsAnalyticsAggregatedAlertOperations>`
        """
        api_version = self._get_api_version('iot_security_solutions_analytics_aggregated_alert')
        if api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations import IotSecuritySolutionsAnalyticsAggregatedAlertOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'iot_security_solutions_analytics_aggregated_alert'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def iot_security_solutions_analytics_recommendation(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`IotSecuritySolutionsAnalyticsRecommendationOperations<azure.mgmt.security.v2019_08_01.aio.operations.IotSecuritySolutionsAnalyticsRecommendationOperations>`
        """
        api_version = self._get_api_version('iot_security_solutions_analytics_recommendation')
        if api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations import IotSecuritySolutionsAnalyticsRecommendationOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'iot_security_solutions_analytics_recommendation'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def jit_network_access_policies(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`JitNetworkAccessPoliciesOperations<azure.mgmt.security.v2020_01_01.aio.operations.JitNetworkAccessPoliciesOperations>`
        """
        api_version = self._get_api_version('jit_network_access_policies')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import JitNetworkAccessPoliciesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'jit_network_access_policies'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def locations(self):
        """Instance depends on the API version:

           * 2015-06-01-preview: :class:`LocationsOperations<azure.mgmt.security.v2015_06_01_preview.aio.operations.LocationsOperations>`
        """
        api_version = self._get_api_version('locations')
        if api_version == '2015-06-01-preview':
            from ..v2015_06_01_preview.aio.operations import LocationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'locations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def mde_onboardings(self):
        """Instance depends on the API version:

           * 2021-10-01-preview: :class:`MdeOnboardingsOperations<azure.mgmt.security.v2021_10_01_preview.aio.operations.MdeOnboardingsOperations>`
        """
        api_version = self._get_api_version('mde_onboardings')
        if api_version == '2021-10-01-preview':
            from ..v2021_10_01_preview.aio.operations import MdeOnboardingsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'mde_onboardings'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2015-06-01-preview: :class:`Operations<azure.mgmt.security.v2015_06_01_preview.aio.operations.Operations>`
        """
        api_version = self._get_api_version('operations')
        if api_version == '2015-06-01-preview':
            from ..v2015_06_01_preview.aio.operations import Operations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'operations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def pricings(self):
        """Instance depends on the API version:

           * 2018-06-01: :class:`PricingsOperations<azure.mgmt.security.v2018_06_01.aio.operations.PricingsOperations>`
           * 2022-03-01: :class:`PricingsOperations<azure.mgmt.security.v2022_03_01.aio.operations.PricingsOperations>`
        """
        api_version = self._get_api_version('pricings')
        if api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations import PricingsOperations as OperationClass
        elif api_version == '2022-03-01':
            from ..v2022_03_01.aio.operations import PricingsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'pricings'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def regulatory_compliance_assessments(self):
        """Instance depends on the API version:

           * 2019-01-01-preview: :class:`RegulatoryComplianceAssessmentsOperations<azure.mgmt.security.v2019_01_01_preview.aio.operations.RegulatoryComplianceAssessmentsOperations>`
        """
        api_version = self._get_api_version('regulatory_compliance_assessments')
        if api_version == '2019-01-01-preview':
            from ..v2019_01_01_preview.aio.operations import RegulatoryComplianceAssessmentsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'regulatory_compliance_assessments'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def regulatory_compliance_controls(self):
        """Instance depends on the API version:

           * 2019-01-01-preview: :class:`RegulatoryComplianceControlsOperations<azure.mgmt.security.v2019_01_01_preview.aio.operations.RegulatoryComplianceControlsOperations>`
        """
        api_version = self._get_api_version('regulatory_compliance_controls')
        if api_version == '2019-01-01-preview':
            from ..v2019_01_01_preview.aio.operations import RegulatoryComplianceControlsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'regulatory_compliance_controls'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def regulatory_compliance_standards(self):
        """Instance depends on the API version:

           * 2019-01-01-preview: :class:`RegulatoryComplianceStandardsOperations<azure.mgmt.security.v2019_01_01_preview.aio.operations.RegulatoryComplianceStandardsOperations>`
        """
        api_version = self._get_api_version('regulatory_compliance_standards')
        if api_version == '2019-01-01-preview':
            from ..v2019_01_01_preview.aio.operations import RegulatoryComplianceStandardsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'regulatory_compliance_standards'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def secure_score_control_definitions(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`SecureScoreControlDefinitionsOperations<azure.mgmt.security.v2020_01_01.aio.operations.SecureScoreControlDefinitionsOperations>`
        """
        api_version = self._get_api_version('secure_score_control_definitions')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import SecureScoreControlDefinitionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'secure_score_control_definitions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def secure_score_controls(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`SecureScoreControlsOperations<azure.mgmt.security.v2020_01_01.aio.operations.SecureScoreControlsOperations>`
        """
        api_version = self._get_api_version('secure_score_controls')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import SecureScoreControlsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'secure_score_controls'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def secure_scores(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`SecureScoresOperations<azure.mgmt.security.v2020_01_01.aio.operations.SecureScoresOperations>`
        """
        api_version = self._get_api_version('secure_scores')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import SecureScoresOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'secure_scores'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_connector_application(self):
        """Instance depends on the API version:

           * 2022-07-01-preview: :class:`SecurityConnectorApplicationOperations<azure.mgmt.security.v2022_07_01_preview.aio.operations.SecurityConnectorApplicationOperations>`
        """
        api_version = self._get_api_version('security_connector_application')
        if api_version == '2022-07-01-preview':
            from ..v2022_07_01_preview.aio.operations import SecurityConnectorApplicationOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'security_connector_application'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_connector_applications(self):
        """Instance depends on the API version:

           * 2022-07-01-preview: :class:`SecurityConnectorApplicationsOperations<azure.mgmt.security.v2022_07_01_preview.aio.operations.SecurityConnectorApplicationsOperations>`
        """
        api_version = self._get_api_version('security_connector_applications')
        if api_version == '2022-07-01-preview':
            from ..v2022_07_01_preview.aio.operations import SecurityConnectorApplicationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'security_connector_applications'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_connectors(self):
        """Instance depends on the API version:

           * 2021-07-01-preview: :class:`SecurityConnectorsOperations<azure.mgmt.security.v2021_07_01_preview.aio.operations.SecurityConnectorsOperations>`
           * 2022-05-01-preview: :class:`SecurityConnectorsOperations<azure.mgmt.security.v2022_05_01_preview.aio.operations.SecurityConnectorsOperations>`
           * 2022-08-01-preview: :class:`SecurityConnectorsOperations<azure.mgmt.security.v2022_08_01_preview.aio.operations.SecurityConnectorsOperations>`
        """
        api_version = self._get_api_version('security_connectors')
        if api_version == '2021-07-01-preview':
            from ..v2021_07_01_preview.aio.operations import SecurityConnectorsOperations as OperationClass
        elif api_version == '2022-05-01-preview':
            from ..v2022_05_01_preview.aio.operations import SecurityConnectorsOperations as OperationClass
        elif api_version == '2022-08-01-preview':
            from ..v2022_08_01_preview.aio.operations import SecurityConnectorsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'security_connectors'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_contacts(self):
        """Instance depends on the API version:

           * 2017-08-01-preview: :class:`SecurityContactsOperations<azure.mgmt.security.v2017_08_01_preview.aio.operations.SecurityContactsOperations>`
        """
        api_version = self._get_api_version('security_contacts')
        if api_version == '2017-08-01-preview':
            from ..v2017_08_01_preview.aio.operations import SecurityContactsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'security_contacts'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_solutions(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`SecuritySolutionsOperations<azure.mgmt.security.v2020_01_01.aio.operations.SecuritySolutionsOperations>`
        """
        api_version = self._get_api_version('security_solutions')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import SecuritySolutionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'security_solutions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_solutions_reference_data(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`SecuritySolutionsReferenceDataOperations<azure.mgmt.security.v2020_01_01.aio.operations.SecuritySolutionsReferenceDataOperations>`
        """
        api_version = self._get_api_version('security_solutions_reference_data')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import SecuritySolutionsReferenceDataOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'security_solutions_reference_data'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def server_vulnerability_assessment(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`ServerVulnerabilityAssessmentOperations<azure.mgmt.security.v2020_01_01.aio.operations.ServerVulnerabilityAssessmentOperations>`
        """
        api_version = self._get_api_version('server_vulnerability_assessment')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import ServerVulnerabilityAssessmentOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'server_vulnerability_assessment'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def settings(self):
        """Instance depends on the API version:

           * 2021-06-01: :class:`SettingsOperations<azure.mgmt.security.v2021_06_01.aio.operations.SettingsOperations>`
           * 2021-07-01: :class:`SettingsOperations<azure.mgmt.security.v2021_07_01.aio.operations.SettingsOperations>`
           * 2022-05-01: :class:`SettingsOperations<azure.mgmt.security.v2022_05_01.aio.operations.SettingsOperations>`
        """
        api_version = self._get_api_version('settings')
        if api_version == '2021-06-01':
            from ..v2021_06_01.aio.operations import SettingsOperations as OperationClass
        elif api_version == '2021-07-01':
            from ..v2021_07_01.aio.operations import SettingsOperations as OperationClass
        elif api_version == '2022-05-01':
            from ..v2022_05_01.aio.operations import SettingsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'settings'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def software_inventories(self):
        """Instance depends on the API version:

           * 2021-05-01-preview: :class:`SoftwareInventoriesOperations<azure.mgmt.security.v2021_05_01_preview.aio.operations.SoftwareInventoriesOperations>`
        """
        api_version = self._get_api_version('software_inventories')
        if api_version == '2021-05-01-preview':
            from ..v2021_05_01_preview.aio.operations import SoftwareInventoriesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'software_inventories'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def sql_vulnerability_assessment_baseline_rules(self):
        """Instance depends on the API version:

           * 2020-07-01-preview: :class:`SqlVulnerabilityAssessmentBaselineRulesOperations<azure.mgmt.security.v2020_07_01_preview.aio.operations.SqlVulnerabilityAssessmentBaselineRulesOperations>`
        """
        api_version = self._get_api_version('sql_vulnerability_assessment_baseline_rules')
        if api_version == '2020-07-01-preview':
            from ..v2020_07_01_preview.aio.operations import SqlVulnerabilityAssessmentBaselineRulesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'sql_vulnerability_assessment_baseline_rules'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def sql_vulnerability_assessment_scan_results(self):
        """Instance depends on the API version:

           * 2020-07-01-preview: :class:`SqlVulnerabilityAssessmentScanResultsOperations<azure.mgmt.security.v2020_07_01_preview.aio.operations.SqlVulnerabilityAssessmentScanResultsOperations>`
        """
        api_version = self._get_api_version('sql_vulnerability_assessment_scan_results')
        if api_version == '2020-07-01-preview':
            from ..v2020_07_01_preview.aio.operations import SqlVulnerabilityAssessmentScanResultsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'sql_vulnerability_assessment_scan_results'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def sql_vulnerability_assessment_scans(self):
        """Instance depends on the API version:

           * 2020-07-01-preview: :class:`SqlVulnerabilityAssessmentScansOperations<azure.mgmt.security.v2020_07_01_preview.aio.operations.SqlVulnerabilityAssessmentScansOperations>`
        """
        api_version = self._get_api_version('sql_vulnerability_assessment_scans')
        if api_version == '2020-07-01-preview':
            from ..v2020_07_01_preview.aio.operations import SqlVulnerabilityAssessmentScansOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'sql_vulnerability_assessment_scans'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def sub_assessments(self):
        """Instance depends on the API version:

           * 2019-01-01-preview: :class:`SubAssessmentsOperations<azure.mgmt.security.v2019_01_01_preview.aio.operations.SubAssessmentsOperations>`
        """
        api_version = self._get_api_version('sub_assessments')
        if api_version == '2019-01-01-preview':
            from ..v2019_01_01_preview.aio.operations import SubAssessmentsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'sub_assessments'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def tasks(self):
        """Instance depends on the API version:

           * 2015-06-01-preview: :class:`TasksOperations<azure.mgmt.security.v2015_06_01_preview.aio.operations.TasksOperations>`
        """
        api_version = self._get_api_version('tasks')
        if api_version == '2015-06-01-preview':
            from ..v2015_06_01_preview.aio.operations import TasksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'tasks'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def topology(self):
        """Instance depends on the API version:

           * 2020-01-01: :class:`TopologyOperations<azure.mgmt.security.v2020_01_01.aio.operations.TopologyOperations>`
        """
        api_version = self._get_api_version('topology')
        if api_version == '2020-01-01':
            from ..v2020_01_01.aio.operations import TopologyOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'topology'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def workspace_settings(self):
        """Instance depends on the API version:

           * 2017-08-01-preview: :class:`WorkspaceSettingsOperations<azure.mgmt.security.v2017_08_01_preview.aio.operations.WorkspaceSettingsOperations>`
        """
        api_version = self._get_api_version('workspace_settings')
        if api_version == '2017-08-01-preview':
            from ..v2017_08_01_preview.aio.operations import WorkspaceSettingsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'workspace_settings'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    async def close(self):
        await self._client.close()
    async def __aenter__(self):
        await self._client.__aenter__()
        return self
    async def __aexit__(self, *exc_details):
        await self._client.__aexit__(*exc_details)
