# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EventHubCreateOrUpdateParameters(Model):
    """Parameters supplied to the Create Or Update Event Hub operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Location of the resource.
    :type location: str
    :param type: ARM type of the Namespace.
    :type type: str
    :param name: Name of the Event Hub.
    :type name: str
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: datetime
    :param message_retention_in_days: Number of days to retain the events for
     this Event Hub.
    :type message_retention_in_days: long
    :param partition_count: Number of partitions created for the Event Hub.
    :type partition_count: long
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :param status: Enumerates the possible values for the status of the Event
     Hub. Possible values include: 'Active', 'Disabled', 'Restoring',
     'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming',
     'Unknown'
    :type status: str or ~azure.mgmt.eventhub.v2015_08_01.models.EntityStatus
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    """

    _validation = {
        'location': {'required': True},
        'created_at': {'readonly': True},
        'partition_ids': {'readonly': True},
        'updated_at': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'properties.messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'properties.partitionCount', 'type': 'long'},
        'partition_ids': {'key': 'properties.partitionIds', 'type': '[str]'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(EventHubCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)
        self.created_at = None
        self.message_retention_in_days = kwargs.get('message_retention_in_days', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.partition_ids = None
        self.status = kwargs.get('status', None)
        self.updated_at = None
