# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServiceAuthConfiguration(Model):
    """Global service auth configuration properties. These are the data-plane
    authorization keys and are used if a service doesn't define it's own.

    :param primary_auth_key_hash: The primary auth key hash. This is not
     returned in response of GET/PUT on the resource.. To see this please call
     listKeys API.
    :type primary_auth_key_hash: str
    :param secondary_auth_key_hash: The secondary auth key hash. This is not
     returned in response of GET/PUT on the resource.. To see this please call
     listKeys API.
    :type secondary_auth_key_hash: str
    """

    _validation = {
        'primary_auth_key_hash': {'required': True},
        'secondary_auth_key_hash': {'required': True},
    }

    _attribute_map = {
        'primary_auth_key_hash': {'key': 'primaryAuthKeyHash', 'type': 'str'},
        'secondary_auth_key_hash': {'key': 'secondaryAuthKeyHash', 'type': 'str'},
    }

    def __init__(self, primary_auth_key_hash, secondary_auth_key_hash):
        self.primary_auth_key_hash = primary_auth_key_hash
        self.secondary_auth_key_hash = secondary_auth_key_hash
