# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AutoScaleConfiguration(Model):
    """AutoScale configuration properties.

    :param status: If auto-scale is enabled for all services. Each service can
     turn it off individually. Possible values include: 'Enabled', 'Disabled'.
     Default value: "Disabled" .
    :type status: str or ~azure.mgmt.machinelearningcompute.models.Status
    :param min_replicas: The minimum number of replicas for each service.
     Default value: 1 .
    :type min_replicas: int
    :param max_replicas: The maximum number of replicas for each service.
     Default value: 100 .
    :type max_replicas: int
    :param target_utilization: The target utilization.
    :type target_utilization: float
    :param refresh_period_in_seconds: Refresh period in seconds.
    :type refresh_period_in_seconds: int
    """

    _validation = {
        'min_replicas': {'minimum': 1},
        'max_replicas': {'minimum': 1},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'min_replicas': {'key': 'minReplicas', 'type': 'int'},
        'max_replicas': {'key': 'maxReplicas', 'type': 'int'},
        'target_utilization': {'key': 'targetUtilization', 'type': 'float'},
        'refresh_period_in_seconds': {'key': 'refreshPeriodInSeconds', 'type': 'int'},
    }

    def __init__(self, status="Disabled", min_replicas=1, max_replicas=100, target_utilization=None, refresh_period_in_seconds=None):
        self.status = status
        self.min_replicas = min_replicas
        self.max_replicas = max_replicas
        self.target_utilization = target_utilization
        self.refresh_period_in_seconds = refresh_period_in_seconds
