# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AcsClusterProperties(Model):
    """Information about the container service backing the cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar cluster_fqdn: The FQDN of the cluster.
    :vartype cluster_fqdn: str
    :param orchestrator_type: Type of orchestrator. It cannot be changed once
     the cluster is created. Possible values include: 'Kubernetes', 'None'
    :type orchestrator_type: str or
     ~azure.mgmt.machinelearningcompute.models.OrchestratorType
    :param orchestrator_properties: Orchestrator specific properties
    :type orchestrator_properties:
     ~azure.mgmt.machinelearningcompute.models.KubernetesClusterProperties
    :param system_services: The system services deployed to the cluster
    :type system_services:
     list[~azure.mgmt.machinelearningcompute.models.SystemService]
    :param master_count: The number of master nodes in the container service.
     Default value: 1 .
    :type master_count: int
    :param agent_count: The number of agent nodes in the Container Service.
     This can be changed to scale the cluster. Default value: 2 .
    :type agent_count: int
    :param agent_vm_size: The Azure VM size of the agent VM nodes. This cannot
     be changed once the cluster is created. This list is non exhaustive; refer
     to https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes
     for the possible VM sizes. Possible values include: 'Standard_A0',
     'Standard_A1', 'Standard_A2', 'Standard_A3', 'Standard_A4', 'Standard_A5',
     'Standard_A6', 'Standard_A7', 'Standard_A8', 'Standard_A9',
     'Standard_A10', 'Standard_A11', 'Standard_D1', 'Standard_D2',
     'Standard_D3', 'Standard_D4', 'Standard_D11', 'Standard_D12',
     'Standard_D13', 'Standard_D14', 'Standard_D1_v2', 'Standard_D2_v2',
     'Standard_D3_v2', 'Standard_D4_v2', 'Standard_D5_v2', 'Standard_D11_v2',
     'Standard_D12_v2', 'Standard_D13_v2', 'Standard_D14_v2', 'Standard_G1',
     'Standard_G2', 'Standard_G3', 'Standard_G4', 'Standard_G5',
     'Standard_DS1', 'Standard_DS2', 'Standard_DS3', 'Standard_DS4',
     'Standard_DS11', 'Standard_DS12', 'Standard_DS13', 'Standard_DS14',
     'Standard_GS1', 'Standard_GS2', 'Standard_GS3', 'Standard_GS4',
     'Standard_GS5'. Default value: "Standard_D3_v2" .
    :type agent_vm_size: str or
     ~azure.mgmt.machinelearningcompute.models.AgentVMSizeTypes
    """

    _validation = {
        'cluster_fqdn': {'readonly': True},
        'orchestrator_type': {'required': True},
        'master_count': {'maximum': 5, 'minimum': 1},
        'agent_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'cluster_fqdn': {'key': 'clusterFqdn', 'type': 'str'},
        'orchestrator_type': {'key': 'orchestratorType', 'type': 'str'},
        'orchestrator_properties': {'key': 'orchestratorProperties', 'type': 'KubernetesClusterProperties'},
        'system_services': {'key': 'systemServices', 'type': '[SystemService]'},
        'master_count': {'key': 'masterCount', 'type': 'int'},
        'agent_count': {'key': 'agentCount', 'type': 'int'},
        'agent_vm_size': {'key': 'agentVmSize', 'type': 'str'},
    }

    def __init__(self, orchestrator_type, orchestrator_properties=None, system_services=None, master_count=1, agent_count=2, agent_vm_size="Standard_D3_v2"):
        self.cluster_fqdn = None
        self.orchestrator_type = orchestrator_type
        self.orchestrator_properties = orchestrator_properties
        self.system_services = system_services
        self.master_count = master_count
        self.agent_count = agent_count
        self.agent_vm_size = agent_vm_size
