"""Use glget to print out the current state of the GL state machine"""
from OpenGL.GL.glget import *
from OpenGL.GL.constants import *
from OpenGL import error
from OpenGL.arrays import formathandler
formathandler.FormatHandler.chooseOutput( 'numpy' )

booleanTypes = [
	GL_CLIP_PLANE0,
	GL_CLIP_PLANE2,
	GL_CLIP_PLANE3,
	GL_CLIP_PLANE4,
	GL_LIGHT0,
	GL_CLIP_PLANE1,
	GL_LIGHT2,
	GL_CONVOLUTION_1D,
	GL_CONVOLUTION_2D,
	GL_SEPARABLE_2D,
	GL_LIGHT3,
	GL_LIGHT4,
	GL_CLIP_PLANE5,
	GL_COLOR_WRITEMASK,
	GL_HISTOGRAM,
	GL_LIGHT6,
	GL_MAP2_INDEX,
	GL_PACK_SWAP_BYTES,
	GL_LIGHT7,
	GL_MINMAX,
	GL_INDEX_MODE,
	GL_RGBA_MODE,
	GL_DOUBLEBUFFER,
	GL_POLYGON_OFFSET_FILL,
	GL_RESCALE_NORMAL,
	GL_TEXTURE_GEN_T,
	GL_STENCIL_TEST,
	GL_TEXTURE_GEN_S,
	GL_POINT_SMOOTH,
	GL_TEXTURE_GEN_R,
	GL_TEXTURE_GEN_Q,
	GL_SCISSOR_TEST,
	GL_VERTEX_ARRAY,
	GL_TEXTURE_3D,
	GL_NORMAL_ARRAY,
	GL_COLOR_ARRAY,
	GL_INDEX_ARRAY,
	GL_TEXTURE_COORD_ARRAY,
	GL_EDGE_FLAG_ARRAY,
	GL_UNPACK_SWAP_BYTES,
	GL_LIGHT5,
	GL_PACK_LSB_FIRST,
	GL_LIGHT1,
	GL_COLOR_TABLE,
	GL_POST_CONVOLUTION_COLOR_TABLE,
	GL_POST_COLOR_MATRIX_COLOR_TABLE,
	GL_MAP2_COLOR_4,
	GL_UNPACK_LSB_FIRST,
	GL_AUTO_NORMAL,
	GL_CURRENT_RASTER_POSITION_VALID,
	GL_MAP_COLOR,
	GL_MAP_STENCIL,
	GL_LINE_SMOOTH,
	GL_LINE_STIPPLE,
	GL_POLYGON_SMOOTH,
	GL_POLYGON_STIPPLE,
	GL_EDGE_FLAG,
	GL_CULL_FACE,
	GL_TEXTURE_2D,
	GL_POLYGON_OFFSET_POINT,
	GL_LIGHTING,
	GL_LIGHT_MODEL_TWO_SIDE,
	GL_COLOR_MATERIAL,
	GL_FOG,
	GL_DEPTH_TEST,
	GL_DEPTH_WRITEMASK,
	GL_TEXTURE_1D,
	GL_MAP1_COLOR_4,
	GL_MAP1_INDEX,
	GL_MAP1_NORMAL,
	GL_MAP1_TEXTURE_COORD_1,
	GL_MAP1_TEXTURE_COORD_2,
	GL_MAP1_TEXTURE_COORD_3,
	GL_MAP1_TEXTURE_COORD_4,
	GL_MAP1_VERTEX_3,
	GL_MAP1_VERTEX_4,
	GL_NORMALIZE,
	GL_INDEX_LOGIC_OP,
	GL_MAP2_NORMAL,
	GL_MAP2_TEXTURE_COORD_1,
	GL_MAP2_TEXTURE_COORD_2,
	GL_MAP2_TEXTURE_COORD_3,
	GL_MAP2_TEXTURE_COORD_4,
	GL_MAP2_VERTEX_3,
	GL_MAP2_VERTEX_4,
	GL_ALPHA_TEST,
	GL_DITHER,
	GL_BLEND,
	GL_POLYGON_OFFSET_LINE,
	GL_LIGHT_MODEL_LOCAL_VIEWER,
	GL_STEREO,
	GL_COLOR_LOGIC_OP
] # end booleanTypes
integerTypes = [
	GL_AUX_BUFFERS,
	GL_BLEND_EQUATION,
	GL_STENCIL_BITS,
	GL_MAX_EVAL_ORDER,
	GL_INDEX_CLEAR_VALUE,
	GL_INDEX_WRITEMASK,
	GL_PIXEL_MAP_I_TO_R_SIZE,
	GL_PIXEL_MAP_I_TO_G_SIZE,
	GL_RENDER_MODE,
	GL_PERSPECTIVE_CORRECTION_HINT,
	GL_POINT_SMOOTH_HINT,
	GL_LINE_SMOOTH_HINT,
	GL_POLYGON_SMOOTH_HINT,
	GL_FOG_HINT,
	GL_TEXTURE_BINDING_1D,
	GL_MAX_TEXTURE_SIZE,
	GL_TEXTURE_BINDING_3D,
	GL_PACK_SKIP_IMAGES,
	GL_PACK_IMAGE_HEIGHT,
	GL_MAX_3D_TEXTURE_SIZE,
	GL_COLOR_MATERIAL_PARAMETER,
	GL_VERTEX_ARRAY_TYPE,
	GL_CURRENT_INDEX,
	GL_NORMAL_ARRAY_TYPE,
	GL_NORMAL_ARRAY_STRIDE,
	GL_COLOR_ARRAY_SIZE,
	GL_COLOR_ARRAY_TYPE,
	GL_COLOR_ARRAY_STRIDE,
	GL_DRAW_BUFFER,
	GL_INDEX_ARRAY_TYPE,
	GL_INDEX_ARRAY_STRIDE,
	GL_TEXTURE_COORD_ARRAY_SIZE,
	GL_TEXTURE_COORD_ARRAY_TYPE,
	GL_TEXTURE_COORD_ARRAY_STRIDE,
	GL_EDGE_FLAG_ARRAY_STRIDE,
	GL_UNPACK_SKIP_IMAGES,
	GL_VERTEX_ARRAY_STRIDE,
	GL_UNPACK_IMAGE_HEIGHT,
	GL_NAME_STACK_DEPTH,
	GL_READ_BUFFER,
	GL_PACK_ROW_LENGTH,
	GL_PIXEL_MAP_I_TO_I_SIZE,
	GL_COLOR_MATRIX_STACK_DEPTH,
	GL_MAX_COLOR_MATRIX_STACK_DEPTH,
	GL_PIXEL_MAP_I_TO_B_SIZE,
	GL_PIXEL_MAP_I_TO_A_SIZE,
	GL_PIXEL_MAP_R_TO_R_SIZE,
	GL_PIXEL_MAP_G_TO_G_SIZE,
	GL_PIXEL_MAP_B_TO_B_SIZE,
	GL_PIXEL_MAP_A_TO_A_SIZE,
	GL_PACK_SKIP_ROWS,
	GL_VERTEX_ARRAY_SIZE,
	GL_ACTIVE_TEXTURE_ARB,
	GL_CLIENT_ACTIVE_TEXTURE_ARB,
	GL_MAX_TEXTURE_UNITS_ARB,
	GL_PACK_SKIP_PIXELS,
	GL_MAX_ELEMENTS_VERTICES,
	GL_MAX_ELEMENTS_INDICES,
	GL_UNPACK_ROW_LENGTH,
	GL_UNPACK_SKIP_ROWS,
	GL_UNPACK_SKIP_PIXELS,
	GL_UNPACK_ALIGNMENT,
	GL_SUBPIXEL_BITS,
	GL_STENCIL_WRITEMASK,
	GL_CURRENT_RASTER_INDEX,
	GL_INDEX_SHIFT,
	GL_INDEX_OFFSET,
	GL_LINE_STIPPLE_PATTERN,
	GL_LINE_STIPPLE_REPEAT,
	GL_MAX_LIST_NESTING,
	GL_PIXEL_MAP_S_TO_S_SIZE,
	GL_MAX_CLIP_PLANES,
	GL_LIST_MODE,
	GL_MAX_LIGHTS,
	GL_LIST_BASE,
	GL_LIST_INDEX,
	GL_MAX_PIXEL_MAP_TABLE,
	GL_MAX_ATTRIB_STACK_DEPTH,
	GL_MAX_MODELVIEW_STACK_DEPTH,
	GL_MAX_NAME_STACK_DEPTH,
	GL_MAX_PROJECTION_STACK_DEPTH,
	GL_MAX_TEXTURE_STACK_DEPTH,
	GL_MAX_VIEWPORT_DIMS,
	GL_MAX_CLIENT_ATTRIB_STACK_DEPTH,
	GL_POLYGON_MODE,
	GL_CULL_FACE_MODE,
	GL_FRONT_FACE,
	GL_INDEX_BITS,
	GL_GREEN_BITS,
	GL_BLUE_BITS,
	GL_ALPHA_BITS,
	GL_DEPTH_BITS,
	GL_ACCUM_RED_BITS,
	GL_ACCUM_GREEN_BITS,
	GL_ACCUM_BLUE_BITS,
	GL_ACCUM_ALPHA_BITS,
	GL_FOG_INDEX,
	GL_FOG_MODE,
	GL_STENCIL_CLEAR_VALUE,
	GL_STENCIL_FUNC,
	GL_DEPTH_FUNC,
	GL_PACK_ALIGNMENT,
	GL_STENCIL_PASS_DEPTH_FAIL,
	GL_STENCIL_PASS_DEPTH_PASS,
	GL_STENCIL_VALUE_MASK,
	GL_MATRIX_MODE,
	GL_MODELVIEW_STACK_DEPTH,
	GL_PROJECTION_STACK_DEPTH,
	GL_TEXTURE_STACK_DEPTH,
	GL_FEEDBACK_BUFFER_TYPE,
	GL_ATTRIB_STACK_DEPTH,
	GL_CLIENT_ATTRIB_STACK_DEPTH,
	GL_STENCIL_FAIL,
	GL_ALPHA_TEST_FUNC,
	GL_MAP1_GRID_SEGMENTS,
	GL_MAP2_GRID_SEGMENTS,
	GL_TEXTURE_BINDING_2D,
	GL_BLEND_DST,
	GL_BLEND_SRC,
	GL_RED_BITS,
	GL_LOGIC_OP_MODE,
	GL_FEEDBACK_BUFFER_SIZE,
	GL_SELECTION_BUFFER_SIZE,
	GL_LIGHT_MODEL_COLOR_CONTROL,
	GL_SHADE_MODEL,
	GL_COLOR_MATERIAL_FACE
] # end integerTypes
doubleTypes = [
	GL_BLEND_COLOR,
	GL_POST_CONVOLUTION_RED_SCALE,
	GL_POST_CONVOLUTION_GREEN_SCALE,
	GL_POST_CONVOLUTION_BLUE_SCALE,
	GL_COLOR_CLEAR_VALUE,
	GL_POLYGON_OFFSET_FACTOR,
	GL_POST_COLOR_MATRIX_RED_SCALE,
	GL_POST_COLOR_MATRIX_GREEN_SCALE,
	GL_POST_COLOR_MATRIX_BLUE_SCALE,
	GL_SCISSOR_BOX,
	GL_POST_COLOR_MATRIX_ALPHA_SCALE,
	GL_POST_COLOR_MATRIX_GREEN_BIAS,
	GL_POINT_SIZE,
	GL_ALIASED_POINT_SIZE_RANGE,
	GL_ALIASED_LINE_WIDTH_RANGE,
	GL_POINT_SIZE_RANGE,
	GL_POINT_SIZE_GRANULARITY,
	GL_POST_COLOR_MATRIX_BLUE_BIAS,
	GL_POST_COLOR_MATRIX_ALPHA_BIAS,
	GL_POST_CONVOLUTION_RED_BIAS,
	GL_POST_CONVOLUTION_GREEN_BIAS,
	GL_POST_CONVOLUTION_BLUE_BIAS,
	GL_POST_CONVOLUTION_ALPHA_BIAS,
	GL_MAP1_GRID_DOMAIN,
	GL_COLOR_MATRIX,
	GL_CURRENT_COLOR,
	GL_CURRENT_NORMAL,
	GL_CURRENT_TEXTURE_COORDS,
	GL_CURRENT_RASTER_COLOR,
	GL_CURRENT_RASTER_TEXTURE_COORDS,
	GL_CURRENT_RASTER_POSITION,
	GL_CURRENT_RASTER_DISTANCE,
	GL_RED_SCALE,
	GL_RED_BIAS,
	GL_ZOOM_X,
	GL_ZOOM_Y,
	GL_GREEN_SCALE,
	GL_GREEN_BIAS,
	GL_BLUE_SCALE,
	GL_BLUE_BIAS,
	GL_ALPHA_SCALE,
	GL_ALPHA_BIAS,
	GL_DEPTH_SCALE,
	GL_DEPTH_BIAS,
	GL_LINE_WIDTH,
	GL_LINE_WIDTH_RANGE,
	GL_LINE_WIDTH_GRANULARITY,
	GL_FOG_DENSITY,
	GL_FOG_START,
	GL_FOG_END,
	GL_FOG_COLOR,
	GL_DEPTH_RANGE,
	GL_DEPTH_CLEAR_VALUE,
	GL_ACCUM_CLEAR_VALUE,
	GL_STENCIL_REF,
	GL_POST_COLOR_MATRIX_RED_BIAS,
	GL_POLYGON_OFFSET_UNITS,
	GL_VIEWPORT,
	GL_MODELVIEW_MATRIX,
	GL_POST_CONVOLUTION_ALPHA_SCALE,
	GL_ALPHA_TEST_REF,
	GL_MAP2_GRID_DOMAIN,
	GL_TEXTURE_MATRIX,
	GL_PROJECTION_MATRIX,
	GL_LIGHT_MODEL_AMBIENT
] # end doubleTypes

stringTypes = [
	GL_VENDOR, 
	GL_RENDERER,
	GL_VERSION,
	GL_EXTENSIONS,
]


if __name__ == "__main__":
	from OpenGL.tests import testing_context
	testing_context.createPyGameContext()
	
	for callable, constants in [
		(glGetBoolean, booleanTypes),
		(glGetBooleanv, booleanTypes),
		(glGetInteger, integerTypes),
		(glGetIntegerv, integerTypes),
		(glGetDoublev, doubleTypes),
		(glGetString, stringTypes),
	]:
		print callable.__name__ 
		for constant in constants:
			try:
				value = callable( constant )
			except error.Error, err:
				print constant, err
			else:
				print constant, value, type(value)
				
		print
