# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ChaosScheduleDescription(Model):
    """Defines the Chaos Schedule used by Chaos and the version of the Chaos
    Schedule. The version value wraps back to 0 after surpassing 2,147,483,647.

    :param version: The version number of the Schedule.
    :type version: int
    :param schedule: Defines the schedule used by Chaos.
    :type schedule: ~azure.servicefabric.models.ChaosSchedule
    """

    _validation = {
        'version': {'minimum': 0},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'int'},
        'schedule': {'key': 'Schedule', 'type': 'ChaosSchedule'},
    }

    def __init__(self, **kwargs):
        super(ChaosScheduleDescription, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.schedule = kwargs.get('schedule', None)
