import os

from setuptools import setup, find_packages

def read(*paths):
    """Build a file path from *paths* and return the contents."""
    with open(os.path.join(*paths), 'r') as f:
        return f.read()

setup(
    name='business_calendar',
    version='0.2.1',
    description='Simple business days, including custom work week and a holiday list.',
    long_description=(read('README.rst') + '\n\n' +
                      read('HISTORY.rst')),
    url='https://github.com/antoniobotelho/py-business-calendar/',
    license='MIT',
    author='Antonio Botelho',
    author_email='antonio@inhames.com',
	packages=find_packages(exclude=['test*']),
    include_package_data=True,
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
	tests_require=['nose', 'python-dateutil'],
	test_suite='nose.collector'
)