## Additional information {#more_info}

### Creating additional forcer/predictable objects
Generating a new project creates a predictable object and a forcer object, if you need additional ones you can use 
the following dsf-cli commands that will inject it to the pipeline after the existing ones. 

Make sure that you are inside generated project folder: <br />
(cd my-new-project)

<br />
Creating a new forcer (will be automatically injected to pipeline after last existing forcer)

    dsf-cli g forcer my-new-forcer 

<br />
Creating a new predictable (will be automatically injected to pipeline after last existing predictable)

    dsf-cli g predictable my-new-predictable 

### Server endpoints
When the server is up it exposes a few endpoints:
    
 * http://localhost:8080/parse - Validates input based on input scheme and executes the pipeline. 
 * http://localhost:8080/predict - Validates input based on input scheme and executes the pipeline. 
 * http://localhost:8080/test - Runs an end to end test, triggered by the Data science portal. Initially performs a mock test
 * http://localhost:8080/livenessprobe - Server response test - returns "alive": True when server is alive.
 * http://localhost:8080/readinessprobe - Server readiness test - returns "ready": True when the server is ready for input.

### Ignore files
When a new project is generated, three ignore files should be present:

  * .gitignore - All files that shouldn't be in the repository must be added to this file. It is generated by the git init command
  * .dvcignore - All artifacts that aren't necessary for the service inference (Old models / vocabs, Research models, etc.) should be added to this file. Created by the dvc init command.
  * .dockerignore - This ignore file is managed as a "Whitelist", meaning that it will automatically ignore every file that is **not** listed. So, if you add files that are imperative for the service activity, please add them here, along with a **!** mark at the beginning. Will be created by the DsFramework upon project generation.

Please make sure that you use these files, as they greatly contribute to both readability and efficiency

### Additional commands
* **dsf-cli create-deploy-files** - deploy files generated automatically when creating new project this is an option to create all non exist deploy files, 

  * if deploy file was deleted by mistake you can recreate it 

  * if dsframework version was update with updated deploy files you can delete deploy files and recreate them

* **dsf-cli create-cloud-eval-files** - cloud eval files this is an option to create all non exist cloud eval files

### list of commands:
Display a list of all cli options:

    dsf-cli 