def get_PF_Results(trafo_vector_group):
    """
    Returns the PF loadflow results of the validation network for the given
    trafo vector groups. For info about the test network see runpp_3ph Validation.pfd
    """
    data_map = {"YNyn": 0,
                "Dyn": 1,
                "Yzn": 2}

    # Create lists to put in the PF loadflow results of the validation network
    bus_vm_pu = [[], [], []]

    # vm_pu     ->       L1           L2              L3
    # Bus #1 ExtGrid
    # Bus #2 TR1_HV
    # Bus #3 TR1_LV
    # Bus #4 Load A1
    # Bus #5 Load B1
    # Bus #6 Load B3
    # Bus #7 TR2_LV

    line_i_ka = [[], [], []]

    # i_ka          ->         L1_from, L2_from, L3_from, L1_to, L2_to, L3_to
    # Leitung #1 ExtGrid_TR1
    # Leitung #2 TR1_LoadA1
    # Leitung #3 TR2_LoadB1
    # Leitung #4 TR2_LoadB3

    trafo_i_ka = [[], [], []]

    # i_ka -> L1_hv, L2_hv, L3_hv, L1_lv, L2_lv, L3_lv
    # Trafo 1
    # Trafo 2

    bus_vm_pu[data_map['YNyn']] = [0.99999787338,	1.0000016161,	1.0000005105,
                                   0.99968050244,	0.99969237855,	0.99963282587,
                                   0.99705343554,	0.99746838183,	0.99718586395,
                                   0.9948995116,	0.99458439962,	0.98674300489,
                                   0.99395111068,	0.99418423529,	0.9863564418,
                                   0.97850425826,	0.99234507124,	0.99521892713,
                                   0.99742536231,	0.99837274406,	0.99814767609]

    line_i_ka[data_map['YNyn']] = [0.014003237709,	0.013578415289,	0.015018686616,	0.014052352411,	0.013615497541,	0.015055831313,
                                   0.045318234753,	0.087462622072,	0.13170744039,	0.045439631098,	0.087508398891,	0.13172221072,
                                   0.067006161071,	0.10938206657,	0.15377206679,	0.067102516557,	0.10942952686,	0.15379184651,
                                   0.24518449462,	0.11090275423,	0.15370539768,	0.24521447354,	0.1109479239,	0.15373201528]

    trafo_i_ka[data_map['YNyn']] = [0.014052351784,	0.013615496912,	0.015055830683,	0.34745891513,	0.3364754264,	0.37259351695,
                                    0.015806285559,	0.011022367484,	0.014341144957,	0.39152062339,	0.27144774298,	0.3546449925]

    bus_vm_pu[data_map['Dyn']] = [0.99999633365,	1.0000007177,	1.0000029487,
                                  0.99966300361,	0.99968280267,	0.99965990087,
                                  0.99703737513,	0.99745820246,	0.99721210683,
                                  0.99488339811,	0.99457396301,	0.98676946744,
                                  0.9939515775, 	0.99418757133,	0.98635265387,
                                  0.97850473318,	0.99234834683,	0.99521515379,
                                  0.99742581829,	0.99837603162,	0.99814393136]

    line_i_ka[data_map['Dyn']] = [0.014110688122,	0.01373849924,	0.014763703519,	0.014164968965,	0.013770898582,	0.014800144789,
                                  0.045318951491,	0.087463575817,	0.13170390089,	0.045440367054,	0.087509317164,	0.13171867828,
                                  0.067006134761,	0.1093816954,	0.1537726556,	0.067102485041,	0.10942915967,	0.15379243712,
                                  0.24518438107,	0.11090238404,	0.15370597872,	0.24521435453,	0.11094755768,	0.15373259815]

    trafo_i_ka[data_map['Dyn']] = [0.014164968341,	0.013770897951,	0.014800144159,	0.34746449192,	0.33647892194,	0.37258362522,
                                   0.01492317272,	0.012146394959,	0.014229967227,	0.39152039065,	0.27144661055,	0.35464662852]

    bus_vm_pu[data_map['Yzn']] = [0.99999633365,	1.0000007177,	1.0000029487,
                                  0.99966300361,	0.99968280267,	0.99965990087,
                                  0.99703737513,	0.99745820246,	0.99721210683,
                                  0.99488339811,	0.99457396301,	0.98676946744,
                                  0.9939515775, 	0.99418757133,	0.98635265387,
                                  0.97850473318,	0.99234834683,	0.99521515379,
                                  0.99742581829,	0.99837603162,	0.99814393136]

    line_i_ka[data_map['Yzn']] = [0.014110688122,	0.01373849924,	0.014763703519,	0.014164968965,	0.013770898582,	0.014800144789,
                                  0.045318951491,	0.087463575817,	0.13170390089,	0.045440367054,	0.087509317164,	0.13171867828,
                                  0.067006134761,	0.1093816954,	0.1537726556,	0.067102485041,	0.10942915967,	0.15379243712,
                                  0.24518438107,	0.11090238404,	0.15370597872,	0.24521435453,	0.11094755768,	0.15373259815]

    trafo_i_ka[data_map['Yzn']] = [0.014164968341,	0.013770897951,	0.014800144159,	0.34746449192,	0.33647892194,	0.37258362522,
                                   0.01492317272,	0.012146394959,	0.014229967227,	0.39152039065,	0.27144661055,	0.35464662852]

    return [bus_vm_pu[data_map[trafo_vector_group]],
            line_i_ka[data_map[trafo_vector_group]],
            trafo_i_ka[data_map[trafo_vector_group]]]
