from flopy.mbase import Package

class ModflowSwr1(Package):
    '''
    SWR1 class

    dataset4a_data
    '''
    def __init__(self, model, nreaches=0, iswrcb=0, dataset4a_data=None, 
        connectivity = None, 
        extension ='swr', unitnumber=36, options=[], naux=0):
        Package.__init__(self, model, extension, 'SWR', unitnumber) # Call ancestor's init to set self.parent, extension, name and unit number
        self.heading = '# SWR1 process for MODFLOW, generated by Flopy.'
        self.url = 'swr1.htm'
        self.iswrcb = iswrcb
        self.dataset4a_data = dataset4a_data
        self.mxactr = 0
        #self.mxactr, self.layer_row_column_data = self.assign_layer_row_column_data(layer_row_column_data, 6+naux)
        self.options = options
        self.parent.add_package(self)
    def __repr__( self ):
        return 'SRW1 class'
    def ncells( self):
        # Returns the  maximum number of cells that have SWR1 (developped for MT3DMS SSM package)
        #print 'Function must be implemented properly for swr1 package'
        return self.mxactr
    def write_file(self):
        print 'SWR1 write method not implemented yet' 
        #f_swr = open(self.fn_path, 'w')
        #f_swr.write('{0}\n'.format(self.heading))
        #f_swr.close()
