from App.class_init import InitializeClass
from AccessControl import ClassSecurityInfo
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.Field import StringField
from Products.Archetypes.Registry import registerField
from Products.Archetypes.Registry import registerPropertyType

from Products.ATExtensions.widget import CommentWidget

class CommentField(StringField):
    """specific field for URLs""" 
    _properties = StringField._properties.copy()
    _properties.update({
        'type' : 'comment',
        'comment' : ' ',
        'comment_type' : 'text/structured',
        'comment_msgid' : '',
        'widget' : CommentWidget,
        })
    security = ClassSecurityInfo()

    def get(self, instance, **kwargs):
        domain = self.widget.i18n_domain
        if self.comment_msgid:
            comment = instance.translate(domain=domain, msgid=self.comment_msgid, default=self.comment)
        else:
            comment = instance.translate(domain=domain, msgid=self.comment, default=self.comment)    
        transforms = getToolByName(instance, 'portal_transforms', None)
        if transforms is None:
            return comment
        return transforms.convertTo('text/html',
                                    comment,
                                    context=instance,
                                    mimetype=self.comment_type).getData()

    def set(self, instance, value, **kwargs):
        pass

InitializeClass(CommentField)

registerField(CommentField,
              title="Comment",
              description="Used for inserting comments into the views",
              )
registerPropertyType('comment', 'string', CommentField)
registerPropertyType('comment_type', 'string', CommentField)
