# coding: utf-8

"""
    OrderCloud

    A full ecommerce backend as a service.

    OpenAPI spec version: 0.1
    Contact: ordercloud@four51.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems
import re


class ShipmentItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, order_id=None, line_item_id=None, quantity_shipped=None):
        """
        ShipmentItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'order_id': 'str',
            'line_item_id': 'str',
            'quantity_shipped': 'int'
        }

        self.attribute_map = {
            'order_id': 'OrderID',
            'line_item_id': 'LineItemID',
            'quantity_shipped': 'QuantityShipped'
        }

        self._order_id = order_id
        self._line_item_id = line_item_id
        self._quantity_shipped = quantity_shipped

    @property
    def order_id(self):
        """
        Gets the order_id of this ShipmentItem.


        :return: The order_id of this ShipmentItem.
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """
        Sets the order_id of this ShipmentItem.


        :param order_id: The order_id of this ShipmentItem.
        :type: str
        """

        self._order_id = order_id

    @property
    def line_item_id(self):
        """
        Gets the line_item_id of this ShipmentItem.


        :return: The line_item_id of this ShipmentItem.
        :rtype: str
        """
        return self._line_item_id

    @line_item_id.setter
    def line_item_id(self, line_item_id):
        """
        Sets the line_item_id of this ShipmentItem.


        :param line_item_id: The line_item_id of this ShipmentItem.
        :type: str
        """

        self._line_item_id = line_item_id

    @property
    def quantity_shipped(self):
        """
        Gets the quantity_shipped of this ShipmentItem.


        :return: The quantity_shipped of this ShipmentItem.
        :rtype: int
        """
        return self._quantity_shipped

    @quantity_shipped.setter
    def quantity_shipped(self, quantity_shipped):
        """
        Sets the quantity_shipped of this ShipmentItem.


        :param quantity_shipped: The quantity_shipped of this ShipmentItem.
        :type: int
        """

        self._quantity_shipped = quantity_shipped

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
