# coding: utf-8

"""
    OrderCloud

    A full ecommerce backend as a service.

    OpenAPI spec version: 0.1
    Contact: ordercloud@four51.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class SpecApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create(self, spec, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create(spec, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Spec spec:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_with_http_info(spec, **kwargs)
        else:
            (data) = self.create_with_http_info(spec, **kwargs)
            return data

    def create_with_http_info(self, spec, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_with_http_info(spec, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Spec spec:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec' is set
        if ('spec' not in params) or (params['spec'] is None):
            raise ValueError("Missing the required parameter `spec` when calling `create`")

        resource_path = '/specs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'spec' in params:
            body_params = params['spec']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_option(self, spec_id, option, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_option(spec_id, option, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param SpecOption option:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_option_with_http_info(spec_id, option, **kwargs)
        else:
            (data) = self.create_option_with_http_info(spec_id, option, **kwargs)
            return data

    def create_option_with_http_info(self, spec_id, option, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_option_with_http_info(spec_id, option, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param SpecOption option:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'option']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_option" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `create_option`")
        # verify the required parameter 'option' is set
        if ('option' not in params) or (params['option'] is None):
            raise ValueError("Missing the required parameter `option` when calling `create_option`")

        resource_path = '/specs/{specID}/options'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'option' in params:
            body_params = params['option']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete(self, spec_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete(spec_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_with_http_info(spec_id, **kwargs)
        else:
            (data) = self.delete_with_http_info(spec_id, **kwargs)
            return data

    def delete_with_http_info(self, spec_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_with_http_info(spec_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `delete`")

        resource_path = '/specs/{specID}'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_option(self, spec_id, option_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_option(spec_id, option_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str option_id: ID of the option. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_option_with_http_info(spec_id, option_id, **kwargs)
        else:
            (data) = self.delete_option_with_http_info(spec_id, option_id, **kwargs)
            return data

    def delete_option_with_http_info(self, spec_id, option_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_option_with_http_info(spec_id, option_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str option_id: ID of the option. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'option_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_option" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `delete_option`")
        # verify the required parameter 'option_id' is set
        if ('option_id' not in params) or (params['option_id'] is None):
            raise ValueError("Missing the required parameter `option_id` when calling `delete_option`")

        resource_path = '/specs/{specID}/options/{optionID}'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']
        if 'option_id' in params:
            path_params['optionID'] = params['option_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_product_assignment(self, spec_id, product_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_product_assignment(spec_id, product_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str product_id: ID of the product. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_product_assignment_with_http_info(spec_id, product_id, **kwargs)
        else:
            (data) = self.delete_product_assignment_with_http_info(spec_id, product_id, **kwargs)
            return data

    def delete_product_assignment_with_http_info(self, spec_id, product_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_product_assignment_with_http_info(spec_id, product_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str product_id: ID of the product. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'product_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_product_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `delete_product_assignment`")
        # verify the required parameter 'product_id' is set
        if ('product_id' not in params) or (params['product_id'] is None):
            raise ValueError("Missing the required parameter `product_id` when calling `delete_product_assignment`")

        resource_path = '/specs/{specID}/productassignments/{productID}'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']
        if 'product_id' in params:
            path_params['productID'] = params['product_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get(self, spec_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get(spec_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_with_http_info(spec_id, **kwargs)
        else:
            (data) = self.get_with_http_info(spec_id, **kwargs)
            return data

    def get_with_http_info(self, spec_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_with_http_info(spec_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `get`")

        resource_path = '/specs/{specID}'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_option(self, spec_id, option_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_option(spec_id, option_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str option_id: ID of the option. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_option_with_http_info(spec_id, option_id, **kwargs)
        else:
            (data) = self.get_option_with_http_info(spec_id, option_id, **kwargs)
            return data

    def get_option_with_http_info(self, spec_id, option_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_option_with_http_info(spec_id, option_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str option_id: ID of the option. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'option_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_option" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `get_option`")
        # verify the required parameter 'option_id' is set
        if ('option_id' not in params) or (params['option_id'] is None):
            raise ValueError("Missing the required parameter `option_id` when calling `get_option`")

        resource_path = '/specs/{specID}/options/{optionID}'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']
        if 'option_id' in params:
            path_params['optionID'] = params['option_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str search: Word or phrase to search for.
        :param str search_on: Comma-delimited list of fields to search on.
        :param str sort_by: Comma-delimited list of fields to sort by.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_with_http_info(**kwargs)
        else:
            (data) = self.list_with_http_info(**kwargs)
            return data

    def list_with_http_info(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str search: Word or phrase to search for.
        :param str search_on: Comma-delimited list of fields to search on.
        :param str sort_by: Comma-delimited list of fields to sort by.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search', 'search_on', 'sort_by', 'page', 'page_size']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/specs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'search' in params:
            query_params['search'] = params['search']
        if 'search_on' in params:
            query_params['searchOn'] = params['search_on']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_options(self, spec_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_options(spec_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str search: Word or phrase to search for.
        :param str search_on: Comma-delimited list of fields to search on.
        :param str sort_by: Comma-delimited list of fields to sort by.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_options_with_http_info(spec_id, **kwargs)
        else:
            (data) = self.list_options_with_http_info(spec_id, **kwargs)
            return data

    def list_options_with_http_info(self, spec_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_options_with_http_info(spec_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str search: Word or phrase to search for.
        :param str search_on: Comma-delimited list of fields to search on.
        :param str sort_by: Comma-delimited list of fields to sort by.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'search', 'search_on', 'sort_by', 'page', 'page_size']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_options" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `list_options`")

        resource_path = '/specs/{specID}/options'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']

        query_params = {}
        if 'search' in params:
            query_params['search'] = params['search']
        if 'search_on' in params:
            query_params['searchOn'] = params['search_on']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_product_assignments(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_product_assignments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec.
        :param str product_id: ID of the product.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_product_assignments_with_http_info(**kwargs)
        else:
            (data) = self.list_product_assignments_with_http_info(**kwargs)
            return data

    def list_product_assignments_with_http_info(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_product_assignments_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec.
        :param str product_id: ID of the product.
        :param int page: Page of results to return. Default: 1
        :param int page_size: Number of results to return per page. Default: 20, max: 100.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'product_id', 'page', 'page_size']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_product_assignments" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/specs/productassignments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'spec_id' in params:
            query_params['specID'] = params['spec_id']
        if 'product_id' in params:
            query_params['productID'] = params['product_id']
        if 'page' in params:
            query_params['page'] = params['page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def patch(self, spec_id, spec, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch(spec_id, spec, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param Spec spec:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_with_http_info(spec_id, spec, **kwargs)
        else:
            (data) = self.patch_with_http_info(spec_id, spec, **kwargs)
            return data

    def patch_with_http_info(self, spec_id, spec, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_with_http_info(spec_id, spec, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param Spec spec:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'spec']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `patch`")
        # verify the required parameter 'spec' is set
        if ('spec' not in params) or (params['spec'] is None):
            raise ValueError("Missing the required parameter `spec` when calling `patch`")

        resource_path = '/specs/{specID}'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'spec' in params:
            body_params = params['spec']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def patch_option(self, spec_id, option_id, option, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_option(spec_id, option_id, option, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str option_id: ID of the option. (required)
        :param SpecOption option:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_option_with_http_info(spec_id, option_id, option, **kwargs)
        else:
            (data) = self.patch_option_with_http_info(spec_id, option_id, option, **kwargs)
            return data

    def patch_option_with_http_info(self, spec_id, option_id, option, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_option_with_http_info(spec_id, option_id, option, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str option_id: ID of the option. (required)
        :param SpecOption option:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'option_id', 'option']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_option" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `patch_option`")
        # verify the required parameter 'option_id' is set
        if ('option_id' not in params) or (params['option_id'] is None):
            raise ValueError("Missing the required parameter `option_id` when calling `patch_option`")
        # verify the required parameter 'option' is set
        if ('option' not in params) or (params['option'] is None):
            raise ValueError("Missing the required parameter `option` when calling `patch_option`")

        resource_path = '/specs/{specID}/options/{optionID}'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']
        if 'option_id' in params:
            path_params['optionID'] = params['option_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'option' in params:
            body_params = params['option']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def save_product_assignment(self, product_assignment, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_product_assignment(product_assignment, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SpecProductAssignment product_assignment:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.save_product_assignment_with_http_info(product_assignment, **kwargs)
        else:
            (data) = self.save_product_assignment_with_http_info(product_assignment, **kwargs)
            return data

    def save_product_assignment_with_http_info(self, product_assignment, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.save_product_assignment_with_http_info(product_assignment, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SpecProductAssignment product_assignment:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_assignment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_product_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_assignment' is set
        if ('product_assignment' not in params) or (params['product_assignment'] is None):
            raise ValueError("Missing the required parameter `product_assignment` when calling `save_product_assignment`")

        resource_path = '/specs/productassignments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'product_assignment' in params:
            body_params = params['product_assignment']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update(self, spec_id, spec, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update(spec_id, spec, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param Spec spec:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_with_http_info(spec_id, spec, **kwargs)
        else:
            (data) = self.update_with_http_info(spec_id, spec, **kwargs)
            return data

    def update_with_http_info(self, spec_id, spec, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_with_http_info(spec_id, spec, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param Spec spec:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'spec']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `update`")
        # verify the required parameter 'spec' is set
        if ('spec' not in params) or (params['spec'] is None):
            raise ValueError("Missing the required parameter `spec` when calling `update`")

        resource_path = '/specs/{specID}'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'spec' in params:
            body_params = params['spec']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_option(self, spec_id, option_id, option, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_option(spec_id, option_id, option, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str option_id: ID of the option. (required)
        :param SpecOption option:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_option_with_http_info(spec_id, option_id, option, **kwargs)
        else:
            (data) = self.update_option_with_http_info(spec_id, option_id, option, **kwargs)
            return data

    def update_option_with_http_info(self, spec_id, option_id, option, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_option_with_http_info(spec_id, option_id, option, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str spec_id: ID of the spec. (required)
        :param str option_id: ID of the option. (required)
        :param SpecOption option:  (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['spec_id', 'option_id', 'option']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_option" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'spec_id' is set
        if ('spec_id' not in params) or (params['spec_id'] is None):
            raise ValueError("Missing the required parameter `spec_id` when calling `update_option`")
        # verify the required parameter 'option_id' is set
        if ('option_id' not in params) or (params['option_id'] is None):
            raise ValueError("Missing the required parameter `option_id` when calling `update_option`")
        # verify the required parameter 'option' is set
        if ('option' not in params) or (params['option'] is None):
            raise ValueError("Missing the required parameter `option` when calling `update_option`")

        resource_path = '/specs/{specID}/options/{optionID}'.replace('{format}', 'json')
        path_params = {}
        if 'spec_id' in params:
            path_params['specID'] = params['spec_id']
        if 'option_id' in params:
            path_params['optionID'] = params['option_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'option' in params:
            body_params = params['option']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['auth']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
