# coding: utf-8

"""
    OrderCloud

    A full ecommerce backend as a service.

    OpenAPI spec version: 0.1
    Contact: ordercloud@four51.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

# import models into sdk package
from .models.address import Address
from .models.address_assignment import AddressAssignment
from .models.approval_rule import ApprovalRule
from .models.buyer import Buyer
from .models.buyer_address import BuyerAddress
from .models.buyer_credit_card import BuyerCreditCard
from .models.category import Category
from .models.category_assignment import CategoryAssignment
from .models.category_product_assignment import CategoryProductAssignment
from .models.cost_center import CostCenter
from .models.cost_center_assignment import CostCenterAssignment
from .models.credit_card import CreditCard
from .models.credit_card_assignment import CreditCardAssignment
from .models.email_template import EmailTemplate
from .models.impersonate_token_request import ImpersonateTokenRequest
from .models.line_item import LineItem
from .models.order import Order
from .models.partial1 import Partial1
from .models.password_reset import PasswordReset
from .models.password_reset_request import PasswordResetRequest
from .models.payment import Payment
from .models.payment_transaction import PaymentTransaction
from .models.price_break import PriceBreak
from .models.price_schedule import PriceSchedule
from .models.product import Product
from .models.product_assignment import ProductAssignment
from .models.promotion import Promotion
from .models.promotion_assignment import PromotionAssignment
from .models.shipment import Shipment
from .models.shipment_item import ShipmentItem
from .models.spec import Spec
from .models.spec_option import SpecOption
from .models.spec_product_assignment import SpecProductAssignment
from .models.spending_account import SpendingAccount
from .models.spending_account_assignment import SpendingAccountAssignment
from .models.user import User
from .models.user_group import UserGroup
from .models.user_group_assignment import UserGroupAssignment
from .models.variant import Variant

# import apis into sdk package
from .apis.address_api import AddressApi
from .apis.admin_user_api import AdminUserApi
from .apis.approval_rule_api import ApprovalRuleApi
from .apis.buyer_api import BuyerApi
from .apis.category_api import CategoryApi
from .apis.cost_center_api import CostCenterApi
from .apis.credit_card_api import CreditCardApi
from .apis.email_template_api import EmailTemplateApi
from .apis.file_api import FileApi
from .apis.line_item_api import LineItemApi
from .apis.me_api import MeApi
from .apis.order_api import OrderApi
from .apis.password_reset_api import PasswordResetApi
from .apis.payment_api import PaymentApi
from .apis.price_schedule_api import PriceScheduleApi
from .apis.product_api import ProductApi
from .apis.promotion_api import PromotionApi
from .apis.security_profile_api import SecurityProfileApi
from .apis.shipment_api import ShipmentApi
from .apis.spec_api import SpecApi
from .apis.spending_account_api import SpendingAccountApi
from .apis.user_api import UserApi
from .apis.user_group_api import UserGroupApi

# import ApiClient
from .api_client import ApiClient

from .configuration import Configuration

configuration = Configuration()

#import the auth class
from .configuration import Auth
auth = Auth()