# -*- coding: gbk -*-
import matplotlib
matplotlib.use("TKAgg")
from matplotlib.widgets import Button, RadioButtons
import matplotlib.pyplot as plt
import numpy as np
import os
import pandas as pd

from stock_plot import *
from data import *


def summary(data):
    '''docstring for plot_table''' 
    data_win = data[data.exit_profit>0]
    data_lose = data[data.exit_profit<0]
    zero_df = data[data.exit_profit==0]
    total_num = len(data)
    av_period = data['period'].mean()
    #plt.text(12,3.4,'Table Title',size=8)
    print "******************************************" 
    print u"ӯ: " + str(data_win.exit_profit.sum() * 300)
    print u"ܿ: " + str(data_lose.exit_profit.sum() * 300)
    print u": " + str((data.exit_profit.sum()) * 300)
    print "******************************************" 
    print u"״: " + str(total_num)
    print u"ӯ: " + str(len(data_win))
    print u": " + str(len(data_lose))
    print u"ƽ :%s" % str(data_win.exit_profit.sum()/ total_num*300)
    print u"ӯ: " + str(abs(data_win.exit_profit.sum()/len(data_win) / (data_lose.exit_profit.sum()/len(data_lose))))
    print u"ʤ: " + str(len(data_win)/float(total_num)*100) + "%" 
    print u"ƽֲ: " + str(av_period)
    print "******************************************" 


def simple_entry_analyze(fig, data, n):
    '''docstring for simple_entry_analyze(dat)''' 
    data2 = data
    entry_nbar_best = data2['entry_nbar_best']
    entry_nbar_worst = data2['entry_nbar_worst']
    return plot_simple_entry(fig, entry_nbar_best, entry_nbar_worst, n)


def entry_analyze(fig, data, n):
    '''볡Ϣͼ
    
    
        data: 
    ''' 
    # ordered by profits
    data2 = data.sort_index(by='exit_profit')

    data_long = data2[data2['islong']] # ǵƽҿƽһô˷
    data_short = data2[data2['islong'] == False]

    exit_profit = data2['exit_profit']
    entry_best = pd.concat([data_long.high_profit, data_short.low_profit]).reindex(data2.index)
    entry_worst = pd.concat([data_long.low_profit, data_short.high_profit]).reindex(data2.index)
    try:
        entry_nbar_best = data2['entry_nbar_best']
        entry_nbar_worst = data2['entry_nbar_worst']
    except Exception, e:
        entry_nbar_best = []
        entry_nbar_worst = []
        

    return plot_entry(fig, exit_profit, entry_best, entry_worst, entry_nbar_best, entry_nbar_worst, n)


def exit_analyze(fig, data, n):
    '''Ϣͼ''' 
    # ordered by profits
    data2 = data.sort_index(by='exit_profit')
    exit_profit = data2['exit_profit']
    try:
        exit_nbar_best = data2['exit_nbar_best']
        exit_nbar_worst = data2['exit_nbar_worst']
        profits_more = exit_nbar_best - exit_profit
        risks = exit_nbar_worst - exit_profit
        return  plot_exit(fig, exit_profit, exit_nbar_best, exit_nbar_worst, profits_more, risks, n)
    except Exception, e:
        return [], []


def scatter_analyze(fig, data):
    '''׷ֲͼ''' 
    data_win = data[data.exit_profit>0]
    data_lose = data[data.exit_profit<0]
    return  plot_scatter(fig, data_win.period.tolist(), data_win.exit_profit.tolist(),
                            data_lose.period.tolist(),
                            data_lose.exit_profit.tolist(), 30)



# Entry analyze
def summary_analyze(fig, data, n, type_):
    ''' Ϣ '''
    print "prepare plotting.." 
    cursors = []
    # ordered by profits
    data = data.sort_index(by='exit_profit')
    data_long = data[data['islong']] # ǵƽҿƽһô˷
    data_short = data[data['islong'] == False]

    exit_profit = data['exit_profit']
    entry_best = pd.concat([data_long.high_profit, data_short.low_profit]).reindex(data.index)
    entry_worst = pd.concat([data_long.low_profit, data_short.high_profit]).reindex(data.index)
    try:
        entry_nbar_best = data['entry_nbar_best']
        entry_nbar_worst = data['entry_nbar_worst']
        exit_nbar_best = data['exit_nbar_best']
        exit_nbar_worst = data['exit_nbar_worst']
        profits_more = exit_nbar_best - exit_profit
        risks = exit_nbar_worst - exit_profit
    except Exception, e:
        entry_nbar_best = pd.Series()
        entry_nbar_worst = pd.Series()
        exit_nbar_best = pd.Series()
        exit_nbar_worst = pd.Series()
        profits_more = pd.Series()
        risks = pd.Series()
        print "No nbar!" 
    rtns = data['return']
    data_win = data[data.exit_profit>0]
    data_lose = data[data.exit_profit<=0]
    print "begin plotting.." 
    # summary
    #cursors.append(cursor)

    #fig, cursor = plot_summary2(rtns, entry_best, data_win, data_lose, exit_profit,exit_nbar_best, exit_nbar_worst, n)
    #cursors.append(cursor)
    print "***8888888*********" 
    print n
    if type_ == 1:
        return plot_summary(fig, exit_profit, entry_best, entry_worst, entry_nbar_best, entry_nbar_worst,
                                        exit_nbar_best, exit_nbar_worst, profits_more, risks, n)
    elif type_ == 2:
        return plot_summary2(fig, rtns, entry_best, data_win, data_lose, exit_profit,exit_nbar_best, exit_nbar_worst, n)


def compare_analyze(datas, colors=['r'], names=[]):
    '''ԱȽ''' 
    NBAR = len(datas[0].ix[0, 'entry_0':'entry_N'])-2
    print "prepare plotting.." 
    figs = []
    axes = []

    exit_profits = []
    entry_bests = []
    entry_worsts = []
    entry_nbar_bests = []
    entry_nbar_worsts = []
    exit_nbar_bests = []
    exit_nbar_worsts = []
    profits_mores = []
    risks = []

    # ordered by profits
    for data in datas:
        data = data.sort_index(by='exit_profit')
        data_long = data[data.high_profit>data.low_profit] # ǵƽҿƽһô˷
        data_short = data[data.high_profit<=data.low_profit]
        exit_profit = data['exit_profit']
        entry_best = pd.concat([data_long.high_profit, data_short.low_profit]).reindex(data.index)
        entry_worst = pd.concat([data_long.low_profit, data_short.high_profit]).reindex(data.index)
        entry_nbar_best = data['entry_nbar_best']
        entry_nbar_worst = data['entry_nbar_worst']
        exit_nbar_best = data['exit_nbar_best']
        exit_nbar_worst = data['exit_nbar_worst']
        profits_more = exit_nbar_best - exit_profit
        risk = exit_nbar_worst - exit_profit

        exit_profits.append(exit_profit)
        entry_bests.append(entry_best)
        entry_worsts.append(entry_worst)
        entry_nbar_bests.append(entry_nbar_best)
        entry_nbar_worsts.append(entry_nbar_worst)
        exit_nbar_bests.append(exit_nbar_best)
        exit_nbar_worsts.append(exit_nbar_worst)
        profits_mores.append(profits_more)
        risks.append(risk)

    # compare
    fig, ax = plot_compare(exit_profits, entry_bests, entry_worsts, entry_nbar_bests, entry_nbar_worsts,
                            exit_nbar_bests, exit_nbar_worsts, profits_mores, risks, colors, names, NBAR)
    figs.append(fig)
    axes.append(ax)
    plt.show()
    return figs, axes

"""
deal_tradeinfoͳݣ
ȻanalyzeʾҪݣ
stock_plotĺͼ
"""
class AnalyzeFrame(object):
    """
    A slider representing a floating point range

    """
    def __init__(self, fname, n=10, intraday=False):
        """ """
        self.fig = plt.figure(facecolor='white')
        self.fig.canvas.set_window_title(u'ڻݷ')
        self.nbar = n
        self.cursors = []
        self.data, = load_datas(n, intraday, fname)
        print self.data
        self.axes = []
        self.rax = plt.axes([0, 0.5, 0.08, 0.15])
        self.radio = RadioButtons(self.rax, ('scatter', 'summary', 'summary2', 'entry', 'exit', 'simple'), active=0)
        self.axes, self.cursors = scatter_analyze(self.fig, self.data)
        self.radio.on_clicked(self.update)

    def update(self, op):
        for ax in self.axes:
            self.fig.delaxes(ax)
        for c in self.cursors:
            del c
        if op == "scatter":
            print("scatter_analyze")
            self.axes, self.cursors = scatter_analyze(self.fig, self.data)
        elif op == "summary":
            print("summary_analyze")
            self.axes, self.cursors = summary_analyze(self.fig, self.data, self.nbar, 1)
        elif op == "summary2":
            print("summary2_analyze")
            self.axes, self.cursors = summary_analyze(self.fig, self.data, self.nbar, 2)
        elif op == "entry":
            print("entry_analyze") 
            self.axes, self.cursors = entry_analyze(self.fig, self.data, self.nbar)
        elif op == "exit":
            print("exit_analyze")
            self.axes, self.cursors = exit_analyze(self.fig, self.data, self.nbar)
        elif op == "simple":
            self.axes, self.cursors = simple_entry_analyze(self.fig, self.data, self.nbar)
        self.fig.canvas.draw()
