# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TimeZoneTimeZoneInformation(Model):
    """Defines a date and time for a geographical location.

    :param location: The name of the geographical location.For example,
     County; City; City, State; City, State, Country; or Time Zone.
    :type location: str
    :param time: The data and time specified in the form,
     YYYY-MM-DDThh;mm:ss.ssssssZ.
    :type time: str
    :param utc_offset: The offset from UTC. For example, UTC-7.
    :type utc_offset: str
    """

    _validation = {
        'location': {'required': True},
        'time': {'required': True},
        'utc_offset': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'time': {'key': 'time', 'type': 'str'},
        'utc_offset': {'key': 'utcOffset', 'type': 'str'},
    }

    def __init__(self, location, time, utc_offset):
        super(TimeZoneTimeZoneInformation, self).__init__()
        self.location = location
        self.time = time
        self.utc_offset = utc_offset
