#!/usr/bin/env python
import os
import sys
from unittest import defaultTestLoader, TextTestRunner, TestSuite
try:
    from importlib import import_module
except ImportError:
    def import_module(path):
        x = path.rsplit('.', 1)
        basemod = __import__(x[0], None, None, [x[-1]], 0)
        if len(x) > 1:
            try:
                return getattr(basemod, x[1])
            except AttributeError:
                raise ImportError("module '%s' does not have component '%s'" % (x[0], x[1]))
        else:
            return basemod


TESTS = ('test_basic', 'test_timezone')


def make_suite(prefix='tests.', extra=(), force_all=False):
    tests = TESTS + extra
    test_names = list(prefix + x for x in tests)
    suite = TestSuite()
    for name in test_names:
        module = import_module(name)
        suite.addTest(defaultTestLoader.loadTestsFromModule(module))
    return suite


def additional_tests():
    """
    This is called automatically by setup.py test
    """
    return make_suite('tests.')


def main():
    my_dir = os.path.dirname(os.path.abspath(__file__))
    sys.path.insert(0, os.path.abspath(os.path.join(my_dir, '..')))

    from optparse import OptionParser
    parser = OptionParser()
    parser.add_option('--with-pep8', action='store_true', dest='with_pep8', default=False)
    parser.add_option('--force-all', action='store_true', dest='force_all', default=False)
    parser.add_option('-v', '--verbose', action='count', dest='verbosity', default=0)
    parser.add_option('-q', '--quiet', action='count', dest='quietness', default=0)
    options, extra_args = parser.parse_args()
    has_pep8 = False
    try:
        import pep8
        has_pep8 = True
    except ImportError:
        if options.with_pep8:
            sys.stderr.write('# Could not find pep8 library.')
            sys.exit(1)

    if has_pep8:
        guide_main = pep8.StyleGuide(
            ignore=[],
            paths=['wtforms_django/'],
            exclude=[],
            max_line_length=130,
        )
        guide_tests = pep8.StyleGuide(
            ignore=['E221'],
            paths=['tests/'],
            max_line_length=150,
        )
        for guide in (guide_main, guide_tests):
            report = guide.check_files()
            if report.total_errors:
                sys.exit(1)

    suite = make_suite('tests.', tuple(extra_args), options.force_all)

    runner = TextTestRunner(verbosity=options.verbosity - options.quietness + 1)
    result = runner.run(suite)
    sys.exit(not result.wasSuccessful())

if __name__ == '__main__':
    main()
