# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class WorkflowAccessKey(SubResource):
    """WorkflowAccessKey.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Gets or sets the resource id.
    :type id: str
    :param not_before: Gets or sets the not-before time.
    :type not_before: datetime
    :param not_after: Gets or sets the not-after time.
    :type not_after: datetime
    :ivar name: Gets the workflow access key name.
    :vartype name: str
    :ivar type: Gets the workflow access key type.
    :vartype type: str
    """ 

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'not_before': {'key': 'properties.notBefore', 'type': 'iso-8601'},
        'not_after': {'key': 'properties.notAfter', 'type': 'iso-8601'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, id=None, not_before=None, not_after=None):
        super(WorkflowAccessKey, self).__init__(id=id)
        self.not_before = not_before
        self.not_after = not_after
        self.name = None
        self.type = None
