/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlStatement;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcHintClause;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsConnection;
import oracle.pg.rdbms.pgql.jdbc.PgqlJdbcRdbmsResultSet;
import oracle.pgql.lang.PgqlException;

public class PgqlJdbcRdbmsStatement
implements Statement {
    private PgqlConnection pgqlConn;
    private PgqlJdbcRdbmsConnection conn;
    private PgqlJdbcRdbmsResultSet currentResultSet;
    private PgqlStatement currentStatement;
    private int queryTimeout = 60;

    public PgqlJdbcRdbmsStatement(PgqlJdbcRdbmsConnection conn) {
        this.conn = conn;
        this.pgqlConn = conn.getPgqlConnection();
    }

    @Override
    public void close() throws SQLException {
        if (this.currentStatement != null) {
            try {
                this.currentStatement.close();
            }
            catch (PgqlException e) {
                throw new SQLException(e);
            }
            finally {
                this.currentStatement = null;
            }
        }
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
            this.currentResultSet = null;
        }
    }

    @Override
    public ResultSet executeQuery(String pgql) throws SQLException {
        this.execute(pgql);
        return this.currentResultSet;
    }

    @Override
    public boolean execute(String pgql) throws SQLException {
        boolean executeResult = false;
        try {
            if (this.currentResultSet != null || this.currentStatement != null) {
                this.close();
            }
            PgqlStatement stmt = this.pgqlConn.createStatement();
            PgqlJdbcHintClause hint = PgqlJdbcHintClause.parse(pgql);
            String options = this.conn.getAutoCommit() ? "AUTO_COMMIT=T," + hint.getOptions() : "AUTO_COMMIT=F," + hint.getOptions();
            executeResult = stmt.execute(pgql, hint.getParallelDop(), hint.getDynamicSamplingLevel(), hint.getMatchOptions(), options);
            this.currentStatement = stmt;
            PgqlResultSet rs = stmt.getResultSet();
            this.currentResultSet = new PgqlJdbcRdbmsResultSet(rs);
            return executeResult;
        }
        catch (PgqlToSqlException | PgqlException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        PgqlJdbcRdbmsResultSet rs = this.currentResultSet;
        this.currentResultSet = null;
        return rs;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.currentStatement == null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (!this.isClosed()) {
            this.currentStatement.setFetchSize(rows);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (!this.isClosed()) {
            return this.currentStatement.getFetchSize();
        }
        return 0;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new UnsupportedOperationException("int executeUpdate(String sql) not yet supported.");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException("int getMaxFieldSize() not yet supported.");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException("void setMaxFieldSize(int max) not yet supported.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new UnsupportedOperationException("int getMaxRows() not yet supported.");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException("void setMaxRows(int max) not yet supported.");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException("void setEscapeProcessing(boolean enable) not yet supported.");
    }

    @Override
    public void cancel() throws SQLException {
        throw new UnsupportedOperationException("void cancel() not yet supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("SQLWarning getWarnings() not yet supported.");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("void clearWarnings() not yet supported.");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException("void setCursorName(String name) not yet supported.");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new UnsupportedOperationException("int getUpdateCount() not yet supported.");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException("boolean getMoreResults() not yet supported.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("void setFetchDirection(int direction) not yet supported.");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException("int getResultSetConcurrency() not yet supported.");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException("void addBatch(String sql) not yet supported.");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException("void clearBatch() not yet supported.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException("int[] executeBatch() not yet supported.");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("boolean getMoreResults(int current) not yet supported.");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("ResultSet getGeneratedKeys() not yet supported.");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("int executeUpdate(String sql, int autoGeneratedKeys) not yet supported.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("int executeUpdate(String sql, int[] columnIndexes) not yet supported.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("int executeUpdate(String sql, String[] columnNames) not yet supported.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException("boolean execute(String sql, int autoGeneratedKeys) not yet supported.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException("boolean execute(String sql, int[] columnIndexes) not yet supported.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException("boolean execute(String sql, String[] columnNames) not yet supported.");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("int getResultSetHoldability() not yet supported.");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException("void setPoolable(boolean poolable) not yet supported.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("boolean isPoolable() not yet supported.");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("void closeOnCompletion() not yet supported.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("boolean isCloseOnCompletion() not yet supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("<T> T unwrap(Class<T> iface) not yet supported.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("not yet supported.");
    }
}

