/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.util;

import java.io.IOException;
import javax.annotation.Nullable;
import org.spoofax.terms.util.StringEscaper;

public final class CStringEscaper
implements StringEscaper {
    private final boolean escapeSingleQuote;
    private final boolean escapeDoubleQuote;
    private final boolean strictUnescape;

    public CStringEscaper() {
        this(true, true, true);
    }

    public CStringEscaper(boolean escapeSingleQuote, boolean escapeDoubleQuote, boolean strictUnescape) {
        this.escapeSingleQuote = escapeSingleQuote;
        this.escapeDoubleQuote = escapeDoubleQuote;
        this.strictUnescape = strictUnescape;
    }

    @Override
    public boolean appendEscape(@Nullable String unescapedInput, Appendable writer) throws IOException {
        if (unescapedInput == null) {
            writer.append(null);
            return false;
        }
        boolean escaped = false;
        int i = 0;
        while (i < unescapedInput.length()) {
            char c = unescapedInput.charAt(i);
            switch (c) {
                case '\u0000': {
                    writer.append("\\0");
                    escaped = true;
                    break;
                }
                case '\u0007': {
                    writer.append("\\a");
                    escaped = true;
                    break;
                }
                case '\b': {
                    writer.append("\\b");
                    escaped = true;
                    break;
                }
                case '\t': {
                    writer.append("\\t");
                    escaped = true;
                    break;
                }
                case '\n': {
                    writer.append("\\n");
                    escaped = true;
                    break;
                }
                case '\u000b': {
                    writer.append("\\v");
                    escaped = true;
                    break;
                }
                case '\f': {
                    writer.append("\\f");
                    escaped = true;
                    break;
                }
                case '\r': {
                    writer.append("\\r");
                    escaped = true;
                    break;
                }
                case '\u001b': {
                    writer.append("\\e");
                    escaped = true;
                    break;
                }
                case '\'': {
                    if (this.escapeSingleQuote) {
                        writer.append("\\'");
                        escaped = true;
                        break;
                    }
                    writer.append(c);
                    break;
                }
                case '\"': {
                    if (this.escapeDoubleQuote) {
                        writer.append("\\\"");
                        escaped = true;
                        break;
                    }
                    writer.append(c);
                    break;
                }
                case '\\': {
                    writer.append("\\\\");
                    escaped = true;
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        writer.append("\\u").append(String.format("%04x", c));
                        escaped = true;
                        break;
                    }
                    writer.append(c);
                }
            }
            ++i;
        }
        return escaped;
    }

    @Override
    public boolean appendUnescape(@Nullable String escapedInput, Appendable writer) throws IOException {
        if (escapedInput == null) {
            writer.append(null);
            return false;
        }
        boolean unescaped = false;
        int i = 0;
        while (i < escapedInput.length()) {
            char c = escapedInput.charAt(i);
            if (c != '\\') {
                writer.append(c);
            } else if (i == escapedInput.length() - 1) {
                if (this.strictUnescape) {
                    throw new IllegalArgumentException("Prematurely terminated escape sequence '\\' at offset " + i + " in string: " + escapedInput);
                }
                writer.append(c);
            } else {
                char c0 = escapedInput.charAt(++i);
                switch (c0) {
                    case 'a': {
                        writer.append("\u0007");
                        unescaped = true;
                        break;
                    }
                    case 'b': {
                        writer.append("\b");
                        unescaped = true;
                        break;
                    }
                    case 't': {
                        writer.append("\t");
                        unescaped = true;
                        break;
                    }
                    case 'n': {
                        writer.append("\n");
                        unescaped = true;
                        break;
                    }
                    case 'v': {
                        writer.append("\u000b");
                        unescaped = true;
                        break;
                    }
                    case 'f': {
                        writer.append("\f");
                        unescaped = true;
                        break;
                    }
                    case 'r': {
                        writer.append("\r");
                        unescaped = true;
                        break;
                    }
                    case 'e': {
                        writer.append("\u001b");
                        unescaped = true;
                        break;
                    }
                    case '\'': {
                        writer.append("'");
                        unescaped = true;
                        break;
                    }
                    case '\"': {
                        writer.append("\"");
                        unescaped = true;
                        break;
                    }
                    case '\\': {
                        writer.append("\\");
                        unescaped = true;
                        break;
                    }
                    case '8': 
                    case '9': {
                        if (this.strictUnescape) {
                            throw new IllegalArgumentException("Non-octal digit '\\" + c0 + "' at offset " + i + " in string: " + escapedInput);
                        }
                        writer.append(c0);
                        break;
                    }
                    case 'x': {
                        int read = this.appendHexCodepointAt(escapedInput, i + 1, -1, 'x', writer);
                        if (read > 0) {
                            i += read;
                            unescaped = true;
                            break;
                        }
                        writer.append(c0);
                        break;
                    }
                    case 'u': {
                        int read = this.appendHexCodepointAt(escapedInput, i + 1, 4, 'u', writer);
                        if (read > 0) {
                            i += read;
                            unescaped = true;
                            break;
                        }
                        writer.append(c0);
                        break;
                    }
                    case 'U': {
                        int read = this.appendHexCodepointAt(escapedInput, i + 1, 8, 'U', writer);
                        if (read > 0) {
                            i += read;
                            unescaped = true;
                            break;
                        }
                        writer.append(c0);
                        break;
                    }
                    default: {
                        if (!CStringEscaper.isOctDigit(c0)) {
                            if (this.strictUnescape) {
                                throw new IllegalArgumentException("Unrecognized escape sequence '\\" + c0 + "' at offset " + i + " in string: " + escapedInput);
                            }
                            writer.append(c0);
                            break;
                        }
                        int read = this.appendOctCodepointAt(escapedInput, i, 3, writer);
                        if (read > 0) {
                            i += read - 1;
                            unescaped = true;
                            break;
                        }
                        writer.append(c0);
                    }
                }
            }
            ++i;
        }
        return unescaped;
    }

    private int appendOctCodepointAt(String input, int index, int maxLength, Appendable writer) throws IOException {
        assert (maxLength > 0) : "Zero or negative (unlimited) length is not supported by this implementation.";
        maxLength = Math.min(maxLength, input.length() - index);
        StringBuilder octStrBuilder = new StringBuilder(maxLength);
        int i = 0;
        while (i < maxLength) {
            char c = input.charAt(index + i);
            if (!CStringEscaper.isOctDigit(c)) break;
            octStrBuilder.append(c);
            ++i;
        }
        String octStr = octStrBuilder.toString();
        assert (octStr.length() > 0);
        if (octStr.length() == 1) {
            writer.append((char)(octStr.charAt(0) - 48));
            return 1;
        }
        int codepoint = Integer.parseInt(octStr, 8);
        try {
            writer.append(String.valueOf(Character.toChars(codepoint)));
        }
        catch (IllegalArgumentException e) {
            if (this.strictUnescape) {
                throw new IllegalArgumentException("Escape sequence designates invalid Unicode code point '\\" + octStr + "' at offset " + index + " in string: " + input);
            }
            return 0;
        }
        return octStrBuilder.length();
    }

    private int appendHexCodepointAt(String input, int index, int length, char prefix, Appendable writer) {
        int codepoint;
        if (length >= 0 && index + length > input.length()) {
            if (this.strictUnescape) {
                throw new IllegalArgumentException("Prematurely terminated escape sequence '\\" + prefix + input.substring(index) + "' at offset " + index + " in string: " + input);
            }
            return 0;
        }
        int maxLength = length >= 0 ? length : input.length() - index;
        StringBuilder hexStrBuilder = new StringBuilder(length >= 0 ? length : 4);
        int i = 0;
        while (i < maxLength) {
            char c = input.charAt(index + i);
            if (!CStringEscaper.isHexDigit(c)) break;
            hexStrBuilder.append(c);
            ++i;
        }
        String hexStr = hexStrBuilder.toString();
        if (hexStr.length() == 0 || length >= 0 && hexStr.length() != length) {
            if (this.strictUnescape) {
                throw new IllegalArgumentException("Prematurely terminated escape sequence '\\" + prefix + hexStr + "' at offset " + index + " in string: " + input);
            }
            return 0;
        }
        try {
            codepoint = Integer.parseInt(hexStr, 16);
        }
        catch (NumberFormatException e) {
            if (this.strictUnescape) {
                throw new IllegalArgumentException("Escape sequence designates Unicode code point out of bounds '\\" + prefix + hexStrBuilder.toString() + "' at offset " + index + " in string: " + input);
            }
            return 0;
        }
        try {
            writer.append(String.valueOf(Character.toChars(codepoint)));
        }
        catch (IOException | IllegalArgumentException e) {
            if (this.strictUnescape) {
                throw new IllegalArgumentException("Escape sequence designates invalid Unicode code point '\\" + prefix + hexStrBuilder.toString() + "' at offset " + index + " in string: " + input);
            }
            return 0;
        }
        return hexStrBuilder.length();
    }

    private static boolean isDecDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexDigit(char c) {
        return CStringEscaper.isDecDigit(c) || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isOctDigit(char c) {
        return c >= '0' && c <= '7';
    }
}

