/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io.binary;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.TermUtils;

class SAFReader {
    private static final int ISSHAREDFLAG = 128;
    private static final int TYPEMASK = 15;
    private static final int ANNOSFLAG = 16;
    private static final int ISFUNSHARED = 64;
    private static final int APPLQUOTED = 32;
    private static final int INITIALSHAREDTERMSARRAYSIZE = 1024;
    private static final int STACKSIZE = 256;
    private final ITermFactory factory;
    private int sharedTermIndex;
    private IStrategoTerm[] sharedTerms;
    private List<StrategoSignature> applSignatures;
    private ATermConstruct[] stack;
    private int stackPosition;
    private int tempType = -1;
    private byte[] tempBytes = null;
    private int tempBytesIndex = 0;
    private int tempArity = -1;
    private boolean tempIsQuoted = false;
    private ByteBuffer currentBuffer;
    private boolean isDone = false;
    private final boolean debug = false;
    private static final int SEVENBITS = 127;
    private static final int SIGNBIT = 128;
    private static final int BYTEMASK = 255;
    private static final int BYTEBITS = 8;
    private static final int LONGBITS = 8;

    public SAFReader(ITermFactory factory) {
        this.factory = factory;
        this.sharedTerms = new IStrategoTerm[1024];
        this.applSignatures = new ArrayList<StrategoSignature>();
        this.sharedTermIndex = 0;
        this.stack = new ATermConstruct[256];
        this.stackPosition = -1;
    }

    private void ensureSharedTermsCapacity() {
        int sharedTermsArraySize = this.sharedTerms.length;
        if (this.sharedTermIndex + 1 >= sharedTermsArraySize) {
            IStrategoTerm[] newSharedTermsArray = new IStrategoTerm[sharedTermsArraySize << 1];
            System.arraycopy(this.sharedTerms, 0, newSharedTermsArray, 0, sharedTermsArraySize);
            this.sharedTerms = newSharedTermsArray;
        }
    }

    public void deserialize(ByteBuffer buffer) {
        this.currentBuffer = buffer;
        if (this.tempType != -1) {
            this.readData();
        }
        while (buffer.hasRemaining()) {
            byte header = buffer.get();
            if ((header & 0x80) == 128) {
                int index = this.readInt();
                IStrategoTerm term = this.sharedTerms[index];
                ++this.stackPosition;
                this.linkTerm(term);
            } else {
                int type = header & 0xF;
                ATermConstruct ac = new ATermConstruct();
                ac.type = type;
                ac.hasAnnos = (header & 0x10) == 16;
                ++this.sharedTermIndex;
                ac.termIndex = ac.termIndex;
                this.ensureSharedTermsCapacity();
                this.stack[++this.stackPosition] = ac;
                switch (type) {
                    case 1: {
                        this.touchAppl(header);
                        break;
                    }
                    case 4: {
                        this.touchList();
                        break;
                    }
                    case 2: {
                        this.touchInt();
                        break;
                    }
                    case 3: {
                        this.touchReal();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown type id: " + type + ". Current buffer position: " + this.currentBuffer.position());
                    }
                }
            }
            this.ensureStackCapacity();
        }
    }

    private void ensureStackCapacity() {
        int stackSize = this.stack.length;
        if (this.stackPosition + 1 >= stackSize) {
            ATermConstruct[] newStack = new ATermConstruct[stackSize << 1];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
    }

    public boolean isDone() {
        return this.isDone;
    }

    public IStrategoTerm getRoot() {
        if (!this.isDone) {
            throw new RuntimeException("Can't retrieve the root of the tree while it's still being constructed.");
        }
        return this.sharedTerms[0];
    }

    private void resetTemp() {
        this.tempType = -1;
        this.tempBytes = null;
        this.tempBytesIndex = 0;
    }

    private void readData() {
        int length = this.tempBytes.length;
        int bytesToRead = length - this.tempBytesIndex;
        int remaining = this.currentBuffer.remaining();
        if (remaining < bytesToRead) {
            bytesToRead = remaining;
        }
        this.currentBuffer.get(this.tempBytes, this.tempBytesIndex, bytesToRead);
        this.tempBytesIndex += bytesToRead;
        if (this.tempBytesIndex == length) {
            if (this.tempType == 1) {
                ATermConstruct ac = this.stack[this.stackPosition];
                StrategoSignature sig = new StrategoSignature();
                String constructorName = new String(this.tempBytes, StandardCharsets.UTF_8);
                sig.cons = this.factory.makeConstructor(constructorName, this.tempArity);
                sig.isString = this.tempIsQuoted;
                this.applSignatures.add(sig);
                if (this.tempArity == 0 && !ac.hasAnnos) {
                    IStrategoTerm term;
                    this.sharedTerms[ac.termIndex] = term = this.convertAppl(sig);
                    this.linkTerm(term);
                } else {
                    ac.tempSig = sig;
                    ac.subTerms = new IStrategoTerm[this.tempArity];
                }
            } else {
                throw new RuntimeException("Unsupported chunkified type: " + this.tempType);
            }
            this.resetTemp();
        }
    }

    private IStrategoTerm convertAppl(StrategoSignature sig) {
        return this.convertAppl(sig, TermFactory.EMPTY_TERM_ARRAY);
    }

    private IStrategoTerm convertAppl(StrategoSignature sig, IStrategoTerm[] subterms) {
        if (sig.isString) {
            return this.factory.makeString(sig.cons.getName());
        }
        if (sig.cons.getName().length() == 0) {
            return this.factory.makeTuple(subterms);
        }
        return this.factory.makeAppl(sig.cons, subterms);
    }

    private void touchAppl(byte header) {
        if ((header & 0x40) == 64) {
            int key = this.readInt();
            StrategoSignature sig = this.applSignatures.get(key);
            int arity = sig.cons.getArity();
            ATermConstruct ac = this.stack[this.stackPosition];
            if (arity == 0 && !ac.hasAnnos) {
                IStrategoTerm term;
                this.sharedTerms[ac.termIndex] = term = this.convertAppl(sig);
                this.linkTerm(term);
            } else {
                ac.tempSig = sig;
                ac.subTerms = new IStrategoTerm[arity];
            }
        } else {
            this.tempIsQuoted = (header & 0x20) == 32;
            this.tempArity = this.readInt();
            int nameLength = this.readInt();
            this.tempType = 1;
            this.tempBytes = new byte[nameLength];
            this.tempBytesIndex = 0;
            this.readData();
        }
    }

    private void touchList() {
        int size = this.readInt();
        ATermConstruct ac = this.stack[this.stackPosition];
        ac.subTerms = new IStrategoTerm[size];
        if (size == 0) {
            IStrategoList term = this.factory.makeList();
            if (!ac.hasAnnos) {
                this.sharedTerms[ac.termIndex] = term;
                this.linkTerm(term);
            } else {
                ac.tempTerm = term;
            }
        }
    }

    private void touchInt() {
        int value = this.readInt();
        ATermConstruct ac = this.stack[this.stackPosition];
        IStrategoInt term = this.factory.makeInt(value);
        if (!ac.hasAnnos) {
            this.sharedTerms[ac.termIndex] = term;
            this.linkTerm(term);
        } else {
            ac.tempTerm = term;
        }
    }

    private void touchReal() {
        double value = this.readDouble();
        ATermConstruct ac = this.stack[this.stackPosition];
        IStrategoReal term = this.factory.makeReal(value);
        if (!ac.hasAnnos) {
            this.sharedTerms[ac.termIndex] = term;
            this.linkTerm(term);
        } else {
            ac.tempTerm = term;
        }
    }

    private IStrategoTerm buildTerm(ATermConstruct ac) {
        IStrategoTerm constructedTerm;
        IStrategoTerm[] subTerms = ac.subTerms;
        int type = ac.type;
        if (type == 1) {
            constructedTerm = this.convertAppl(ac.tempSig, subTerms);
        } else if (type == 4) {
            IStrategoList list = this.factory.makeList();
            int i = subTerms.length - 1;
            while (i >= 0) {
                list = this.factory.makeListCons(subTerms[i], list);
                --i;
            }
            constructedTerm = list;
        } else if (ac.hasAnnos) {
            constructedTerm = ac.tempTerm;
        } else {
            throw new RuntimeException("Unable to construct term.\n");
        }
        if (ac.hasAnnos) {
            constructedTerm = this.factory.annotateTerm(constructedTerm, ac.annos);
        }
        return constructedTerm;
    }

    private void linkTerm(IStrategoTerm aTerm) {
        IStrategoTerm term = aTerm;
        while (this.stackPosition != 0) {
            ATermConstruct parent = this.stack[--this.stackPosition];
            IStrategoTerm[] subTerms = parent.subTerms;
            boolean hasAnnos = parent.hasAnnos;
            if (subTerms != null && subTerms.length > parent.subTermIndex) {
                subTerms[parent.subTermIndex++] = term;
                if (parent.subTerms.length != parent.subTermIndex || hasAnnos) {
                    return;
                }
                if (!hasAnnos) {
                    parent.annos = this.factory.makeList();
                }
            } else if (hasAnnos && TermUtils.isList(term)) {
                parent.annos = TermUtils.toList(term);
            } else {
                throw new RuntimeException("Encountered a term that didn't fit anywhere. Type: " + (Object)((Object)term.getType()) + ", term " + term);
            }
            this.sharedTerms[parent.termIndex] = term = this.buildTerm(parent);
        }
        if (this.stackPosition == 0) {
            this.isDone = true;
        }
    }

    private int readInt() {
        byte part = this.currentBuffer.get();
        int result = part & 0x7F;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.currentBuffer.get();
        result |= (part & 0x7F) << 7;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.currentBuffer.get();
        result |= (part & 0x7F) << 14;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.currentBuffer.get();
        result |= (part & 0x7F) << 21;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.currentBuffer.get();
        return result |= (part & 0x7F) << 28;
    }

    private double readDouble() {
        long result = this.readLong();
        return Double.longBitsToDouble(result);
    }

    private long readLong() {
        long result = 0L;
        int i = 0;
        while (i < 8) {
            result |= ((long)this.currentBuffer.get() & 0xFFL) << i * 8;
            ++i;
        }
        return result;
    }

    public static IStrategoTerm readTermFromSAFFile(ITermFactory factory, File file) throws IOException {
        SAFReader binaryReader = new SAFReader(factory);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        ByteBuffer sizeBuffer = ByteBuffer.allocate(2);
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fis = new FileInputStream(file);
            fc = fis.getChannel();
            ((Buffer)byteBuffer).limit(1);
            int bytesRead = ((FileChannel)fc).read(byteBuffer);
            if (bytesRead != 1) {
                throw new IOException("Unable to read SAF identification token.\n");
            }
            do {
                ((Buffer)sizeBuffer).clear();
                bytesRead = ((FileChannel)fc).read(sizeBuffer);
                if (bytesRead <= 0) break;
                if (bytesRead != 2) {
                    throw new IOException("Unable to read block size bytes from file: " + bytesRead + ".\n");
                }
                ((Buffer)sizeBuffer).flip();
                int blockSize = (sizeBuffer.get() & 0xFF) + ((sizeBuffer.get() & 0xFF) << 8);
                if (blockSize == 0) {
                    blockSize = 65536;
                }
                ((Buffer)byteBuffer).clear();
                ((Buffer)byteBuffer).limit(blockSize);
                bytesRead = ((FileChannel)fc).read(byteBuffer);
                ((Buffer)byteBuffer).flip();
                if (bytesRead != blockSize) {
                    throw new IOException("Unable to read bytes from file " + bytesRead + " vs " + blockSize + ".");
                }
                binaryReader.deserialize(byteBuffer);
            } while (bytesRead > 0);
            if (!binaryReader.isDone()) {
                throw new RuntimeException("Term incomplete, missing data.\n");
            }
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return binaryReader.getRoot();
    }

    public static IStrategoTerm readTermFromSAFString(ITermFactory factory, byte[] data) {
        int blockSize;
        SAFReader binaryReader = new SAFReader(factory);
        if (data.length == 0) {
            throw new RuntimeException("Unable to read SAF identification token.\n");
        }
        byte identifier = data[0];
        if (identifier != 63) {
            throw new RuntimeException("Not a SAF byte array.");
        }
        int length = data.length;
        int position = 1;
        do {
            blockSize = data[position++] & 0xFF;
            if ((blockSize += (data[position++] & 0xFF) << 8) == 0) {
                blockSize = 65536;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(blockSize);
            byteBuffer.put(data, position, blockSize);
            ((Buffer)byteBuffer).flip();
            binaryReader.deserialize(byteBuffer);
        } while ((position += blockSize) < length);
        if (!binaryReader.isDone()) {
            throw new RuntimeException("Term incomplete, missing data.\n");
        }
        return binaryReader.getRoot();
    }

    public static IStrategoTerm readTermFromSAFStream(ITermFactory factory, InputStream in) throws IOException {
        int bytesRead;
        SAFReader binaryReader = new SAFReader(factory);
        ReadableByteChannel channel = Channels.newChannel(in);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        ((Buffer)byteBuffer).limit(1);
        char identifier = (char)in.read();
        if (identifier == '\uffffffff') {
            throw new IOException("Unable to read SAF identification token.\n");
        }
        if (identifier != '?') {
            throw new IOException("Not a SAF file.");
        }
        do {
            int size1 = in.read();
            int size2 = in.read();
            if (size1 < 0 || size2 < 0) break;
            int blockSize = size1 + (size2 << 8);
            if (blockSize == 0) {
                blockSize = 65536;
            }
            ((Buffer)byteBuffer).clear();
            ((Buffer)byteBuffer).limit(blockSize);
            bytesRead = 0;
            while (bytesRead < blockSize) {
                int res = channel.read(byteBuffer);
                if (res <= 0) break;
                bytesRead += res;
            }
            if (bytesRead != blockSize) {
                throw new IOException("Unable to read bytes from file " + bytesRead + " vs " + blockSize + ".");
            }
            ((Buffer)byteBuffer).flip();
            binaryReader.deserialize(byteBuffer);
        } while (bytesRead > 0);
        if (!binaryReader.isDone()) {
            throw new RuntimeException("Term incomplete, missing data.\n");
        }
        return binaryReader.getRoot();
    }

    public static boolean isStreamingATerm(BufferedInputStream stream) throws IOException {
        boolean isSaf = false;
        stream.mark(1);
        char ch = (char)stream.read();
        if (ch == '?') {
            isSaf = true;
        }
        stream.reset();
        return isSaf;
    }

    static class ATermConstruct {
        public int type;
        public int termIndex = 0;
        public IStrategoTerm tempTerm = null;
        public int subTermIndex = 0;
        public IStrategoTerm[] subTerms = null;
        public boolean hasAnnos;
        public IStrategoList annos;
        public StrategoSignature tempSig;

        ATermConstruct() {
        }
    }

    class StrategoSignature {
        IStrategoConstructor cons;
        boolean isString;

        StrategoSignature() {
        }
    }
}

