/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.tokens.treeshaped;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokens;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.tokens.treeshaped.TokenTree;
import org.spoofax.jsglr2.tokens.treeshaped.TreeToken;

public class TreeTokens
implements ITokens {
    private static final long serialVersionUID = 2054391299757162697L;
    private final String filename;
    private final String input;
    final TreeToken startToken;
    final TreeToken endToken;
    TokenTree tree;
    public static final Position EMPTY_RANGE = new Position(0, 1, 0);

    public static Position addPosition(Position pos, Position add2) {
        return new Position(pos.offset + add2.offset, pos.line + add2.line - 1, add2.line == 1 ? pos.column + add2.column : add2.column);
    }

    public TreeTokens(JSGLR2Request input) {
        this.input = input.input;
        this.filename = input.fileName;
        this.startToken = new TreeToken(this, EMPTY_RANGE, IToken.Kind.TK_RESERVED, null);
        this.endToken = new TreeToken(this, EMPTY_RANGE, IToken.Kind.TK_EOF, null);
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public int getTokenCount() {
        return this.tree.size;
    }

    @Override
    public IToken getTokenAtOffset(int offset) {
        int currentOffset = 0;
        TokenTree currentTree = this.tree;
        block0: while (currentTree.token == null) {
            Iterator<TokenTree> iterator = currentTree.children.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                TokenTree child = iterator.next();
                if (child.leftToken == null) continue;
                int width = child.positionRange.offset;
                if (currentOffset <= offset && offset < currentOffset + (width == 0 ? 1 : width)) {
                    currentTree = child;
                    continue block0;
                }
                currentOffset += width;
            }
            break;
        }
        return currentTree.token;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String toString(IToken left, IToken right) {
        int startOffset = left.getStartOffset();
        int endOffset = right.getEndOffset();
        if (startOffset >= 0 && endOffset >= 0) {
            return this.toString(startOffset, endOffset + 1);
        }
        return "";
    }

    @Override
    public String toString(int startOffset, int endOffset) {
        return this.input.substring(startOffset, endOffset);
    }

    public String toString() {
        return "TreeTokens{filename='" + this.filename + "', input='" + this.input + "'}";
    }

    @Override
    public Iterator<IToken> iterator() {
        return new TokenIterator(true, false, false);
    }

    @Override
    public Iterable<IToken> allTokens() {
        return () -> new TokenIterator(true, true, true);
    }

    class TokenIterator
    implements Iterator<IToken> {
        private final Stack<TokenTree> stack = new Stack();
        private final boolean includeAmbiguous;
        private final boolean includeEmpty;

        TokenIterator(boolean includeStartEnd, boolean includeAmbiguous, boolean includeEmpty) {
            if (includeStartEnd) {
                this.stack.push(TreeTokens.this.tree);
            } else {
                this.stack.push(TreeTokens.this.tree.children.get(1));
            }
            this.includeAmbiguous = includeAmbiguous;
            this.includeEmpty = includeEmpty;
        }

        @Override
        public boolean hasNext() {
            while (!this.stack.isEmpty()) {
                boolean updated = false;
                while (!this.stack.isEmpty() && !this.stack.peek().children.isEmpty()) {
                    TokenTree pop = this.stack.pop();
                    if (pop.isAmbiguous && !this.includeAmbiguous) {
                        this.stack.push(pop.children.get(0));
                    } else {
                        int i = pop.children.size() - 1;
                        while (i >= 0) {
                            this.stack.push(pop.children.get(i));
                            --i;
                        }
                    }
                    updated = true;
                }
                while (!this.stack.isEmpty() && this.stack.peek().children.isEmpty() && this.shouldSkipToken(this.stack.peek().token)) {
                    this.stack.pop();
                    updated = true;
                }
                if (updated) continue;
                return true;
            }
            return false;
        }

        private boolean shouldSkipToken(TreeToken token) {
            return token == null || !this.includeEmpty && token.getKind() != IToken.Kind.TK_EOF && token.getKind() != IToken.Kind.TK_RESERVED && token.positionRange.offset == 0;
        }

        @Override
        public IToken next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.stack.pop().token;
        }
    }
}

