/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.recovery;

import java.util.HashSet;
import java.util.Set;
import org.spoofax.jsglr2.parseforest.Disambiguator;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.recovery.IRecoveryParseState;
import org.spoofax.jsglr2.stack.IStackNode;

public class RecoveryDisambiguator<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>, StackNode extends IStackNode, ParseState extends AbstractParseState<?, StackNode>>
implements Disambiguator<ParseForest, Derivation, ParseNode, StackNode, ParseState> {
    @Override
    public void disambiguate(ParseState parseState, ParseNode parseNode) {
        if (parseNode.isAmbiguous() && ((IRecoveryParseState)parseState).isRecovering()) {
            RecoverCost minRecoveryCost = null;
            IDerivation bestRecovery = null;
            HashSet<ParseNode> spine = new HashSet<ParseNode>();
            spine.add(parseNode);
            for (IDerivation derivation : parseNode.getPreferredAvoidedDerivations()) {
                RecoverCost cost = this.recoveryCost(0, (ParseNode)derivation, parseNode.width(), (Set<ParseNode>)spine);
                if (bestRecovery != null && !RecoverCost.lowerThan(cost, minRecoveryCost)) continue;
                minRecoveryCost = cost;
                bestRecovery = derivation;
            }
            parseNode.disambiguate(bestRecovery);
        }
    }

    private RecoverCost recoveryCost(int offset, Derivation derivation, int width, Set<ParseNode> spine) {
        String constructor = derivation.production().constructor();
        if (constructor != null) {
            if (constructor.equals("INSERTION")) {
                return new RecoverCost(1, offset, false);
            }
            if (constructor.equals("WATER")) {
                return new RecoverCost(1 + width, offset, false);
            }
        }
        RecoverCost cost = null;
        IParseForest[] iParseForestArray = derivation.parseForests();
        int n = iParseForestArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParseForest child = iParseForestArray[n2];
            if (child instanceof IParseNode) {
                IParseNode parseNode = (IParseNode)child;
                if (!spine.contains(parseNode)) {
                    spine.add(parseNode);
                    cost = RecoverCost.merge(cost, this.recoveryCost(offset, (ParseNode)parseNode, parseNode.width(), spine));
                    spine.remove(parseNode);
                } else {
                    cost = RecoverCost.cycle();
                }
            }
            offset += child.width();
            ++n2;
        }
        return cost;
    }

    private RecoverCost recoveryCost(int offset, ParseNode parseNode, int width, Set<ParseNode> spine) {
        RecoverCost cost = null;
        for (IDerivation derivation : parseNode.getDerivations()) {
            RecoverCost derivationCost = this.recoveryCost(offset, (ParseNode)derivation, width, spine);
            cost = RecoverCost.merge(cost, derivationCost);
        }
        return cost;
    }

    static class RecoverCost {
        int cost;
        int firstRecoveryOffset;
        boolean containsCycle;

        RecoverCost(int cost, int firstRecoveryOffset, boolean containsCycle) {
            this.cost = cost;
            this.firstRecoveryOffset = firstRecoveryOffset;
            this.containsCycle = containsCycle;
        }

        RecoverCost(RecoverCost first, RecoverCost second) {
            this(first.cost + second.cost, Math.min(first.firstRecoveryOffset, second.firstRecoveryOffset), first.containsCycle || second.containsCycle);
        }

        static RecoverCost cycle() {
            return new RecoverCost(0, -1, true);
        }

        static RecoverCost merge(RecoverCost first, RecoverCost second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            return new RecoverCost(first, second);
        }

        static boolean lowerThan(RecoverCost first, RecoverCost second) {
            if (second == null) {
                return false;
            }
            if (first == null) {
                return true;
            }
            if (first.containsCycle != second.containsCycle) {
                return second.containsCycle;
            }
            return first.cost < second.cost || first.cost == second.cost && first.firstRecoveryOffset > second.firstRecoveryOffset;
        }
    }
}

