/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.recovery;

import java.util.Collections;
import org.metaborg.parsetable.symbols.ILiteralSymbol;
import org.metaborg.parsetable.symbols.SyntaxContext;
import org.spoofax.jsglr2.inputstack.IInputStack;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parseforest.ParseNodeVisitor;
import org.spoofax.jsglr2.parser.IParser;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.parser.result.ParseSuccess;

public class Reconstruction {
    public static Reconstructed reconstruct(IParser<?> parser, ParseSuccess<?> success) {
        ReconstructParseNodeVisitor visitor = new ReconstructParseNodeVisitor(((IInputStack)success.parseState.inputStack).inputString());
        parser.visit(success, visitor);
        return visitor.getReconstructed();
    }

    static class ReconstructParseNodeVisitor<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>>
    implements ParseNodeVisitor<ParseForest, Derivation, ParseNode> {
        String inputString;
        StringBuilder reconstruction = new StringBuilder();
        int insertions = 0;
        int deletions = 0;

        public ReconstructParseNodeVisitor(String inputString) {
            this.inputString = inputString;
        }

        @Override
        public boolean visitAmbiguousDerivations() {
            return false;
        }

        @Override
        public boolean preVisit(ParseNode parseNode, Position startPosition) {
            return !this.isBoundary(parseNode);
        }

        private boolean isBoundary(ParseNode parseNode) {
            return parseNode.production().isRecovery() || parseNode.production().isLexical() || parseNode.production().isLiteral() || parseNode.production().lhs().syntaxContext() == SyntaxContext.Lexical && parseNode.production().isLayout();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void postVisit(ParseNode parseNode, Position startPosition, Position endPosition) {
            if (!this.isBoundary(parseNode)) return;
            if (parseNode.production().isWater()) {
                this.reconstruction.append(String.join((CharSequence)"", Collections.nCopies(parseNode.width(), " ")));
                this.deletions += parseNode.width();
                return;
            } else if (parseNode.production().isInsertion()) {
                if (!parseNode.production().isLiteral()) throw new IllegalStateException("cannot reconstruct non-literal insertion");
                String literal = ((ILiteralSymbol)parseNode.production().lhs()).literal();
                this.reconstruction.append(literal);
                this.insertions += literal.length();
                return;
            } else {
                this.reconstruction.append(this.inputString, startPosition.offset, endPosition.offset);
            }
        }

        Reconstructed getReconstructed() {
            return new Reconstructed(this.reconstruction.toString(), this.insertions, this.deletions);
        }
    }

    public static class Reconstructed {
        public final String inputString;
        public final int insertions;
        public final int deletions;

        public Reconstructed(String inputString, int insertions, int deletions) {
            this.inputString = inputString;
            this.insertions = insertions;
            this.deletions = deletions;
        }
    }
}

