/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.imploder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.symbols.IMetaVarSymbol;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.imploder.AbstractTreeImploder;
import org.spoofax.jsglr2.imploder.ImplodeResult;
import org.spoofax.jsglr2.imploder.treefactory.ITokenizedTreeFactory;
import org.spoofax.jsglr2.parseforest.ICharacterNode;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.tokens.Tokens;

public abstract class TokenizedTreeImploder<ParseForest extends IParseForest, ParseNode extends IParseNode<ParseForest, Derivation>, Derivation extends IDerivation<ParseForest>, Tree>
extends AbstractTreeImploder<ParseForest, ParseNode, Derivation, Tokens, Void, Tree, ImplodeResult<Tokens, Void, Tree>> {
    protected final ITokenizedTreeFactory<Tree> treeFactory;

    public TokenizedTreeImploder(ITokenizedTreeFactory<Tree> treeFactory) {
        this.treeFactory = treeFactory;
    }

    @Override
    public ImplodeResult<Tokens, Void, Tree> implode(JSGLR2Request request, ParseForest parseForest, Void resultCache) {
        Tokens tokens = new Tokens(request.input, request.fileName);
        tokens.makeStartToken();
        Position position = Position.START_POSITION;
        SubTree<Tree> tree = this.implodeParseNode(parseForest, tokens, position);
        tokens.makeEndToken(tree.endPosition);
        this.tokenTreeBinding(tokens.startToken(), tree.tree);
        this.tokenTreeBinding(tokens.endToken(), tree.tree);
        return new ImplodeResult(tokens, null, tree.tree, tree.containsAmbiguity);
    }

    protected SubTree<Tree> implodeParseNode(ParseForest parseForest, Tokens tokens, Position startPosition) {
        Object tree;
        IToken token;
        if (parseForest instanceof ICharacterNode) {
            int width = parseForest.width();
            Position endPosition = startPosition.step(tokens.getInput(), width);
            IToken token2 = tokens.makeToken(startPosition, endPosition, null);
            Tree tree2 = this.createCharacterTerm(((ICharacterNode)parseForest).character(), token2);
            return new SubTree<Tree>(tree2, endPosition, token2, token2, false);
        }
        IParseNode parseNode = this.implodeInjection((IParseNode)parseForest);
        IProduction production = parseNode.production();
        if (production.isContextFree() && !production.isSkippableInParseForest()) {
            List filteredDerivations = this.applyDisambiguationFilters(parseNode);
            if (filteredDerivations.size() > 1) {
                ArrayList trees = new ArrayList(filteredDerivations.size());
                SubTree<Tree> result = null;
                if (production.isList()) {
                    for (List derivationParseForests : this.implodeAmbiguousLists(filteredDerivations)) {
                        if (result == null) {
                            result = this.implodeListDerivation(tokens, production, derivationParseForests, startPosition);
                            trees.add(result.tree);
                            continue;
                        }
                        trees.add(this.implodeListDerivation((Tokens)tokens, (IProduction)production, derivationParseForests, (Position)startPosition).tree);
                    }
                } else {
                    for (IDerivation derivation : filteredDerivations) {
                        if (result == null) {
                            result = this.implodeDerivation(tokens, derivation, startPosition);
                            trees.add(result.tree);
                            continue;
                        }
                        trees.add(this.implodeDerivation((Tokens)tokens, derivation, (Position)startPosition).tree);
                    }
                }
                result.tree = this.treeFactory.createAmb(trees, result.leftToken, result.rightToken);
                result.containsAmbiguity = true;
                return result;
            }
            return this.implodeDerivation(tokens, (IDerivation)filteredDerivations.get(0), startPosition);
        }
        int width = parseNode.width();
        Position endPosition = startPosition.step(tokens.getInput(), width);
        IToken iToken = token = width > 0 || production.isLexical() ? tokens.makeToken(startPosition, endPosition, production) : null;
        if (production.isLayout() || production.isLiteral()) {
            tree = null;
        } else if (production.isLexical()) {
            tree = this.createLexicalTerm(production, tokens.toString(startPosition.offset, endPosition.offset), token);
        } else {
            throw new RuntimeException("invalid term type");
        }
        return new SubTree<Object>(tree, endPosition, token, token, false);
    }

    protected SubTree<Tree> implodeDerivation(Tokens tokens, Derivation derivation, Position startPosition) {
        IProduction production = derivation.production();
        if (!production.isContextFree()) {
            throw new RuntimeException("non context free imploding not supported");
        }
        ArrayList childASTs = new ArrayList();
        ArrayList<IToken> unboundTokens = new ArrayList<IToken>();
        SubTree subTree = this.implodeChildParseNodes(tokens, childASTs, Arrays.asList(derivation.parseForests()), derivation.production(), unboundTokens, startPosition);
        subTree.tree = this.createContextFreeTerm(derivation.production(), childASTs, subTree.leftToken, subTree.rightToken);
        for (IToken token : unboundTokens) {
            this.tokenTreeBinding(token, subTree.tree);
        }
        return subTree;
    }

    protected SubTree<Tree> implodeListDerivation(Tokens tokens, IProduction production, List<ParseForest> childParseForests, Position startPosition) {
        ArrayList childASTs = new ArrayList();
        ArrayList<IToken> unboundTokens = new ArrayList<IToken>();
        SubTree subTree = this.implodeChildParseNodes(tokens, childASTs, childParseForests, production, unboundTokens, startPosition);
        subTree.tree = this.createContextFreeTerm(production, childASTs, subTree.leftToken, subTree.rightToken);
        for (IToken token : unboundTokens) {
            this.tokenTreeBinding(token, subTree.tree);
        }
        return subTree;
    }

    protected SubTree<Tree> implodeChildParseNodes(Tokens tokens, List<Tree> childASTs, Iterable<ParseForest> childParseForests, IProduction production, List<IToken> unboundTokens, Position startPosition) {
        SubTree<Object> result = new SubTree<Object>(null, startPosition, null, null, false);
        Position pivotPosition = startPosition;
        for (IParseForest childParseForest : childParseForests) {
            SubTree<Tree> subTree;
            IProduction childProduction;
            IParseNode childParseNode = childParseForest instanceof IParseNode ? (IParseNode)childParseForest : null;
            IProduction iProduction = childProduction = childParseNode != null ? childParseNode.production() : null;
            if (production.isList() && childProduction != null && childProduction.isList() && childProduction.constructor() == null && childParseNode.getPreferredAvoidedDerivations().size() <= 1 && !production.isLexical()) {
                subTree = this.implodeChildParseNodes(tokens, childASTs, Arrays.asList(childParseNode.getFirstDerivation().parseForests()), childProduction, unboundTokens, pivotPosition);
            } else {
                subTree = this.implodeParseNode(childParseForest, tokens, pivotPosition);
                if (subTree.tree != null) {
                    childASTs.add(subTree.tree);
                }
                if (subTree.tree == null) {
                    if (subTree.leftToken != null) {
                        unboundTokens.add(subTree.leftToken);
                    }
                    if (subTree.rightToken != null && subTree.rightToken != subTree.leftToken) {
                        unboundTokens.add(subTree.rightToken);
                    }
                }
            }
            if (childProduction != null && !childProduction.isLayout() || childParseNode == null) {
                if (result.leftToken == null) {
                    result.leftToken = subTree.leftToken;
                }
                if (subTree.rightToken != null) {
                    result.rightToken = subTree.rightToken;
                }
            }
            pivotPosition = subTree.endPosition;
            result.containsAmbiguity |= subTree.containsAmbiguity;
        }
        if (result.leftToken == null) {
            assert (result.rightToken == null);
            result.leftToken = result.rightToken = tokens.makeToken(startPosition, pivotPosition, production);
            unboundTokens.add(result.leftToken);
        }
        result.endPosition = pivotPosition;
        return result;
    }

    protected Tree createContextFreeTerm(IProduction production, List<Tree> childASTs, IToken leftToken, IToken rightToken) {
        String constructor = production.constructor();
        if (constructor != null) {
            return this.treeFactory.createNonTerminal(production.lhs(), constructor, childASTs, leftToken, rightToken);
        }
        if (production.isOptional()) {
            return this.treeFactory.createOptional(production.lhs(), childASTs, leftToken, rightToken);
        }
        if (production.isList()) {
            return this.treeFactory.createList(childASTs, leftToken, rightToken);
        }
        if (childASTs.size() == 1) {
            return this.treeFactory.createInjection(production.lhs(), childASTs.get(0), production.isBracket());
        }
        return this.treeFactory.createTuple(childASTs, leftToken, rightToken);
    }

    protected Tree createLexicalTerm(IProduction production, String lexicalString, IToken lexicalToken) {
        Tree lexicalTerm = production.lhs() instanceof IMetaVarSymbol ? this.treeFactory.createMetaVar((IMetaVarSymbol)production.lhs(), lexicalString, lexicalToken) : this.treeFactory.createStringTerminal(production.lhs(), lexicalString, lexicalToken);
        if (lexicalToken != null) {
            this.tokenTreeBinding(lexicalToken, lexicalTerm);
        }
        return lexicalTerm;
    }

    protected Tree createCharacterTerm(int character, IToken lexicalToken) {
        Tree term = this.treeFactory.createCharacterTerminal(character, lexicalToken);
        this.tokenTreeBinding(lexicalToken, term);
        return term;
    }

    protected abstract void tokenTreeBinding(IToken var1, Tree var2);

    static class SubTree<Tree> {
        Tree tree;
        Position endPosition;
        IToken leftToken;
        IToken rightToken;
        boolean containsAmbiguity;

        SubTree(Tree tree, Position endPosition, IToken leftToken, IToken rightToken, boolean containsAmbiguity) {
            this.tree = tree;
            this.endPosition = endPosition;
            this.leftToken = leftToken;
            this.rightToken = rightToken;
            this.containsAmbiguity = containsAmbiguity;
        }
    }
}

